/* 
 * blast.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.4 $
 * $Date: 1991/11/22 20:52:24 $
 */

#ifndef blast_h
#define blast_h

/*
 * timeout calculations:
 *   receive timeout 	= REC_CONST (msec) * number_of_fragments
 *   send timeout	= SEND_CONST
 */
#define REC_CONST 100
#define SEND_CONST 3000

#define BLAST_MAX_TRIES(m) (((m)/MAX_FRAG_LEN) + 1) 
#define BLAST_REC_DELAY(m) (((m)/MAX_FRAG_LEN)*REC_CONST)
#define BLAST_SEND_DELAY(m) (((m)/MAX_FRAG_LEN)*SEND_CONST)

/* Default number of concurrent outstanding messages allowed
 * (per protocol instantiation)
 */
#define OUTSTANDING_MESSAGES 64

#define BLAST_SETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 0)
#define BLAST_GETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 1)


#define FULLMASK 0xffff

#endif blast_h
