
#include "gp.h"


/*insert(). Insert the element pointed  to by node into the linked list.  */

   port_insert(list,node)
   llist **list, *node;

    {
       llist *last;
/* check if list is empty */
       if ( (*list) == NULL)
         {
           *list = node;
           node->next = node;
           node->prev = node;
         }

 /* otherwise; insert at the end of the list */
       else
          {
            last = (*list)->prev;
            last->next = node;
            node->prev = last;
            (*list)->prev = node;
            node->next = (*list);
            *list = node;
           }
     } /* end insert. */

/* remove(). Removes the first element in the list and returns it. Returns 
             NULL if list is empty */
  llist *port_remove(list)
  llist **list;

  {
      llist *p, *last, *second;

/* check if list is empty */
      if (*list == NULL)
         return(NULL);

/* otherwise; */
      else 
         {
          p = (*list);
      
     /* check if list has one element */
          if (p == p->next)
            *list = NULL;
          else
            {
              last = (*list)->prev;
              second = (*list)->next;
              second->prev = last;
              last->next = second;
              *list = second;
            }
          }
 
           return(p);

    } /* end remove() */



/* keyremove(). Removes the first node in the list whose key is val and returns
                it. If list empty or node does not exist, returns NULL. */
llist *keyremove(list,val)
 llist **list;
 nodeptr val;

 {
     llist *p;
  

     if (*list == NULL)
        return(NULL);
     else
        {
          p = (*list);

      /* find val in the list */
          while (p->key != val && p->next != (*list) )
              p = p->next;

       /* if val is the only element in the list */
          if ( p == p->next && p->key == val)
            {
              *list = NULL;
              return(p);
            }

        /* if val is the first element in the list */
          else if (p == (*list) && p->key == val )
                  *list = p->next;

        /* if reached end of list and can find val */
          else if ( p->next == (*list) && p->key != val )
                  return(NULL);

          (p->prev)->next = p->next;
          (p->next)->prev = p->prev;

        }
 
      return(p);

 } /* end remove() */


/* find(). Finds the first node in the list whose key value is val and returns
           a pointer to it. It does not remove the node from the list. If list
           is empty or node is found, it returns NULL. */
llist *port_find(list, val)
   llist **list;
   nodeptr val;

   {
     llist *p;


     if ( *list == NULL) 
           return(NULL);
        
     else
       {
          p = (*list);
       /* find val in the list */
          while ( p->key != val && p->next != (*list) )
                        p = p->next;

       /* if reached end of list and can not find val */
          if ( p->next == (*list) && p->key != val )
                  return(NULL);

          else
                  return(p);
       }

  } /* end find(). */
          

