/* 
 * ms_consts.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/* Generates offsets for data structures defined in C. */
/* The offsets are generated by a complicated script, see Makefile */

#include "process.h"

#define findOffset(base,field) \
        asm("#X#base#Y#field ZZZZ"); \
	ZYXZ  = (int) (    ( (char *) ( &( ( (base *) 0 )->field ) ) ) \
                         - ( (char *) (  ( ( (base *) 0 )        ) ) ) \
                      )

#define defineConstant(name,value) \
	asm("#X##Y#name ZZZZ"); \
	ZYXZ = (int) value

#define findValue(field,value) \
	asm("#X#field#Y#value ZZZZ"); \
	ZYXZ = (int) value

#define findBitOffset(base,field) \
        asm("#X#base#Y#field ZZZZ"); \
	ZYXZ  = ( (base *) 0 )-> field

#define findSizeOf(someType) \
        asm("#X#sizeof#Y#someType ZZZZ"); \
	ZYXZ  = sizeof(someType)
	

int ZYXZ;
main()
{
  findOffset(Process,link);
  findOffset(Process,pid);
  findOffset(Process,state);
  findOffset(Process,priority);
  findOffset(Process,aspace);
  findOffset(Process,queuePtr);
  findOffset(Process,ps);
  findOffset(Process,ps.regs);
  findOffset(Process,ps.regs.r.d0);
  findOffset(Process,ps.regs.r.d1);
  findOffset(Process,ps.regs.r.d2);
  findOffset(Process,ps.regs.r.d3);
  findOffset(Process,ps.regs.r.d4);
  findOffset(Process,ps.regs.r.d5);
  findOffset(Process,ps.regs.r.d6);
  findOffset(Process,ps.regs.r.d7);
  findOffset(Process,ps.regs.r.a0);
  findOffset(Process,ps.regs.r.a1);
  findOffset(Process,ps.regs.r.a2);
  findOffset(Process,ps.regs.r.a3);
  findOffset(Process,ps.regs.r.a4);
  findOffset(Process,ps.regs.r.a5);
  findOffset(Process,ps.regs.r.a6);
  findOffset(Process,ps.regs.r.a7);
  findOffset(Process,ps.regs.r.usp);
  findOffset(Process,ps.stackBase);
  findOffset(Process,ps.stackLimit);
  findOffset(Semaphore,count);
  findValue(PS,READY);
  findValue(PS,DEAD);
  findValue(PS,WAITING);
  findOffset(MC68020ExceptionStackFrame,frame);
  defineConstant(TRAP_NOP,0);
  defineConstant(TRAP_OPEN,1);
  defineConstant(TRAP_OPENENABLE,2);
  defineConstant(TRAP_OPENDISABLE,3);
  defineConstant(TRAP_CLOSE,4);
  defineConstant(TRAP_PUSH,5);
  defineConstant(TRAP_CONTROLSESSN,6);
  defineConstant(TRAP_CONTROLPROTL,7);
  defineConstant(TRAP_CREATEPROTOCOL,8);
  defineConstant(TRAP_DESTROYPROTOCOL,9);
  defineConstant(TRAP_CREATEPROCESS,10);
  defineConstant(TRAP_DESTROYPROCESS,11);
  defineConstant(TRAP_CREATESEMAPHORE,12);
  defineConstant(TRAP_DESTROYSEMAPHORE,13);
  defineConstant(TRAP_P,14);
  defineConstant(TRAP_V,15);
  defineConstant(TRAP_YIELD,16);
  defineConstant(TRAP_GETTIME,17);
  defineConstant(TRAP_PUTCHAR,18);
  defineConstant(TRAP_EVENTREGISTER,19);
  defineConstant(TRAP_EVENTREMOVE,20);
  defineConstant(TRAP_EVENTREMOVEEVENT,21);
  defineConstant(TRAP_SBRK,22);
  defineConstant(TRAP_SEMAPHORECOUNT,23);
  defineConstant(TRAP_ONFAULT,24);
  defineConstant(TRAP_PROFILE,25);
  defineConstant(TRAP_PAUSE, 26);
  defineConstant(TRAP_CALL, 27);
  defineConstant(TRAP_GETPROTLBYNAME, 28);
  defineConstant(TRAP_GETPAGE, 29);
  defineConstant(TRAP_PUSHPAGE, 30);
  defineConstant(TRAP_CALLPAGE, 31);
  defineConstant(TRAP_BRK, 32);
  defineConstant(TRAP_TEST,33);
  defineConstant(TRAP_CLONEASPACE,34);
  defineConstant(TRAP_GETASPACEID,35);
  defineConstant(TRAP_LAST,35);
  defineConstant(KERNELSTACKREQUIRED,2048);
}

