/*
 * nfs_xdr.c
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 */

#define NFS_FHSIZE 32
#define NFS_COOKIESIZE 4

typedef char nfscookie[NFS_COOKIESIZE];
typedef struct entry entry;
typedef struct dirlist dirlist;
typedef struct readdirres readdirres;
bool_t xdr_dirlist();
bool_t xdr_filename();
bool_t xdr_nfscookie();
bool_t xdr_entry();

struct entry {
	u_int fileid;
	char *name;
	nfscookie cookie;
	struct entry *nextentry;
};

struct dirlist {
	entry *entries;
	bool_t eof;
};

struct readdirres {
	enum nfsstat status;
	union {
		dirlist reply;
	} readdirres_u;
};

