h35151
s 00617/00000/00000
d D 1.1 91/01/10 10:59:22 llp 1 0
c date and time created 91/01/10 10:59:22 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * lanceEther.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "ethernet.h"
#include "lanceEther.h"
#include "memory.h"

static	install_buf_in_rmd();
static	msg_frag *gather_frags();
static	msg_frag *get_msg_frags();
extern	eth_demux();

#ifndef INT3
#define INT3	3
#endif  INT3

#define PACKSIZE 1500

#ifndef upi_h
#include "message.h"
#include "nmessage.h"
typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef int(*Pfi) ();
#endif upi_h

extern	int	errno;
static	struct	lance_softc Lan;
struct	lance_softc	*Es = &Lan;
Semaphore	Lance_sem;
int	trans_buf_cnt;

#define ether_addr_not_equal(a,b)	\
    ((a).high != (b).high || (a).mid != (b).mid || (a).low != (b).low)

#define ether_addr_equal(a,b)	\
    ((a).high == (b).high && (a).mid == (b).mid && (a).low == (b).low)

/* Cache for message fragments */
static msg_frag *Frag_list = NULL;

#define free_frag(frag)	\
    { frag->next = Frag_list;  Frag_list = frag; }

#define alloc_frag(frag)	\
    {  if (Frag_list == NULL) frag = (msg_frag *)malloc(sizeof(msg_frag)); \
       else { frag = Frag_list; Frag_list = frag->next; } }

char *buffer[LE_TBUFS + 1]; /* Transmit buffers */
int next_buf = 0; /* Next buffer to use */

/* -------------------------------------------------------------------- */
/* Initialize Chip; called from ethProtol				*/
/* -------------------------------------------------------------------- */

int ethCtlrInit(LocalEthAd)
ethAd_t LocalEthAd;
{
  register struct le_device *le=Es->es_lance=(struct le_device *) 0xfe10000;
  register struct le_init_block *ib = &Es->es_ib;
  struct le_md *pmd;
  int i, timeout = 5 * TIMEBOMB;
  Msg	msg;
  char	*p;

  extern int	Asm_lance_ih();

  InitSemaphore(&Lance_sem, 1);
  TRACE1(ether, 3, "le: lancereset(%x)", Es);
  TRACE1(ether, 3, "le: lancereset(%x)", le);

  /* Set Interrupt Handler */
  setexvec(Asm_lance_ih, INT3);

  /* Reset the chip */
  le->le_rap = LE_CSR0;
  le->le_csr = LE_STOP;

  /* Perform the basic initialization */
  
  /* Construct the initialization block */
  bzero((char *)&Es->es_ib, sizeof (struct le_init_block));

  /* Leave the mode word 0 for normal operating mode */

  Es->es_enaddr.high = LocalEthAd.high;
  Es->es_enaddr.mid = LocalEthAd.mid;
  Es->es_enaddr.low = LocalEthAd.low;

  p = (char *) &Es->es_enaddr;
  /* For a consistent byte ordering among processors bytes must be swapped */
  ib->ib_padr[0] = p[1];
  ib->ib_padr[1] = p[0];
  ib->ib_padr[2] = p[3];
  ib->ib_padr[3] = p[2];
  ib->ib_padr[4] = p[5];
  ib->ib_padr[5] = p[4];

  /* Leave address filter 0 -- we don't want Multicast packets at this time */
  /* ib->ib_ladrf[0] = 0; ... ib->ib_ladrf[7] = 0; */

  /*
   * Set up transmit and receive ring pointers,
   * taking the 8-byte alignment requirement into account.
   */
  Es->es_rmdp[0] = ((struct le_md *) ((u_long)(&Es->es_rmd[0]) & ~07)) + 1;
  pmd = Es->es_rmdp[0];
  for (i = 1; i < LE_RBUFS; i++) {
    Es->es_rmdp[i] = ++pmd;
    } /* for */
  Es->es_tmdp[0] = ((struct le_md *)((u_long)(&Es->es_tmd[0]) & ~07)) + 1;
  pmd = Es->es_tmdp[0];
  for (i = 1; i < LE_TBUFS; i++) {
    Es->es_tmdp[i] = ++pmd;
    } /* for */
  trans_buf_cnt = LE_TBUFS;

  ib->ib_rdrp.drp_laddr = (long)Es->es_rmdp[0];
  ib->ib_rdrp.drp_haddr = (long)Es->es_rmdp[0] >> 16;
  ib->ib_rdrp.drp_len  = LE_RBUFEXP;
  
  ib->ib_tdrp.drp_laddr = (long)Es->es_tmdp[0];
  ib->ib_tdrp.drp_haddr = (long)Es->es_tmdp[0] >> 16;
  ib->ib_tdrp.drp_len  = LE_TBUFEXP;

  /* Clear all the descriptors */
  for (i = 0; i < LE_RBUFS; i ++) {
    Es->es_rmdp[i]->lmd_flags = 0;
    Es->es_rmdp[i]->lmd_bcnt = 0;
    Es->es_rmdp[i]->lmd_mcnt = 0;
    }
  for (i = 0; i < LE_TBUFS; i++) {
    Es->es_tmdp[i]->lmd_flags = 0;
    Es->es_tmdp[i]->lmd_bcnt = 0;
    Es->es_tmdp[i]->lmd_flags3 = 0;
    }

  /* Give the init block to the chip */
  le->le_rap = LE_CSR1;	/* select the low address register */
  le->le_rdp = (long)ib & 0xffff;

  le->le_rap = LE_CSR2;	/* select the high address register */
  le->le_rdp = ((long)ib >> 16) & 0xff;

  le->le_rap = LE_CSR3;	/* Bus Master control register */
  le->le_rdp = LE_BSWP;

  le->le_rap = LE_CSR0;	/* main control/status register */
  le->le_csr = LE_INIT;

  while( ! (le->le_csr & LE_IDON) ) {
    if (timeout-- <= 0) {
        printf("le: cannot initialize\n");
        return 1;
        } /* if */
  } /* while */
  le->le_csr = LE_IDON;	/* Clear the indication */

  /* Hang out the receive buffers */
  Es->es_next_rmd = 0;

  for (i = 0; i < LE_RBUFS; i++) {
    msg_make_allstack(msg, LANCERBUFSIZ, (char *) 0, 0);
    install_buf_in_rmd(msg, i);
    } /* for */

  /* Set up for the first transmit buffer */
  Es->es_next_tmd = 0;
  Es->es_last_tmd = 0;

  le->le_csr = LE_STRT | LE_INEA;

  TRACE0(ether, 3, "le: lancereset returns OK");
  return 0;    /* It all worked! */
} /* ethCtrlInit */

/* -------------------------------------------------------------------- */
/* Puts a pointer to the data section of a contiguous message in	*/
/* the proper data structure so that the LANCE chip is able to		*/
/* find it								*/
/* -------------------------------------------------------------------- */

static install_buf_in_rmd(msg, which)
  Msg	msg;
  int	which;
{
  register struct le_md	*rmd = Es->es_rmdp[which];
  u_char *buffer;

  TRACE0(ether, 9, "le: install_buf_in_rmd");
  buffer = (u_char *) msg.stack->stack;
  rmd->lmd_ladr = (u_short)buffer;
  rmd->lmd_hadr = (long)buffer >> 16;
  rmd->lmd_bcnt = -LANCERBUFSIZ;
  rmd->lmd_mcnt = 0;
  Es->es_save_rmsg[which] = msg;
  rmd->lmd_flags = LMD_OWN;
} /* install_buf_in_rmd */


/* -------------------------------------------------------------------- */
/* Transmit a packet; called from ethProtl				*/
/* -------------------------------------------------------------------- */

ethCtlrXmit(packet, destAd, ethType)
Msg packet;
ethAd_t	destAd;
ethType_t ethType;
{
  register struct le_device *le = Es->es_lance;
  /* Transmit Msg. Descriptor */
  register struct le_md *tmd;	/* Transmit descriptor */
  int x;
  msg_frag *frag, *tmp;
  ethHdr_t *h;
  register msg_frag *p, *q;
  short flags,firstflags;
  int which;
  int rest, len;
  char *buf, *m;
  int lance_min_tu = LANCE_MIN_TU, frag_count;

  TRACE1(ether, 5, "ethCtlrXmit: semaphore = %d", Lance_sem.count);
  TRACE1(ether, 5, "Transmit buffers available = %d", trans_buf_cnt);
  IFTRACE(ether, 6) {
    printf("      CSR0 = %d%d%d%d:%d%d%d%d:%d%d%d%d:%d%d%d%d\n",
	(le->le_csr & LE_ERR ) ? 1 : 0, (le->le_csr & LE_BABL) ? 1 : 0,
	(le->le_csr & LE_CERR) ? 1 : 0, (le->le_csr & LE_MISS) ? 1 : 0,
	(le->le_csr & LE_MERR) ? 1 : 0, (le->le_csr & LE_RINT) ? 1 : 0,
	(le->le_csr & LE_TINT) ? 1 : 0, (le->le_csr & LE_IDON) ? 1 : 0,
	(le->le_csr & LE_INTR) ? 1 : 0, (le->le_csr & LE_INEA) ? 1 : 0,
	(le->le_csr & LE_RXON) ? 1 : 0, (le->le_csr & LE_TXON) ? 1 : 0,
	(le->le_csr & LE_TDMD) ? 1 : 0, (le->le_csr & LE_STOP) ? 1 : 0,
	(le->le_csr & LE_STRT) ? 1 : 0, (le->le_csr & LE_INIT) ? 1 : 0);
    } /* IFTRACE */

  P(&Lance_sem); /* get exclusive control of CRS0 */

  if (trans_buf_cnt == 0) {  /* if there are no transmit buffers */
    TRACE0(ether, 0, "XMIT FAILED: NO AVAILABLE BUFFERS");
    le->le_csr = LE_INEA | LE_TDMD;
    V(&Lance_sem);
    msg_free(packet);
    return (0);
  }

  /* construct buffer list, including ethernet header */

  if (msg_data_len(packet) == 0)  { /* fast path */
    h = (ethHdr_t *) msg_push(packet, sizeof(ethHdr_t));
    h->srcEthAd.high = Es->es_enaddr.high;
    h->srcEthAd.mid = Es->es_enaddr.mid;
    h->srcEthAd.low = Es->es_enaddr.low;
    h->destEthAd = destAd;
    h->ethType = ethType;
    if (msg_len(packet) < MIN_ETH_DATA_SZ)
      len = MIN_ETH_DATA_SZ;
    else
      len = msg_len(packet);
    x = spl7();
    trans_buf_cnt--;
    Es->es_save_tmsg[Es->es_next_tmd] = packet;
    tmd = Es->es_tmdp[Es->es_next_tmd];
    Es->es_next_tmd = (Es->es_next_tmd == LE_TBUFS - 1)? 0 :
			Es->es_next_tmd + 1;
    m = msg_top(packet,msg_stack_len(packet));
    tmd->lmd_hadr = ((int)m) >> 16;
    tmd->lmd_ladr = ((u_short) m);
    tmd->lmd_bcnt = -(len);
    tmd->lmd_flags3 = 0;
    tmd->lmd_flags =  LMD_OWN | LMD_STP | LMD_ENP;
    le->le_csr = LE_INEA | LE_TDMD;
    splx(x);
    V(&Lance_sem);
    TRACE0(ether, 3, "done with ethCtlrXmit fast path");
    return (0);
  }

  h = (ethHdr_t *) msg_push(packet, sizeof(ethHdr_t));
  h->srcEthAd.high = Es->es_enaddr.high;
  h->srcEthAd.mid = Es->es_enaddr.mid;
  h->srcEthAd.low = Es->es_enaddr.low;
  h->destEthAd = destAd;
  h->ethType = ethType;
  frag = gather_frags(packet, &frag_count);

  if (msg_stack_len(packet) >= LANCE_MIN_TU && frag_count <= 2) {  /* go ahead and push now */
    TRACE1(ether, 5, "first frag is big enough (%d)",msg_stack_len(packet));  
  }
  else { /* going to have to deal with small first fragment */
    buf = buffer[next_buf];
    if (buf != NULL) free(buf);
    buffer[next_buf] = buf = malloc(MAXBUF);
	
    next_buf = (next_buf == LE_TBUFS) ? 0 : next_buf + 1;
    /*
     * If there are two or less frags, then use the original lance_min_tu,
     * otherwise set it to maxpacket.
     */
    if (frag_count > 2) lance_min_tu = MAXBUF;

    /*
     * Copy the data from the first frag into buf, and adjust the first frag
     * to point to buf.
     */
    p = frag;
    bcopy(p->str, buf, p->len);
    p->str = buf;
    buf += p->len;

    /*
     * Do more frags as long as they fit entirely into buf
     */
    while (p->next && p->len + p->next->len <= lance_min_tu) {
      bcopy(p->next->str, buf, p->next->len);
      buf += p->next->len;
      p->len += p->next->len;
      tmp = p->next;
      p->next = p->next->next;
      free_frag(tmp);
    }
    /*
     * Get part of the next frag into buf, if necessary.
     */
    if (p->len < lance_min_tu && p->next) {  
      rest = lance_min_tu - p->len;
      bcopy(p->next->str, buf, rest);
      p->len += rest;		/* should be equal to lance_min_tu */
      p->next->str += rest;
      p->next->len -= rest;
    }
    TRACE0(ether, 5, "first frag is not big enough");    
  }

  /* Lie about the length of the msg if it is too short */
  if (frag->len < MIN_ETH_DATA_SZ) {
    frag->len = MIN_ETH_DATA_SZ;
    TRACE0(ether, 5, "total message less than min");
  }
  
  x = spl7();

  which = Es->es_next_tmd; /* patch leak */
  /* for every fragment in the packet */
  for (p = frag; p != NULL; p = q) {
    /* get a transimit descriptor */
    if (--trans_buf_cnt == 0) {  /* if there are no transmit buffers */
      TRACE0(ether, 0, "XMIT FAILED: NO AVAILABLE BUFFERS");
      le->le_csr = LE_INEA | LE_TDMD;
      V(&Lance_sem);
      splx(x);
      msg_free(packet);
      return (0);
    }
    tmd = Es->es_tmdp[Es->es_next_tmd];
    msg_clear(Es->es_save_tmsg[Es->es_next_tmd]);  /* patch leak */
    TRACE2(ether, 5, "Using Transmit Desc. %d (last %d)", Es->es_next_tmd,
		Es->es_last_tmd);
    Es->es_next_tmd = (Es->es_next_tmd == LE_TBUFS - 1)? 0 :
			Es->es_next_tmd + 1;

    TRACE3(ether, 5, "putting frag (%x), size %d, str = %x in descriptor",
	(int)p, p->len, (int)p->str);
    /* Enter buffer data into the descriptor */
    tmd->lmd_hadr = ((int)p->str) >> 16;
    tmd->lmd_ladr = ((u_short) p->str);
    tmd->lmd_bcnt = -(p->len);
    tmd->lmd_flags3 = 0;
    flags = LMD_OWN;
    if (p == frag)
      flags = flags | LMD_STP;
    if (p->next == NULL)
      flags = flags | LMD_ENP;
    TRACE5(ether, 5, "TMD= HADR %x, LADR %x, FLAGS %x, FLAGS3 %x, BCNT %d",
		tmd->lmd_hadr, tmd->lmd_ladr, flags, tmd->lmd_flags3,
		tmd->lmd_bcnt);
    if (p != frag)
      tmd->lmd_flags = flags;
    else 
      firstflags = flags;
    q = p->next;
    free_frag(p);
    } /* for */
  Es->es_save_tmsg[which] = packet; /* patch leak */
  Es->es_tmdp[which]->lmd_flags = firstflags;
  le->le_csr = LE_INEA | LE_TDMD;

  splx(x);
  V(&Lance_sem);
  TRACE0(ether, 3, "done with ethCtlrXmit");
  return (0);
} /* ethCtlrXmit */


/* -------------------------------------------------------------------- */
/* Called at Interrupt time						*/
/* -------------------------------------------------------------------- */

lance_ih()
{
  register struct le_md	*tmd;
  register struct le_device	*le = Es->es_lance;

  TRACE0(ether, 7, "in lance_ih");
  if (le->le_csr & LE_RINT) {
    TRACE0(ether, 4, "lance_ih: receive interrupt");
    ethRcvIt();
  }

  else if (le->le_csr & LE_TINT) {
    tmd = Es->es_tmdp[Es->es_last_tmd];
    TRACE3(ether, 3, "le: transmit interrupt w/ flags=%x flags3%x desc=%d",
	tmd->lmd_flags, tmd->lmd_flags3, Es->es_last_tmd);
    if ( (tmd->lmd_flags & LMD_ERR) || (tmd->lmd_flags3 & TMD_BUFF)) {
      if (tmd->lmd_flags3 & TMD_BUFF) printf("TMD_BUFF error\n");
      if (tmd->lmd_flags3 & TMD_UFLO) printf("TMD_UFLO error\n");
      if (tmd->lmd_flags3 & TMD_LCOL) printf("TMD_LCOL error\n");
      if (tmd->lmd_flags3 & TMD_LCAR) printf("TMD_LCAR error\n");
      if (tmd->lmd_flags3 & TMD_RTRY) printf("TMD_RTRY error\n");
      if (tmd->lmd_flags3 & TMD_TDR)  printf("TMD_TDR error\n");
      }
    le->le_csr = LE_TINT | LE_INEA;     /* Clear interrupt */
    /* Reclaim transmit descriptors */
    while (!(tmd->lmd_flags & LMD_OWN) && trans_buf_cnt < LE_TBUFS) {
      if (!msg_isnull(Es->es_save_tmsg[Es->es_last_tmd])) { /* patch leak */
	msg_free(Es->es_save_tmsg[Es->es_last_tmd]);
	TRACE1(ether, 7,"calling free for desc %d",Es->es_last_tmd);
      }
      Es->es_last_tmd = (Es->es_last_tmd == LE_TBUFS- 1) ? 0 :
			Es->es_last_tmd + 1;
      tmd = Es->es_tmdp[Es->es_last_tmd];
      trans_buf_cnt++;
      } /* while */
    } /* if */

  if (le->le_csr & LE_ERR) {
    IFTRACE(ether, 1) {
      TRACE0(ether, 6, "lance_ih: ERROR DETECTED");
      /* some error has occurred */
      if (le->le_csr & LE_BABL)
        TRACE0(ether, 7, "lance_ih: babble error");
      if (le->le_csr & LE_CERR)
        TRACE0(ether, 7, "lance_ih: collision error");
      if (le->le_csr & LE_MISS)
        TRACE0(ether, 7, "lance_ih: missed packet error");
      if (le->le_csr & LE_MERR)
        TRACE0(ether, 7, "lance_ih: memory error");
      } /* IFTRACE */
    /* clear error bits */
    le->le_csr = LE_BABL | LE_CERR | LE_MISS | LE_MERR | LE_INEA;
    }

TRACE0(ether, 5, "done with lance_ih");

}

/* -------------------------------------------------------------------- */
/* Called by lance_ih to handle a receive interrupt; forks eth_demux	*/
/* -------------------------------------------------------------------- */

ethRcvIt()
{
  register struct le_device	*le = Es->es_lance;
  register struct le_md    *rmd;
  Msg	msg;
  int  	length;
  ethHdr_t *h;

  TRACE0(ether, 3, "le: in ethRcvIt");
  rmd = Es->es_rmdp[Es->es_next_rmd];

  le->le_csr = LE_RINT | LE_INEA;     /* Clear interrupt */
  /* while (we own the current buffer)  */
  while (!(rmd->lmd_flags & LMD_OWN)) {

    TRACE1(ether, 3, "le: ethRcvIt: received packet (%d)",
		Es->es_next_rmd);

    /* turn the RINT bit off */
    le->le_csr = LE_RINT | LE_INEA;     /* Clear interrupt */

    if ( (rmd->lmd_flags & ~RMD_OFLO) != (LMD_STP|LMD_ENP) ) {
      TRACE1(ether, 3, "Receive packet error - rmd flags %x",rmd->lmd_flags);
      rmd->lmd_mcnt = 0;
      rmd->lmd_flags = LMD_OWN;
    }
    else {  /* Got a good packet; get msg and give it to a process */
      length = rmd->lmd_mcnt - 4;	/* don't count the 4 CRC bytes */
      TRACE1(ether, 3, "Packet of length %d", length);
      msg = Es->es_save_rmsg[Es->es_next_rmd];
      msg.stack->base =msg.stack->stack + length - 1;
      msg.stack->size = length;
      msg_push(msg, length);
      h = (ethHdr_t *) msg_top(msg,sizeof(ethHdr_t));
      msg_pop(msg, sizeof(ethHdr_t));
      if (!CreateKernelProcess(eth_demux, 5,
		  (sizeof msg + 3) / 4 + 1 + 2 * ((sizeof h->srcEthAd + 3) /4),
		  msg, h->ethType, h->srcEthAd, h->destEthAd)) {

	msg_free(msg);
	TRACE0(ether, 1, "create process failed");
      }
      else
	TRACE0(ether, 3, "back from create process");
      /* allocate a new buffer to replace the one just used */
      msg_make_allstack(msg, LANCERBUFSIZ, (char *) 0, 0);
      install_buf_in_rmd(msg, Es->es_next_rmd);
      TRACE0(ether, 3, "back from install_buff_in_rmd");
    }

    /* Get ready to use the other buffer next time */
    /* What about errors ? */
    Es->es_next_rmd = (Es->es_next_rmd == LE_RBUFS - 1) ? 0:
			Es->es_next_rmd + 1;
    rmd = Es->es_rmdp[Es->es_next_rmd];

    TRACE0(ether, 3, "buffer restored");
    }  /* while */

  TRACE0(ether, 3, "done with ethRcvIt");
  return(0);
}  /* ethRcvIt */


/* -------------------------------------------------------------------- */
/* Takes a message and returns a list of message fragments, each	*/
/* fragment points to a chunk of data and gives the data length		*/
/* In addition this routine will insure that the first fragment is at 	*/
/* least LANCE_MIN_TU bytes in length.					*/
/* -------------------------------------------------------------------- */

static msg_frag *gather_frags(msg, count)
Msg msg;
int *count;
{
  int slen, blen;
  msg_frag  *frag;

  TRACE0(ether, 7, "in gather_frags");
  slen = msg_stack_len(msg);
  blen = msg_data_len(msg);
  *count = 0;
  if (slen > 0) {
    (*count)++;
    alloc_frag(frag);
    frag->str =  msg_top(msg, slen);
    frag->len = slen;
    frag->next = NULL;
  }
  if (blen > 0)
    (void) get_msg_frags(msg.data, 0, blen, frag, count); /* ignore new tail */
  TRACE0(ether, 7, "leaving gather_frags");    
  return(frag);
}  /* gather_frags */


/* -------------------------------------------------------------------- */
/* Actually do the work; called by gather_frags	*/
/* -------------------------------------------------------------------- */

static msg_frag *get_msg_frags(msg, off, len, tail, count)
register NMSG msg;
register msg_frag *tail;
int *count;
{
  int tlen, toff;
  register msg_frag *frag;

  switch(msg->tag) {
    case NM_Contig:
      (*count)++;
      alloc_frag(frag);
      frag->str = &msg->body.contig.data[off+msg->off];
      frag->len = len;
      frag->next = NULL;
      tail->next = frag;	/* assume tail not NULL */
      tail = frag;
      break;
    case NM_Single:
      tail = get_msg_frags(msg->body.single, off + msg->off, len, tail, count);
      break;
    case NM_Pair:
      toff = off + msg->off;
      tlen = msg->body.pair.l->len - toff;
      if (msg->len - off < tlen)
	tlen = msg->len - off;
      if (tlen > len)
	tlen = len;
      if (tlen > 0) {
	tail = get_msg_frags(msg->body.pair.l, toff, tlen, tail, count);
        }
      else
	tlen = 0;
      toff = off + msg->off - msg->body.pair.l->len;
      if (toff < 0)
	toff = 0;
      tlen = len - tlen;
      if (tlen > 0) {
	tail = get_msg_frags(msg->body.pair.r, toff, tlen, tail, count);
      }
      break;
    }
  return tail;  
}

SetPromiscusous()
{
  struct le_init_block *ib = &Es->es_ib;

  ib->ib_prom = 1;
}
E 1
