(* Variables - Definition v3 pages 4,5 *)

(*
$File: Common/VAR.sml $
$Date: 1992/08/19 14:48:06 $
$Revision: 1.14 $
$Locker: birkedal $
*)

(*$VAR *)

signature VAR =
  sig
    type id and longid and strid

    eqtype longvar
    val mk_longvar : longid  -> longvar
    and pr_longvar : longvar -> string

    eqtype var
    val mkVar: id -> var
    val unVar: var -> id

    and pr_var : var -> string

    val unqualified : longvar -> bool
    and decompose   : longvar -> strid list * var

   (* The variable `prim'. *)
    val var_PRIM: var
    (* The overloaded predefined variables *)
    val var_ABS  : var
    val var_NEG  : var
    val var_PLUS : var
    val var_MINUS: var
    val var_MUL  : var
    val var_LESS   : var
    val var_GREATER: var
    val var_LESSEQ : var
    val var_GREATEREQ: var

   (* bogus long variable *)
    val bogus : longvar
  end;

