(* Reporting of errors, binding, and so on. Tidier than the stuff
   generated by the pretty-printer. *)

(*
$File: Common/Report.sml $
$Date: 1992/02/13 11:32:33 $
$Revision: 1.2 $
$Locker: birkedal $
*)

(*$Report: BASIC_IO REPORT*)
functor Report(structure BasicIO: BASIC_IO): REPORT =
  struct
    datatype Report = REPORT of string list

    val null = REPORT nil
    fun line s = REPORT [s]

    infix //
    fun (REPORT r1) // (REPORT r2) = REPORT(r1 @ r2)

    val flatten = List.foldR (General.curry op //) null

    fun indent(i, REPORT lines) =
      REPORT(map (fn x => String.create i " " ^ x) lines)

    fun decorate(text, REPORT lines) =
      let
	val space = String.create (String.size text) " "

	fun f(str, line :: rest) = (str ^ line) :: f(space, rest)
	  | f(_, nil) = nil
      in
	REPORT(f(text, lines))
      end

    fun print(REPORT lines) = (map BasicIO.println lines; ())
  end;
