/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_utils.c[3.8] Fri Feb  7 20:28:54 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>
  
#include "vadm.h"
#include "vadmdefs.h"

extern char *malloc();

/**/
int GetGenerationNumber (version)
     char *version;
{
  /*
   * Returns the generation number (as an int) from a version specification
   * (as a string), e.g.: 2.1 ==> 2
   */
  register int i;
  char tmp[MSGLEN];
    
  if ( (!version) || (! *version) || (*version == '.') ) return -1;

  i = 0;
  while (*version) {
    if (*version == '.') {
      tmp[i] = '\0';
      return atoi(tmp);
    }
    else {
      tmp[i] = *version;
      version++; i++;
    }
  }
  return atoi(tmp);
}

/**/
int GetRevisionNumber (version)
     char *version;
{
  /*
   * Returns the revision number (as an int) from a version specification
   * (as a string), e.g.: 2.1 ==> 2
   */
  register int i;
  char tmp[MSGLEN];
  register char *cp;
  
  if ( (!version) || (! *version) ) return -1;

  if (! (cp = rindex (version, '.'))) return -1;

  cp++;

  if (!*cp) return -1;		/* version_num was: any.\0 */
  
  i = 0;
  while (*cp) {
    tmp[i] = *cp;
    cp++; i++;
  }
  tmp[i] = '\0';
  return atoi(tmp);
}

logmsg (msg) char *msg; {
  if (!IsOptionSet(Vopt_quiet)) {
    fprintf (stdout, "%s\n", msg);
  }
}

logwng (msg) char *msg; {
  if (!IsOptionSet(Vopt_quiet)) {
    fprintf (stdout, "Warning: %s\n", msg);
  }
}

logerr (msg) char *msg; {
  fprintf (stderr, "%s: %s\n", progname, msg);
}

Sfunc_t interrupt_action () { /* is executed by appropriate signal handler */

  if (ask_confirm ("\nDo you really want to quit this ?", "yes"))
    exit (1);
  else
    return;
}
