/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_promote.c[3.14] Fri Feb  7 20:28:34 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "vadm.h"
/* #include "locks.h" now in afsapp.h */

/* external */
extern char *malloc(), *st_table[];
extern unsigned int options;
extern int def_vnum;
extern struct Transaction ThisTransaction;

/* locals */
char buf[2048];

/**/
static
int do_promote (set)
     Af_set *set;
{
  int i, oldstate;
  int errs = 0;
  char version[1024];

  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_promote: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    if (setjmp (ThisTransaction.tr_env)) continue;
    mkvstring (version, &set->af_klist[i]);
    if ((oldstate = af_rstate (&set->af_klist[i])) == -1) {
      af_perror ("do_promote()");
      return 1;
    }

    switch (oldstate) {
    case AF_BUSY:
      (void)sprintf (buf, "%s busy. Fatal", version);
      logmsg (buf);
      vctl_abort ("CONTACT LOCAL GURU"); /* no return */
      break;
    case AF_SAVED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	return 1;
      }
      if (af_sstate (&set->af_klist[i], AF_PROPOSED) == -1) {
	af_perror ("af_sstate():");
	return 1;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s promoted to state \"%s\".", version,
	       st_table[AF_PROPOSED]);
      logmsg (buf);
      break;
    case AF_PROPOSED:
      if ((lockeruid(vc_lock (&set->af_klist[i],(Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	return 1;
      }
      if (af_sstate (&set->af_klist[i], AF_PUBLISHED) == -1) {
	af_perror ("af_sstate():");
	return 1;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s promoted to state \"%s\".", version,
	       st_table[AF_PUBLISHED]);
      logmsg (buf);
      break;
    case AF_PUBLISHED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	return 1;
      }
      if (af_sstate (&set->af_klist[i], AF_ACCESSED) == -1) {
	af_perror ("af_sstate():");
	return 1;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s promoted to state \"%s\".", version,
	       st_table[AF_ACCESSED]);
      logmsg (buf);
      break;
    case AF_ACCESSED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	return 1;
      }
      if (af_sstate (&set->af_klist[i], AF_FROZEN) == -1) {
	af_perror ("af_sstate():");
	return 1;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s promoted to state \"%s\".", version,
	       st_table[AF_FROZEN]);
      logmsg (buf);
      break;
    case AF_FROZEN:
      (void)sprintf (buf, "%s already frozen. --- Not promoted.", version);
      logmsg (buf);
      errs++;
      break;
    default:
      (void)sprintf (buf, "%s has unknown version state %d.", version, oldstate);
      logmsg (buf);
      vctl_abort ("CONTACT LOCAL GURU.");
    }
  }
  if (errs)
    return 1;
  else
    return 0;
}

/**/
int DoPromote (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!(vlist->from_version_set) || !(vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_LASTVERS, AF_LASTVERS, &set, &erroneous);
    else
      errs = GetKeysByName ( ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!Vopt_quiet) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_promote (&set);
}

int DoSetState (vlist, action, ac, av)
     struct vc_vlist *vlist;
     int action, ac;
     char **av;
{
  Af_set set;
  int errs, t_state;
  char **erroneous;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!(vlist->from_version_set) || !(vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_LASTVERS, AF_LASTVERS, &set, &erroneous);
    else
      errs = GetKeysByName ( ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!Vopt_quiet) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  switch (action) {
  case Varg_submit:
    t_state = AF_PROPOSED;
    break;
  case Varg_publish:
    t_state = AF_PUBLISHED;
    break;
  case Varg_access:
    t_state = AF_ACCESSED;
    break;
  case Varg_freeze:
    t_state = AF_FROZEN;
    break;
  default:
    logerr ("Argh! Impossible switch in DoSetState()");
    return 1;
  }
  return do_setstate (&set, t_state);
}
  
/**/
static
int do_setstate (set, state)
     Af_set *set;
{
  Af_key *key;
  int oldstate, sdiff;
  int errs = 0;
  register int i;
  char version[1024], messg[128];

  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_setstate: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    key = &set->af_klist[i];
    mkvstring (version, key);
    if (setjmp (ThisTransaction.tr_env)) continue;
    if ((oldstate = af_rstate (key)) == -1) {
      af_perror ("do_setstate()");
      return 1;
    }
    if ((sdiff = (state - oldstate)) > 0) {
      if ((lockeruid(vc_lock(key, (Uid_t)geteuid()))) != (Uid_t)geteuid()) {
	(void) sprintf (messg, "can't change %s's state to %s -- locked.", 
			version, st_table[state]);
	logerr (messg);
	errs++;
	continue;
      }
      if (oldstate == AF_BUSY) {
	(void) sprintf (messg, "can't change %s's state, it's a busy version.",
			version);
	logerr (messg);
	errs++;
	(void)vc_unlock(key);
	continue;
      }
      if (af_sstate (key, oldstate+sdiff) == -1) {
	(void) sprintf (messg, "af_setstate: while processing %s", 
			version);
	af_perror (messg);
	return 1;
      }
      (void) sprintf (messg, "%s set to state %s.", version, 
		      st_table[state]);
      logmsg (messg);
      (void)vc_unlock(key);
      (void)af_dropkey (key);
    }
    /* else: state already is at least "state" */
    else {
      (void) sprintf (messg, "%s already better than %s.", version,
		      st_table[state]);
      logmsg (messg);
      (void) af_dropkey (key);
    }
  }
  return errs;
}

/**/
static
int do_unpromote (set)
     Af_set *set;
{
  int i, oldstate;
  int errs = 0;
  char version[1024];

  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_unpromote: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue;
    if ((oldstate = af_rstate (&set->af_klist[i])) == -1) {
      af_perror ("do_promote()");
      errs++;
      continue;
    }

    switch (oldstate) {
    case AF_BUSY:
      (void)sprintf (buf, "%s busy. Fatal", version);
      logmsg (buf);
      vctl_abort ("CONTACT LOCAL GURU"); /* no return */
      break;
    case AF_SAVED:
      (void)sprintf (buf, "%s already saved.", version);
      logmsg (buf);
      errs++;
      break;
    case AF_PROPOSED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	errs++;
	break;
      }
      if (af_sstate (&set->af_klist[i], AF_SAVED) == -1) {
	af_perror ("af_sstate():");
	errs++;
	break;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s unpromoted to state \"%s\".", version, 
	       st_table[AF_SAVED]);
      logmsg (buf);
      break;
    case AF_PUBLISHED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	errs++; break;
      }
      if (af_sstate (&set->af_klist[i], AF_PROPOSED) == -1) {
	af_perror ("af_sstate():");
	errs++; break;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s unpromoted to state \"%s\".", version,
	       st_table[AF_PROPOSED]);
      logmsg (buf);
      break;
    case AF_ACCESSED:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	errs++; break;
      }
      if (af_sstate (&set->af_klist[i], AF_PUBLISHED) == -1) {
	af_perror ("af_sstate():");
	errs++; break;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s unpromoted to state \"%s\".", version,
	       st_table[AF_PUBLISHED]);
      logmsg (buf);
      break;
    case AF_FROZEN:
      if ((lockeruid(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) != 
	  (Uid_t)geteuid()) {
	logerr ("can't change state -- locked");
	errs++; break;
      }
      if (af_sstate (&set->af_klist[i], AF_ACCESSED) == -1) {
	af_perror ("af_sstate():");
	errs++; break;
      }
      (void)vc_unlock (&set->af_klist[i]);
      (void)sprintf (buf, "%s unpromoted to state \"%s\".", version,
	       st_table[AF_ACCESSED]);
      logmsg (buf);
      break;
    default:
      (void)sprintf (buf, "%s has unknown version state %d.", version, oldstate);
      logmsg (buf);
      vctl_abort ("CONTACT LOCAL GURU.");
    }
  }
  return errs;
}

/**/
int DoUnpromote (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!(vlist->from_version_set) || !(vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_LASTVERS, AF_LASTVERS, &set, &erroneous);
    else
      errs = GetKeysByName (ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!Vopt_quiet) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_unpromote (&set);
}
