/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_note.c[3.23] Mon Mar  9 20:54:19 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "vadm.h"
/* #include "locks.h" now in afsapp.h */

/* Externals */
extern int af_errno;
extern jmp_buf here;		/* reentrance point after we caught a sig */
extern char *malloc (), *getenv();
extern char **environment;	/* pointer to our environment */
extern struct Transaction ThisTransaction;
extern char *get_from_stdin();	/* read a text from stdin */
extern int call_editor();	/* returns a text */
extern char *FindProgram(), *FindFile();
extern unsigned int options;
extern int def_vnum;

/* locals */
static char buf[MSGLEN];		/* buffer for error messages */
static char *editor;		/* user's favorite editor*/

/**/
static
int determine_defaults ()
{
  /*
   * Returns 0 on error (editor not found, editor not executable, and so).
   * 1 on success.
   */
  char *neweditor;
  int ask_default = 0;		/* if env-editor is not available */
				/* user if he/she want's default editor */

  /* examine user's favorite editor, if any */
  if ((editor = getenv ("EDITOR")) == NULL)
    editor = DEFAULT_EDITOR;

  if (!index (editor, '/'))
    if ((neweditor = FindFile (editor)) == NULL) {
      (void)sprintf (buf, "Sorry, your favorite editor %s is not available on this machine.",
		     editor);
      logmsg (buf);
      ask_default++;
    }
    else
      editor = neweditor;
  
  /* is editor executable ? */
  if (!ask_default && !FileExecutable (editor)) {
   (void)sprintf (buf, "Sorry, your favorite editor %s is not executable.",
	     editor);
    logmsg (buf);
    ask_default++;
  }
  
  if (ask_default) {
    /* if default editor not available resign. */
    if (strcmp (editor, DEFAULT_EDITOR)) {
      (void)sprintf (buf, "Do you accept default editor %s ?", DEFAULT_EDITOR);
      if (ask_confirm (buf, "yes")) {
	editor = DEFAULT_EDITOR;
	if (!FileExecutable (editor)) {
	  logmsg ("Arrg, also default editor is not available. --- I resign.");
	  return 0;
	}
      }
      else
	return 0;		/* user doesn't want */
    }
    else
      return 0;			/* default editor is not available */
  }
  return 1;
}

/**/
static
int note_ok (newnote, oldnote)
     char *newnote, *oldnote;
{
  /*
   * returns 0 if no changes detected, 1 otherwise.
   */
    
  if (!newnote) {
    if ((!Vopt_quiet) &&
	ask_confirm ("Description is empty. Save anyway ?", "no"))
      return 0;
    else
      return 1;
  }
      
  if (oldnote && !strcmp (newnote, oldnote)) {
    logmsg ("No changes detected.");
    return 0;
  }

  /* newnote contains only layout ? */
  while (*newnote) {
    switch (*newnote) {
    case ' ':
    case '\n':
    case '\t':
      break;
    default:
      return 1;
      break;
    }
    newnote++;
  }

  if ((!Vopt_quiet) &&
      ask_confirm ("Description contains only layout. Save anyway?", "no"))
    return 0;
  else
    return 1;
}

/**/
static
int save_it (key, note)
     Af_key *key;
     char *note;
{
  af_snote (key, note);
  ThisTransaction.tr_done = 1;
}

/**/
static
int save_note_multiple (note, set)
     char *note;
     Af_set *set;
{
  int i, rc = 0;

  for (i = 0 ; i < set->af_nkeys; i++) {
    rc += af_snote (&(set->af_klist[i]), note);
  }
  if (note) free (note);
  return rc;
}

/**/
static
int process_notes (set, change_it)
     Af_set *set;
     int change_it;
{
  int i;
  char *cp, *note, *newnote, *mktemp();
  int retcode;			/* retcode from editor */
  char tmp_file[MSGLEN];		/* tmp-file's name */
  char name[MAXNAMLEN], nametype[MAXTYPLEN], tmpfnam[MAXNAMLEN];
  
  if (!determine_defaults ())	/* that is the editor */
    return -1;
  
  CatchSigs ();

  /* read description per file and save if changes. */
  for (i = 0; i < set->af_nkeys; i++) {

    /* remember this location */
    if (setjmp (ThisTransaction.tr_env)) {
      if ( i < set->af_nkeys )
	continue;
      else
	return 0;
    }

    /* construct file name */
    cp = af_rtype(&set->af_klist[i]); cp = (cp ? cp : "");
    (void)sprintf (nametype, "%s", cp);
    cp = af_rname(&set->af_klist[i]); cp = (cp ? cp : "");
    (void)sprintf (name,  "%s%s%s", cp,
	     nametype ? "." : NULL,
	     nametype ? nametype : NULL);
    
    ThisTransaction.tr_seqno = i;
    (void)strcpy (ThisTransaction.tr_fname, name);
    ThisTransaction.tr_done = 0;
      
    /* print afsname and version */
    mkvstring (buf, &set->af_klist[i]);
    logmsg (buf);		/* this file */

    if (af_rstate (&set->af_klist[i]) == AF_BUSY) {
      if (change_it)
	logerr ("Can't change note of a busy version.");
      else
	logerr ("Can't set note for a busy version.");
      continue;
    }
    (void) strcpy (tmpfnam, "/tmp/vctlXXXXXX");
    (void)strcpy (tmp_file, mktemp (tmpfnam));

    /* Do we change the old note ? */
    if (change_it) {		/* get old note */
      note = af_rnote (&set->af_klist[i]);

      /* Note "Empty log message" is an empty note  */
      if (!strcmp (note ? note : "", EMPTYNOTE)) {
	if (note) free (note);
	note = NULL;
      }
    }
    else
      note = NULL;
    
    newnote = NULL;
    retcode = call_editor (editor, tmp_file, note, &newnote);
      
    if (retcode == -1) {	/* editor exited abnormally */
      if (i == (set->af_nkeys - 1)) {
	logmsg ("Description lost.");
	return 1;
      }
      
      if ((!Vopt_quiet) && 
	  ask_confirm ("Description lost. Continue ?", "no"))
	return 1;
      else
	continue;
    }
    
    if (note_ok (newnote, note)) { /* any changes ? */
      save_it (&set->af_klist[i], newnote);
      logmsg ("Description saved.");
    }
    else
      logmsg ("Description not saved.");
    
    if (note)
      free (note);
    
    if (newnote)
      free (newnote);
  }
  return 0;
}

/**/
print_erroneous (erroneous, errs)
     char **erroneous;
     int errs;
{
  int i, j;
  extern char *progname;
  
  fprintf (stderr, "%s: can't find appropriate version of", progname);
  j = 0;
  for (i = 0; i < errs; i++) {
    if (++j == errs)
      if (errs == 1)
	fprintf (stderr, " \"%s\".\n", erroneous[i]);
      else
	fprintf (stderr, " and \"%s\".\n", erroneous[i]);
    else
      fprintf (stderr, " \"%s\",", erroneous[i]);
  }
}

/**/
static
int do_note (vlist, ac, av, change_it)
     struct vc_vlist *vlist;
     int ac;
     char **av;
     int change_it;
{
  Af_set set;
  int errs;
  char **erroneous;
  
  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, 
	 &erroneous);
  }
  else {
    if (! ((vlist->from_version_set) || vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
    else
      errs = GetKeysByName (ac,av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  /* all given files do not exist ? */
  if (!set.af_nkeys) {
    return 1;
  }

  if (af_sortset (&set, AF_ATTHUMAN) == -1) {
    af_perror ("Do_note: af_sortset AF_ATTHUMAN");
    return 1;
  }
      
  /* If stdin is redirected use text as description for *all* AtFS files. */
  if ((!isatty (0)) || IsOptionSet(Vopt_stdin)) {
    /* do not append to old desc. Also we have no special term-char.
     * Read until EOF. */
    return save_note_multiple (get_from_stdin ('.'), &set);
  }
  
  /* shall we go on if an error occurs? Ask user. */
  if (errs && (!Vopt_quiet) && (!ask_confirm ("Continue anyway ?", "yes")))
      return 1;
    
  return process_notes (&set, change_it);
}

/**/
int DoSetNote (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  return do_note (vlist, ac, av, 0); /* don't change existing note */
}

/**/
int DoChangeNote (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  return do_note (vlist, ac, av, 1); /* change existing note */
}

/**/
static
int do_description (vlist, ac, av, change_it)
     struct vc_vlist *vlist;
     int ac;
     char **av;
     int change_it;		/* if set, append to old note */
{
  /*
   * Changes an existing description note of the first version (i.e. 1.0)
   * of an AtFS file. Returns 0 on success, otherwise 1 to indicate an error.
   */

  Af_set set;
  int errs = 0;			/* # of not found AtFS files */
  char **erroneous;
  
  /* A version list makes no sence. Ignore it, but display warning msg. */
  if (vlist->from_version_set || vlist->to_version_set)
    logwng ("version specification list ignored.");
  
  errs = GetKeysByGenRev (ac,av, AF_FIRSTVERS, AF_FIRSTVERS, &set, 
			  &erroneous);

  if (errs)
    print_erroneous (erroneous, errs);
  
  /* all given files do not exist ? */
  if (!set.af_nkeys) {
    return 1;
  }
    
  if (af_sortset (&set, AF_ATTHUMAN) == -1) {
    af_perror ("Do_description: af_sortset AF_ATTHUMAN");
    return 1;
  }
      
  /* If stdin is redirected use text as description for *all* AtFS files. */
  if ((!isatty (0)) || IsOptionSet(Vopt_stdin)) {
    /* do not append to old desc. Also we have no special term-char.
     * Read until EOF. */
    return save_note_multiple (get_from_stdin ('.'), &set);
  }
    
  /* shall we go on if an error occurs? Ask user. */
  if (errs && (!Vopt_quiet) && (!ask_confirm ("Continue anyway ?", "yes")))
    return 1;

  return process_notes (&set, change_it);
}

/**/
int DoSetDescription (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  return do_description (vlist, ac, av, 0); /* don't change existing note */
}

/**/
int DoChangeDescription (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  return do_description (vlist, ac, av, 1); /* change to old note */
}

int DoSetIntent (ac, av) int ac; char **av; {
  /* We must hold the lock for the history, that we wanna change. */
  register int i;
  int rc, rcsum = 0;
  char fname[MSGLEN], messg[MSGLEN], *oldintent, *intent, 
  *getintent(), *intattr,
       *lockerid(), *mkfn();
  Af_key thiskey;
  Af_user *locker;

  for (i=0; i < ac; i++) {
    if (setjmp (ThisTransaction.tr_env)) continue;
    rc = af_getkey (af_afpath (av[i]), af_afname (av[i]), 
		    af_aftype (av[i]), AF_LASTVERS, AF_LASTVERS, &thiskey);
    if (rc < 0) {
      (void)sprintf (messg, "can't find most recent version of %s.", av[i]);
      logerr (messg);
      continue;
    }
    mkvstring (fname, &thiskey);
    if (locked(locker=vc_testlock (&thiskey))) {
      if (lockeruid (locker) == (Uid_t)geteuid ()) {
	oldintent = af_rudattr (&thiskey, INTENT);
	intent = getintent ((char *)NULL, oldintent,
			    IsOptionSet(Vopt_stdin), mkfn (&thiskey));
	intattr = malloc ((unsigned)(strlen (intent) + strlen (INTENT) +1));
	if (intattr == (char *) NULL)
	  vctl_abort("Can't malloc");
	(void)sprintf (intattr, "%s%s", INTENT, intent);
	if (fail(af_sudattr (&thiskey, AF_REPLACE, intattr)))
	  af_sudattr (&thiskey, AF_ADD, intattr);
	if (oldintent) free (oldintent);
	free (intattr);
	af_dropkey (&thiskey);
      }
      else {
	(void)sprintf (messg, "Can't set intent on %s (locked by %s).",
		 fname, lockerid (locker));
	logerr (messg);
	af_dropkey (&thiskey);
	rcsum++;
	continue;
      }
    }
    else {
      (void)sprintf (messg, "You must have a lock on %s to set change intention.", 
	       fname);
      logerr (messg);
      af_dropkey (&thiskey);
      rcsum++;
      continue;
    }
  }
  return rcsum;
}    
