/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_delete.c[3.15] Fri Feb  7 20:28:16 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>

#include "atfs.h"
#include "atfsapp.h"
#include "vadm.h"
/*#include "locks.h" now in afsapp.h */

/* external */
extern char *malloc();
extern unsigned int options;
extern struct Transaction ThisTransaction;

/* locals */
static char buf[2048];

/**/
int DoDelete (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  Af_set set;
  Af_key *key, genlock;
  Af_user *vc_testlock(), *vc_lock();
  Uid_t lockeruid();
  char **erroneous, *lockerid();
  char version[1024];
  int state;
  int i;
  int errs = 0;

  errs = GetKeysByName (ac, av, vlist, &set, &erroneous);

  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs)
    if (IsOptionSet(Vopt_no_confirm) || IsOptionSet(Vopt_quiet) 
	|| !ask_confirm ("Continue ?", "yes"))
      return 1;

  ThisTransaction.tr_rc = 0;
  for (i = 0 ; i < set.af_nkeys; i++) {
    Af_user *thislock;
    ThisTransaction.tr_seqno = i;
    key = &set.af_klist[i];
    mkvstring (version, key);
    (void)strcpy (ThisTransaction.tr_fname, version);
    if (setjmp (ThisTransaction.tr_env)) continue;
    if ((state = af_rstate (key)) == -1) {
      (void) sprintf (buf, "DoDelete (%s): af_rstate", 
		      ThisTransaction.tr_fname);
      af_perror (buf);
      ThisTransaction.tr_rc++;
      continue;
    }

    if (state > AF_SAVED) {
      (void)sprintf (buf, "%s cannot be deleted. Version state must be \"saved\".",
	       version);
      logmsg (buf);
      ThisTransaction.tr_rc++;
      continue;
    }

    (void)sprintf (buf, "Delete %s ?", version);

    thislock = vc_testlock (key);
    if (locked(thislock)) {
      if (lockeruid (thislock) != (Uid_t)geteuid ()) {
	/* locked ! ... but by somebody else */
	(void)sprintf (buf, "No permission to delete %s (locked by %s).",
		 version, lockerid (thislock));
	logmsg (buf);
	continue;
      }
    }
    else { /* the version is not locked. We must lock it to delete it. */
      Af_user *tlock = vc_lock (key, (Uid_t)geteuid ());
      if (lockeruid (tlock) != (Uid_t)geteuid ()) {
	(void)sprintf (buf, "can't lock %s. Not deleted.", version);
	logmsg (buf);
	continue;
      }
    }

    if (!(IsOptionSet(Vopt_no_confirm) || IsOptionSet(Vopt_quiet)))
      if (!ask_confirm (buf, "yes")) {
	(void)sprintf (buf, "%s not deleted.", version);
	logmsg (buf);
	continue;
      }
    if (af_rm (key) == -1) {
      (void)sprintf (buf, "DoDelete(): During deletion of %s.", version);
      af_perror (buf);
      return 1;
    }
    (void)sprintf (buf, "%s deleted.", version);
    logmsg (buf);
  }

  if (errs)
    return 1;
  else
    return 0;
}

