/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * $Header: vadm.h[3.11] Fri Jun 28 20:32:32 1991 axel@cs.tu-berlin.de frozen $
 */


/* miscellaneous */
#define MAIL "/usr/ucb/mail -s 'Your lock on %s was broken by %s' "

/* options */
#define Vopt_help 01
#define Vopt_binary 02
#define Vopt_version 010000
#define Vopt_no_confirm 020000
#define Vopt_quiet 040000
#define Vopt_stdin 0100000
#define Vopt_nomail 0200000
#define Vopt_submit 0400000
#define Vopt_publish 01000000
#define Vopt_access 02000000
#define Vopt_freeze 04000000

/* actions */
#define Varg_reserve 1
#define Varg_unreserve 2
#define Varg_symname 3
#define Varg_delete 4
#define Varg_promote 5
#define Varg_unpromote 6
#define Varg_change_note 7
#define Varg_change_description 8
#define Varg_set_note 9
#define Varg_set_description 10
#define Varg_lock 11
#define Varg_unlock 12
#define Varg_chmod 13
#define Varg_chown 14
#define Varg_chaut 15
#define Varg_adduda 16
#define Varg_setuda 17
#define Varg_unsetuda 18
#define Varg_setattrs 19
#define Varg_setc_symbol 20
#define Varg_set_intent 22
#define Varg_remuda 23
#define Varg_submit 24
#define Varg_publish 25
#define Varg_access 26
#define Varg_freeze 27

#define SetBit(x,b) ((x) |= (b))
#define ClearBit(x,b) ((x) &= ~(b))
#define IsBitSet(x,b) ((x) & (b))
#define IsBitCleared(x,b) !(IsBitSet((x),(b)))

#define SetOption(b) SetBit(options, (b))
#define ClearOption(b) ClearBit(options, (b))
#define IsOptionSet(b) IsBitSet (options, (b))
#define IsOptionCleared(b) IsBitCleared (options, (b))

#define SetAction(b) actions = actions ? 999 : (b)
#define ClearAction(b) actions = 0
#define IsActionSet(b) actions == (b)
#define IsActionCleared(b) !actions

struct vc_vlist {
  char from_version_set, to_version_set;
  int from_generation;
  int from_revision;
  int to_generation;
  int to_revision;
  struct vc_vlist *next;
};

