/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm.c[3.25] Fri Feb  7 20:28:07 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <signal.h>

#include <atfs.h>
#include <atfsapp.h>
#include <ParseArgs.h>
#include "vadm.h"

extern char *malloc();

/* forward declarations */
/*
 * Options (e.g. -V, -from, or -to) and actions (-delete, -set, etc.)
 * are parse at the same time by calling function ParseArgs().
 */

/* option */
extern int handle_binary_option ();
extern int handle_help_option ();	    /* handler for option -h */
extern int handle_version_option ();	    /* handler for -V option */
extern int handle_from_option ();	    /* handler for -from option */
extern int handle_to_option ();		    /* handler for -to option */
extern int handle_force_switch ();          /* handler for "force" */
extern int handle_quiet_option ();
extern int handle_R_option ();
char debug_on = 0;
extern int handle_d_option ();
extern int handle_stdin_option (); /* enables reading note from stdin  */
extern int handle_nomail_option (); /* suppress mail on broken locks */

/* actions */
extern int handle_reserve_action ();
extern int handle_unreserve_action ();
extern int handle_symname_action ();
extern int handle_setc_action ();
extern int handle_delete_action ();
extern int handle_promote_action ();
extern int handle_unpromote_action ();
extern int handle_change_action ();
extern int handle_lock_action ();
extern int handle_unlock_action ();
extern int handle_chmod_action ();
extern int handle_chown_action ();
extern int handle_chaut_action ();
extern int handle_set_action ();
extern int handle_setuda_action ();
extern int handle_unsetuda_action ();
extern int handle_setattrs_action ();
extern int handle_submit_action ();
extern int handle_publish_action ();
extern int handle_access_action ();
extern int handle_freeze_action ();

/* Global variables */
OptDesc argdesc[] = {	/* known options,actions and its handler */
  { "version", PSWITCH, handle_R_option, NULL, NULL },
  { "b", PSWITCH, handle_binary_option, NULL, NULL },
  { "f", PSWITCH, handle_force_switch, NULL, NULL },
  { "h", POARG, handle_help_option, NULL, NULL },
  { "V", PARG, handle_version_option, NULL, NULL },
  { "from", PARG, handle_from_option, NULL, NULL },
  { "to", PARG, handle_to_option, NULL, NULL },
  { "q", PSWITCH, handle_quiet_option, NULL, NULL },
  { "debug", PSWITCH|PHIDDEN, handle_d_option, NULL, NULL },
  { "symbolic", PARG, handle_symname_action, NULL, NULL },
  { "setc", PARG, handle_setc_action, NULL, NULL },
  { "delete", PSWITCH, handle_delete_action, NULL, NULL },
  { "promote", PSWITCH, handle_promote_action, NULL, NULL },
  { "unpromote", PSWITCH, handle_unpromote_action, NULL, NULL },
  { "lock", PSWITCH, handle_lock_action, NULL, NULL },
  { "unlock", PSWITCH, handle_unlock_action, NULL, NULL },
  { "chmod", PARG, handle_chmod_action, NULL, NULL },
  { "chown", PARG, handle_chown_action, NULL, NULL },
  { "chaut", PARG, handle_chaut_action, NULL, NULL },
  { "set", PARG, handle_set_action, NULL, NULL },
  { "remuda", PARG, handle_unsetuda_action, NULL, NULL },
  { "setuda", PARG, handle_setuda_action, NULL, NULL },
  { "unsetuda", PARG, handle_unsetuda_action, NULL, NULL },
  { "setattrs", PARG, handle_setattrs_action, NULL, NULL },
  { "stdin", PSWITCH, handle_stdin_option, NULL, NULL },
  { "nomail", PSWITCH, handle_nomail_option, NULL, NULL },
  { (char *) NULL, NULL, NULL, NULL, NULL }
};

unsigned int options = 0;	/* given options */
unsigned int actions = 0;	/* given actions */
char *progname;			/* program's name */
struct vc_vlist *vlist = (struct vc_vlist*) NULL;
     /* versions to be processed */
struct vc_vlist *vcur = (struct vc_vlist*) NULL;
int def_vnum;
int to_option_pending = 0;	/* if -from is given, -to is expected later */
int from_option_pending = 0;	/* if -to is given before any -from, -from is
				 * pending. If -to is followed by -V, any
				 * from-pending is rejected.*/ 
char *symname = NULL;		/* symbolic name -symname arg */
char *csym =  NULL;             /* comment leader symbol */
int newmode;
Af_user newauthor; /* arguments of the resp. actions */
char *TakeFromFile = NULL;      /* Filename, where uda-val will be taken
				   from (see handle_setuda_action) */
char Attrfile[MSGLEN];             /* Name of file where attribute definitions
				   will be taken from */
char udaname[AF_UDANAMLEN];     /* Name of uda to be set */
char udaval[MSGLEN];               /* String val to which udaname will be set */
struct Transaction ThisTransaction;
static char buf[MSGLEN];
char **environment;
jmp_buf here;

/**/
main (ac, av, ev)
     int ac;
     char **av, **ev;
{
  int nac;			/* ac after parsing */
  char **nav, *cp;		/* av after parsing */
  int retcode = 0;		/* return value */
  register int i, j;
  
  progname = (cp = rindex (av[0], '/')) ? ++cp : av[0];
  /* make prog-name available to entire program */
  environment = ev;		/*  */
  CatchSigs();
  if (setjmp (ThisTransaction.tr_env)) return 1; 
  InitVcontrol ();

  if (strcmp (progname, "vadm")) {
    if (!(strcmp (progname, "sbmt")))
      retcode=handle_submit_action ();
    else if (!(strcmp (progname, "publ")))
      retcode=handle_publish_action ();
    else if (!(strcmp (progname, "accs")))
      retcode=handle_access_action ();
    else if (!(strcmp (progname, "frze")))
      retcode=handle_freeze_action ();
  }

  if (ParseArgs (ac, av, &nac, &nav, argdesc)) {
    (void)sprintf (buf, "BTW, try \"%s -h\" for more information or rtfm.",
	     progname);
    logmsg (buf);
    exit (1);			/* error detected  */
  }
  /* Look for identical arguments -- zero out twins */
  for ( i = 0; i < nac; i++)
    for (j = i+1; j < nac;) 
      if (!strcmp (nav[i], nav[j])) {
	register int k;

	for (k = j+1; k < nac; k++) {
	  nav[k-1] = nav[k];
	}
	nav[--nac] = '\0';
      }
      else
	j++;

  if (debug_on)
    DumpVlist ();
  
  if (!nac) {
    if (actions)		/* if an action is given */
      logmsg ("Filenames missing.");
    else
      logmsg ("An action and filenames missing.");

    ShortUsage ();
    exit (1);
  }

  if (!ActionsPlausible ()) exit (1); /* no chance to do anything */

  switch (actions) {
  case Varg_set_note:
    retcode = DoSetNote (vlist, nac, nav);
    break;
  case Varg_change_note:
    retcode = DoChangeNote (vlist, nac, nav);
    break;
  case Varg_set_description:
    retcode = DoSetDescription (vlist, nac, nav);
    break;
  case Varg_change_description:
    retcode = DoChangeDescription (vlist, nac, nav);
    break;
  case Varg_set_intent:
    retcode = DoSetIntent (nac, nav);
    break;
  case Varg_setc_symbol:
    retcode = DoSetCommentSymbol (nac, nav, csym);
    break;
  case Varg_delete:
    retcode = DoDelete (vlist, nac, nav);
    break;
  case Varg_promote:
    retcode = DoPromote (vlist, nac, nav);
    break;
  case Varg_unpromote:
    retcode = DoUnpromote (vlist, nac, nav);
    break;
  case Varg_lock:
  case Varg_reserve:
    retcode = DoReserve (nac, nav);
    break;
  case Varg_unlock:
  case Varg_unreserve:
    retcode = DoUnreserve (nac, nav);
    break;
  case Varg_chmod:
    retcode = DoChmod (vlist, nac, nav);
    break;
  case Varg_chown:
    retcode = DoChown (nac, nav);
    break;
  case Varg_chaut:
    retcode = DoChaut (vlist, nac, nav);
    break;
  case Varg_symname:
    retcode = DoSymname (vlist, nac, nav, symname);
    break;
  case Varg_adduda:
  case Varg_setuda:
    retcode = DoSetUda (vlist, nac, nav);
    break;
  case Varg_remuda:
  case Varg_unsetuda:
    retcode = DoUnsetUda (vlist, nac, nav);
    break;
  case Varg_setattrs:
    retcode = DoSetAttrs (vlist, nac, nav);
    break;
  case Varg_submit:
  case Varg_publish:
  case Varg_access:
  case Varg_freeze:
    retcode = DoSetState (vlist, actions, nac, nav);
    break;
  default:
    logerr ("Ooops, You have requested more than one action.\
 Please try again");
    logmsg ("with only *one* action at a time.");
    retcode = 1;
    break;
  }
  
  if (retcode)
    logmsg ("terminated.");
  else
    logmsg ("done.");
  return (retcode);
}

/**/
int ActionsPlausible ()
{
  if (actions) {
    return 1;
  }
  else {
    logmsg ("Action missing.");
    ShortUsage ();
    return 0;
  }
}

/**/
int InitVcontrol ()
{
  if ((vlist = (struct vc_vlist*) malloc ((unsigned) sizeof(struct vc_vlist))) == NULL) {
    vctl_abort ("malloc vc_vlist");
  }

  vlist->from_version_set = vlist->to_version_set = NULL;
  vlist->from_generation =  NULL;
  vlist->from_revision =  NULL;
  vlist->to_generation = NULL;
  vlist->to_revision = NULL;
  
  vlist->next = NULL;
  vcur = vlist;
}

/**************************
 *     Action handlers    *
 *************************/
/**/
/*ARGSUSED*/
int handle_reserve_action (act, arg)
     char *act, *arg;
{
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't reserve or unreserve binary.");
    exit (1);
  }
  SetAction(Varg_reserve);	/* macro */
  if (IsActionSet(Varg_unreserve)) {
    logerr ("You already mentioned \"unreserve\", so what do you want ?");
    return 1;
  }
  return 0;
}

/*ARGSUSED*/
int handle_unreserve_action (act, arg)
     char *act, *arg;
{
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't reserve or unreserve binary.");
    exit (1);
  }
  SetAction(Varg_unreserve);
  if (IsActionSet(Varg_reserve)) {
    logerr ("You already mentioned \"reserve\", so what do you want ?");
    return 1;
  }
  return 0;
}

/*ARGSUSED*/
int handle_symname_action (act, arg)
     char *act, *arg;
{
  SetAction(Varg_symname);
  symname = arg;
  return 0;
}

/*ARGSUSED*/
int handle_setc_action (act, arg)
     char *act, *arg;
{
  csym = arg;
  if (strlen (csym) > (CLEADMAXLEN-(strlen(CLEAD)+2))) {
    logerr ("Specified comment leader symbol is too long");
    return 1;
  }
  SetAction(Varg_setc_symbol);
  return 0;
}  

/*ARGSUSED*/
int handle_delete_action (act, arg)
     char *act, *arg;
{
  SetAction(Varg_delete);
  return 0;
}

/*ARGSUSED*/
int handle_promote_action (act, arg)
     char *act, *arg;
{
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't promote status of binary.");
    exit (1);
  }
  SetAction(Varg_promote);
  if (IsActionSet(Varg_unpromote)) {
    logerr ("You already mentioned \"unpromote\", so what do you want ?");
    return 1;
  }
  return 0;
}

/*ARGSUSED*/
int handle_unpromote_action (act, arg)
     char *act, *arg;
{
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't unpromote status of binary.");
    exit (1);
  }
  SetAction(Varg_unpromote);
  if (IsActionSet(Varg_promote)) {
    logerr ("You already mentioned \"promote\", so what do you want ?");
    return 1;
  }
  return 0;
}

/*ARGSUSED*/
int handle_change_action (act, arg)
     char *act, *arg;
{
  char messg[MSGLEN];
  if (IsOptionSet (Vopt_binary)) {
    (void)sprintf (messg, "Can't change %s of binaries. Sorry.", 
	     arg ? arg : "note or description" );
    logerr (messg);
    exit (1);
  }
  if (!strcmp (arg, "note")) {
    SetAction(Varg_change_note);
    return 0;
  }
  if (!strcmp (arg, "description")) {
    SetAction(Varg_change_description);
    return 0; 
  }
  logerr ("Change what, eh? - Note or description?");
  return 1;
}

/*ARGSUSED*/
int handle_lock_action (act, arg) char *act, *arg; {
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't lock or unlock binary.");
    exit (1);
  }
  if (IsActionSet (Varg_unlock)) {
    logerr ("Can't lock and unlock at the same time.");
    exit (1);
  }
  SetAction (Varg_lock);
  return 0;
}

/*ARGSUSED*/
int handle_unlock_action (act, arg) char *act, *arg; {
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't lock or unlock binary.");
    exit (1);
  }
  if (IsActionSet (Varg_lock)) {
    logerr ("Can't lock and unlock at the same time.");
    exit (1);
  }
  SetAction (Varg_unlock);
  return 0;
}

/*ARGSUSED*/
int handle_chmod_action (act, arg) char *act, *arg; {
  register int mode = 0;
  char messg[MSGLEN], ciph, err = 0;
  register char *cp = arg;

  if (strlen (arg) > 4) err++;
  else 
    while (ciph = *cp++) { 
      ciph -= '0';
      if ((ciph > 7) || (ciph < 0)) err++;
      else {
	mode <<= 3;  
	mode += ciph;
      }
    }
  if (err) {
    (void)sprintf (messg, "invalid mode \"%s\".", arg);
    logerr (messg);
    exit (1);
  }
  SetAction (Varg_chmod);
  newmode = mode;
  return 0;
}

/*ARGSUSED*/
int handle_chown_action (act, arg) char *act, *arg; {
  char messg[MSGLEN];

  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't change owner of binary.");
    exit (1);
  }
  if (getpwnam (arg) == NULL) {
    (void)sprintf (messg, "%s is not a valid userid on this machine.", arg);
    logerr (messg);
    exit (1);
  }
  SetAction (Varg_chown);
/*  newowner = opw->pw_uid; */
  return 0;
}

/*ARGSUSED*/
int handle_chaut_action (act, arg) char *act, *arg; {
  char messg[MSGLEN], hostname[MAXHOSTNAMELEN];
  
  if (IsOptionSet (Vopt_binary)) {
    logerr ("Can't change author of binary.");
    exit (1);
  }
  if (getpwnam (arg) == NULL ) {
    (void)sprintf (messg, "%s is not a valid userid on this machine.", arg);
    logerr (messg);
    exit (1);
  }
  SetAction (Varg_chaut);
  (void) strcpy (newauthor.af_username, arg);
  (void) gethostname (hostname, MAXHOSTNAMELEN);
  (void) strcpy (newauthor.af_userhost, hostname);
  return 0;
}

/*ARGSUSED*/
int handle_setuda_action (act, arg) char *act, *arg; {
  char *cp;
  register int i;
  int tmpadduda = FALSE;

  if (strcmp (act, "adduda") == NULL) tmpadduda = TRUE;
  if (cp=index(arg, '=')) {
    if (arg == cp) { /* No attribute name */
      logerr ("No attribute name given");
      exit (1);
    }
    if (*(cp-1) == '+') tmpadduda = TRUE;
    if (*(cp+1) == '@') { /* the attribute value will be taken from file */
      TakeFromFile = malloc (128);
      if (TakeFromFile == NULL) {
	logerr ("Can't allocate memory for filename");
	exit (1);
      }
      (void)sscanf (cp+1, "@%s", TakeFromFile); /* ignore evtly. trailing junk */
      if (TakeFromFile ? TakeFromFile[0] ? 0 : 1 : 1) {
	/* condition holds if no filename specified */
	TakeFromFile = NULL;
	(void)strcpy (udaval, "@");
      }
    }
    else { /* attribute value will be taken literally */
      (void)strcpy (udaval, cp+1);
      for (i=0; udaval[i]; i++) {
	if (udaval[i] == 1) { /* cntl-A not allowed */
	  logerr ("Invalid char (cntl-A) in attribute value");
	  exit (1);
	}
      }
    }
    if ((cp-arg) > AF_UDANAMLEN) {
      logerr ("Attributename too long");
      exit (1);
    }
    (void)strncpy (udaname, arg, cp-arg);
    udaname[cp-arg] = '\0';
    if (tmpadduda) 
      SetAction (Varg_adduda);
    else 
      SetAction (Varg_setuda);
  }
  else { /* No '=' in arg */
    logerr ("Illegal format of attribute expression");
    exit (1);
  }
  return 0; /* OK */
}

/*ARGSUSED*/
int handle_unsetuda_action (act, arg) char *act, *arg; {
  char *cp, messg[MSGLEN];
  register int i;
  
  if (strcmp (act, "remuda") == NULL) {
    if (cp=index(arg, '=')) {
      if (arg == cp) { /* No attribute name */
	logerr ("No attribute name given");
	exit (1);
      }
      if (*(cp+1) == '@') { /* the attribute value will be taken from file */
	TakeFromFile = malloc (128);
	if (TakeFromFile == NULL) {
	  logerr ("Can't allocate memory for filename");
	  exit (1);
	}
	(void)sscanf (cp+1, "@%s", TakeFromFile); /* ignore evtly. trailing junk */
	if (TakeFromFile ? TakeFromFile[0] ? 0 : 1 : 1) {
	  /* condition holds if no filename specified */
	  TakeFromFile = NULL;
	  (void)strcpy (udaval, "@");
	}
      }
      else { /* attribute value will be taken literally */
	(void)strcpy (udaval, cp+1);
	for (i=0; udaval[i]; i++) {
	  if (udaval[i] == 1) { /* cntl-A not allowed */
	    logerr ("Invalid char (cntl-A) in attribute value");
	    exit (1);
	  }
	}
      }
      if ((cp-arg) > AF_UDANAMLEN) {
	logerr ("Attributename too long");
	exit (1);
      }
      (void)strncpy (udaname, arg, cp-arg);
      udaname[cp-arg] = '\0';
      SetAction (Varg_remuda);
    }
    else {
      (void)sprintf (messg, "%s\n%s", 
	     "\"remuda\" needs attributename and value. Use \"unsetuda\"",
		     "to discard entire attribute.");
      logerr (messg);
      exit (1);
    }
  }
  else { /* unsetuda */
      if (strlen(arg) > AF_UDANAMLEN) {
	logerr ("Attributename too long");
	exit (1);
      }
      (void)strcpy (udaname, arg);
      SetAction (Varg_unsetuda);
    }
  return 0;
}

/*ARGSUSED*/
int handle_setattrs_action (act, arg)
     char *act, *arg; {

       SetAction (Varg_setattrs);
       (void)strcpy (Attrfile, arg);
       return 0;
     }

/*ARGSUSED*/
int handle_set_action (act, arg)
     char *act, *arg;
{
  char messg[MSGLEN];

  if (IsOptionSet (Vopt_binary)) {
    (void)sprintf (messg, "Can't set %s on binaries. Sorry.", 
	     arg ? arg : "note or description" );
    logerr (messg);
    exit (1);
  }
  if (!strcmp (arg, "note")) {
    SetAction(Varg_set_note);
    return 0;
  }
  if (!strcmp (arg, "description")) {
    SetAction(Varg_set_description);
    return 0; 
  }
  if (!strcmp (arg, "intent")) {
    SetAction(Varg_set_intent);
    return 0;
  }
  logerr ("Set what, eh? - note, description, or intent ?");
  return 1;
}

int handle_submit_action () {
  SetAction (Varg_submit);
  SetOption (Vopt_submit);
  return 0;
}

int handle_publish_action () {
  SetAction (Varg_publish);
  SetOption (Vopt_publish);
  return 0;
}

int handle_access_action () {
  SetAction (Varg_access);
  SetOption (Vopt_access);
  return 0;
}

int handle_freeze_action () {
  SetAction (Varg_freeze);
  SetOption (Vopt_freeze);
  return 0;
}

/**************************
 *     Option handlers    *
 *************************/

/*ARGSUSED*/
int handle_binary_option (opt, arg) char *opt, *arg; {
  if (IsActionSet (Varg_reserve | Varg_unreserve | Varg_promote | 
		   Varg_unpromote | Varg_change_note | 
		   Varg_change_description | Varg_set_description | 
		   Varg_set_note | Varg_lock | Varg_unlock | Varg_chown | 
		   Varg_chaut)) {
    logerr ("This action request is not supported for binaries.");
    exit (1);
  }
  SetOption (Vopt_binary);
  return 0;
}

#ifdef NEVER_SET_THIS
int handle_version_option (opt, arg)
     char *opt, *arg;
{
  struct vc_vlist *vtmp;
  int generation = 0, revision = 0;
  
  if ((vcur->from_version_set) || (vcur->to_version_set)) {
    /* if any -to num pending, report error */
    if (to_option_pending) {
      (void)sprintf (buf, "\"-to <version number>\" expected. Got \"-%s %s\"",
	       opt, arg);
      logerr (buf);
      return 1;
    }

    if (from_option_pending) {
      from_option_pending = 0;	/* vctl -to 3.4 -from 5.6 -to 6.7 */
				/* means: from 1.0 to 3.4 and from 5.6 to */
				/* 6.7 */
    }
    if ((vtmp = (struct vc_vlist*)malloc ((unsigned) sizeof (struct vc_vlist))) == NULL)
      vctl_abort ("malloc,2 vc_vlist");

    vcur->next = vtmp;
    vcur = vtmp;
  }

  generation = GetGenerationNumber (arg);
  revision = GetRevisionNumber (arg);
  
  vcur->from_generation = generation;
  vcur->from_revision = revision;
  vcur->to_generation = generation;
  vcur->to_revision = revision;
  vcur->from_version_set = vcur->to_version_set = 1;
  vcur->next = NULL;

  if ((revision < 0) || (generation <= 0)) {
    (void)sprintf (buf, "%s version number %s.",
	     *arg ? "bad" : "missing",
	     *arg ? arg : "");
    logerr (buf);
    return 1;
  }
  return 0;
}
#endif

/*ARGSUSED*/
int handle_version_option (opt, arg)
     char *opt, *arg;
{
  def_vnum = mkvno (arg);
  if (IsOptionSet(Vopt_version) || 
      (vlist->from_generation + vlist->to_generation) ) {
    logerr ("Set only one default version or version range.");
    return 1;
  }
  SetOption(Vopt_version);
  return 0;
}

/**/
int handle_from_option (opt, arg)
     char *opt, *arg;
{
  struct vc_vlist *vtmp;
  
  if (IsOptionSet(Vopt_version)) {
    logerr ("Set only one default version or version range.");
    return 1;
  }
  if (vcur->from_version_set) {	/* need a new entry in vlist */
    if ((vtmp = (struct vc_vlist*)malloc ((unsigned) sizeof (struct vc_vlist))) == NULL)
      vctl_abort ("malloc,3 vc_vlist");
    
    vcur->next = vtmp;
    vcur = vtmp;
    vcur->to_generation = vcur->to_revision = NULL;
    vcur->to_version_set = NULL;
    vcur->next = NULL;
  }

  vcur->from_version_set = 1;
  vcur->from_generation = GetGenerationNumber (arg);
  vcur->from_revision = GetRevisionNumber (arg);

  if (to_option_pending) {
    (void)sprintf (buf, "\"-to <version number>\" expected. Got \"-%s %s\"",
	     opt, arg);
    logerr (buf);
    return 1;
  }
  else {
    if (!from_option_pending)
      /* e.g.: -to is followed by -from then no -to is pending */
      to_option_pending++;
  }

  if ((vcur->from_revision < 0) || (vcur->from_generation <= 0)) {
    (void)sprintf (buf, "%s version number %s.",
	     *arg ? "bad" : "missing",
	     *arg ? arg : "");
    logerr (buf);
    return 1;
  }

  from_option_pending = 0;
  return 0;
}

/**/
int handle_to_option (opt, arg)
     char *opt, *arg;
{
  struct vc_vlist *vtmp;
  
  if (IsOptionSet(Vopt_version)) {
    logerr ("Set only one default version or version range.");
    return 1;
  }
  if (vcur->to_version_set) {
    if ((vtmp = (struct vc_vlist*) malloc ((unsigned) sizeof (struct vc_vlist))) == NULL)
      vctl_abort ("malloc,4 vc_vlist");

    vcur->next = vtmp;
    vcur = vtmp;
    vcur->from_generation = vcur->from_revision = NULL;
    vcur->from_version_set = NULL;
    vcur->next = NULL;
  }

  vcur->to_generation = GetGenerationNumber (arg);
  vcur->to_revision = GetRevisionNumber (arg);
  vcur->to_version_set = 1;

  if (from_option_pending) {
    (void)sprintf (buf, "\"-from <version number>\" expected. Got \"-%s %s\"",
	     opt, arg);
    logerr (buf);
    return 1;
  }
  else {
    if (!to_option_pending)	/* -to followd by -from then no -from is
				 * pending */
      from_option_pending++;
  }
  
if ((vcur->to_revision < 0) || (vcur->to_generation <= 0)) {
    (void)sprintf (buf, "%s version number %s.",
	     *arg ? "bad" : "missing",
	     *arg ? arg : "");
    logerr (buf);
    return 1;
  }

  to_option_pending = 0; 
  return 0;
}

/**/
int handle_force_switch (opt, arg)
     char *opt, *arg;
{
  SetOption(Vopt_no_confirm);
  return 0;
}

/*ARGSUSED*/
int handle_quiet_option (o, a) char *o, *a; {
  SetOption(Vopt_quiet);
  return 0;
}

/**/
ShortUsage ()
{
  pa_ShortUsage (progname, argdesc, "files ...");
}

/*ARGSUSED*/
int handle_help_option (opt, arg)
     char *opt, *arg;
{
  if (*arg) {
    logerr ("long help not yet implemented.");
  }
  else {
    ShortUsage ();
  }

  exit (1);			/* no way to proceed */
}

/*ARGSUSED*/
handle_R_option (o, a) char *o, *a; {
  extern char *vadm_version(), *at_version(), *af_version();

  (void) printf ("This is %s version %s.\n", progname, vadm_version ());
  (void) printf ("AtFS toolkit lib version %s.\n", at_version());
  (void) printf ("AtFS version %s.\n", af_version());
  exit (0);
}

/**/
vctl_abort (message)
     char *message;
{
  perror (message);
  exit (1);
}

/*ARGSUSED*/
int handle_stdin_option (opt, arg)
     char *opt, *arg;
{
  SetOption(Vopt_stdin);
  return 0;
}

/*ARGSUSED*/
int handle_nomail_option (opt, arg)
     char *opt, *arg;
{
  SetOption(Vopt_nomail);
  return 0;
}

/*ARGSUSED*/
int handle_d_option (opt, arg)
     char *opt, *arg;
{
  debug_on++;
}

DumpVlist ()
{
  struct vc_vlist *vtmp;
  int f_gen, f_rev, t_gen, t_rev;
  
  for (vtmp = vlist; vtmp; vtmp = vtmp->next) {
    f_gen = vtmp->from_generation;
    f_rev = vtmp->from_revision;
    t_gen = vtmp->to_generation;
    t_rev = vtmp->to_revision;

    if ( (f_gen == t_gen) && (f_rev == f_rev))
      (void) fprintf (stderr, "-V%d.%d\n", f_gen, f_rev);
    else
      (void) fprintf (stderr, "-from %d.%d -to %d.%d\n", f_gen, f_rev, t_gen, t_rev);
  }
}

