/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

 *
 * $Header: rcs2atfs.h[1.8] Wed Mar 11 14:45:14 1992 nickel@cs.tu-berlin.de accessed $
 * Header file for rcs2atfs, global data structures and variables
 */

#include <ctype.h>
#include <stdio.h>
#include "atfs.h"		/* includes config.h */

/*
 * Constants
 */

#ifdef bool			/* atfs.h defines this to short, */
#undef bool			/* but I need it as int */
#endif

typedef int bool ;

#define false (0)
#define true  (1)

#ifndef NULL
#define NULL 0
#endif

/* shell we call in a pipe */
#define BOURNE_SHELL "/bin/sh"

/* name of AtFS directory */
#ifndef AtFSDIR
#define AtFSDIR "AtFS"
#endif

/* reader state in readin.c */
typedef enum { header,		/* in header of rlog output */
	       skip,		/* skip lines beginning with whitespace */
	       locks,		/* look at locks */
	       symnames,	/* look at symbolic names */
	       description,	/* look at description */
	       revision1,	/* first line of revision */
	       revision2,	/* second line of revision */
	       log_msg		/* log message of revision or branches line */
	       } read_state_t ;

/* type of a file */
typedef enum { f_plain,		/* plain file */
	       f_rcs,		/* RCS file (*,v) */
	       f_dir,		/* directory */
	       f_rcsdir,	/* directory named RCS */
	       f_error		/* can't stat(2) file */
	       } filetype_t ;

#define LINELENGTH 1024		/* Max. length of input line */

/* messages etc. */

#define RLOG_COMMAND	"rlog "
#define RLOG_FAILED	"rlog command failed, file skipped"
#define POPEN_RLOG	"popen to rlog command failed"
#define POPEN_SHELL	"popen to shell failed"
#define LOCKED_VERSIONS	"locked version(s) exist"
#define NO_COLON	"colon after symbolic name missing, file skipped"
#define NO_REVISION	"\"revision\" not found, file skipped"
#define NO_DATE		"date not found, file skipped"
#define NO_AUTHOR	"author not found, file skipped"
#define NO_STATUS	"status not found, file skipped"
#define MIND_LOST	"Oops? Unknown reader state in readin_rcsfile!"
#define CHECK_FAILED	"rlog information missing, file skipped"
#define BOGUS_SYMNAME	"symbolic name to non-existent revision"
#define NOMORECORE	"no more core"
#define AtFS_EXISTS	"AtFS history exists, file skipped"
#define NOT_RECURSIVE	"-R flag not set, directory skipped"
#define REV_CORRUPT	"revision numbers corrupted!"
#define MUSTNOT		"this must not happen"
#define BAD_REVNO	"number of revisions is wrong!"
#define BRANCHES	"branches exist, can't keep revision numbers"
#define CONTRADICT	"You can't mean this.\n"

/*
 * Strings in rlog output
 */

#define K_rcsfile "RCS file:"
#define K_wrkfile "Working file:"
#define K_head "head:"
#define K_branch "branch:"
#define K_locks "locks:"
#define K_symnames "symbolic names:"
#define K_comlead "comment leader: "
#define K_descr "description:"
#define K_revision "revision "
#define K_locked "locked_by: "
#define K_date "date: "
#define K_author "author: "
#define K_state "state: "
#define K_alist "access list:"
#define K_branches "branches:  "
#define K_revsep "----------------------------"
#define K_filesep "============================================================================="

/* header for generated shell script */
#define SCRIPT_HEADER "#!/bin/sh\n\
# shell script generated by rcs2atfs\n\
# %s\n\
\n\
\n"


/*
 * Structures
 */

/* structure for storing a symbolic name while reading rlog output */
struct SYMNAME {
    char *symname ;		/* the symbolic name itself */
    char *revision ;		/* the revision number it belongs to */
    struct SYMNAME *next ;	/* pointer to next symname */
} ;

/* structure containing information of an RCS revision */
struct RCSREV {
    struct RCSREV *next ;	/* pointer to next r. */
    char	*number ;	/* r. number (string!) */
    time_t	date ;		/* date (of check-in?) */
    char	*author ;	/* author of this r. */
    char	*state ;	/* state of the r. (Exp, Stab, Rel,... */
    char	*log_message ;	/* log message of the r. */
    struct SYMNAME *symbolic_names ; /* symbolic names of this r. */
} ;

/* structure containing header information of an RCS file */

struct RCSFILE {
    char	*dirname ;	/* name of dir. working file is in */
    char	*rcs_file ;	/* name of RCS archive file */
    char 	*working_file ;	/* name of working file */
    bool	locks ;		/* locks exist */
    char	*comment_leader ; /* comment leader string */
    char	*description ;	/* descriptive text */
    struct RCSREV *revisions ;	/* list of revisions */
    bool	branches ;	/* Branches exist */
    int		no_of_revs ;	/* number of revisions */
    struct rcsfile *next ;	/* pointer to next rcsfile */
} ;

/* struct afind_state is built by init_afind(), used by afind_next() */
struct AFIND_STATE {
    Af_set set ;
    int counter ;
} ;

/*
 * Variables
 */

extern char *progname ;		/* name this program was called with */
extern int warnings ;		/* no of warnings issued */
extern int errors ;		/* no of errors encountered */
extern char *shellscript ;	/* name of shellscript (if any) */
extern bool keep_quiet ;	/* don't issue warnings */
extern bool recursive ;		/* recursively descend directories */

extern int errno ;		/* I want to handle ... */
extern char *sys_errlist[] ;	/* ... these strings by myself */

/*
 * extern functions
 */

#ifdef __STDC__

extern int af_initattrs(Af_attrs *attrbuf) ;
extern int af_find (Af_attrs  *attrbuf, Af_set    *resultset) ;
extern int af_nrofkeys (Af_set *set) ;
extern int af_setgkey (Af_set *set, int  position, Af_key *key) ;
extern int af_dropset(Af_set *set) ;
extern int af_access (char *path, char *name, char *type, int mode) ;
extern int at_mktime(char *datestring) ;

#else /* __STDC__ */

extern int af_initattrs() ;
extern int af_find () ;
extern int af_nrofkeys () ;
extern int af_setgkey () ;
extern int af_dropset() ;
extern int af_access () ;
extern int at_mktime() ;

#endif /* __STDC__ */

/*EOF*/
