/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */

/* Thanks to Steve Emerson (steve@unidata.ucar.edu) for implementing
   the following code */

#ifndef	STRING_BUFFER_HEADER_INCLUDED
#define	STRING_BUFFER_HEADER_INCLUDED

/*
 * String-buffer data-type.
 */
typedef struct str_buf	*sb_ptr;

#ifdef __STDC__
#   define A(x)		x
#else
#   define A(x)		()
#endif

/*
 * String-buffer interface:
 */
extern sb_ptr	sbnew	A((int max));
extern sb_ptr	sbinit	A((sb_ptr sb, char *string, int len));
extern void	sbfree	A((sb_ptr sb));
extern sb_ptr	sbcpy	A((sb_ptr sb, char *string, int len));
extern sb_ptr	sbcat	A((sb_ptr sb, char *string, int len));
extern char	*sbstr	A((sb_ptr sb));
extern int	sblen	A((sb_ptr sb));

#endif	/* !STRING_BUFFER_HEADER_INCLUDED */
