/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: rule.c[1.37] Wed Apr 22 18:02:43 1992 axel@cs.tu-berlin.de accessed $";
#endif

/* intermixing of implicit "." rules and normal targets is *not* allowed */

#include "shape.h"
#include "rule.h"
extern char *realloc(), *get_dep(), *expandmacro(), *get_src_name();

extern int hashval(), errexit();

extern struct rules *stdruletab[];

extern int implicit_suffs[];

extern Bool is_old_rule();
extern Bool is_special_target() ;

char *firsttarget;

Bool oldrule;

int depnr, targnr, cmdnr, heritnr;
char *targfield[MAXTARGS], *depfield[MAXDEPS], *cmdfield[MAXCMDS];
char *heritfield[MAXHERIT];


ruledef(string)
     char *string;
{
register int i = 0, k = 0;
int i2 = 0;
char klazu;
char t[2048], string2[2048];
char *string3;

targnr = 0;
depnr = 0;
cmdnr = 0;
heritnr = 0;

if((string3 = malloc(2048)) == NIL)
  errexit(10,"malloc");

while(string[i] != ':')
  i++;
i2 = i;
(void) strncpy(string2,string,i + 1);
string2[i+1] = '\0';
(void) strcpy(string3,string2);
(void) strcpy(string2,expandmacro(string3));
free(string3);

i = 0;
while(string2[i] != ':')
  {
    while((string2[i] != ' ') && (string2[i] != '\t') && (string2[i] != ':'))
      {
	t[k] = string2[i];
	i++;
	k++;
      }
    t[k] = '\0';
    targnr++;
    if (targnr > MAXTARGS)
      errexit(27, "targets");
    if ((targfield[targnr] = malloc((unsigned) strlen(t) + 1)) == NIL)
      errexit(10,"malloc");
    (void) strcpy(targfield[targnr], t);
    k = 0;
    while((string2[i] == ' ') || (string2[i] == '\t'))
      i++;
  }
i = i2;
if (string[i+1] == ':')
  {
    doublecolon = TRUE;
    i = i + 2;
  }
else
  i++;

while((string[i] != '\0') && (string[i] != ';') && (string[i] != ':'))
  {
    while((string[i] == ' ') || (string[i] == '\t') ||
	  (string[i] == '\\'))
      {
	if ((string[i] == '\\') && (string[i+1] == '\n'))
	  i = i+2;
	else
	  i++;
      }
    while((string[i] != ' ') && (string[i] != '\t') &&
	  (string[i] != ';') && (string[i] != '\0') &&
	  (string[i] != ':') && (string[i] != '\\'))
      {
	t[k] = string[i];
	i++;
	k++;
      }
    t[k] = '\0';
    if (k != 0)
      {
	depnr++;
	if (depnr > MAXDEPS)
	  errexit(27, "dependents");
	if ((depfield[depnr] = malloc((unsigned) strlen(t) + 1)) == NIL)
	  errexit(10,"malloc");
	(void) strcpy(depfield[depnr],t);
      }
    k = 0;
  }


while((string[i] == ' ') || (string[i] == '\t'))
  i++;

/* heritage */

k = 0;
if (string[i] == ':')
  {
    i++;
    while( (string[i] != '\0') )
      {
	while((string[i] == ' ') || (string[i] == '\t'))
	  i++;
	if (string[i] != '+')
	  errexit(26, &string[i]);
	if (string[i+1] == '(')
	  klazu = ')';
	else
	  {
	    if (string[i+1] == '{')
	      klazu = '}';
	    else
	      klazu = ' ';
	  }

	while (string[i] != klazu)
	  {
	    t[k] = string[i];
	    i++;
	    k++;
	    if (string[i] == '\0')
	      errexit(26,&string[i]);
	  }
	t[k] = string[i];
	k++;
	i++;
	t[k] = '\0';
	heritnr++;
	if (heritnr > MAXHERIT)
	  errexit(27, "iherits");
	if ((heritfield[heritnr] = malloc((unsigned) strlen(t) + 1)) == NIL)
	  errexit(10,"malloc");
	(void) strcpy(heritfield[heritnr],t);
	k = 0;
      }
  }

/* commands on ruledef line */
if( string[i] == ';')
  {
    i++;
    while( (string[i] != '\0'))
      {
	t[k] = string[i];
	i++;
	k++;
      }
    t[k] = '\0';
    cmdnr++;
    if (cmdnr > MAXCMDS)
      errexit(27, "commands");
    if ((cmdfield[cmdnr] = malloc((unsigned) strlen(t) + 1)) == NIL)
      errexit(10,"malloc");
    if (t[strlen(t)-1] == '\n')
      t[strlen(t)-1] = '\0';
    (void) strcpy(cmdfield[cmdnr], t);
  }
}

rulecont(string)
     char *string;
{
/* only commands have been found */
cmdnr++;
if(cmdnr > MAXCMDS)
  errexit(27, "commands");
if ((cmdfield[cmdnr] = malloc ((unsigned) strlen(string) + 1)) == NIL)
  errexit(10,"malloc");
if (string[strlen(string)-1] == '\n')
  string[strlen(string)-1] = '\0';
(void) strcpy(cmdfield[cmdnr], string);
}

ruleend()
{
  struct rules *current, *previous;
  struct rules *first_target, *next_target;
  struct cmds *curcmd;
  register int i = 0, j = 0;
  int kkk = 0, xx = 0, ss = 0, hasht = 0, targs = 0;
  Bool src_found = FALSE;
  char *p, *srcname, *get_token_from_deplist();
  Bool std_rule = FALSE, found = FALSE;
  
  if(targnr == 0)
    return;

  if(!strcmp(targfield[1],".SILENT"))
    silentflg = TRUE ;

  if(!strcmp(targfield[1],".BPOOL"))
    bpoolflg = TRUE;

  if(!strcmp(targfield[1],".NOBPOOL"))
    nobpoolflg = TRUE;

  if(!strcmp(targfield[1],".IGNORE"))
    ignoreflg = TRUE;
  
  if ((is_old_rule(targfield[1])) && (strcmp(targfield[1],".SUFFIXES") != 0))
    {
      oldrule = TRUE;
      targs = targnr;
      for(i = 1; i <= targs; i++)
	{
	  if (is_old_rule(targfield[i]))
	    {
	      if (targfield[i] != NIL)
		convertrule(i);
	    }
	      ruleend();
	}
      oldrule = FALSE;
      return;
    }

  for(i = 1; i <= targnr; i++)
    {
      p = index(targfield[i],'%');
      if ((p != NIL) && ((*(p+1) == '\0') || (*(p+1) == '.')))
	{
	  std_rule = TRUE;
	  break;
	}
    }

  for(i = 1; i <= targnr; i++)
    {
      found = FALSE;
      if(!std_rule)
	{
	  hasht = hashval(targfield[i]);
	  if ( ruletab[hasht] == (struct rules *) NIL)
	    {
	      if((current = ruletab[hasht] = (struct rules *) malloc( sizeof(struct rules))) == (struct rules *)NIL)
		errexit(10,"malloc");
	      bzero (current, sizeof (struct rules));
	    }
	  else
	  {
	    current = ruletab[hasht];
	    if ((!strcmp(ruletab[hasht]->name, targfield[i])) &&
		(strcmp(ruletab[hasht]->name, ".SUFFIXES")) &&
		(current->doublecolon == FALSE) &&
		(doublecolon == FALSE) &&
		(ruletab[hasht]->cmdlist != (struct cmds *) NIL) &&
		(cmdfield[1] != NIL))
	      errexit(1, targfield[i]);

	    if((!strcmp(current->name,targfield[i])) &&
	       ((cmdfield[0] == NIL) ||
		(current->cmdlist == (struct cmds *) NIL)))
	      {
		found = TRUE;
	      }

	    while((current != (struct rules *) NIL) && (!found))
	      {
		if((strcmp(current->name,targfield[i]) == 0) &&
		   ((cmdfield[0] == NIL) ||
		    (current->cmdlist == (struct cmds *) NIL)))
		  {
		    found = TRUE;
		    break;
		  }
		else
		  {
		    previous = current;
		    current = current->nextrule;
		  }
	      }
	    if(found)
	      {
		if ((strcmp(current->name, targfield[i]) == 0) &&
		    (strcmp(ruletab[hasht]->name, ".SUFFIXES") != 0) &&
		    (ruletab[hasht]->cmdlist != (struct cmds *) NIL) &&
		    (current->doublecolon == FALSE) &&
		    (doublecolon == FALSE) &&
		    (cmdfield[1] != NIL))
		  errexit(1, targfield[i]);
		if ((strcmp(current->name, ".SUFFIXES")) == 0)
		  {
		    if (depnr == 0) /* delete suffix list */
		      {
			current->deplist = NIL;
		      }
		    else
		      {
			if (current->deplist == NIL)
			  {
			    if ((current->deplist = malloc((unsigned) 1)) == NIL)
			      errexit(10,"malloc");
			    current->deplist[0] = '\0';
			  }
			for (kkk = 1; kkk <= depnr; kkk++)
			  {
			    if ((current->deplist =
				 realloc(current->deplist, (unsigned) (strlen(depfield[kkk]) + strlen(current->deplist) + 3))) == NIL)
			      errexit(10,"realloc");
			    (void) strcat(current->deplist," ");
			    (void) strcat(current->deplist, depfield[kkk]);
			  }
		      }
		  }
	      }
	    if (!found)
	      {
		if((previous->nextrule = current = 
		    (struct rules *) malloc(sizeof(struct rules)))
		   == (struct rules *) NIL)
		  errexit(10,"malloc");
		bzero (current, sizeof (struct rules));
	      }
	  }
	}
      else
	{
	  lastrule++;
	  if((current = stdruletab[lastrule] = 
	      (struct rules *) malloc( sizeof(struct rules))) == 
	     (struct rules *) NIL)
	    errexit(10,"malloc");
	  bzero ((char *)current, sizeof (struct rules));
	  overload_stdrule(i);
	  implicit_suffs[lastrule+1] = -1;
	  stdruletab[lastrule+1] = (struct rules *) NIL;
	}
      if (!found)
	{
	  if((current->name = malloc( (unsigned) strlen( targfield[i] ) + 1)) == NIL)
	    errexit(10,"malloc");
	  (void) strcpy(current->name, targfield[i]);
	  current->targetlist[0] = NIL;
	  current->heritage[0] = NIL;
	}
      current->done = 0;
      if (doublecolon)
	current->doublecolon = TRUE;
      else
	current->doublecolon = FALSE;
      if(i == 1)
	{
	  first_target = current;
	  next_target = current;
	  current->next = (struct rules *)NIL;
	  current->saved = FALSE;
	}
      else
	{
	  if(cmdnr >= 1)
	    {
	      next_target->next = current;
	      next_target = current;
	    }
	}
      if((i == 1) && (firsttarget == NIL) && !is_pattern (current->name) &&
	 ! is_old_rule(current->name) && ! is_special_target(current->name))
	 firsttarget = current->name;
      if(!found)
	{
	  current->deplist = NIL;
	  current->cmdlist = (struct cmds *) NIL;
	  current->nextrule = (struct rules *) NIL;
	}
      if ((depnr > 0) && (!found))
	{
	  if ((current->firstdep = malloc((unsigned) (strlen(depfield[1]) + sizeof(char)))) == NIL)
	    errexit(10,"malloc");
	  (void) strcpy(current->firstdep, depfield[1]);
	}
      
      if (found)
	{
	  xx = 0;
	  while (get_token_from_deplist (current, xx, 0)) xx++;
	}	  
      for(j = xx+1; j <= xx+depnr; j++)
	{
	  for(ss = 0; get_token_from_deplist(current,ss,0) != NIL; ss++)
	    {
	      if (!strcmp(get_token_from_deplist(current,ss,0),depfield[j-xx]))
		{
		  src_found = TRUE;
		  break;
		}
	    }
	  if(!src_found)
	    {
	      if(current->deplist == NIL)
		{
		  if((current->deplist = 
		      malloc( (unsigned) (strlen (depfield[j-xx]) + 1))) == NIL)
		    errexit(10,"malloc");
		  (void) strcpy(current->deplist,depfield[j-xx]);
		}
	      else
		{
		  if ((current->deplist =
		       realloc(current->deplist,
			       (unsigned)
			       (strlen(current->deplist) + (strlen(depfield[j-xx]))) + 3)) == NIL)
		    errexit(10,"realloc");
		  (void) strcat(current->deplist," ");
		  (void) strcat(current->deplist, depfield[j-xx]);
		}
	    }
	  src_found = FALSE;
	}
	
      /* get standard dependent */

      if (!is_pattern (current->name))
	{
	  if((srcname = get_src_name(current->name)) != NIL)
	    {
	      for(ss = 0; get_token_from_deplist(current,ss,0) != NIL; ss++)
		{
		  if(!strcmp(srcname,get_token_from_deplist (current,ss,0)))
		    {
		      src_found = TRUE;
		      break;
		    }
		}
	      if (!src_found)
		{
		  if (current->deplist == NIL)
		    {
		      if((current->deplist = 
			  malloc( (unsigned) (strlen(srcname) + 1))) == NIL)
			errexit(10,"malloc");
		      (void) strcpy(current->deplist,srcname);
		    }
		  else
		    {
		      if((current->deplist =
			  realloc(current->deplist,
				  (unsigned) (strlen(srcname) + strlen(current->deplist) + 3))) == NIL)
			errexit(10,"realloc");
		      (void) strcat(current->deplist," ");
		      (void) strcat(current->deplist,srcname);
		    }
		}
	      src_found = FALSE;
	    }
	}

      if (heritnr > 0)
	{
	  j = 0;
	  while(current->heritage[j] != NIL)
	    j++;
	  for (j = j+1; j <= heritnr; j++)
	    {
	      if((current->heritage[j-1] =
		  malloc((unsigned) (strlen(heritfield[j]) + sizeof(char)))) == NIL)
		errexit(10,"malloc");
	      (void) strcpy(current->heritage[j-1], heritfield[j]);
	    }
	  current->heritage[j-1] = NIL;
	}

      if(std_rule)
	{
	  for (j = 1; j <= targnr; j++)
	    {
	      if((current->targetlist[j-1] =
		  malloc((unsigned) (strlen(targfield[j]) + 1))) == NIL)
		errexit(10,"malloc");
	      (void) strcpy(current->targetlist[j-1],targfield[j]);
	    }
	  current->targetlist[j-1] = NIL;
	  current->next = (struct rules *) NIL;
	}
      if (cmdnr > 0)
	{
	  if ((curcmd = current->cmdlist = (struct cmds *) malloc( sizeof( struct cmds))) == (struct cmds *) NIL)
	    errexit(10,"malloc");
	  for (j = 1; j <= cmdnr; j++)
	    {
	      if((curcmd->command = malloc( (unsigned) strlen (cmdfield[j]) + 1)) == NIL)
		errexit(10,"malloc");
	      (void) strcpy(curcmd->command, cmdfield[j]);
	      if (j != cmdnr)
		{
		  if((curcmd = curcmd->nextcmd = (struct cmds *) malloc( sizeof( struct cmds))) == (struct cmds *) NIL)
		    errexit(10,"malloc");
		}
	      else
		curcmd->nextcmd = (struct cmds *) NIL;
	    }
	}

      if((targnr > 1) && (cmdnr > 0))
	current->next = first_target;
      else
	current->next = (struct rules *) NIL;
    }

doublecolon = FALSE;
if (!oldrule)
  {
    targnr = 0;
    targfield[1] = NIL;
    depnr =  0;
    depfield[1] = NIL;
    cmdnr = 0;
    cmdfield[1] = NIL;
    heritnr = 0;
    heritfield[1] = NIL;
  }
} /* end ruleend */

convertrule(i)
     int i;
{
  char *p;
  register int j;
  p = rindex(targfield[i],'.');
  *p = '\0';
  p++;
  if ((depfield[1] = malloc((unsigned) (strlen(targfield[i]) + 3))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(depfield[1],"%");
  (void) strcat(depfield[1],targfield[i]);
  if((targfield[1] = malloc((unsigned) (strlen(p) + 3))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(targfield[1],"%.");
  (void) strcat(targfield[1],p);
  targnr = 1;
  depnr = 1;
  for(j = 1; j <= cmdnr; j++)
    (void) convert_comm(j,depfield[1]);
}

convert_comm(j,suff)
     int j;
     char *suff;
{
  char newcomm[1024];
  register char *p,*p2;
  register int i;
  Bool mod = FALSE;
  p = cmdfield[j];
  i = 0;
  if(index(cmdfield[j],'$') == NIL)
    return(0);
  while(*p != '\0')
    {
      if(*p != '$')
	{
	  newcomm[i] = *p;
	  p++;
	  i++;
	  newcomm[i] = '\000';
	}
      else
	{
	  switch(*(p+1))
	    {
	    case '*':
	      mod = TRUE;
	      newcomm[i] = '%';
	      i++;
	      newcomm[i] = '\0';
	      p = p+2;
	      break;
	    case '<':
	      mod = TRUE;
	      p2 = suff;
	      while(*p2 != '\0')
		{
		  newcomm[i] = *p2;
		  p2++;
		  i++;
		}
	      p = p+2;
	      break;
	    default:
	      newcomm[i] = '$';
	      i++;
	      p++;
	      break;
	    }
	}
    }
  if(!mod)
    return(0);
  newcomm[i] = '\0';
  if((cmdfield[j] = realloc(cmdfield[j],
			    (unsigned)(strlen(newcomm)
				       + sizeof(char)))) == NIL)
    errexit(10,"realloc");
  (void) strcpy(cmdfield[j],newcomm);
  return(0);
}

ruledump(fd)
     FILE *fd;
{
register struct rules *cur;
register struct cmds *ccmd;
register int i, k;
char *pp = NIL;

for(i = 0; i< RULETABSIZE; i++)
  {
    if (ruletab[i] != (struct rules *) NIL)
      {
	cur = ruletab[i];
	while( cur != (struct rules *) NIL)
	  {
	    if(fd == stdout)
	      fprintf(fd,"%s\n", cur->name);
	    else
	      fprintf(fd,"%s", cur->name);

	    if (fd == stdout)
	      fprintf(fd," depends on:");
	    else
	      fprintf(fd,":");

	    if(cur->deplist != NIL)
	      {
		if(is_selrule_name(get_dep(cur,0,0)))
		  {
		    pp = index(cur->deplist,' ');
		    if(pp != NIL)
		      {
			pp++;
			fprintf(fd," %s",pp);
		      }
		  }
		else
		  fprintf(fd," %s",cur->deplist);
	      }

	    if(fd == stdout)
	      fprintf(fd,"\n");

	    if (cur->heritage[0] != NIL)
	      {
		if(fd == stdout)
		  fprintf(fd," inherits:");
		else
		  fprintf(fd," :");
	      }

	    k = 0;
	    while (cur->heritage[k] != NIL)
	      {
		fprintf(fd," %s", cur->heritage[k]);
		k++;
	      }
	    fprintf(fd,"\n");

	    ccmd = cur->cmdlist;
	    if (ccmd == '\0')
	      ccmd = (struct cmds *) NIL;

	    if(fd == stdout)
	      fprintf(fd," commands:\n");
	      
	    while (ccmd != (struct cmds *) NIL)
	      {
		if(ccmd->command != NIL)
		  fprintf(fd,"%s\n", ccmd->command);
		ccmd = ccmd->nextcmd;
	      }
	    fprintf(fd,"\n");
	    cur = cur->nextrule;
	  }
      }
  }


for(i = 0; i <= lastrule; i++)
  {
    cur = stdruletab[i];

    if(fd == stdout)
      fprintf(fd,"%s\n", cur->name);
    else
      fprintf(fd,"%s", cur->name);

    if (fd == stdout)
      fprintf(fd," depends on:");
    else
      fprintf(fd," :");

    fprintf(fd," %s",cur->deplist);

    if (fd == stdout)
      fprintf(fd,"\n");

    k = 0;
    
    if (fd == stdout)
      fprintf(fd," inherits:");
    else
      fprintf(fd," :");

    while (cur->heritage[k] != NIL)
      {
	fprintf(fd," %s", cur->heritage[k]);
	k++;
      }
    fprintf(fd,"\n");

    ccmd = cur->cmdlist;
    
    if (fd == stdout)
      fprintf(fd," commands:\n");

    while (ccmd != (struct cmds *) NIL)
      {
	if(ccmd->command != NIL)
	  fprintf(fd,"%s\n", ccmd->command);
	ccmd = ccmd->nextcmd;
	if (ccmd == '\0')
	  ccmd = (struct cmds *) NIL;
      }
    fprintf(fd,"\n");
  }

(void) fflush(fd);

} /* end ruledump */


adjust_stdrules(suffs)
     /*ARGSUSED*/
     char *suffs;
{

;
}
      
Bool is_old_rule(string)
     char *string;
{
  if (index(string,'/') != NIL)
    return(FALSE);
  if ((string[0] == '.') &&
      (index(string+2,'.') != NIL))
    return(TRUE);
  else
    return(FALSE);
}
      
   
Bool overload_stdrule(k)
     int k;
{
  register int i;
  
  for(i = 0; implicit_suffs[i] != -1; i++)
    {
      if((strcmp(stdruletab[implicit_suffs[i]]->name,targfield[k]) == 0) &&
	 (strcmp(get_dep(stdruletab[implicit_suffs[i]],0,0), depfield[1]) == 0))
	{
	  implicit_suffs[i] = lastrule;
	  return;
	}
    }
  implicit_suffs[lastrule] = lastrule;
}
	
	
	
init_ruletab()
{
  bzero((char *) ruletab, 257 * sizeof(struct rules *));
}

/*** NEW CODE FOR get_dep BEGIN ***/

#define LINELEN 128


#define copy_token(source, dest) { register char *s = source, \
				      *d = dest; \
					while (*s && !isspace(*s)) \
					  *d++ = *s++; \
					    *d = '\0'; }

#define advance(tok) { while (*tok && !isspace(*tok)) tok++; \
			  while (*tok && isspace(*tok)) tok++; }

#define skip_leading_space(tok) { while (*tok && isspace(*tok)) tok++; }

static Bool is_macro (token) char *token; {
  register char *tc = token;

  while (*tc && !isspace (*tc) && !(*tc == '$')) tc++;
  return *tc == '$';
}

char *get_dep (dep_rule, nth, junk)
     struct rules *dep_rule;
     int nth;
     int junk; /* unused. Kept for compatibility during test phase */
{
  /*
   * Returns "nth" dependent from the list of dependents in the
   * dependency rule "dep_rule".
   * Principle is: for each token that has a lower token number than 
   * "nth", check if it is a macro, and expand it if needed.
   * Proceed through tokens in expanded macro. If tokens in expanded
   * macro are exhausted, proceed as before .....
   */

  static struct rules *last_rule;
  static int last_token_number;
  static char nth_dependent[MAXPATHLEN];
  static Bool got_token = FALSE;
  char *this_token, *m, *expand_token(), *insert_expansion();
  int this_token_position = 0;

  if (!dep_rule) return NIL;
  if (!dep_rule->deplist) return NIL;

  if ((last_rule == dep_rule) && (nth == last_token_number))
      return got_token ? nth_dependent : NIL;
  else {
    last_rule = dep_rule;
    last_token_number = nth;
    got_token = FALSE;
  }

  this_token = dep_rule->deplist;
  skip_leading_space (this_token);

  do {
    if (nth == this_token_position) {
      if (!is_macro (this_token)) {
	if (*this_token) {
	  copy_token (this_token, nth_dependent);
	  got_token = TRUE;
	  /*
	   * special treatment for "./targets" and "../targets"
	   */
	  if (nth_dependent[0] == '.')
	    if (nth_dependent[1] == '/') {
	      register char *s1 = nth_dependent, *s2 = nth_dependent + 2;
	      while (*s1++ = *s2++);
	    }
	    else if ((nth_dependent[1] == '.') && (nth_dependent[2] == '/')) {
	      char editbuf[MAXPATHLEN];
	      (void) strcpy (editbuf, prev_dir);
	      (void) strcat (editbuf, nth_dependent + 2);
	      (void) strcpy (nth_dependent, editbuf);
	    }
	  return nth_dependent;
	}
	else
	  return NIL;
      }
      else {
	m = expand_token (this_token);
	this_token = insert_expansion (&dep_rule->deplist, this_token, m);
	skip_leading_space (this_token);
	continue;
      }
    }
    if (!is_macro (this_token)) {
      advance (this_token);
      this_token_position++;
    }
    else {
      m = expand_token (this_token);
      this_token = insert_expansion (&dep_rule->deplist, this_token, m);
      skip_leading_space (this_token);
    }
  } while (*this_token);
  return NIL;
}

void add_defaults (targ, rule)
     char *targ; struct rules *rule;
{
  /*
   * Make sure that the "primary dependent" of a target (e.g. "foo.c"
   * for target "foo.o" actually appears in the dependents list.
   * This is necessary, because there are often various explicit 
   * dependencies in a Shape/Makefile but the most basic dependency
   * is not specified, because it's the default.
   *
   * First, find applicable default rule for "targ". Then construct
   * a regular Shapefile dependency from the pattern rule and the 
   * "targ" name. Having the rule formed, it is passed to shape's 
   * rule definition machinery.
   */
  char default_dependency_line[2 * MAXPATHLEN], targ_edit[MAXPATHLEN],
        *this_target, *suff;
  struct rules *implicit_target(), 
      *default_rule = implicit_target (targ);
  register int i;
  register char *line_end, *deplist;

  if (!default_rule)
    return;

  rule->cmdlist = default_rule->cmdlist;

  /*
   * make target part ... 
   */
  default_dependency_line[0] = '\0';
  for (i = 0; (i < MAXHERIT) && 
       (this_target = default_rule->targetlist[i]); i++) {
    if (is_pattern (this_target)) {
      targ_edit[0] = '\0';
      (void) strcat (targ_edit, targ);
      suff = suffix (targ_edit);
      if (suff != targ_edit)
	*suff = '\0';
      suff = suffix (this_target);
      if (suff != this_target)
	(void) strcat (targ_edit, suff);
      (void) strcat (default_dependency_line, targ_edit);
    }
    else 
      (void) strcat (default_dependency_line, this_target);
    (void) strcat (default_dependency_line, " ");
  }

  (void) strcat (default_dependency_line, ": ");

  /*
   * make dependents part....
   */

  targ_edit[0] = '0';
  (void) strcpy (targ_edit, targ);
  suff = suffix (targ_edit);
  if (suff != targ_edit)
    *suff = '\0';
  
  line_end = default_dependency_line;
  while (*line_end) line_end++;
  deplist = default_rule->deplist;
  while (deplist && *deplist) {
    if (*deplist == '%') {
      *line_end = '\0';
      (void) strcat (default_dependency_line, targ_edit);
      while (*line_end) line_end++;
      deplist++;
    }
    else
      *line_end++ = *deplist++;
  }
  *line_end = '\0';

  /*
   * make additional dependency known to shape...
   */

  ruledef (default_dependency_line);
  ruleend ();
  return;
}

static char *get_token_from_deplist (dep_rule, nth, junk)
     struct rules *dep_rule;
     int nth;
     int junk; /* unused; kept for compatibility during testing */
{
  /*
   * Returns "nth" token from the list of dependents in the
   * dependency rule "dep_rule". Macros are not expanded.
   */

  static struct rules *last_rule;
  static int last_token_number;
  static char nth_dependent[MAXPATHLEN];
  static Bool got_token = FALSE;
  char *this_token;
  int this_token_position = 0;

  if (!dep_rule) return NIL;
  if (!dep_rule->deplist) return NIL;

  if ((last_rule == dep_rule) && (nth == last_token_number))
      return got_token ? nth_dependent : NIL;
  else {
    last_rule = dep_rule;
    last_token_number = nth;
    got_token = FALSE;
  }

  this_token = dep_rule->deplist;
  skip_leading_space (this_token);

  do {
    if (nth == this_token_position) {
      if (*this_token) {
	copy_token (this_token, nth_dependent);
	got_token = TRUE;
	/*
	 * special treatment for "./targets" and "../targets"
	 */
	if (nth_dependent[0] == '.')
	  if (nth_dependent[1] == '/') {
	    register char *s1 = nth_dependent, *s2 = nth_dependent + 2;
	    while (*s1++ = *s2++);
	  }
	  else if ((nth_dependent[1] == '.') && (nth_dependent[2] == '/')) {
	    char editbuf[MAXPATHLEN];
	    (void) strcpy (editbuf, prev_dir);
	    (void) strcat (editbuf, nth_dependent + 2);
	    (void) strcpy (nth_dependent, editbuf);
	  }
	return nth_dependent;
      }
      else
	return NIL;
    }
    else {
      advance (this_token);
      this_token_position++;
    }
  } while (*this_token);
  return NIL;
}

static char *expand_token (tok) char *tok; {
  char tokbuf[LINELEN];

  copy_token (tok, tokbuf);
  return expandmacro (tokbuf);
}

static char *insert_expansion (baseaddr, position, insertion)
     char **baseaddr, *position, *insertion;
{
  char tokbuf[LINELEN], *base = *baseaddr;
  unsigned int replacement_offset = position - base, 
               trailer_length, replace_length, replacement_length,
               new_base_length;
  char *new_base, *hook;

  copy_token (position, tokbuf);
  replace_length = strlen (tokbuf);
  trailer_length = strlen (position + replace_length);
  replacement_length = strlen (insertion);
  new_base_length = replacement_offset + replacement_length + trailer_length;
  if ((new_base = malloc (new_base_length)) == NIL) return position;
  (void) strncpy (new_base, base, replacement_offset);
  new_base[replacement_offset] = '\0';
  (void) strcat (new_base, insertion);
  (void) strcat (new_base, position + replace_length);
  if ((hook = realloc (base, new_base_length)) == NIL) {
    free (new_base);
    return position;
  }
  else {
    *baseaddr = hook;
    base = *baseaddr;
  }
  (void) strcpy (base, new_base);
  position = base + replacement_offset;
  free (new_base);
  return position;
}

/*** NEW CODE FOR get_dep END ***/

char *special_target[] = {
    ".BPOOL",
    ".DEFAULT",
    ".IGNORE",
    ".NOBPOOL",
    ".SILENT",
    ".SUFFIXES",
    (char *) 0 } ;

Bool is_special_target(string)
char * string ;
{
    int i ;

    for (i = 0; special_target[i]; i++) {
	if (!strcmp(string, special_target[i])) return TRUE ;
    }
    return FALSE ;
}

Bool is_pattern (string) char * string; {
  /*
   * recognize implicit rules that use the pattern notation
   */

  if (!string) return FALSE;
  if (string[0] == '%') return TRUE;
  if (index (string, '%')) return TRUE;
  return FALSE;
}


#define STEMLEN 128

char *stem (pattern, string) char *pattern, *string; {
  /*
   * Match "string" against "pattern" (consists of '%' and a possibly
   * empty constant string) and returns the substring of string that
   * matched the wildcard character. If "string" didn't match, NULL
   * is returned.
   */

  register char *p1, *p2, *q1, *q2;
  char *s;
  unsigned int l;
  static char wild_stem[STEMLEN];

  if (!(pattern && string && *pattern && *string))
    return NULL;
  if (index (string, '%')) {
    fprintf (stderr, "String to match (%s) must not be a pattern.\n",
	     string);
    return NULL;
  }
  p1 = pattern;
  p2 = string;
  while (*p1 && (*p1 == *p2)) { p1++ ; p2++; }
  if ((*p1 == *p2) && (*p1 == NULL)) {
    /* pattern and string are identical */
    (void)strcpy (wild_stem, string);
    return wild_stem;
  }
  q1 = pattern + ((l = strlen (pattern)) ? l-1 : 0);
  q2 = string + ((l = strlen (string)) ? l-1 : 0);
  while (*q1 == *q2) { q1--; q2--; }
  if ((p1 == q1) && (*q1 == '%')) {
    q2++;
    (void) strncpy (wild_stem, p2, q2 - p2);
    wild_stem[q2 - p2] = '\0';
    return wild_stem;
  }
  else
    return NULL;
}
