/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: files.c[1.52] Fri Apr 24 18:00:58 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"
#include "files.h"

#include <sys/file.h>
#include <stdio.h>
#include <errno.h>

extern int errno;

extern register_link();

extern FILE *af_open();

extern struct passwd *getpwnam();
extern char *mktemp();

extern int af_setgkey(), af_gattrs(), WriteXPand(), logerr(), append_attrs();
extern int dump(), ruledump(), vardump(), reset_vclass();
extern Bool stopit(), tunix();
extern struct rules *get_target();
extern char *expandmacro();
Af_attrs buft;
extern char *macrostr, *states[];

extern char cursr[];
char actpath[MYMAXNAMLEN], dollarplus[MYMAXNAMLEN];

extern Bool busy_done;
extern int depth;
struct linked_list *confid_list;
char *pathlist[MAXPATHLIST][2];
int lastpath = 0;

get_date_of (anything,set,path)
     char *anything;
     Af_set *set;
     char *path;
{
  Af_key key;

  if (af_getkey (path, af_afname(anything), af_aftype(anything),
		 AF_BUSYVERS, AF_BUSYVERS, &key) == -1)
    if (af_getkey (path, af_afname(anything), af_aftype(anything),
		 AF_LASTVERS, AF_LASTVERS, &key) == -1)
      errexit (10, "af_getkey");
  af_initset (set);
  af_setaddkey (set, 0, &key);
  af_dropkey (&key);
} 

static void add_to_pathlist (name, path) char *name, *path; {
  char *namep = rindex (name, '/');

  if (lastpath >= MAXPATHLIST)
    return;

  if ((pathlist[lastpath][0] = malloc (MYMAXNAMLEN)) == NIL)
    return;
  (void) strcpy (pathlist[lastpath][0], namep ? namep + 1 : name);

  if (!strcmp (path, curvpath[0])) {
    if ((pathlist[lastpath][1] = malloc(3)) == NIL) {
      free (pathlist[lastpath][0]);
      return;
    }
    (void) strcpy (pathlist[lastpath][1], "&$");
  }
  else {
    if ((pathlist[lastpath][1] = malloc(MYMAXNAMLEN)) == NIL) {
      free (pathlist[lastpath][0]);
      free (pathlist[lastpath][1]);
      return;
    }
    (void) strcpy (pathlist[lastpath][1], path);
    (void) strcat (pathlist[lastpath][1], "/");
    (void) strcat (pathlist[lastpath][1], pathlist[lastpath][0]);
  }
  lastpath++;
}

Bool locate_object (name, mode)
     char *name;
     int mode;
{
  /*
   * Try to locate a history or at least a regular file of the specified
   * name. In doing so, consider current vpath. If an object is found
   * write its path-prefix (i.e. not the name, just the path) into the
   * global variable "actpath" and return TRUE. If no object can be
   * found, return FALSE - "actpath" is undefined.
   * "mode" == ALL: check if "name" exists in any of BPOOL or SRC-R-KIVE
   * "mode" == NONE: ???
   * "mode" == SOURCE: check if "name" exists in SRC-R-KIVE and nowhere else
   * "mode" == BINARY: check if "name" exists in BPOOL
   */
  char bname[MYMAXNAMLEN], sysp[MYMAXNAMLEN], lname[MYMAXNAMLEN];
  char current_path[MYMAXNAMLEN];
  register char *px;
  register int i;

#define YES 0
#define NO -1
  int file_exists = NO, 
      file_exists_in_src_rkive, 
      file_exists_in_bpool;

  int ii;
  Af_attrs buf;
  Bool is_in_pathlist(), full_path = FALSE;
  
  if (!name || (name[0] == '\0'))
    return (FALSE);

  sysp[0] = '\0';

  (void) strcpy (lname, name);
  if (px = rindex (lname,'/')) {
    full_path = TRUE;
    *px = '\0';
    px++;
  }
  else
    px = lname;

  if ((mode != BINARY) && is_in_pathlist (lname, px, full_path)) 
    return TRUE;


  (void) strcpy (bname, name);

  if (rindex (bname, '/')) {
    (void) strcpy (sysp, af_afpath (bname));
  }

  af_initattrs (&buf);
  (void) strcpy (buf.af_name, af_afname (bname));
  (void) strcpy (buf.af_type, af_aftype (bname));

  ii = 1;
  while (curvpath[ii]) ii++;

  i = ii - 1;

  /* "i" is index of last "vpath" element */

  while ( i >= 0 ) {
    if (i) { /* still vpath entries to look through ... */
      (void) strcpy (current_path, expandmacro (curvpath[i]));
      if (!*current_path)
	break;
      if(*current_path != '/') {
	(void) strcpy (buf.af_syspath, curvpath[0]);
	(void) strcat (buf.af_syspath, "/");
	(void) strcat (buf.af_syspath, current_path);
      }
      else
	(void) strcpy (buf.af_syspath, current_path);
    }
    else { /* i == 0 -- curvpath[0] points to build directory */
      if (*sysp)
	(void) strcpy (buf.af_syspath, sysp);
      else
	(void) strcpy (buf.af_syspath, curvpath[0]);
    }
    
    if (mode == ALL) {
      file_exists_in_src_rkive = af_access (buf.af_syspath, buf.af_name, 
					    buf.af_type, AF_SOURCE);
      file_exists_in_bpool = af_access (buf.af_syspath, buf.af_name, 
					buf.af_type, AF_DERIVED);
      if((file_exists_in_src_rkive == YES) || 
	 (file_exists_in_bpool == YES))
	file_exists = YES;
      else
	file_exists = NO;
    }
    
    if (mode == NONE)
      file_exists = af_access (buf.af_syspath, buf.af_name, 
			       buf.af_type, AF_SOURCE);
    
    if (mode == SOURCE) {
      file_exists = af_access (buf.af_syspath, buf.af_name, 
			       buf.af_type, AF_DERIVED);
      if (file_exists == NO)
	file_exists = af_access (buf.af_syspath, buf.af_name, 
				 buf.af_type, AF_SOURCE);
      else
	file_exists = NO;
    }
    
    if (mode == BINARY)
      file_exists = af_access(buf.af_syspath, buf.af_name, 
			      buf.af_type, AF_DERIVED);
    
    if (file_exists == YES) {
      (void) strcpy (actpath, buf.af_syspath);
      if (!full_path)
	add_to_pathlist (bname, buf.af_syspath);
      break;
    }
    i--;
    
  } /* end while ( i >= 0 ) */
  
  return (file_exists == YES);
  
#undef YES
#undef NO
}

static Bool is_in_pathlist (raw_name, sought_name, full_path) 
     char *raw_name, *sought_name; Bool full_path; 
{
  register int i;
  
  for(i = lastpath - 1; i >= 0; i--) {
    /* looking in pathlist if file already exists */
    
    if (!strcmp (sought_name, pathlist[i][0])) {
      if (!strcmp (pathlist[i][1], "&$"))
	(void) strcpy (actpath, curvpath[0]);
      else {
	if (pathlist[i][1][0] != '/') {
	  (void) strcpy (actpath, curvpath[0]);
	  (void) strcat (actpath, "/");
	  (void) strcat (actpath, pathlist[i][1]);
	}
	else {
	  (void) strcpy (actpath, pathlist[i][1]);
	}
	if ((sought_name = rindex (actpath, '/')) != NIL)
	  *sought_name = '\0';
      }
      if(full_path) {
	if (!strcmp (pathlist[i][1], raw_name)) {
	  (void) strcpy (actpath, pathlist[i][1]);
	  if ((sought_name = rindex (actpath, '/')) != NIL)
	    *sought_name = '\0';
	  return TRUE;
	}
	if (!strcmp (raw_name, curvpath[0]))	{
	  (void) strcpy (actpath, curvpath[0]);
	  return TRUE;
	}
      }
      else {
	if ((pathlist[i][1][0] == '&') && (pathlist[i][1][1] == '$')) {
	  (void) strcpy (actpath, curvpath[0]);
	  return TRUE;
	}
	else {
	  (void) strcpy (actpath, pathlist[i][1]);
	  if ((sought_name = rindex (actpath, '/')) != NIL)
	    *sought_name = '\0';
	  return TRUE;
	}
      }
      
    } /* end if (!strcmp (sought_name, pathlist[i][0])) */
    
  } /* end for (i = lastpath - 1; i >= 0; i--) */
  return FALSE;
}

FILE *vmfopen( filename, mode, major_version, minor_version)
     char *filename;
     char *mode;
     int major_version;
     int minor_version;
{
  Af_key key;
  FILE *fp;
  Af_set resultset;
  Af_attrs inattrs;
  int ret;

  af_initattrs(&inattrs);
  if(major_version != AF_BUSYVERS)
    {
      inattrs.af_gen = major_version;
      inattrs.af_rev = minor_version;
    }
  af_initset(&resultset);
  ret = at_gsbndvers(filename, &resultset, &inattrs);
  if(ret)
    {
      if(af_setgkey(&resultset,0,&key) == -1)
	errexit(10,"af_setgkey");
      if(af_dropset(&resultset) == -1)
	errexit(10,"af_dropset");
    }
  else
    {
      if(locate_object(filename,NONE))
	{
	  if(af_getkey(af_afpath(filename), af_afname(filename),
		       af_aftype(filename),major_version,minor_version,&key) == -1)
	    {
	      if(af_getkey(af_afpath(filename),af_afname(filename),
		       af_aftype(filename),AF_LASTVERS,AF_LASTVERS,&key) == -1)
		errexit(10,"af_getkey");
	    }
	}
      else
	return((FILE *) NIL);
    }
  if((fp = af_open(&key, mode)) == NULL)
    errexit(10,"af_open");
  return (fp);
}


get_set(anything,set)
     char *anything;
     Af_set *set;
     {

Af_attrs buf;
char bname[MYMAXNAMLEN], sysp[MYMAXNAMLEN];

sysp[0] = '\0';

(void) strcpy(bname,anything);

if ((rindex(bname,'/')) != NIL)
  (void) strcpy(sysp, af_afpath(bname));

af_initattrs(&buf);

(void) strcpy(buf.af_name,af_afname(bname));
(void) strcpy(buf.af_type,af_aftype(anything));
if(sysp[0] != '\0')
     (void) strcpy(buf.af_syspath, sysp);
else
  (void) strcpy(buf.af_syspath, curvpath[0]);
if (af_find(&buf,set) == -1)
  errexit(10,"af_find");
}

Bool try_to_bind_version (dep, bind_rule, try_or_bind, bind_result)
     char *dep;
     struct selection_rules *bind_rule;
     Bool try_or_bind;
     BKey *bind_result;
{
  register struct list *sellist;
  struct rules *testrule;
  Af_attrs buf2, testbuf;
  Af_key key2, keyt, testkey;
  Af_set tmpSet, sett;
  Bool objectExists, object_lives_in_vpath = FALSE, match = FALSE, 
  has_attr = FALSE, object_has_explicit_path = FALSE;
  void add_to_restorelist ();
  int ii = 0, uda = 0, testi = 0, pathj;
  char dep2[MYMAXNAMLEN], testpath[MYMAXNAMLEN];
  stopflg = FALSE;

  bind_result->bk_isdefined = FALSE;
  af_initattrs(&buf2);
  af_initattrs(&testbuf);

  if (locate_object (dep, BINARY))
    return FALSE;

  af_initset(&tmpSet);
  af_initset(&sett);

  (void) strcpy (dep2, dep);

  if (objectExists = locate_object (dep2, SOURCE)) {
    if (rindex (dep2, '/') != NIL) {
      (void) strcpy (testpath, af_afpath (dep2));
      object_has_explicit_path = TRUE;
    }
    else
      (void) strcpy (testpath, actpath);
    
    ii = 0;
    while ((bind_rule->predlist[ii] != (struct list *) NIL) 
	   && (match == FALSE)) {
      /*
       * This is the loop that looks through all alternatives
       * of the current selection rule.
       */

      
      if(bind_rule->predlist[ii]->parv[0] == '+')
	return TRUE;
      sellist = bind_rule->predlist[ii];
      dollarplus[0] = '\0';
      match = bind_rule->predlist[ii]->selfunc (dep, 
					      bind_rule->predlist[ii]->parv, 
					   (Af_set *)NIL);
      if (match) {
	/*
	 * The alternative applies !
	 * Now prepare to look through all the predicates.
	 */
	if (sellist->i == SMILEY)
	  (void) tunix (NIL, NIL, (Af_set *) NIL);
	if (sellist->i == GRIMMY)
	  (void) stopit (NIL, NIL, (Af_set *) NIL);
	sellist = sellist->cont; 
	
	(void) strcpy(dollarplus, dep);
	
	if (index(dep,'/') == NIL) {
	  if (strcmp(actpath,""))
	    (void) strcpy (testpath, actpath);
	  else
	    (void) strcpy (testpath, curvpath[0]);
	  /*
	   * "actpath" has been (implicitly) set by the 
	   * call to "locate_object", above. If "dep" has been
	   * found to exist, "actpath" points to the location 
	   * where it lives. The entire vpath stuff is taken
	   * care of by "locate_object".
	   */
	  (void) strcat (testpath, "/");
	  (void) strcat (testpath, dep);
	  get_set (testpath, &tmpSet);
	}
	else
	  get_set (dep, &tmpSet);
	
	if (tmpSet.af_setlen == 0) {
	  if(af_dropset(&tmpSet) == -1)
	    errexit(10,"af_dropset");
	  return TRUE;
	}
	
	/* generate buffer */
	af_initattrs(&buft);
	
	/* insert unique attrs */
	
	if (af_setgkey (&tmpSet, 0, &key2) == -1)
	  errexit (10, "af_setgkey");
	if (af_dropset (&tmpSet) == -1)
	  errexit (10, "af_dropset");
	if (af_gattrs (&key2, &buf2) == -1)
	  errexit (10, "af_gattrs");
	if (af_dropkey (&key2) == -1)
	  errexit (10, "af_dropkey");
	
	(void) strcpy (buft.af_syspath, buf2.af_syspath);
	(void) strcpy (buft.af_name, buf2.af_name);
	(void) strcpy (buft.af_type, buf2.af_type);
	
	if (!object_has_explicit_path)
	  object_lives_in_vpath = 
	    strcmp (buf2.af_syspath, curvpath[0]);
	
	/* perform initial retrieve operation.
	 * Evaluate version selection rule after that.
	 */
	if (af_find (&buft, &sett) == -1)
	  errexit(10,"af_find");
	
	/* --- START SEL RULE EVAL ---------- */
	
	/* initialize or recycle "buf2" */
	if (buf2.af_udattrs[0] != NIL)
	  free (buf2.af_udattrs[0]);
	
	af_initattrs(&buf2);
	(void) strcpy (buf2.af_syspath, buft.af_syspath);
	(void) strcpy (buf2.af_name, buft.af_name);
	(void) strcpy (buf2.af_type, buft.af_type);
	
	if (sett.af_nkeys) {
	  int  attrType = 0;
	  Bool full;
	  char *strPtr, *strPtr1;
	  
	  full = TRUE;
	  while ((sellist != (struct list *) NIL) && (full)) {
	    /*
	     * This loop evaluates all the predicates of
	     * the current alternative.
	     * if the current alternative fails, the enclosing
	     * loop looks for another matching alternative.
	     */
	    if((sellist->i == 0) && (try_or_bind == BIND_IT))
	      sellist->selfunc (sellist->parn, sellist->parv, (Af_set *) NIL);
	    if((sellist->i == 3) && (try_or_bind == BIND_IT))
	      if (sellist->selfunc (sellist->parn, sellist->parv, (Af_set *) NIL) == FALSE)
		/* simulate termination criterium */
		af_dropset (&sett);
	    if (sellist->i == GRIMMY) {
	      errexit (28, dep);
	    }
	    if (sellist->i == 1) {
	      attrType = get_attr_type(sellist->parn);
	      switch (attrType) {
	      case 0:
		buf2.af_gen = atoi(sellist->parv);
		break;
	      case 1:
		buf2.af_rev = atoi(sellist->parv);
		break;
	      case 2:
		buf2.af_state = (short) get_state_no(sellist->parv);
		if (buf2.af_state == 99)
		  errexit(16, sellist->parv);
		break;
	      case 3:
		(void) strcpy (buf2.af_author.af_username, sellist->parv);
		if ((strPtr = 
		     index (buf2.af_author.af_username,'@')) != NIL) {
		  *strPtr = '\0';
		  strPtr++;
		  (void) strcpy (buf2.af_author.af_userdomain, strPtr);
		}
		break;
	      case 4:
		errexit(10,"group id");
		break;
	      case 5:
		if(!strcmp(sellist->parv,"last")) {
		  buf2.af_gen = AF_LASTVERS;
		  buf2.af_rev = AF_LASTVERS;
		  break;
		}
		if(!strcmp(sellist->parv,"first")) {
		  buf2.af_gen = AF_FIRSTVERS;
		  buf2.af_rev = AF_FIRSTVERS;
		  break;
		}
		if ((strPtr = malloc ((unsigned) (strlen(sellist->parv) + 1))) == NIL)
		  errexit(10,"malloc");
		(void) strcpy (strPtr, sellist->parv);
		if (( strPtr1 = index(strPtr,'.')) == 0)
		  errexit(9,sellist->parv);
		else {
		  strPtr1[0] = '\0';
		  buf2.af_gen = atoi(strPtr);
		  strPtr1++;
		  buf2.af_rev = atoi(strPtr1);
		}
		break;
	      case 6:
		/* variant -- no longer supported */
		break;
	      case 7:
		(void) strcpy (buft.af_syspath, sellist->parv);
		break;
	      case 8:
		(void) strcpy (buf2.af_host, sellist->parv);
		break;
	      case 9:
		/* 
		 * Check if we have a locked busy-version.
		 * If we do have such a beast, we must insert it
		 * manually into the resultset of the query below.
		 * This special case exists because of our locking-protocol,
		 * that assumes that a locked most recent version implies 
		 * a locked busy-version.
		 */
		
		if(strcmp(sellist->parv,"")) {
		  (void) strcpy(buf2.af_locker.af_username,sellist->parv);
		  if ((strPtr = 
		       index(buf2.af_locker.af_username,'@')) != NIL) {
		    *strPtr = '\0';
		    strPtr++;
		    (void) strcpy(buf2.af_locker.af_userdomain, strPtr);
		  }
		}
		else {
		  static Af_user afnouser=AF_NOUSER;
		  buf2.af_locker = afnouser;
		}
		break;
	      case 10:
		(void) strcpy(buf2.af_owner.af_username,sellist->parv);
		if ((strPtr = 
		     index(buf2.af_owner.af_username,'@')) != NIL) {
		  *strPtr = '\0';
		  strPtr++;
		  (void) strcpy(buf2.af_owner.af_userdomain, strPtr);
		}
		break;
	      default:
		if ((buf2.af_udattrs[uda] =
		     malloc((unsigned) (strlen(sellist->parv) + 1 + strlen(sellist->parn) + 1 + 1))) == NIL)
		  errexit(10,"malloc");
		(void) strcpy(buf2.af_udattrs[uda],sellist->parn);
		(void) strcat(buf2.af_udattrs[uda],"=");
		(void) strcat(buf2.af_udattrs[uda],sellist->parv);
		buf2.af_udattrs[uda+1] = NIL;
		/* isn't "uda++" missing here ??? */
		break;
	      }
	      
	      /* retrieve second set with class 1 attributes
	       * and build intersection with original set
	       */
	      if (af_find (&buf2, &tmpSet) == -1)
		errexit (10, "af_find");
	      if (af_intersect (&sett, &tmpSet, &sett) == -1)
		errexit (10, "af_intersect");
	      if(af_dropset(&tmpSet) == -1)
		errexit(10,"af_dropset");
	      buf2 = buft; /* pseudo init-attrs */
	      
	    } /* End "if (sellist-> == 1)" */
	    
	    /* else part by Sibylle */
	    else {
	      if ((sellist->i == 2) && 
		  (get_attr_type (sellist->parn) > STD_ATTRS)) {
		/* if sellist->selfunc is attrnot, attrlt, attrgt,    */
		/* attrle, attrge, attrMYmax or attrmin and parameter */
		/* type is uda then it's more efficient to perform    */
		/* af_find on said uda. Hence parn is copied to buft. */
		if ((buft.af_udattrs[uda] = malloc((unsigned) (strlen(sellist->parn) + 1))) == NIL)
		  errexit(10,"malloc");
		(void) strcpy (buft.af_udattrs[uda], sellist->parn);
		uda++;
		buft.af_udattrs[uda] = NIL;
	      }
	    }
	    if (sellist->i == 2) {
	      full = sellist->selfunc(sellist->parn, sellist->parv, &sett);
	    }
	    if (sett.af_nkeys == 0)
	      break;
	    sellist = sellist->cont;
	  } /* end while ((sellist != (struct list *) NIL) && (full)) */
	  
	  if ((sett.af_nkeys == 1) && (sellist == (struct list *)0)) {
	    int restoreType;

	    /* ==> successful */
	    if (try_or_bind == TEST_ONLY) {
	      if (af_dropset (&sett) == -1)
		errexit (10, "af_dropset");
	      return TRUE;
	    }
	    if (af_setgkey (&sett, 0, &keyt) ==  -1)
	      errexit (10, "af_setgkey");
	    bind_result->bk_isdefined = TRUE;
	    bind_result->bk_key = keyt;


	    if (af_gattrs (&keyt, &buft) == -1)
	      errexit(10, "af_gattrs");
	    
	    if(confid) {
	      if(dep[0] == '/')
		write_confid (&buft, 1);
	      else
		write_confid (&buft, 0);
	    }
	    
	    if(selectflg) {
	      (void) write_select_list (&buft);
	      return (TRUE);
	    }
	    
	    /* If this version is found via vpath, we want it to be
	     * "restored" to the current directory. Even if it is a
	     * busy-version. If the version is non-busy,
	     * we have to restore it anyway.
	     */
	    if (object_lives_in_vpath) {
	      restoreType = 1; /* vpath */
	    }
	    else if (rindex (dep, '/')) {
	      restoreType = 2; /* explicit */
	    }
	    else
	      restoreType = 0; /* local */
	    
	    if (object_lives_in_vpath ||
		(buft.af_state != AF_BUSY ) || 
		(expflg)) {
	      add_to_restorelist (&keyt, dep, restoreType);
	      if(af_dropset(&sett) == -1)
		errexit(10,"af_dropset");
	      return TRUE;
	    }
	    else {
	      if(af_dropset (&sett) == -1)
		errexit (10, "af_dropset");
	      return TRUE;
	    }
	  } /* end if ((sett.af_nkeys == 1) && (sellist == NIL)) */
	} /* end if (sett.af_nkeys != 0) */
	
	/* --- END SEL RULE EVAL ---------- */
	
	if ((sett.af_nkeys == 0) &&
	    (bind_rule->predlist[ii+1] == (struct list *) NIL) &&
	    (!tunixflg) && !object_lives_in_vpath) {
	  testrule = get_target(dep2);
	  if (testrule && !is_pattern (testrule->name)) {
	    if(af_dropset(&sett) == -1)
	      errexit(10,"af_dropset");
	    return TRUE;
	  }
	  else {
	    if(notfoundflg)
	      (void) notfounditem(dep2);
	    else
	      errexit(17,dep2);
	  }
	}
	else {
	  /* next predicate */
	  if (stopflg)
	    errexit(28,dep);
	  if(tunixflg) {
	    tunixflg = FALSE;
	    if(af_dropset(&sett) == -1)
	      errexit(10,"af_dropset");
	    return FALSE;
	  }
	}
	if(af_dropset(&sett) == -1)
	  errexit(10,"af_dropset");
      } /* End of "if (match == TRUE)" */
      match = FALSE;
      stopflg = FALSE;
      ii++;
    } /* end while (more alternatives to look through ?) */
    reset_vclass();
  } /* end if (object_exists = locate_object...) */
  
  if ((match == FALSE) && (bind_rule->predlist[ii] == (struct list *) NIL)) {
    testrule = get_target (dep2);
    if (testrule && !is_pattern (testrule->name)) {
      if (af_dropset(&sett) == -1)
	errexit(10,"af_dropset");
      return TRUE;
    }
    else {
      if(notfoundflg)
	(void) notfounditem(dep2);
      else
	errexit(17,dep);
    }
  }
  /*NOTREACHED*/
  if (af_dropset(&sett) == -1)
    errexit(10,"af_dropset");
  return FALSE;
}

Bool bound_key_defined (keyp) BKey *keyp; {
  return keyp->bk_isdefined;
}

Af_key *bound_key (keyp) BKey *keyp; {
  return &keyp->bk_key;
}

int init_confid(name)
     char *name;
{
  fprintf(cid,"###### CONFID for %s ######\n", name);
  fprintf(cid,"\n");
  fprintf(cid,"#%% RULE-SECTION\n");
  fprintf(cid,"@%s:\n", name);
}



int write_confid(buf,cid_mode)
     Af_attrs *buf;
     int cid_mode;
{
  if(already_in_confid(buf))
    return;

  if (cid_mode == 0)
    fprintf(cid,"\t%s.%s,\n", buf->af_name, buf->af_type);
  else
    fprintf(cid, "\t%s/%s.%s,\n", buf->af_syspath, buf->af_name, buf->af_type);
  
  fprintf(cid,"\tattr(host,%s),\n", buf->af_host);
  if (cid_mode == 0)
    fprintf(cid,"\tattr(syspath,%s),\n", buf->af_syspath);

  if(buf->af_gen != AF_BUSYVERS)
    {
      fprintf(cid,"\tattr(generation,%d),\n", buf->af_gen);

      fprintf(cid,"\tattr(revision,%d),\n", buf->af_rev);
    }

  if (buf->af_state < AF_PUBLISHED)
    {
      fprintf(cid,"\tmsg(warning: confid contains %s version for %s.%s),\n",
	      states[buf->af_state], buf->af_name, buf->af_type);
      fprintf(stderr,"shape - warning: confid contains %s version for %s.%s\n",
	      states[buf->af_state], buf->af_name, buf->af_type);
    }

  fprintf(cid,"\tattr(state,%s)", states[buf->af_state]);

  fprintf(cid,";\n");

  fprintf(cid,"\n");
  (void) fflush(cid);
}

int finish_confid()

{
  fprintf(cid,"\t:-),\n\tmsg(\"Just to get a . to the end of the rule\").\n\n");
  fprintf(cid,"#%% END-RULE-SECTION\n");
  fprintf(cid,"\n");
  dump(cid);
  ruledump(cid);
  vardump(cid);
}


FILE *cmfopen( filename, mode, major_version,minor_version)
     char *filename;
     char *mode;
     /*ARGSUSED*/
     int major_version;
     int minor_version;
{
  char syspath[MYMAXNAMLEN];
  Af_key key;
  FILE *fp;

  if (rindex(filename,'/') == NIL)
    {
      (void) strcpy(syspath,curvpath[0]);
    }
  else
    {
      (void) strcpy(syspath,af_afpath(filename));
    }
  
  if(af_crkey(syspath, af_afname(filename), af_aftype (filename),&key) == -1)
    errexit(10,"af_crkey");
  else
    {
      fp = af_open(&key, mode);
      return (fp);
    }
  return((FILE *) NIL);
}


Bool already_in_confid(buf)
     Af_attrs *buf;
{
  char name[MYMAXNAMLEN];
  register struct linked_list *clist;

  (void) sprintf(name,"%s.%s[%d.%d]\0",buf->af_name,buf->af_type,buf->af_gen,
		 buf->af_rev);

  if(confid_list == (struct linked_list *) NIL)
    {
      if((confid_list = (struct linked_list *)
	 malloc(sizeof(struct linked_list))) == (struct linked_list *)NIL)
	errexit(10,"malloc");
      if((confid_list->string = malloc((unsigned)(strlen(name)+
						  sizeof(char)))) == NIL)
	errexit(10,"malloc");
      confid_list->nextstring = (struct linked_list *) NIL;
      (void) strcpy(confid_list->string,name);
      return(FALSE);
    }
  else
    {
      clist = confid_list;
      while(strcmp(name,clist->string))
	{
	  if(clist->nextstring != (struct linked_list *) NIL)
	    clist = clist->nextstring;
	  else
	    break;
	}

      if(clist->nextstring != (struct linked_list *) NIL)
	return(TRUE);
  
      if((clist->nextstring = (struct linked_list *)
	  malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	errexit(10,"malloc");
      if((clist->nextstring->string = 
	  malloc((unsigned) (strlen(name) + sizeof(char)))) == NIL)
	errexit(10,"malloc");
      (void) strcpy(clist->nextstring->string,name);
      clist->nextstring->nextstring = (struct linked_list *) NIL;
      return(FALSE);
    }
}


/*================ restore list ================== */
/* partially rewritten by andy@cs.tu-berlin.de -- 27. Jan. 92 */

static struct restoreItem {
  char     *unixName;
  Af_key   restoreKey;
  int      restoreType; /* 0 = local, 1 = vpath, 2 = external */
  struct   restoreItem *next;
} **restoreList; /* need one restore list for each recursion level */

static int maxResListDepth = 0;

static void add_to_restorelist (restoreKey, unixName, restoreType)
     Af_key *restoreKey;
     char *unixName;
     int restoreType;
{
  struct restoreItem *currentItem;

  /* add to restore macro */
  {
    char buffer[10240];
    (void) strcpy(buffer, "RESTORED_OBJS=");
    (void) strcat(buffer, expandmacro("$(RESTORED_OBJS)"));
    (void) strcat(buffer, " ");
    (void) strcat(buffer, unixName);
    macrodef(buffer);
  }

  if (depth >= maxResListDepth)
    {
      int i;
      if (maxResListDepth == 0)
	if((restoreList = (struct restoreItem **) malloc (16*sizeof(void *))) == (struct restoreItem **)0)
	  errexit(10,"malloc");
      else
	if((restoreList = (struct restoreItem **) realloc (restoreList, 16*sizeof(void *))) == (struct restoreItem **)0)
	  errexit(10,"realloc");
      for (i=maxResListDepth; i<maxResListDepth+16; i++)
	restoreList[i] = (struct restoreItem *)0;
      maxResListDepth += 16;
    }
	

  if(restoreList[depth] == (struct restoreItem *)0)
    {
      if ((restoreList[depth] = (void *) malloc (sizeof(struct restoreItem))) == (void *)0)
	errexit(10,"malloc");
      currentItem = restoreList[depth];
    }
  else
    {
      currentItem = restoreList[depth];
      while (currentItem->next) currentItem = currentItem->next;
      if ((currentItem->next = (void *) malloc (sizeof(struct restoreItem))) == (void *)0)
	errexit(10,"malloc");
      currentItem = currentItem->next;
    }
  
  if((currentItem->unixName = malloc((unsigned) (strlen(unixName) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  (void) strcpy(currentItem->unixName, unixName);
  currentItem->restoreKey = *restoreKey;
  currentItem->restoreType = restoreType;
  currentItem->next = (struct restoreItem *)0;
}


static void restore_vers (restoreKey, unixName, restoreType)
     Af_key *restoreKey;
     char *unixName;
     int restoreType;
{
  FILE *atfs_fp, *tmp_fp;
  char tmpName[MYMAXNAMLEN], hiddenName[MYMAXNAMLEN];
  char *buf, *at_getfilename();
  Bool busy_exist;
  
  if (noexflg)  /* don't execute commands (-n Option) */
    return;

  /* creation of a temporary file for the revision to be restored */
  if (restoreType == 2) /* external */
    {
      (void) strcpy (tmpName, af_rsyspath (restoreKey));
      (void) strcat (tmpName, "/");
      (void) strcat (tmpName, "shapeXXXXXX");
    }
  else
    {
      (void) strcpy (tmpName, "shapeXXXXXX");
    }
  (void) mktemp (tmpName);

  /* link, unlink, set busy */
  if ((atfs_fp = af_open (restoreKey, "r")) == NULL)
    errexit(10,"af_open");
  
  /* copy old revision into temp. file */
  if ((buf = malloc((unsigned) af_rsize (restoreKey))) == NIL)
    errexit(10,"malloc");
  (void) fread (buf, sizeof(char), (int) af_rsize (restoreKey), atfs_fp);
  af_close(atfs_fp);
  
  if ((tmp_fp = fopen (tmpName, "w")) == NULL)
    errexit(10, "fopen; could not create tmpfile");
  
  if(noexpflg)
    (void) fwrite (buf, sizeof(char), (int) af_rsize (restoreKey), tmp_fp);
  else
    WriteXPand (buf, af_rsize (restoreKey), tmp_fp, restoreKey);
  free(buf);
  (void) fclose(tmp_fp);

  /* save busy version into AtFS directory if necessary */

  errno = 0;
  if (access (unixName, R_OK) == 0) /* unix File already exists */
    {
      /* make name for real version that must be temporarily moved */
      if (restoreType == 2) /* external */
	(void) strcpy (hiddenName, af_rsyspath (restoreKey));
      else
	(void) strcpy (hiddenName, curvpath[0]);
      
      (void) strcat (hiddenName, "/.");
      (void) strcat (hiddenName, af_rname (restoreKey));
      if (strcmp (af_rtype (restoreKey), ""))
	{
	  (void) strcat (hiddenName, ".");
	  (void) strcat (hiddenName, af_rtype (restoreKey));
	}
      (void) strcat (hiddenName,"XXXXXX");
      (void) mktemp (hiddenName);
  
      busy_exist = TRUE;

      if (link (unixName, hiddenName) != 0)
	{
	  unlink (tmpName);
	  errexit(20, unixName);
	}
      if (unlink (unixName) != 0)
	{
	  unlink (tmpName);
	  errexit(21, unixName);
	}
    }
  else
    {
      hiddenName[0] = '\0';
      busy_exist = FALSE;
    }

  if (link (tmpName, unixName) != 0)
    errexit(22, unixName);
  if (unlink (tmpName) != 0)
    errexit(21, tmpName);
  register_link (unixName, hiddenName, busy_exist);
  if (af_rstate (restoreKey) != AF_BUSY)
    busy_done = TRUE;
}

restore_all_vers()
{
  struct restoreItem *currentItem, *lastItem;

  if (depth >= maxResListDepth) return;

  currentItem = restoreList[depth];
  while(currentItem != (struct restoreItem *)0)
    {
      restore_vers (&currentItem->restoreKey, currentItem->unixName, currentItem->restoreType);
      (void) free (currentItem->unixName);
      lastItem = currentItem;
      currentItem = currentItem->next;
      free (lastItem);
    }
  restoreList[depth] = (struct restoreItem *)0;
}

void drop_restorelist ()
{
  struct restoreItem *currentItem, *lastItem;

  if (depth >= maxResListDepth) return;

  currentItem = restoreList[depth];
  while(currentItem != (struct restoreItem *)0)
    {
      (void) free (currentItem->unixName);
      lastItem = currentItem;
      currentItem = currentItem->next;
      free (lastItem);
    }
  restoreList[depth] = (struct restoreItem *)0;
}

/*============ end restore list ================== */

write_select_list(buf)
     Af_attrs *buf;
{
  char filename[MYMAXNAMLEN];
  if(buf->af_type != NIL)
    {
      if(buf->af_state != AF_BUSY)
	{
	  sprintf(filename, "%s/%s%s%s[%d.%d]\0",buf->af_syspath,buf->af_name,
		  (buf->af_type && *buf->af_type) ? "." : "",
		  buf->af_type, buf->af_gen, buf->af_rev);
	}
      else
	{
	  sprintf(filename, "%s/%s%s%s\0",buf->af_syspath,buf->af_name,
		  (buf->af_type && *buf->af_type) ? "." : "",
		  buf->af_type, buf->af_gen, buf->af_rev);
	}
    }
  else
    {
      if(buf->af_state != AF_BUSY)
	{
	  sprintf(filename, "%s/%s%s%s[%d.%d]\0",buf->af_syspath,buf->af_name,
		 (buf->af_type && *buf->af_type) ? "." : "", buf->af_type,
		 buf->af_gen, buf->af_rev);
	}
      else
	{
	  sprintf(filename, "%s/%s%s%s\0",buf->af_syspath,buf->af_name,
		 (buf->af_type && *buf->af_type) ? "." : "", buf->af_type);
	}
    }
  if(!nomsgflg)
    printf("%s\n", filename);
  (void) add_to_selmacro(filename);
}

notfounditem(dependent)
     char *dependent;
{
  static char depname[MYMAXNAMLEN];
  if(strcmp(dependent,depname))
    printf("%s\n", dependent);
  (void) strcpy(depname,dependent);
}

add_to_selmacro(fname)
     char *fname;
{
  char buffer[10240];
  if(fname[strlen(fname)-1] == ']') {
    (void) strcpy(buffer, "SELECTED_AtFS=");
    (void) strcat(buffer, expandmacro("$(SELECTED_AtFS)"));
    (void) strcat(buffer," ");
    (void) strcat(buffer,fname);
    macrodef(buffer);
  }
  else {
    (void) strcpy(buffer, "SELECTED_FS=");
    (void) strcat(buffer, expandmacro("$(SELECTED_FS)"));
    (void) strcat(buffer," ");
    (void) strcat(buffer,fname);
    macrodef(buffer);
  }
}

Af_key *check_busylock (dependent, locker) 
     char *dependent, *locker;
{
  char *n, *t;
  static Af_key busy;
  Af_key last;
  static Af_user nobody = AF_NOUSER;
  Af_user mylocker, *real_locker, *vc_testlock();

  n = af_afname (dependent);
  t = af_aftype (dependent);

  if (af_getkey ("", n, t, AF_LASTVERS, AF_LASTVERS, &last) == -1) {
    return (Af_key *)NULL;
  }

  if (locker && *locker) {
    char tmpstr[MAXUSERNAMELEN+MAXDOMAIN+2], *at, *dom;

    (void) strcpy (tmpstr, locker);
    at = index (tmpstr, '@');
    if (at) {
      *at = '\0';
      dom = at+1;
    }else {
      dom = (char *)NULL;
    }
    (void) strcpy (mylocker.af_username, tmpstr);
    (void) strcpy (mylocker.af_userdomain, dom);
  }
  else
    mylocker = nobody;

  if (locked (real_locker = vc_testlock (&last))) {
    if ((!strcmp (real_locker->af_username, mylocker.af_username)) &&
	!strcmp (real_locker->af_userdomain, mylocker.af_userdomain)) {

      if (af_getkey ("", n, t, AF_BUSYVERS, AF_BUSYVERS, &busy) == -1) {
	af_dropkey (&last);
	return (Af_key *)NULL;
      }
      af_dropkey (&last);
      return &busy;
    }
  }
  af_dropkey (&last);
  return (Af_key *)NULL;
}
