/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * hash.h
 *
 * $Header: hash.h[2.5] Thu Jan  4 15:16:05 1990 axel@cs.tu-berlin.de frozen $
 */
/*
 * $Header: hash.h,v 2.0 88/06/29 16:14:46 axel Stable $
 *
 * $Log:	hash.h,v $
 * Revision 2.0  88/06/29  16:14:46  axel
 * New System Generation
 * 
 * Revision 1.1  88/06/07  17:10:11  axel
 * This version is part of a release
 * 
 */

#define NAMSZ 64   /* estimated max-size of names */
#define DEFHSIZE 521 /* default size of hashtable */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef struct hashent Hashent;		 

typedef struct hash Hash;

struct hashent { char    symbol[NAMSZ],
		         symval[NAMSZ];
		 Hashent *next;
	       };

struct hash { int     hsize,       /* No. of slots in hashtable */
		      (*fhash)();  /* Pointer to hash-function */
	      char    *cur_symval; /* Pointer to value of last retrvd. sym */
#ifdef CCOL
	      int     collcnt;
#endif
	      int     symcount;
	      Hashent *hashtb;     /* Anchor of hashtable */
	       };
