/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * hash.c
 *
 * $Header: hash.c[2.7] Wed Feb  5 18:10:58 1992 axel@cs.tu-berlin.de accessed $
 */

#ifndef lint
static char *ATFSid = "$Header: hash.c[2.7] Wed Feb  5 18:10:58 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
  static char *Cflags = CFFLGS;
#endif
#endif

/*
 * $Log:	hash.c,v $
 * Revision 2.0  88/06/29  16:14:43  axel
 * New System Generation
 * 
 * Revision 1.1  88/06/07  17:10:05  axel
 * This version is part of a release
 * 
 */

#include <stdio.h>
#include <atfs.h>  /* includes appropriate string[s].h */
/* #include <sys/types.h>
   #include <sys/stat.h>
   #include <strings.h>
*/
#include "hash.h"

hashinit (htab, hsize, sizeratio, fhash) Hash *htab; int hsize, sizeratio,
       (*fhash)(); {
  char *chash, *malloc();
  int ltimes, ctimes;
  register int i;
  register int lnull = 0L;
  long *lhash;

/*
 * Determination of reasonable size and initialization of hashtable.
 */

  /* initialize Hash - structure */
  htab->hsize = hsize/sizeratio;
  if ((htab->hashtb = 
       (Hashent *)malloc ((unsigned) (htab->hsize*sizeof (Hashent)))) == NULL) {
    perror ("malloc hashtable");
    exit (1);
  }
  htab->fhash = fhash;
#ifdef CCOL
  htab->collcnt = 0;
#endif
  htab->symcount = 0;

  /* set hashlist all zeros, take care of alignment */
  lhash = (long *)htab->hashtb;
  ltimes = (htab->hsize*sizeof (Hashent))/sizeof (long);
  ctimes = (htab->hsize*sizeof (Hashent))%sizeof (long);
  for (i=0; i < ltimes; i++)
    *lhash++ = lnull;
  chash = (char *)lhash;
  for (i=0; i < ctimes; i++)
    *chash++ = '\0';
/*
 * End of hashtable initialization.
 */
}

char *hashsym (htab, symbol, symval) Hash *htab; char *symbol, *symval; {
/*
 * put entry into hashtable. Only called, if symbol hasn't been found in 
 * hashtable. Function returns pointer to the symbol-string and sets
 * external variable cur_symval to corresponding symval.
 */
  int symindex;
  Hashent *new, *curptr;

  htab->symcount++;
  symindex = htab->fhash (htab, symbol);
  if (!htab->hashtb[symindex].symbol[0]) { /* found entry is not used yet */
    (void) strcpy (htab->hashtb[symindex].symbol, symbol);
    (void) strcpy (htab->hashtb[symindex].symval, symval);
    htab->hashtb[symindex].next = NULL;
    htab->cur_symval = htab->hashtb[symindex].symval;
    return htab->hashtb[symindex].symbol;
  }
  else {    /* oh boy - a collision! */
#ifdef CCOLL
    htab->collcnt++;
    fprintf (stderr, "%d'th hash-collision.\n", htab->collcnt);
#endif
    new = (Hashent*)malloc (sizeof (Hashent));
    (void) strcpy (new->symbol, symbol);
    (void) strcpy (new->symval, symval);
    new->next = NULL;
    curptr = &htab->hashtb[symindex];
    while (curptr->next) curptr = curptr->next;
    curptr->next = new;
    htab->cur_symval = new->symval;
    return new->symbol;
  } /* endif */
} /* end symhash */

int fhash (htab, hstr) Hash *htab; char *hstr; {
  register int lhstr, hval = 0, i;

  lhstr = strlen (hstr);
  for (i = 0; i < lhstr; i++)
    hval = hval + i*hstr[i];
  return hval%htab->hsize;
}

char *symlookup (htab, symbol) Hash *htab; char *symbol; {
/* 
 * Function searches htab for an entry with the given name symbol.
 * If such an entry exists, a pointer to the symbol string is returned
 * and the external variable cur_symval is set to the corresponding
 * symbolvalue
 */
  int where;
  Hashent *targ;

  where = htab->fhash (htab, symbol);
  if (htab->hashtb[where].symbol[0]) { /* well, we found at least something */
    if (!strcmp (symbol, htab->hashtb[where].symbol)) {  /* found it ? */
      htab->cur_symval = htab->hashtb[where].symval;
      return htab->hashtb[where].symbol;
    }
    else {  /* maybe it is somewhere down the gully */
      targ = &htab->hashtb[where];
      while (targ->next) {
	targ = targ->next;
	if (!strcmp (targ->symbol, symbol)) {
	  htab->cur_symval = targ->symval;
	  return targ->symbol;
	}
      }
    }
  }
  /* when we come to this point, the symbol hasn't been known */
  htab->cur_symval = NULL;
  return NULL;
}

char *cur_symval (htab) Hash *htab; {
  return htab->cur_symval;
}

destroy_htab (htab) Hash *htab; {
  (void) free ((char *)htab->hashtb);
}

dumphtb (htab) Hash *htab; {
  extern FILE *yyout;
  register int i;
  register Hashent *h;

#ifdef CCOLL
  fprintf (yyout, "Hash-collision statistics:\n");
  fprintf (yyout, "Table-size: %d\tNo. of symbols: %d\tCollisions: %d\n",
	   htab->hsize, htab->symcount, htab->collcnt);
#endif

  for (i = 0; i < htab->hsize; i++) {
    if (htab->hashtb[i].symbol[0]) {
      h = &htab->hashtb[i];
      while (h) {
	fprintf (yyout, "symbol: %s", h->symbol);
	if (h->symval[0])
	  fprintf (yyout, ", value: %s.\n", h->symval);
	else
	  fprintf (yyout, " -- no value.\n");
	h = h->next;
      }
    }
    else fprintf (yyout, "empty hastable-entry.\n");
  }
}

getfsize (fil) FILE *fil; {
  struct stat buf;

  if (fil == stdin) {
    return DEFHSIZE;
  }
  else {
    if (fstat (fileno (fil), &buf) == -1) {
      perror ("file should be accessible");
      exit (1);
    }
    return (int)buf.st_size;
  }
}
