/* LINTLIBRARY */
/*$__copyright */
/*
 * at_retrieve.c
 */
/*
 * $Header: at_retrieve.c[1.8] Mon Apr  6 21:48:35 1992 axel@cs.tu-berlin.de accessed $
 */

/*
 * defines:
 *
 *		int at_gsbndvers(name, key, attrbuf)
 *                  get set from bound version
 *
 *              int at_setcachekey (*Af_key key)
 *                  assign unique key attribute (the name "cachekey"
 *                  is somewhat misleading to the derived object
 *                  pointed to by key.
 *
 *              int at_savebinary (*Af_key old, *Af_key old)
 *                  save "old" in bpool and make sure a uniqe 
 *                  cache_key is assigned to the stored object.
 *
 *              char *at_rcachekey (*Af_key)
 *                  return pointer to string, containing a cached
 *                  object's cachekey.
 */
#ifndef lint
static char *ATFSid = "$Header: at_retrieve.c[1.8] Mon Apr  6 21:48:35 1992 axel@cs.tu-berlin.de accessed $";
static char *ConfFlg = "$__CFLAGS$";
static char *Objfile = "at_retrieve.c[$__version] accessed";
#ifdef CFFLGS
  static char *Cflags = CFFLGS;
#endif
#endif

#include <atfs.h>
#include "atfsapp.h"

#define PATTERN ".*?[]"		/* valid patterns for uda specs */

/* get key from bound version */
int at_gsbndvers(name, resultset, inattrs)
     char *name;
     Af_set *resultset;
     Af_attrs *inattrs;
{
  /* Input: filename in bound version notation. Eg.: foo[1.2] or
   * foo[symbolicname], or foo[].
   * Output: A set. Returns 1 if found, 0 otherwise.
   */
  
  Af_attrs attrs;
  Af_set set;
  Af_key key;
  int i, pattern=0, vno;
  char *cp1, *cp2, fn[MAXPATHLEN+1], uda[MAXPATHLEN+1] /* hmmm */;
  char *regex[1];

  extern char *at_mkedpat();
  
  (void) strcpy(fn, name);
  if (!((cp1 = rindex(fn, '[')) && (cp2 = index(cp1, ']'))))
    return 0;

  af_initset(&set);
  bcopy((char *) inattrs, (char *) &attrs, sizeof(attrs));

  *(cp1++) = '\0';
  *cp2 = '\0';

  if (vno =  mkvno(cp1)) {
    attrs.af_gen = gen(vno);
    attrs.af_rev = rev(vno);
  }
  else {
    if (!strcmp(cp1, "busy")) {
      attrs.af_gen = AF_BUSYVERS;
      attrs.af_rev = AF_BUSYVERS;
    }
    else {
      /* symbolic name */
      vno = Symn2Vno (fn, cp1);
      attrs.af_gen = gen(vno);
      attrs.af_rev = rev(vno);
    }
  }

  (void) strcpy(attrs.af_syspath, af_afpath(fn));
  (void) strcpy(attrs.af_name, af_afname(fn));
  (void) strcpy(attrs.af_type, af_aftype(fn));

  if (af_find(&attrs, &set) == -1) {
    af_perror("at_gsbndvers: af_find:");
    exit(1);
  }

  if (pattern) {
    regex[0] = at_mkedpat(strcat(uda, cp1));

    for (i = 0; i < set.af_nkeys; i++) {
      if (af_setgkey(&set, i, &key) == -1) {
	af_perror("at_gsbndvers: af_setgkey:");
	exit(1);
      }
      if (af_gattrs(&key, &attrs) == -1) {
	af_perror("at_gsbndvers: af_gattrs:");
	exit(1);
      }
      if (at_matchregex(regex, 1, &attrs))
	af_setaddkey(resultset, AF_LASTPOS, &key);

      (void) af_dropkey(&key);
    }

    (void) af_dropset(&set);
    return resultset->af_nkeys;
  }

  (void) af_copyset(&set, resultset);
  (void) af_dropset(&set);
  return resultset->af_nkeys;
}

#define CACHEKEY "__CacheKey__"
#define CACHEKEYLEN 64

int at_setcachekey (key) Af_key *key; {
  static int serial = 1;
  char keybuffer[CACHEKEYLEN];
  Af_attrs bbuf;

  if (fail(af_gattrs (key, &bbuf))) return -1;

  (void) sprintf (keybuffer, "%s=%d.%d.%d", CACHEKEY, bbuf.af_mtime, 
		  getpid (), serial++);
  if (fail(af_sudattr (key, AF_REPLACE, keybuffer)))
    if (fail(af_sudattr (key, AF_ADD, keybuffer)))
      return -1;

  (void) udafree (&bbuf);

  return 0;
}

int at_savebinary (old, new) Af_key *old, *new; {
  char *cache_key = at_rcachekey (old);
  
  if (cache_key == (char *)NULL)
    (void) at_setcachekey (old);
  else
    free (cache_key);

  return af_savebinary (old, new);
}

char *at_rcachekey (dokey) Af_key *dokey; {
  return af_rudattr (dokey, CACHEKEY);
}


  
