/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/*
 * Shape/AtFS
 *
 * s-svr_3/config.h -- general definitions for System V/386 Release 3
 *
 * $Header: config.h[1.6] Wed Mar 11 12:35:20 1992 andy@cs.tu-berlin.de accessed $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* identify operating system flavor */
#define SYSV           /* System V/386 Release 3 */

/* general includes */
#include <sys/types.h>
#include <sys/stat.h>
#ifndef MAXNAMLEN
#include <sys/dir.h>
#endif
#include <sys/param.h>
#ifndef SIGHUP			/* sys/param.h does not include signal.h */
#include <signal.h>
#endif
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <utime.h>
/* In some versions of Interactive UNIX <utime.h> is missing.
 * If your system complains about that, define
 *
 * struct  utimbuf {
 *       time_t  actime;
 *       time_t  modtime;
 * };
 *
 * instead.
 */

/* system dependent includes */
#include <unistd.h>
#include <dirent.h>

/* general type definitions */
#define u_short ushort
#define u_long  ulong

#define Sfunc_t int      /* type of function argument to signal call */
#define Sigret_t void    /* return type of signal system call */
#define Size_t  size_t   /* used for args to malloc(), fread() etc. */
#define Uid_t   u_short  /* used for user-id types */
#define Gid_t   u_short  /* used for group-id types */

/* If mode_t is not defined, insert
 *
 * #define mode_t ushort
 */

/* define the return type of syscall wait() */
typedef union wait { int w_status; };

/* timeval and timezone is not defined on Sys V */
struct timeval {
	long tv_sec;
	long tv_usec;
};

struct timezone {
	int tz_minuteswest;
	int tz_dsttime;
};

/* Which dbm should be used ? (default ndbm) */
#define OWNDBM

/* How long can names be */
#undef MAXNAMLEN
#define MAXNAMLEN 14
#define MAXTYPLEN 14
#define MAXPATHLEN 255
#define MAXHOSTNAMELEN 64
#define MAXDOMAIN      255

/* define number of groups a user can belong to */
#define NGROUPS 1

/* definitions according to config.c */
char *index ();
char *rindex ();
char *getwd ();

/* other definitions */
struct passwd *getpwnam ();
struct passwd *getpwuid ();

#define direct dirent

extern char *re_comp();		/* requires linking with -lPW */

#endif /* _defs_ */
