/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/*
 * Shape/AtFS
 *
 * s-aix/config.h -- general definitions for AIX 3
 *
 * $Header: config.h[1.3] Mon Mar 30 20:05:10 1992 nickel@cs.tu-berlin.de accessed $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* identify operating system flavor */
#define AIX

#undef __STR__

/* general includes */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <signal.h>
#include <string.h>
#include <pwd.h>
#include <time.h>
#include <utime.h>

/* system dependent includes */
#include <unistd.h>
#include <dirent.h>
#include <sys/wait.h>

/* general type definitions */
#define u_short ushort
#define u_long  ulong

#define Sfunc_t int      /* type of function argument to signal call */
#define Sigret_t void    /* return type of signal system call */
#define Size_t  size_t   /* used for args to malloc(), fread() etc. */
#define Uid_t   uid_t    /* used for user-id types */
#define Gid_t   gid_t    /* used for group-id types */
#define Wait_t  int
#define Pid_t   pid_t

/* How long can names be */
#define MAXTYPLEN 255
#define MAXDOMAIN 255

/* definitions according to config.c */
char *index ();
char *rindex ();

/* other definitions */
struct passwd *getpwnam ();
struct passwd *getpwuid ();

#define direct dirent
#define vfork fork

extern char *re_comp();		/* requires linking with -lPW */

#endif /* _defs_ */
