/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	afarchive.h - Constant-Definitions for AtFS-archives
 *
 *	Author:	Andreas Lampen (andy@coma.UUCP
 *				andy@db0tui62.BITNET)
 *
 *	$Header: afarchive.h[1.9] Fri Jan 31 18:06:38 1992 andy@cs.tu-berlin.de accessed $
 *
 */

/*=========================================================================
 * Internal Installation dependent constants
 *=========================================================================*/

#define AF_NEWREVS         8	/* add. space for new revisions in rev list */
#define AF_MAXLISTS      211    /* maximum number of read-in archives */
#define AF_MAXMEM    1000000    /* maximum size of memory occupied by */
                                /* read in archives */
#define AF_LISTSEG         8    /* size of segments of revlists-list */
#define AF_UDASEGSIZ     512    /* size of memory segment for UDAs */
#define AF_BPOOLSIZE      64    /* max number of files in binary pool */
                                /* should be determined dynamically */
#define MAXDBMLEN       1024    /* maximum size of dbm-datastring */
#define DBMLOSS            8    /* size of management data in dbm entry */
                                /* ( 2 * sizeof (int)) */

/*=========================================================================
 * Identification strings in archive and binary pool files
 *=========================================================================*/

#define AF_LINESIZ      1024            /* size of input line */

#define AF_SEGSTRLEN    5
#define AF_ARHEADER 	"\02ARHD"	/* Header of Archive-file */
#define AF_DATAHEADER 	"\02DATA"	/* Header of Data-file */
#define AF_BPHEADER 	"\02BPHD"	/* Header of Binary-pool-file */
#define AF_UDASEG 	"\02USEG"	/* User defined attributes Segment */

#define AF_IDSTRLEN 	2
#define AF_NAMEID	"\02I" 	/* Identification path, name, type */ 
#define AF_OWNID	"\02O" 	/* Owner */
#define AF_PRDID	"\02P" 	/* predecessor of busy version */
#define AF_LOCKID	"\02L" 	/* Lock */
#define AF_REVID	"\02R" 	/* revision specific attributes */
				/* gen, rev, state, mode */
#define AF_AUTHORID	"\02A" 	/* Author */
#define AF_DATEID	"\02T" 	/* date of last mod., last access, */
				/* creation, save */
#define AF_REPRID	"\02M" 	/* kind of represetation, size of file, size */
				/* of delta and other delta stuff (tree) */
#define AF_NOTEID	"\02N" 	/* gen, rev, size, text of note */
#define AF_UDAID	"\02U" 	/* gen, rev, size, text of udattrs */
#define AF_DATAID	"\02D" 	/* gen, rev, size, repr, text of data */

#define AF_BPFILEID     "\02B"  /* filename prefix for BP files */
#define AF_ATFSFILEID   "\02A"  /* filename prefix for AtFS archives */

/******* binary pool specific stuff *********/
#define AF_BPSTDENTRY   "\01##" /* dbm entry name for special information */
#define AF_BPOOLNAME    "\02Bpool"

/*======================================================================
 * other constants
 *======================================================================*/

#define AF_ARCHMODE     0444
#define AF_ARCURVERS    3
#define AF_BPCURVERS    1

#define AF_NOSTRING     "\01$"

/*=========================================================================
 * Useful macros
 *=========================================================================*/

/* test if string is empty */
#define NOTMT(str) ((str && str[0]) ? str : AF_NOSTRING)

