#!/bin/sh
#
# # Copyright (C) 1989,1990,1991,1992 by
#	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
#	Wolfgang Obst and Ulrich Pralle 
# 
# This file is part of shapeTools.
#
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with shapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# $Header: shape_config.sh[1.6] Fri Apr 24 18:28:13 1992 shape@cs.tu-berlin.de accessed $
#

base=$1

trap "if [ ! -f Makefile ]; then mv $savename Makefile; fi; rm -f Makefile.new; exit 1" 1 2 13 15

# test if echo command interprets -n option
xxx=`echo -n`

if [ -z "$xxx" ]
  then
    echolead=-n
    echotrail=
  else
    echolead=
    echotrail="""\c"""
fi

echo
echo "Configure the shapeTools build/installation procedure ..."

# base path (BASE)

if [ -z "$base" ] # if path is not given as argument
  then
    base=`pwd`
    echo "Where did you place the shapeTools sources ?"
    echo $echolead "[Default: $base] > " $echotrail
    read input
    if [ -n "$input" ]
      then
        base=$input
    fi
fi

grep shapeTools $base/Makefile > /dev/null 2>&1
retval=$?

while [ $retval -ne 0 ]
  do
    echo $echolead "This seems not to be the right one. Another try > " $echotrail
    read input
    base=$input
    grep shapeTools $base/Makefile > /dev/null 2>&1
    retval=$?
  done

# Operating System type (HOSTSYSTEM)

hostsystem=`grep HOSTSYSTEM $base/Makefile | head -1 | \
	sed -e 's/HOSTSYSTEM//' -e 's/[= ]//g' -e 's/s-//'`
echo
echo "Please enter the operating system type. Supported platforms are:"
echo "    aix   -- (AIX)             bsd_4_3  -- (BSD 4.3)"
echo "    hpux  -- (HP/UX)           irix     -- (IRIX 3.3.x)"
echo "    mach  -- (Mach/NeXT)       sunos_4  -- (SunOS 4.x.x)"
echo "    svr_3 -- (System V Rel 3)  ultrix_4 -- (Ultrix 4.x)"
echo "    for others see the README file."
echo $echolead "[Default: $hostsystem] > " $echotrail
read input
if [ -n "$input" ]
  then
    hostsystem=s-$input
  else
    hostsystem=s-$hostsystem
fi

# machine architecture (HOSTTYPE)

hosttype=`(aa=\`arch\`; echo $aa) 2> /dev/null`

# system libraries (SYSLIBS)

if [ "$hostsystem" = "s-svr_3" -o "$hostsystem" = "s-hpux_6_2" ]
  then
    syslibs="-lPW"
fi
if [ "$hostsystem" = "s-aix" ]
  then
    syslibs="-lPW"
fi

make=`grep MAKE $base/Makefile | head -1 | sed -e 's/MAKE//' -e 's/=//'`
cc=`grep CC $base/Makefile | head -1 | sed -e 's/CC//' -e 's/=//'`
cflags=`grep CFLAGS $base/Makefile | head -1 | sed -e 's/CFLAGS//' -e 's/=//'`
ldflags=`grep LDFLAGS $base/Makefile | head -1 | sed -e 's/LDFLAGS//' -e 's/=//'`
echo
echo "Do you want to change any of the following macro definitions ?"
echo "   MAKE    = $make"
echo "   CC      = $cc"
echo "   CFLAGS  = $cflags"
echo "   LDFLAGS = $ldflags"
echo $echolead "[Default: no] > " $echotrail
read input

if [ "$input" = "yes" -o "$input" = "y" ]
  then
    echo
    echo $echolead "MAKE    = [Default: $make] " $echotrail
    read input
    if [ -n "$input" ]
      then
        make=$input
    fi
    echo $echolead "CC      = [Default: $cc] " $echotrail
    read input
    if [ -n "$input" ]
      then
        cc=$input
    fi
    echo $echolead "CFLAGS  = [Default: $cflags] " $echotrail
    read input
    if [ -n "$input" ]
      then
        cflags=$input
    fi
    echo $echolead "LDFLAGS = [Default: $ldflags] " $echotrail
    read input
    if [ -n "$input" ]
      then
        ldflags=$input
    fi
fi

subsystems=`grep SUBSYSTEMS $base/Makefile | head -1 | \
	sed -e 's/SUBSYSTEMS//' -e 's/=//'`
echo
echo "Do you use 'GNU-emacs' on your machine ?"
echo "Do you want the emacs shapeTools mode to be compiled too ?"
echo $echolead "[Default: yes] > " $echotrail
read input

if [ "$input" = "no" -o "$input" = "n" ]
  then
    subsystems=`echo $subsystems | sed -e 's.src/interface..'`
fi
subsystems=`echo $subsystems | sed -e 's.tutorial..'`

installbinpath=`grep INSTALLBINPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLBINPATH//' -e 's/[\= ]//g'`
echo
echo "Where shall the executables be installed ?"
echo $echolead "[Default: $installbinpath] > " $echotrail
read input
if [ -n "$input" ]
  then
    installbinpath=$input
fi

installmanpath=`grep INSTALLMANPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLMANPATH//' -e 's/[\= ]//g'`
echo
echo "... and the manuals ? (You need man{1,7,8} subdirectories there)"
echo $echolead "[Default: $installmanpath] > " $echotrail
read input
if [ -n "$input" ]
  then
    installmanpath=$input
fi

awk "{  if ((\$1 == \"BASE\" && \$2 == \"=\") || \$1 == \"BASE=\")
	  print \"BASE = $base\"
	else if ((\$1 == \"HOSTSYSTEM\" && \$2 == \"=\") || \$1 == \"HOSTSYSTEM=\")
	  print \"HOSTSYSTEM = $hostsystem\"
	else if ((\$1 == \"HOSTTYPE\" && \$2 == \"=\") || \$1 == \"HOSTTYPE=\")
	  print \"HOSTTYPE = $hosttype\"
	else if ((\$1 == \"SYSLIBS\" && \$2 == \"=\") || \$1 == \"SYSLIBS=\")
	  print \"SYSLIBS = $syslibs\"
	else if ((\$1 == \"SUBSYSTEMS\" && \$2 == \"=\") || \$1 == \"SUBSYSTEMS=\")
	  print \"SUBSYSTEMS = $subsystems\"
	else if ((\$1 == \"MAKE\" && \$2 == \"=\") || \$1 == \"MAKE=\")
	  print \"MAKE = $make\"
	else if ((\$1 == \"CC\" && \$2 == \"=\") || \$1 == \"CC=\")
	  print \"CC = $cc\"
	else if ((\$1 == \"CFLAGS\" && \$2 == \"=\") || \$1 == \"CFLAGS=\")
	  print \"CFLAGS = $cflags\"
	else if ((\$1 == \"LDFLAGS\" && \$2 == \"=\") || \$1 == \"LDFLAGS=\")
	  print \"LDFLAGS = $ldflags\"
	else if ((\$1 == \"INSTALLBINPATH\" && \$2 == \"=\") || \$1 == \"INSTALLBINPATH=\")
	  print \"INSTALLBINPATH = $installbinpath\"
	else if ((\$1 == \"INSTALLMANPATH\" && \$2 == \"=\") || \$1 == \"INSTALLMANPATH=\")
	  print \"INSTALLMANPATH = $installmanpath\"
	else print }" Makefile > Makefile.new

savename=Makefile.orig
echo
echo "Saving original Makefile to Makefile.orig."
mv Makefile $savename
mv Makefile.new Makefile

touch .configured
exit 0
