.*------------------------------------------------------------------------------
.* mSQL V 1.0.14 for OS/2 with TCP/IP
.*------------------------------------------------------------------------------
:userdoc.
:title.Mini SQL 1.0.14 (OS/2 version)
.*------------------------------------------------------------------------------
.* 'Info'
.*------------------------------------------------------------------------------
:h1 id=info clear.Info
:lines align=left.
Mini SQL - A Lightweight Database Engine
:hp4.mSQL 1.0.14 for OS/2 2.x or Warp with TCP/IP:ehp4.
:elines.
:artwork name='hughes.bmp' align=center.
:lines align=center.
:hp8.All programs included in this package are provided "as is", without
any warranty! Try them on your own risk.
:ehp8.
:elines.
:p.This documentation is based on the postscript file mSQL-111.ps
describing version 1.0.11 (Feb. 1996) and has been adapted to the OS/2
port.
:p.Copyright (c) 1993 - 1996 David J. Hughes (Hughes Technologies Pty Ltd)
:p.Adaption to OS/2 made by Dirk Ohme

.*------------------------------------------------------------------------------
.* 'Introduction and History'
.*------------------------------------------------------------------------------
:h1 id=introduction clear.Introduction and History
:p.Mini SQL, or mSQL, is a lightweight database engine designed to provide
fast access to stored data with low memory requirements. As its name
implies, mSQL offers a subset of SQL as its query interface. Although it
only supports a subset of SQL (no views, sub-queries, etc.), everything
it supports is in accordance with the ANSI SQL specification. The mSQL
package includes the database engine, a terminal "monitor" program, a
database administration program, a schema viewer, and a C language API.
The API and the database engine have been designed to work in a
client/server environment over a TCP/IP network.

.*------------------------------------------------------------------------------
.* 'Mini SQL Specification'
.*------------------------------------------------------------------------------
:h1 id=specification clear.Mini SQL Specification
:p.The mSQL language offers a significant subset of the features provided
by ANSI SQL. It allows a program or user to store, manipulate and
retrieve data in table structures. It does not support relational
capabilities such as table joins, views or nested queries. Although it
does not support all the relational operations defined in the ANSI
specification, it does provide the capability of "joins" between multiple
tables.

:p.Although the definitions and examples on the next pages depict mSQL key
words in upper case, no such restriction is placed on the actual queries.

.*------------------------------------------------------------------------------
.* 'The Create Clause'
.*------------------------------------------------------------------------------
:h2 id=create_table clear.The CREATE TABLE Clause
:p.The create clause as supported by mSQL can onyl be used to create a
table. It cannot be used to create other definitions such as views. It
should also be noted that there can only be one :hp2.primary:ehp2. key
field defined for a table. Defining a field as a key generates and
implicit :hp2.not null:ehp2. attribute for the field.
:xmp.
  CREATE TABLE table_name (
      co_name      col_type [ not null | primary key ]
      [, col_name  col_type [ not null | primary key ] ]**
  )
:exmp.
for example:
:xmp.
  CREATE TABLE emp_details (
      first_name   char(15) not null,
      last_name    char(15) not null,
      dept         char(20),
      emp_id       int primary key,
      salary       int
  )
:exmp.
:p.The available types (col_type) are:
:table cols='10 70' rules=both frame=box.
:row.
:c.char(len)
:c.String of characters (or other 8 bit data)
:row.
:c.int
:c.signed integer values
:row.
:c.real
:c.Decimal or Scientific Notation real values
:etable.

.*------------------------------------------------------------------------------
.* 'The Drop Clause'
.*------------------------------------------------------------------------------
:h2 id=drop clear.The DROP Clause
:p.DROP is used to remove a table definition from the database:
:xmp.
  DROP TABLE table_name
:exmp.
:p.for example:
:xmp.
  DROP TABLE emp_details
:exmp.

.*------------------------------------------------------------------------------
.* 'The Insert Clause'
.*------------------------------------------------------------------------------
:h2 id=insert_into clear.The INSERT INTO Clause
:p.Unlike ANSI SQL, you cannot nest a SELECT within an INSERT (i.e. you
cannot insert the data returned by a SELECT). If you don not specify the
field names they will be used in the same order they were defined - you
must specify a value for every field if you do this.
:xmp.
  INSERT INTO table_name [ ( column [ , column ]** ) ]
    VALUES ( value [ , value ]** )

  value can be a either a integer or scientific number, a string
  or 'sysdate' or 'systime'.
:exmp.
:note.
SYSDATE and SYSTIME are only available in the OS/2 version of mSQL. SYSDATE
returns the current date in a string of 10 characters 'yyyy/mm/dd', there
'yyyy' is the year, 'mm' is the month (01-12) and 'dd' is the day of month
(01-31). SYSTIME returns the current local time in a string of 8 characters
'hH&colon.MM.SS', with 'hH' is the hour (0-23), 'MM' is the minute (00-59)
and 'SS' is the second (00-59). On "Feb 14, 1996  08&colon.01.30" SYSDATE
returns "1996/02/14" and SYSTIME returns " 8&colon.01.30". The key-words
SYSDATE and SYSTIME are not case-sensitive.
:p.for example:
:xmp.
  INSERT INTO emp_details (first_name, last_name, dept, salary)
    VALUES ('David', 'Hughes', 'I.T.S.', 12345)

  INSERT INTO emp_details
    VALUES ('David', 'Hughes', 'I.T.S.', 12345)

  INSERT INTO log_table
    VALUES ('starting time', sysdate, systime)
:exmp.
:p.The number of values supplied must match the number of columns.

.*------------------------------------------------------------------------------
.* 'The Delete Clause'
.*------------------------------------------------------------------------------
:h2 id=delete_from clear.The DELETE FROM Clause
:p.The syntax for mSQL's DELETE clause is
:xmp.
  DELETE FROM table_name
    WHERE column OPERATOR value
    [ AND | OR column OPERATOR value ]**

  OPERATOR can be <, >, =, <=, >=, <>, or 'like'
:exmp.
:p.for example:
:xmp.
  DELETE FROM emp_details WHERE emp_id = 12345
:exmp.

.*------------------------------------------------------------------------------
.* 'The Select Clause'
.*------------------------------------------------------------------------------
:h2 id=select clear.The SELECT Clause
:p.The SELECT offered by mSQL lacks some of the features provided by the SQL
spec:
:lm margin=5.
:ul.
:li.No nested selects
:li.No implicit functions (e.g. count(), avg() )
:eul.
:lm margin=1.
:p.It does however support:
:lm margin=5.
:ul.
:li.Joins - including table aliases
:li.:hp2.DISTINCT:ehp2. row selection
:li.:hp2.ORDER BY:ehp2. clauses
:li.Regular expression matching
:li.Column to column comparisons in :hp2.WHERE:ehp2. clauses
:eul.
:lm margin=1.
:p.So, the formal syntax for mSQL's SELECT is:
:xmp.
  SELECT [table.]column [, [table.]column ]**
    FROM table [ = alias][, table [ = alias]]**
    [ WHERE [table.]column OPERATOR VALUE
      [ AND | OR [table.]column OPERATOR VALUE]** ]
    [ ORDER BY [table.]column [DESC][,[table.]column [DESC]]
    [ LIMIT number_of_rows ]

  OPERATOR can be <, >, =, <=, >=, <>, or 'like'
  VALUE can be a literal value or a column name
:exmp.
:p.A simple SELECT may be
:xmp.
  SELECT first_name, last_name FROM exmp_details
    WHERE dept = 'finance'
:exmp.
:p.To sort the returned data in ascending order by :hp1.last_name:ehp1.
and descending order by :hp1.first_name:ehp1. the query would look like this
:xmp.
  SELECT first_name, last_name FROM emp_details
    WHERE dept = 'finance'
    ORDER BY last_name, first_name DESC
:exmp.
:p.And to remove any duplicate rows, the :hp2.DESTINCT:ehp2. operator could
be used&colon.
:xmp.
  SELECT DISTINCT first_name, last_name FROM emp_details
    WHERE dept = 'finance'
    ORDER BY last_name, first_name DESC
:exmp.
:p.To limit the number of rows returned to a maximum of :hp4.3:ehp4. rows,
use the :hp2.LIMIT:ehp2. operator&colon.
:xmp.
  SELECT DISTINCT first_name, last_name FROM emp_details
    WHERE dept = 'finance'
    ORDER BY last_name, first_name DESC
    LIMIT 3
:exmp.
:p.The regular expression syntax supported by :hp2.LIKE:ehp2. clauses is
that of standard SQL:
:lm margin=5.
:ul.
:li. '_' matches any single character
:li. '%' matches 0 or more characters of any value
:li. '\' excapes special characters (e.g. '\%' matches '%' and '\\' matches
'\')
:li. all other characters match themselves
:eul.
:lm margin=1.
:p.So, to search for anyone in :hp1.finance:ehp1. who's last name consits of
a letter followed by 'ughes', such as Hughes, the query could look like this:
:xmp.
  SELECT first_name, last_name FROM emp_details
    WHERE dept = 'finance'
    AND last_name like '_ughes'
:exmp.
:p.The power of a relational query language starts to become apparent when
you start joining tables together during a select. Lets say you had two
tables defined, one containing staff details and another listing the projects
being worked on by each staff member, and each staff member has been assigned
an employee number that is unique to that person. You could generate a sorted
list of who was working on what project with a query like this:
:xmp.
  SELECT emp_details.first_name, emp_details.last_name,
         project_details.project
    FROM emp_details, project_details
    WHERE emp_details.emp_id = project_details.emp_id
    ORDER BY emp_details.last_name, emp_details.first_name
:exmp.
:p.mSQL places no restriction on the number of tables "joined" during a query
so if there were 15 tables all containing information related to an employee
ID in some maner, data from each of those tables could be extracted, albeit
slowly, by a single query. One key point to note regarding joins is that you
must qualify all column names with a table name. mSQL does not support the
concept of uniquely named columns spanning multiple tables so you are forced
to qualify every column name as soon as you access more than one table in
a single select.
:p.mSQL-1.0.6 adds table aliases so that you can perform a join of a table
onto itself. With this you could find out from a list of child/parent tuples
any grandparents using something like
:xmp.
  SELECT t1.parent, t2.child FROM parent_data=t1, parent_data=t2
    WHERE t1.child = t2.parent
:exmp.
:p.The table aliases :hp1.t1:ehp1. and :hp1.t2:ehp1. both point to the same
table (:hp1.parent_data:ehp1. in this case) and are treated as two different
tables that just happen to contain exactly the same data.

.*------------------------------------------------------------------------------
.* 'The Update Clause'
.*------------------------------------------------------------------------------
:h2 id=update clear.The UPDATE Clause
:p.The mSQL UPDATE clause cannot use a column name as a value. Only literal
values may be used as an update value
:xmp.
  UPDATE table_name SET column = value [, column = value ]**
    WHERE column OPERATOR value
    [ AND | OR column OPERATOR value ]**

  OPERATOR can be <, >, =, <=, >=, <>, or 'like'
  value can be a either a integer or scientific number, a string
  or 'sysdate' or 'systime'.
:exmp.
:note.
SYSDATE and SYSTIME are only available in the OS/2 version of mSQL. SYSDATE
returns the current date in a string of 10 characters 'yyyy/mm/dd', there
'yyyy' is the year, 'mm' is the month (01-12) and 'dd' is the day of month
(01-31). SYSTIME returns the current local time in a string of 8 characters
'hH&colon.MM.SS', with 'hH' is the hour (0-23), 'MM' is the minute (00-59)
and 'SS' is the second (00-59). On "Feb 14, 1996  08&colon.01.30" SYSDATE
returns "1996/02/14" and SYSTIME returns " 8&colon.01.30". The key-words
SYSDATE and SYSTIME are not case-sensitive.
:p.for example:
:xmp.
  UPDATE emp_details SET salary=30000 WHERE emp_id=1234

  UPDATE log_table SET date=sysdate WHERE date like '1996/%'
:exmp.

.*------------------------------------------------------------------------------
.* 'The Database Engine (Server)'
.*------------------------------------------------------------------------------
:h1 id=msqld clear.The Database Engine (Server)
:p.The mSQL daemon, :hp2.msqld.exe:ehp2., is a standalone application that
listens for connections on a well known TCP socket. It is a single process
engine that will accept multiple connections and serialise the queries
received. It utilises memory mapped I/O and cache techniques to offer rapid
access to the data stored in a database. It also utilises a stack based
machanism that ensures that INSERT operations are performed at the same
speed regardless of the size of the table being accessed. Preliminary
testing performed by a regular user of mSQL has shown that for simple
queries, the performance of mSQL is comparable to or better than other
freely available database packages. For example, on a set of sample queries
including simple INSERTs, UPDATEs and SELECTs, mSQL performs roughly 4 times
faster than University Ingres and over 20 times faster than Postgres on an
Intel 486 class machine running Linux.
:p.The server may be accessed via a well known TCP socket (per default port
4333) - since OS/2 does not offer UNIX domain socket with the file system,
:hp8.there is no UNIX domain socket supported:ehp8.. The availability of
the TCP socket allows client software to access data stored on machine over
the network. (Sentences concerning UNIX domain socket supported ommited.)
See the details on the programming API and also the command line options
to standard programs for details on selecting the server machine.

.*------------------------------------------------------------------------------
.* 'Server Debugging'
.*------------------------------------------------------------------------------
:h2 id=server_debugging clear.Server Debugging
:p.The database engine includes debugging code so that its progress can be
monitored. There are currently 8 debugging modules available in the engine.
Debugging for any of the available modules can be enabled at runtime by
setting the contents of the
:link reftype=hd refid=minerva_debug.MINERVA_DEBUG:elink. environment
variable to a colon separated list of debug module names. A list of available
debug modules is given below:
:table cols='20 60' rules=both frame=box.
:row.
:c.access
:c.Display details on client accesses
:row.
:c.cache
:c.Display the workings of the table cache
:row.
:c.error
:c.Display error message as well as sending them to the client
:row.
:c.key
:c.Display details of key based data look-ups
:row.
:c.malloc
:c.Display details on memory allocation
:row.
:c.mmap
:c.Display details of memory mapped regions
:row.
:c.proctitle
:c.Display procedure calls
:row.
:c.query
:c.Display each query before it is executed
:row.
:c.trace
:c.Display a function call trace as the program executes
:row.
:c.general
:c.Anything that didn't fit into a category above
:etable.
:p.For example, to make the server display the queries before they are
processed and also show details of the memory allocation that takes place
during the query execution, the following value would be set
:xmp.
  set MINERVA_DEBUG=query&colon.malloc
:exmp.
:note.
Since OS/2 comes with the concept of separate command shells, you have to
stop the server, change the environment variable and then to re-start the
server again in order to see the desired debugging information.

.*------------------------------------------------------------------------------
.* 'Configuration'
.*------------------------------------------------------------------------------
:h2 id=server_configuration clear.Configuration
:p.By default, the software is installed into :hp2.\public\mSQL\:ehp2. and
the server will use space within that directory for the storage of the
databases and also temporary result tables during operations such as joins
and ordering. The following list shows the assignment of directories below
there:
:table cols='10 70' rules=both frame=box.
:row.
:c.\BIN\
:c.contains all executables, such as server, monitor, utilities, etc.
:row.
:c.\DOC\
:c.contains all printable and online documentation
:row.
:c.\INCLUDE\
:c.contains header files for the C programming API
:row.
:c.\LIB\
:c.contains the programming and runtime libraries
:row.
:c.\MSQLDB\
:c.contains the sub-directories with the database tables
:row.
:c.\TMP\
:c.temporary stuff
:row.
:c.\W3-mSQL\
:c.W3-mSQL gateway programming samples
:etable.
:note.
The access to directories has been changed. Up to 1.0.13c all paths were set
absolutely. Since 1.0.14a the server msqld.exe the path detection goes like
this&colon.
:lm margin=5.
:ul.
:li.first the pre-defined path set in :hp1.site.mm:ehp1. (:hp2.INSTPATH:ehp2.)
will taken
:li.if a environment variable :hp4.MSQL_HOME:ehp4. does exist its values is
taken instead of the pre-defined path
:eul.
if a sub-directory :hp1.MSQLDB:ehp1. containing the database files could be
found, no more path checking is done, else&colon.
:lm margin=10.
:ul.
:li.the server gets the path to its binary file (msqld.exe)
:li.first, at that path is checked whether :hp1.MSQLDB:ehp1. exists or not
:li.if not, the same check is done a directory hierarchie higher than the
server executable is located (i.e. :hp2.\aaa\bbb\msqld.exe:ehp2., first
:hp2.\aaa\bbb\msqldb\:ehp2., second :hp2.\aaa\msqldb\:ehp2.)
:li.if this again fails the server terminates with an error message
:eul.
:lm margin=1.

.*------------------------------------------------------------------------------
.* 'Access Control List (ACL)'
.*------------------------------------------------------------------------------
:h2 id=acl clear.Access Control List (ACL)
:p.Access control is managed by the :hp1.msql.acl:ehp1. file in the
installation directory (default: :hp1.\public\mSQL\:ehp1.). This file is split
into entries for each database to be controlled. If the file doesn't exist or
details for a particular database aren't configured, access reverts to global
read/write. An example ACL entry is included below:
:xmp.
  # Sample access control for mSQL
  database=test
  read=bambi,paulp
  write=root
  host=*.Bond.edu.au,-student.it.Bond.edu.au
  access=local,remote
:exmp.
:p.Using this definition, database :hp4.test:ehp4. can be accessed by both
:hp4.local:ehp4. and :hp4.remote:ehp4. connections from any host in the
:hp4.Bond.edu.au:ehp4. domain :hp2.except:ehp2. for the machine
:hp4.student.it.Bond.edu.au:ehp4.. Read access is only granted to
:hp4.bambi:ehp4. and :hp4.paulp:ehp4.. Nobody else is allowed to perform
SELECTs on the database. Write access is only available to :hp4.root:ehp4..
:p.Control is matched on the first match found for a given item. So, a line
such as ":hp1.read=-*,bambi:ehp1." would not do the desired thing (i.e. deny
access to everyone other than :hp1.bambi:ehp1.) because :hp1.-*:ehp1. will
also match :hp1.bambi:ehp1.. In this case the line would have to be
":hp4.read=bambi,-*:ehp4." although the :hp1.-*:ehp1. is superfluous as that
is the default action.
:p.Note that if an entry isn't found for a particular configuration line (such
as :hp1.read:ehp1.) it defaults to a global denial. For example, if there is
no ":hp1.read:ehp1." line (i.e. there are no :hp1.read:ehp1. tokens after the
data is loaded) nobody will be granted read access. This is in contrast to
the action taken if the entire database definition is missing in which case
access to everything is granted.
:p.Another thing to note is that a database's entry :hp8.must:ehp8. be
followed by a blank line to signify the end of the entry. There may also be
multiple config lines in the one entry (such as ":hp4.read=bambi,paulp:ehp4."
 ":hp4.read=root:ehp4."). The data will be loaded as though it was
concatenated onto the same "read" line (i.e.
":hp4.read=bambi,paulp,root:ehp4.").
:p.Wildcards can be used in any configuration entry. A wildcard by itself will
match anything whereas a wildcard followed by some text will cause only a
partial wildcard (e.g. :hp1.*.Bond.edu.au:ehp1. matches anything that ends in
:hp1..Bond.edu.au:ehp1.). A wildcard can also be set for the database name.
:note.
A good practice is to install an entry with :hp4.database=*:ehp4. as the last
entry in the ACL file so that if the database being accessed wasn't covered
by any of the other rules a default site policy can be enforced.
:p.The ACL information can be reloaded at runtime using
":link reftype=hd refid=msqladm.msqladm:elink. :hp3.reload:ehp3.". This will
parse the file before it sends the reload command to the engine. Only if the
file is parsed cleanly is it reloaded. Like most
:link reftype=hd refid=msqladm.msqladm:elink. commands, it will only be
accepted if generated by the root user (e.g. under OS/2 the user set in the
environment variable :link reftype=hd refid=user.USER:elink. at server
startup) on the local host running the server.

.*------------------------------------------------------------------------------
.* 'RunTime Configuration'
.*------------------------------------------------------------------------------
:h1 id=runtime_configuration clear.Runtime Configuration
:p.Both the mSQL server and API library support a series of environment
variables that can dictate and modify the behaviour of the software. Using
these variables it is possible to run multiple servers on the same host
(one for testing for example). It must be stressed that at no time must
more than one server be configured to access the same database directory.
If multiple servers are configured to work on the same data, you will
probably end up with corrupted database (remark on OS/2: won't be possible
since OS/2 prohibits write access to already opened files).

.*------------------------------------------------------------------------------
.* 'Environment Variable EDITOR'
.*------------------------------------------------------------------------------
:h2 id=editor clear.Environment Variable EDITOR
:p.Used by the monitor program, :link reftype=hd refid=msql.msql.exe:elink..
The environment variable specifies the path and name of the default editor
used for editing a stored query. This variable is used only if
:link reftype=hd refid=visual.VISUAL:elink. is empty. If VISUAL and EDITOR
both are empty, the default :hp2.e:ehp2. (OS/2 system editor) is used.

.*------------------------------------------------------------------------------
.* 'Environment Variable MINERVA_DEBUG'
.*------------------------------------------------------------------------------
:h2 id=minerva_debug clear.Environment Variable MINERVA_DEBUG
:p.This environment variable is used on debugging. It has different sets of
parameters for :link reftype=hd refid=server_debugging.server:elink. and
:link reftype=hd refid=api_debugging.API:elink. debugging. Please see the
appropriate chapters for details.
:note.
:hp1.API debugging:ehp1. includes debugging of the client software, because
the clients make use of the API.

.*------------------------------------------------------------------------------
.* 'Environment Variable MSQL_HOME'
.*------------------------------------------------------------------------------
:h2 id=msql_home clear.Environment Variable MSQL_HOME
:p.The MSQL_HOME variable instructs the server to ignore the default
installation directory (such as :hp2.\public\mSQL\:ehp2.) and use the value
of that variable instead. The directory in which mSQL maintains the databases
is a subdirectory of the installation directory so this environment variable
allows you to run the mSQL server on another set of databases if you wish.

.*------------------------------------------------------------------------------
.* 'Environment Variable MSQL_HOST'
.*------------------------------------------------------------------------------
:h2 id=msql_host clear.Environment Variable MSQL_HOST
:p.The MSQL_HOST environment variable is used at the monitor program
:link reftype=hd refid=msql.msql.exe:elink. to specify an alternative
default mSQL server machine.
:note.
This environment variable is used nowhere else except
:link reftype=hd refid=msql.msql.exe:elink. (on the OS/2 port of mSQL it
is used in every client program coming with the archive).

.*------------------------------------------------------------------------------
.* 'Environment Variable MSQL_TCP_PORT'
.*------------------------------------------------------------------------------
:h2 id=msql_tcp_port clear.Environment Variable MSQL_TCP_PORT
:p.By default, mSQL uses a pre-defined TCP/IP port (OS/2: :hp2.4333:ehp2.)
for network communications. You can reconfigure mSQL to use another TCP
port in 2 ways, either with the MSQL_TCP_PORT variable or by editing
:hp2.\MPTN\ETC\services:ehp2. (on OS/2 Warp Connect).
:p.mSQL initially searches for an entry of type :hp2.msql/tcp:ehp2. in the
:hp2.service:ehp2. database. If it finds such an entry, it uses the port
number specified in that file. It then checks for the MSQL_TCP_PORT
environment variable. If it finds such a variable, it uses the port number
stored in that variable as the TCP port (overriding the :hp2.services:ehp2.
entry if any). If it finds neither an :hp2.services:ehp2. entry nor the
MSQL_TCP_PORT variable, it defaults to using the precompiled value for the
TCP port (see :hp1.\SRC\site.mm:ehp1.).

.*------------------------------------------------------------------------------
.* 'Environment Variable MSQL_UNIX_PORT'
.*------------------------------------------------------------------------------
:h2 id=msql_unix_port clear.Environment Variable MSQL_UNIX_PORT
:p.:hp8.Not used under OS/2, since OS/2 does not support UNIX domain
sockets.
:ehp8.

.*------------------------------------------------------------------------------
.* 'Environment Variable USER'
.*------------------------------------------------------------------------------
:h2 id=user clear.Environment Variable USER
:p.This environment variable is normally set within the TCP/IP environment
on OS/2 and represent the default user name. The OS/2 version of the database
engine uses USER to determine a root user. Root user is a user with a name
identical to the contents of USER. On the other hand, the OS/2 versions of
monitor, tools and the API use USER to determine the user name. Since OS/2
does not offer a multi-user environment the way, UNIX does, this may be a
solution. To prevent database engine from detecting a 'root' set different
USER environment variables in the shells you use for engine and clients.

.*------------------------------------------------------------------------------
.* 'Environment Variable VISUAL'
.*------------------------------------------------------------------------------
:h2 id=visual clear.Environment Variable VISUAL
:p.Used by the monitor program, :link reftype=hd refid=msql.msql.exe:elink..
The environment variable specifies the path and name of the default editor
used for editing a stored query. If VISUAL and
:link reftype=hd refid=editor.EDITOR:elink. both are empty, the default
:hp2.e:ehp2. (OS/2 system editor) is used.

.*------------------------------------------------------------------------------
.* 'C Programming API'
.*------------------------------------------------------------------------------
:h1 id=c_api clear.C Programming API
:p.Included in the distribution is the mSQL API library, :hp2.mSQL.lib:ehp2.
for static and :hp2.mSQL_dll.lib:ehp2. for dynamic linking against
:hp1.mSQL.DLL:ehp1.. The API allows any C program to communicate with the
database engine. The API functions are accessed by including the
:hp2.msql.h:ehp2. header file into your program and by linking against the
mSQL library (by adding :hp1.mSQL.lib:ehp1. or :hp1.mSQL_dll:ehp1. to the
list of modules to be linked by the linker). The library and header files
will be installed by default into :hp2.\lib\:ehp2. and :hp2.\include\:ehp2.
respictively.
:p.The following :hp2.function:ehp2. and :hp2.procedure prototypes:ehp2. are
defined in :hp1.msql.h:ehp1.&colon.
:lm margin=5.
:ul.
:li.int :link reftype=hd refid=msqlGetErrMsg.msqlGetErrMsg:elink.( char *pszErrMsg );
:li.int :link reftype=hd refid=msqlConnect.msqlConnect:elink.( char *host );
:li.int :link reftype=hd refid=msqlUserConnect.msqlConnect:elink.( char *host, char *user );
:li.int :link reftype=hd refid=msqlCreateDB.msqlCreateDB:elink.( int sock, char *dbName );
:li.int :link reftype=hd refid=msqlDropDB.msqlDropDB:elink.( int sock, char *dbName );
:li.int :link reftype=hd refid=msqlSelectDB.msqlSelectDB:elink.( int sock, char *dbName );
:li.int :link reftype=hd refid=msqlQuery.msqlQuery:elink.( int sock, char *query );
:li.m_result *:link reftype=hd refid=msqlStoreResult.msqlStoreResult:elink.();
:li.void :link reftype=hd refid=msqlFreeResult.msqlFreeResult:elink.( m_result *result );
:li.m_row :link reftype=hd refid=msqlFetchRow.msqlFetchRow:elink.( m_result *result );
:li.void :link reftype=hd refid=msqlDataSeek.msqlDataSeek:elink.( m_result *result, int pos );
:li.int :link reftype=hd refid=msqlNumRows.msqlNumRows:elink.( m_result *result );
:li.m_field *:link reftype=hd refid=msqlFetchField.msqlFetchField:elink.( m_result *result );
:li.void :link reftype=hd refid=msqlFieldSeek.msqlFieldSeek:elink.( m_result *result, int pos );
:li.int :link reftype=hd refid=msqlNumFields.msqlNumFields:elink.( m_result *result );
:li.m_result *:link reftype=hd refid=msqlListDBs.msqlListDBs:elink.( int sock );
:li.m_result *:link reftype=hd refid=msqlListTables.msqlListTables:elink.( int sock );
:li.m_result *:link reftype=hd refid=msqlListFields.msqlListFields:elink.( int sock, char *tableName );
:li.int :link reftype=hd refid=msqlClose.msqlClose:elink.( int sock );
:li.char *:link reftype=hd refid=msqlGetHostInfo.msqlGetHostInfo:elink.();
:li.int :link reftype=hd refid=msqlGetProtoInfo.msqlGetProtoInfo:elink.();
:li.char *:link reftype=hd refid=msqlGetServerInfo.msqlGetServerInfo:elink.();
:eul.
:lm margin=1.
:p.The following :hp2.global variables:ehp2. are defined in
:hp1.msql.h:ehp1. (only available with static linking)&colon.
:lm margin=5.
:ul.
:li.extern char :link reftype=hd refid=msqlErrMsg.msqlErrMsg[]:elink.;
:eul.
:lm margin=1.
:p.The following :hp2.definitions:ehp2. are defined in :hp1.msql.h:ehp1.&colon.
:lm margin=5.
:ul.
:li.:link reftype=hd refid=msqlFetchField.CHAR_TYPE:elink.
:li.:link reftype=hd refid=msqlFetchField.INT_TYPE:elink.
:li.:link reftype=hd refid=msqlFetchField.IS_PRI_KEY:elink.( flags )
:li.:link reftype=hd refid=msqlFetchField.IS_NOT_NULL:elink.( flags )
:li.:link reftype=hd refid=msqlFetchField.REAL_TYPE:elink.
:eul.
:lm margin=1.
:p.The following :hp2.data types:ehp2. are defined in :hp1.msql.h:ehp1.&colon.
:lm margin=5.
:ul.
:li.:link reftype=hd refid=msqlFetchField.m_field:elink.
:li.:link reftype=hd refid=msqlFetchRow.m_row:elink.
:eul.
:lm margin=1.

.*------------------------------------------------------------------------------
.* 'API Debugging'
.*------------------------------------------------------------------------------
:h2 id=api_debugging clear.API Debugging
:p.Like the mSQL engine, the API supports debugging via the
:link reftype=hd refid=minerva_debug.MINERVA_DEBUG:elink. environment
variable. Three debugging modules are currently supported by the API:
:table cols='20 60' rules=both frame=box.
:row.
:c.msql_api
:c.Internal informations, such as connection details, are displayed
:row.
:c.msql_malloc
:c.Details about the memory used by the API library is obtained. Information
:row.
:c.msql_query
:c.API prints the contents of queries as they are sent to the server
such as the location and size of (m)allocated blocks and the adresses passed
to :hp1.free():ehp1. will be generated.
:etable.
:p.Multiple debug modules can be enabled by setting MINERVA_DEBUG to a colon
separated list of module names. For example:
:xmp.
  set MINERVA_DEBUG=api&colon.query
:exmp.
:note.
Since OS/2 comes with the concept of separate command shells, you have to
stop the server, change the environment variable and then to re-start the
server again in order to see the desired debugging information.

.*------------------------------------------------------------------------------
.* 'msqlGetErrMsg'
.*------------------------------------------------------------------------------
:h2 id=msqlGetErrMsg clear.msqlGetErrMsg
:xmp.
  char *msqlGetErrMsg( char *pszErrMsg );
:exmp.
:p.This function grants access to an internal variable in the database library,
containing a text string with a detailed message after errors. The parameter
:hp1.pszErrMsg:ehp1. points to a buffer long enough to store this message. In
this case the returned pointer is equal to :hp1.pszErrMsg:ehp1.. If the
parameter is set :hp2.NULL:ehp2. the returned pointer can be used to address
the internal library variable (read-only).
:note.This function is prefered for both static and dynamic linkage.

.*------------------------------------------------------------------------------
.* 'msqlConnect'
.*------------------------------------------------------------------------------
:h2 id=msqlConnect clear.msqlConnect
:xmp.
  int msqlConnect( char *host );
:exmp.
:p.:hp1.msqlConnect():ehp1. forms an interconnection with the mSQL engine.
It takes as its only argument the name or IP address of the host running
the mSQL server. If :hp2.NULL:ehp2. is specified as the host argument, a
connection is made to :hp1.localhost:ehp1.. If any error occurs, a value of
:hp4.-1:ehp4. is returned and the external variable :hp4.msqlErrMsg:ehp4.
will contain an appropriate text message. This variable is defined in
:link reftype=hd refid=c_api.msql.h:elink..
:p.If the connection is made to the server, an integer identifier is
returned to the calling function. This value is used as a handle for all
other calls to the mSQL API. The value returned is in fact the socket
descriptor for the connection. By calling :hp1.msqlConnect():ehp1. more
than once and assigning the returned values to separate variables,
connections to multiple database servers can be maintained
similtaneously.
:p.In previous versions of mSQL, the
:link reftype=hd refid=msql_host.MSQL_HOST:elink. environment variable
could be used to specify a target machine if the :hp1.host:ehp1. parameter
was :hp2.NULL:ehp2.. :hp8.This is no longer the case:ehp8..

.*------------------------------------------------------------------------------
.* 'msqlUserConnect'
.*------------------------------------------------------------------------------
:h2 id=msqlUserConnect clear.msqlUserConnect
:lines align=right.
:hp8.only available within the OS/2 port:ehp8.
:elines.
:xmp.
  int msqlUserConnect( char *host, char *user );
:exmp.
:p.Like :link reftype=hd refid=msqlConnect.msqlConnect():elink., but this
routine allows the programmer to specify a :hp1.user:ehp1. for which the
connection should be done. In order to distinquish between
:hp2.msqlUserConnect():ehp2. and
:link reftype=hd refid=msqlConnect.msqlConnect():elink. this routine adds a
fix prefix to the :hp1.user:ehp1. parameter (:hp4.x_:ehp4.). If you specify
a :hp1.user:ehp1. named :hp4.Carl:ehp4., the server will treat him as user
:hp4.x_Carl:ehp4..

.*------------------------------------------------------------------------------
.* 'msqlCreateDB'
.*------------------------------------------------------------------------------
:h2 id=msqlCreateDB clear.msqlCreateDB
:lines align=right.
:hp8.undocumented within original documentation:ehp8.
:elines.
:xmp.
  int msqlCreateDB( int sock, char *dbName );
:exmp.
:p.This function ables one to create of a new database. Its parameters are
:hp1.sock:ehp1., the communication socket, and :hp1.dbName:ehp1., the name of
the database to be created. The function returns a value of :hp4.0:ehp4. on
success, any other value represents an error.
:note.
A database is the place there tables are stored. Under mSQL this is a
sub-directory.

.*------------------------------------------------------------------------------
.* 'msqlDropDB'
.*------------------------------------------------------------------------------
:h2 id=msqlDropDB clear.msqlDropDB
:lines align=right.
:hp8.undocumented within original documentation:ehp8.
:elines.
:xmp.
  int msqlDropDB( int sock, char *dbName );
:exmp.
:p.A database can be removed with this function. There must be an open
connection to the database server (with :hp1.sock:ehp1. as socket descriptor).
If the database :hp1.dbName:ehp1. could be removed successfully, a return value
of :hp4.0:ehp4. is provided.

.*------------------------------------------------------------------------------
.* 'msqlSelectDB'
.*------------------------------------------------------------------------------
:h2 id=msqlSelectDB clear.msqlSelectDB
:xmp.
  int msqlSelectDB( int   sock,
                    char *dbName
                  );
:exmp.
:p.Prior to submitting any queries, a database must be selected.
:hp1.msqlSelectDB():ehp1. instructs the engine which database is to be
accessed. :hp1.msqlSelectDB():ehp1. is called with the socket descriptor
returned by :hp1.msqlConnect():ehp1. and the name of the desired
database. A return value of :hp4.-1:ehp4. indicates an error with
:hp4.msqlErrMsg:ehp4. set to a text string representing the error.
:hp1.msqlSelectDB():ehp1. may be called multiple times during a
program's execution. Each time it is called, the server will use the
specified database for future access. By calling
:hp1.msqlSelectDB():ehp1. multiple times, a program can switch between
different databases during its execution.

.*------------------------------------------------------------------------------
.* 'msqlQuery'
.*------------------------------------------------------------------------------
:h2 id=msqlQuery clear.msqlQuery
:xmp.
  int msqlQuery( int   sock,
                 char *query
               );
:exmp.
:p.Queries are sent to the engine over the connection associated with
:hp1.sock:ehp1. as plain text strings using :hp1.msqlQuery():ehp1.. As
usual, a returned value of :hp4.-1:ehp4. indicates an error and
:hp4.msqlErrMsg:ehp4. will be updated. If the query generates output
from the engine, such as a SELECT statement, the data is buffered in the
API waiting for the application to retrieve it. If the application
submits another query before it retrieves the data using
:link reftype=hd refid=msqlStoreResult.msqlStoreResult():elink., the buffer
will be overwritten by any data generated by the new query.

.*------------------------------------------------------------------------------
.* 'msqlStoreResult'
.*------------------------------------------------------------------------------
:h2 id=msqlStoreResult clear.msqlStoreResult
:xmp.
  m_result *msqlStoreResult();
:exmp.
:p.Data returned by a SELECT query must be stored before another query
is submitted or it will be removed from the internal API buffers. Data
is stored using the :hp1.msqlStoreResult():ehp1. function which returns
a result handle to the calling routines. The result handle is a pointer
to a :hp4.m_result:ehp4. structure and is passed to other API routines
when access to the data is required. Once the result handle is
allocated, other queries may be submitted. A program may have many
result handles active simultaneously.

.*------------------------------------------------------------------------------
.* 'msqlFreeResult'
.*------------------------------------------------------------------------------
:h2 id=msqlFreeResult clear.msqlFreeResult
:xmp.
  void msqlFreeResult( m_result *result );
:exmp.
:p.When a program no longer requires the data associated with a
particular query result, the data must be freed using
:hp1.msqlFreeResult():ehp1.. The result handle associated with the data,
as returned by
:link reftype=hd refid=msqlStoreResult.msqlStoreResult():elink., is passed
to :hp1.msqlFreeResult():ehp1. to identify the data set to be freed.

.*------------------------------------------------------------------------------
.* 'msqlFetchRow'
.*------------------------------------------------------------------------------
:h2 id=msqlFetchRow clear.msqlFetchRow
:xmp.
  m_row msqlFetchRow( m_result *result );
:exmp.
:p.The individual database rows returned by a SELECT are accessed via
the :hp1.msqlFetchRow():ehp1. function. The data is returned in a
variable of type :hp4.m_row:ehp4. which contains a char pointer for each
field in the row. For example, if a SELECT statement selected 3 fields
from each row returned, the value of the 3 fields would be assigned to
the elements [0], [1], and [2] of the variable returned by
:hp1.msqlFetchRow:ehp1.. A value of :hp4.NULL:ehp4. is returned when the
end of the data has been reached. See the example at the end of this
section for further details. Note, a :hp4.null:ehp4. value is
represented as a :hp4.NULL pointer:ehp4. in the row.

.*------------------------------------------------------------------------------
.* 'msqlDataSeek'
.*------------------------------------------------------------------------------
:h2 id=msqlDataSeek clear.msqlDataSeek
:xmp.
  void msqlDataSeek( m_result *result,
                     int       pos
                   );
:exmp.
:p.The :hp4.m_result:ehp4. structure contains a client side
":hp1.cursor:ehp1." that holds information about the next row of data to
be returned to the calling program. :hp1.msqlDataSeek():ehp1. can be
used to move the position of the data cursor. If it is called with a
position of :hp4.0:ehp4., the next call to
:link reftype=hd refid=msqlFetchRow.msqlFetchRow():elink. will return the
first row of data returned by the server. The value of :hp4.pos:ehp4. can be
anywhere form :hp4.0:ehp4. (the first row) and the number of rows in the
table. If a seek is made past the end of the table, the next call to
:link reftype=hd refid=msqlFetchRow.msqlFetchRow():elink. will return
:hp4.NULL:ehp4..

.*------------------------------------------------------------------------------
.* 'msqlNumRows'
.*------------------------------------------------------------------------------
:h2 id=msqlNumRows clear.msqlNumRows
:xmp.
  int msqlNumRows( m_result *result );
:exmp.
:p.The number of rows returned by a query can be found calling
:hp1.msqlNumRows():ehp1. and passing it the result handle returned by
:link reftype=hd refid=msqlStoreResult.msqlStoreResult():elink.. The number
of rows of data sent as a result of the query is returned as an integer
value. If a SELECT query didn't match any data, :hp1.msqlNumRows():ehp1.
will indicate that the result table has :hp4.0:ehp4. rows.
:note.earlier versions of mSQL returned a :hp4.NULL:ehp4. result handle
if no data was found. This has been simplified and made more intuitive by
returning a result handle with :hp4.0:ehp4. rows of result data.

.*------------------------------------------------------------------------------
.* 'msqlFetchField'
.*------------------------------------------------------------------------------
:h2 id=msqlFetchField clear.msqlFetchField
:xmp.
  m_field *msqlFetchField( m_result *result );
:exmp.
:p.Along with the actual data rows, the server returns information about
the data fields selected. This information is made available to the
calling program via the :hp1.msqlFetchField():ehp1. function. Like
:link reftype=hd refid=msqlFetchRow.msqlFetchRow():elink., this function
returns one element of information at a time and returns :hp4.NULL:ehp4.
when no further information is available. The data is returned in a
:hp4.m_field:ehp4. structure which contains the following information:
:xmp.
  typedef struct { char  *name,    /* name of the field        */
                         *table;   /* name of the table        */
                   int    type,    /* data type of field       */
                          length,  /* length in bytes of field */
                          flags;   /* attribute flags          */
                 } m_field;
:exmp.
:p.Possible values for the :hp4.type:ehp4. field (see also
:link reftype=hd refid=create_table.CREATE TABLE:elink.) are defined in
:link reftype=hd refid=c_api.msql.h:elink. as
:lm margin=5.
:ul.
:li.:hp4.CHAR_TYPE:ehp4. (character string or any other 8 bit data)
:li.:hp4.INT_TYPE:ehp4. (integer value)
:li.:hp4.REAL_TYPE:ehp4. (floating point value)
:eul.
:lm margin=1.
:p.The individual attribute :hp4.flag:ehp4. entry can be accessed using
the following macros:
:xmp.
  IS_PRI_KEY( flags )   /* Field is the primary key           */
  IS_NOT_NULL( flags )  /* Field may not contain a null value */
:exmp.

.*------------------------------------------------------------------------------
.* 'msqlFieldSeek'
.*------------------------------------------------------------------------------
:h2 id=msqlFieldSeek clear.msqlFieldSeek
:xmp.
  void msqlFieldSeek( m_result *result,
                      int       pos
                    );
:exmp.
:p.The :hp4.result:ehp4. structure includes a ":hp1.cursor:ehp1." for
the field data. It's position can be moved using the
:hp1.msqlFieldSeek():ehp1. function. See
:link reftype=hd refid=msqlDataSeek.msqlDataSeek():elink. for further
details.

.*------------------------------------------------------------------------------
.* 'msqlNumFields'
.*------------------------------------------------------------------------------
:h2 id=msqlNumFields clear.msqlNumFields
:xmp.
  int msqlNumFields( m_result *result );
:exmp.
:p.The number of fields returned by a query can be ascertained by
calling :hp1.msqlNumFields():ehp1. and passing it the :hp4.result:ehp4.
handle. The value returned by :hp1.msqlNumFields():ehp1. indicates the
number of elements in the data vector returned by
:link reftype=hd refid=msqlFetchRow.msqlFetchRow():elink.. It is wise to
check the number of fields returned before, as with all the arrays, accessing
an element that is beyond the end of the data vector - which can result in a
segmentation fault.

.*------------------------------------------------------------------------------
.* 'msqlListDBs'
.*------------------------------------------------------------------------------
:h2 id=msqlListDBs clear.msqlListDBs
:xmp.
  m_result *msqlListDBs( int sock );
:exmp.
:p.A list of the databases known to the mSQL engine can be obtained via
the :hp1.msqlListDBs():ehp1. function. A result handle is returned to
the calling program that can be used to access the actual database
names. The individual names are accessed by calling
:link reftype=hd refid=msqlFetchRow.msqlFetchRow():elink. passing  it the
:hp4.result:ehp4. handle. The :hp4.m_row:ehp4. data structure returned by
each call will contain one field being the name of the available databases.
As with all functions that return a :hp4.result:ehp4. handle, the data
associated with the result must be freed when it is no longer required using
:link reftype=hd refid=msqlFreeResult.msqlFreeResult():elink..

.*------------------------------------------------------------------------------
.* 'msqlListTables'
.*------------------------------------------------------------------------------
:h2 id=msqlListTables clear.msqlListTables
:xmp.
  m_result *msqlListTables( int sock );
:exmp.
:p.Once a database has been selected using :hp2.msqlInitDB():ehp2., a
list of the tables defined in that database can be retrieved using
:hp1.msqlListTables():ehp1.. As with
:link reftype=hd refid=msqlListDBs.msqlListDBs():elink., a
:hp4.result:ehp4. handle is returned to the calling program and the
names of the tables are contained in data rows where element [0] of the
row is the name of one table in the current database. The result handle
must bee freed when it is no longer needed by calling
:link reftype=hd refid=msqlFreeResult.msqlFreeResult():elink..

.*------------------------------------------------------------------------------
.* 'msqlListFields'
.*------------------------------------------------------------------------------
:h2 id=msqlListFields clear.msqlListFields
:xmp.
  m_result *msqlListFields( int   sock,
                            char *tableName
                          );
:exmp.
:p.Information about the fields in a particular table can be obtained
using :hp1.msqlListFields():ehp1.. The function is called with the name
(:hp4.tableName:ehp4.) of a table in the current database as selected
using :hp2.msqlSelectDB():ehp2. and a :hp4.result:ehp4. handle is
returned to the caller. Unlike
:link reftype=hd refid=msqlListDBs.msqlListDBs():elink. and
:link reftype=hd refid=msqlListTables.msqlListTables():elink., the field
information is contained in field structures rather than data rows. It is
accessed using :link reftype=hd refid=msqlFetchField.msqlFetchField():elink..
The result handle must bee freed when it is no longer needed by calling
:link reftype=hd refid=msqlFreeResult.msqlFreeResult():elink..

.*------------------------------------------------------------------------------
.* 'msqlClose'
.*------------------------------------------------------------------------------
:h2 id=msqlClose clear.msqlClose
:xmp.
  int msqlClose( int sock );
:exmp.
:p.The connection to the mSQL engine can be closed using
:hp1.msqlClose():ehp1.. The function must be called with the connection
:hp4.sock:ehp4.et returned by
:link reftype=hd refid=msqlConnect.msqlConnect():elink. when the initial
connection was made.

.*------------------------------------------------------------------------------
.* 'msqlGetHostInfo'
.*------------------------------------------------------------------------------
:h2 id=msqlGetHostInfo clear.msqlGetHostInfo
:lines align=right.
:hp8.undocumented within original documentation:ehp8.
:elines.
:xmp.
  char *msqlGetHostInfo();
:exmp.
:p.Set by :link reftype=hd refid=msqlConnect.msqlConnect:elink. before
trying to connect to database server. The string returned contains the
host name and the kind of connection, i.e. for local connections
:xmp.
  Localhost via UNIX socket          (Unix)
  localhost via TCP/IP               (OS/2)
:exmp.
and for remote connections
:xmp.
  <server_name> via TCP/IP
:exmp.

.*------------------------------------------------------------------------------
.* 'msqlGetProtoInfo'
.*------------------------------------------------------------------------------
:h2 id=msqlGetProtoInfo clear.msqlGetProtoInfo
:lines align=right.
:hp8.undocumented within original documentation:ehp8.
:elines.
:xmp.
  int msqlGetProtoInfo();
:exmp.
:p.Set by :link reftype=hd refid=msqlConnect.msqlConnect:elink. at connection.
This function returns the current mSQL protocol version used.

.*------------------------------------------------------------------------------
.* 'msqlGetServerInfo'
.*------------------------------------------------------------------------------
:h2 id=msqlGetServerInfo clear.msqlGetServerInfo
:lines align=right.
:hp8.undocumented within original documentation:ehp8.
:elines.
:xmp.
  char *msqlGetServerInfo();
:exmp.
:p.Set by :link reftype=hd refid=msqlConnect.msqlConnect:elink. at connection.
The function returns the host name information provided by the database server.

.*------------------------------------------------------------------------------
.* 'msqlErrMsg'
.*------------------------------------------------------------------------------
:h2 id=msqlErrMsg clear.msqlErrMsg
:xmp.
  extern char msqlErrMsg[];
:exmp.
:p.contains a zero-terminated error message, if an error occurs.
:note.
This variable is only accessible with static linkage. On dynamic linkage the
function :link reftype=hd refid=msqlGetErrMsg.msqlGetErrMsg():elink. is
prefered to use.

.*------------------------------------------------------------------------------
.* 'Clients delivered within this package'
.*------------------------------------------------------------------------------
:h1 id=clients clear.Clients delivered within this package
:p.The OS/2 version of mSQL comes with the same client programs as the
original distribution for Unix does. In fact, in order to be able to run
mSQL an FAT based file systems, too, the names of the programs has been
adapted to 8.3 notation of FAT.
:p.The client programs are (OS/2 file name, Unix file name,
description):
:table cols='20 20 40' rules=both frame=box.
:row.
:c.:link reftype=hd refid=msql.msql.exe:elink.
:c.msql
:c.Terminal Monitor
:row.
:c.:link reftype=hd refid=msqladm.msqladm.exe:elink.
:c.msqladmin
:c.Database Administration
:row.
:c.:link reftype=hd refid=relshow.relshow.exe:elink.
:c.relshow
:c.Schema Viewer
:row.
:c.:link reftype=hd refid=msqldump.msqldump.exe:elink.
:c.msqldump
:c.Database Dumper
:etable.

.*------------------------------------------------------------------------------
.* 'msql.exe - Terminal Monitor'
.*------------------------------------------------------------------------------
:h2 id=msql clear.msql.exe - Terminal Monitor
:xmp.
  msql[.exe] [ -q ] [ -h host ] database
:exmp.
:p.Like all database applications, mSQL provides a program that allows a
user to interactively submit queries to the database engine. In the case
of mSQL, it is a program simply called ':hp1.msql.exe:ehp1.'. If
requires one command line argument, being the name of the :hp4.database:ehp4.
to access. Once started, there is no way to swap databases without
restarting the program.
:p.The monitor also accepts two command line flags as outlined below:
:lm margin=5.
:ul.
:li.':hp1.-h:ehp1. :hp3.host:ehp3.' connect to the mSQL server on the
given :hp4.host:ehp4.
:li.':hp1.-q:ehp1.' process one query and quit returning an exit code
:eul.
:lm margin=1.
:p.The monitor has been modelled after the original Ingres (and the
subsequent Postgres) monitor program. Commands are distinguished from
queries due to their being prefixed with a backslash. To obtain help
from the monitor prompt, the :hp9.\h:ehp9. command is used. To exit from
the program, the :hp9.\q:ehp9. command must be entered.
:p.To send a query to the engine, the query is entered followed by the
:hp9.\g:ehp9. command. :hp9.\g:ehp9. tells the monitor to "Go" and send
the query to the engine. If you wish to edit your last query,
:hp9.\e:ehp9. will place you inside an editor so that you can modify
your query.
:note.
In order to determine the editor for doing the job, the monitor first
asks the environment variable :link reftype=hd refid=visual.VISUAL:elink.
for a default editor. If the variable is not set, the monitor second request
the environment variable :link reftype=hd refid=editor.EDITOR:elink. for a
default editor setting. If this again fails, the OS/2 default system editor
:hp2.e:ehp2. is used.
:p.When you have completed your editing, exiting the editor in the usual
manner will return you to :hp1.msql.exe:ehp1. with the edited query
placed in the buffer. The query can then be submitted to the server by
using the :hp9.\g:ehp9. "Go" command as usual.
:p.The query buffer is maintained between queries to not only enable
query editing, but to also allow a query to be submitted multiple times.
If :hp9.\g:ehp9. is entered without entering a new query, the last query
to be submitted wil be resumitted. The contents of the query buffer can
also be displayed by using the :hp9.\p:ehp9. "Print" command of the
monitor.
:p.To enable convenient access to database servers running on remote
hosts, the mSQL terminal monitor supports the use of an environment
variable to indicate the machine running the server (rather than having
to specify ":hp1.-h some.host.name:ehp1." everytime you execute mSQL).
To use this feature set the environment variable
:link reftype=hd refid=msql_host.MSQL_HOST:elink. to the name or IP address
of the desired machine.
:note.
This is a function provided by the mSQL terminal monitor :hp8.NOT:ehp8.
the mSQL API library and as such is not available for use with other
programs.

.*------------------------------------------------------------------------------
.* 'msqladm.exe - Database Administration'
.*------------------------------------------------------------------------------
:h2 id=msqladm clear.msqladm.exe - Database Administration
:xmp.
  msqladm[.exe] [ -h host ] [ create database |
                              drop   database |
                              shutdown        |
                              reload          |
                              version ]
:exmp.
:p.mSQL databases are administrated using the :hp1.msqladm.exe:ehp1. (Unix:
msqladmin) tool. Several administrative tasks, such as creating new
databases and forcing a server shutdown are performed using
:hp1.msqladm.exe:ehp1.. Like all mSQL programs, :hp1.msqladm.exe:ehp1.
accepts the ':hp1.-h:ehp1. :hp3.host:ehp3.' command line flag to specify
the desired machine. The commands available via :hp1.msqladm.exe:ehp1.
are:
:table cols='20 60' rules=both frame=box.
:row.
:c.create database
:c.Create a new database called 'database'
:row.
:c.drop database
:c.Delete the entire database called 'database' (with all tables)
:row.
:c.shutdown
:c.Tell the server to shut itself down
:row.
:c.reload
:c.Tell the server to relaod its access control information (ACL)
:row.
:c.version
:c.Display various version information from the server
:etable.
:p.If should be noted that the server will only accept
:hp1.create:ehp1., :hp1.drop:ehp1., :hp1.shutdown:ehp1., and
:hp1.reload:ehp1. commands if they are sent by the root user and are
sent from the machine running the server. An attempt to perform any of
these commands from a remote client or as a non-root user will result in
a "permission denied" error. The only command you can execute over the
network or as a non-root user is :hp1.version:ehp1..
:note.
On OS/2 :hp4.root:ehp4. user is defined as the user indicated in the
environment variable :link reftype=hd refid=user.USER:elink. at server
startup.

.*------------------------------------------------------------------------------
.* 'relshow.exe - Schema Viewer'
.*------------------------------------------------------------------------------
:h2 id=relshow clear.relshow.exe - Schema Viewer
:xmp.
  relshow[.exe] [ -h host ] [ database ] [ table ]
:exmp.
:p.mSQL provides the :hp1.relshow:ehp1. command for display the
structure of a database. If executed with :hp4.no arguments:ehp4.,
:hp1.relshow.exe:ehp1. will list the available databases. If it is
executed with the name of a :hp4.database:ehp4., :hp1.relshow.exe:ehp1.
will list the tables that have been defined for that database. If given
both a :hp4.database:ehp4. and :hp4.table:ehp4. name, the schema viewer
will display the structure of the table including the field names,
types, and sizes. Like all mSQL programs, :hp1.relshow.exe:ehp1. honors
the ':hp1.-h:ehp1. :hp3.host:ehp3.' command line flag to specify a
remote machine as the database server.
:note.
'relshow.exe' is linked dynamically against :hp2.mSQL.DLL:ehp2.

.*------------------------------------------------------------------------------
.* 'msqldump.exe - Database Dumper'
.*------------------------------------------------------------------------------
:h2 id=msqldump clear.msqldump.exe - Database Dumper
:xmp.
  msqldump[.exe] [ -h host ] [ -v ] database [ table ]
:exmp.
:p.A program is provided that will dump the contents and structure of a
:hp4.table:ehp4. or entire :hp4.database:ehp4. in an ASCII form. The program,
:hp1.msqldump.exe:ehp1., produces output that is suitable to be read by
the mSQL terminal monitor :link reftype=hd refid=msql.msql.exe:elink. as a
script file. Using this tool, the contents of a database can be backed-up or
moved to a new database. By virtue of the ':hp1.-h:ehp1. :hp3.host:ehp3.'
option, the contents of a remote database may be sucked over the net. This
can be used as a mechanism for mirroring the contents of a mSQL database onto
multiple machines. A :hp4.v:ehp4. mode can be selected for more information
during the dump.
:note.
:hp1.msqldump.exe:ehp1. started life as a user contributed program
called :hp1.msqlsave:ehp1. written by Igor Romanenko
(:hp2.igor@frog.kiev.us:ehp2.). Thanks Igor.
:note.
'msqldump.exe' is linked dynamically against :hp2.mSQL.DLL:ehp2.

.*------------------------------------------------------------------------------
.* 'mSQL Access from (Script) Languages'
.*------------------------------------------------------------------------------
:h1 id=scipts clear.mSQL Access from (Script) Languages
:note.
The following list describes the Unix and OS/2 versions of user-contributed
extensions to the respective language for use with mSQL. These extensions
are not shipped with the mSQL package and may be retrieved separately.

.*------------------------------------------------------------------------------
.* 'CLI (OS/2)'
.*------------------------------------------------------------------------------
:h2 id=scripts_cli clear.CLI (OS/2)
:p.The Call Level Interface is a project, to able programmers to write protable
C code for database applications. It is a part of the OS/2 mSQL package. See
the appropriate documentation in the mSQL folder.

.*------------------------------------------------------------------------------
.* 'ESL (Unix)'
.*------------------------------------------------------------------------------
:h2 id=scripts_esl clear.ESL (Unix)
:p.Another development that has arisen from the development of Minerva has
been the :hp1.Extensible Scripting Language:ehp1. :hp3.ESL:ehp3. (pronounced
Easel). ESL is a C styled scripting language that offers automatic memory
allocation, strict typing, associative arrays (both in-core and bound the
ndbm files), full SNMP support and much, much more. ESL resembles C so closly
that any C programmer will be able to code in ESL within a minute or two of
scanning the manual. Because both ESL and mSQL have developed as part of the
Minerva project (D. J. Hughes: "well, both were developed in the spare
bedroom I call office as part of my Ph.D."). ESL provides full support for
the mSQL API. This includes every aspect of the C API as well as the client
server mode of operation.

.*------------------------------------------------------------------------------
.* 'ODBC (Win 3.x, Win95, WinNT)'
.*------------------------------------------------------------------------------
:h2 id=scripts_odbc_win clear.ODBC (Win 3.x, Win95, WinNT)
:p.Kevin Gill (:hp2.kgill@kindle.ie:ehp2.) has written an open database
connection driver (ODBC level 1) and a Windows mSQL dynamic link library,
so one could access mSQL via Visual Basic or other ODBC client software within
the Windows environment. For more details mail the author and check
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/contrib/ODBC/:ehp9. for the
latest archives&colon.
:lm margin=5.
:ul.
:li.:hp2.gorta.faq:ehp2. (28kB) - FAQ for the ODBC driver
:li.:hp2.gortarts.zip:ehp2. (17kB) - ODBC driver for use with ODBC manager
:li.:hp2.gortasrc.zip:ehp2. (33kB) - ODBC driver source for use with ODBC-SDK
:li.:hp2.installd.zip:ehp2. (225kB) - ODBC driver set, if you don't have an
ODBC manager
:li.:hp2.wmsqlrts.zip:ehp2. (12kB) - mSQL client for MS-Windows
:li.:hp2.wmsqlsrc.zip:ehp2. (15kB) - mSQL client for MS-Windows, Source
:eul.
:lm margin=1.
:note.
In order to use the Windows ODBC driver you must have a Windows mSQL client.

.*------------------------------------------------------------------------------
.* 'Perl5 (Unix)'
.*------------------------------------------------------------------------------
:h2 id=scripts_perl5 clear.Perl5 (Unix)
:p.Andreas K&oe.nig (:hp2.k@franz.ww.TU-Berlin.de:ehp2.) has developed
:hp3.MsqlPerl:ehp3., a Perl5 adapter for mSQL. It was written against the
mSQL 0.2 Patch 1 API but should still work with the 1.0 release as the API
hasn't changed (although a couple of semantice have). MsqlPerl is available
via ftp from
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/MsqlPerl-a1.tgz:ehp9..

.*------------------------------------------------------------------------------
.* 'Python (Unix)'
.*------------------------------------------------------------------------------
:h2 id=scripts_python clear.Python (Unix)
;p.Anthony Baxter (:hp2.anthony.baxter@aaii.oz.au:ehp2.) has developed
:hp3.PymSQL:ehp3., a Python module for mSQL. It was written using mSQL
0.2 Patch 2 API but should still work well. PymSQL can be found on
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/contrib/PymSQL.tar.gz:ehp9..

.*------------------------------------------------------------------------------
.* 'Rexx (OS/2)'
.*------------------------------------------------------------------------------
:h2 id=scripts_rexx clear.Rexx (OS/2)
:p.Mark Hessling (:hp2.M.Hessling@qut.edu.au:ehp2.) is the programmer of
:hp3.REXX/SQL:ehp3., a REXX interface for SQL databases including mSQL and
Oracle. It is distributed under the GNU General Public License with source
included. It can be found on
:hp9.ftp&colon.//ftp.qut.edu.au/src/REXXSQL/rxsql*.zip:ehp9. (ZIPped version)
or :hp9.ftp&colon.//ftp.qut.edu.au/src/REXXSQL/rxsql*.tar.Z:ehp9.
(TARed and compressed version). The current version is 1.3 for the mSQL
and 1.2 for the Oracle implementation (V 1.3 dated March 1996). The mSQL
version can be found on
:hp9.ftp&colon.//ftp.Bond.edu.au/pub/Minerva/msql/Contrib/:ehp9., too.
:note.
Version 1.3 has been adapted for use with mSQL for OS/2.

.*------------------------------------------------------------------------------
.* 'Tcl (Unix)'
.*------------------------------------------------------------------------------
:h2 id=scripts_tcl clear.Tcl (Unix)
:p.Brad Pepers (:hp2.pepersb@cuug.ab.ca:ehp2.) has developed
:hp3.tcl_msql:ehp3., a Tcl interface to mSQL. It can't be recalled which
version of the mSQL API Brad was using when he wrote tcl_msql (Brad's been
hacking on mSQL since the early days). But it's nearly certain that it'll
work against release 1.0 of mSQL.

.*------------------------------------------------------------------------------
.* 'FAQ'
.*------------------------------------------------------------------------------
:h1 id=FAQ clear.Frequently asked questions (FAQ)
:p.The following sections contain questions and answers to various problems
with bot Unix and OS/2 version of mSQL and related programs. There are the
following sections&colon.
:lm margin=5.
:ul.
:li.:link reftype=hd refid=comFAQ.common FAQ:elink. - common problems
:li.:link reftype=hd refid=FAQ_OS2.OS/2:elink. - problems especially with the
OS/2 version of mSQL.
:eul.
:lm margin=1.

.*------------------------------------------------------------------------------
.* 'common FAQ'
.*------------------------------------------------------------------------------
:h2 id=comFAQ clear.common FAQ
:p.Common problems and their solution, that is the intention of this section.

:p.:hp9.Q&colon. When I try to store a large number into a 'real' field, then
the number is stored wrong.:ehp9.
:p.A&colon. This is a problem of the parser - not a bug, but a problem in
determination between integer and floating point numbers. If you want to store
a number larger than 32767 into a 'real' field, writethe number with an
terminating :hp4..:ehp4. or :hp4..0:ehp4.. That signalizes a floating point
number to the parser who then handles the number in the correct manner.

.*------------------------------------------------------------------------------
.* 'FAQ - OS/2'
.*------------------------------------------------------------------------------
:h2 id=FAQ_OS2 clear.FAQ - OS/2
:p.This section deals with special problems of the OS/2 version of mSQL.

:p.:hp9.Q&colon. On starting relshow, msqldump or w3-mSQL I get an error
'SYS1804: Can't find file MSQL':ehp9.
:p.A&colon. OS/2 can't find the dynamic link library :hp2.mSQL.DLL:ehp2..
Check, if there is mSQL.DLL in a path accessable via the :hp1.LIB_PATH:ehp1.
entry in your :hp1.CONFIG.SYS:ehp1.. You may include the directory
:hp2.\lib\:ehp2. or :hp2.\bin\:ehp2. in the :hp1.LIB_PATH:ehp1. line.

:p.:hp9.Q&colon. I can't create databases, msqladm returns 'access
denied':ehp9.
:p.A&colon. First, check if you have a entry :hp1.localhost:ehp1. within your
host configuration file (normally :hp2.\tcpip\etc\hosts:ehp2.). Further, check
if both server and client are having equal values for the environment variable
:link reftype=hd refid=user.USER:elink.. To perform actions as mSQL root the
entries for USER (on server and client) must contain the same string.

:p.:hp9.Q&colon. msqld.exe dies immediately with a 'hit by sig 2':ehp9.
:p.A&colon. Sorry, folks, just a bug in the older port of mSQL for OS/2. The
abort is caused by an incorrect access to a non-existing environment variable.
Check, if your :hp1.CONFIG.SYS:ehp1. contains setting for the environment
variable :link reftype=hd refid=user.USER:elink.. If not, insert the missing
line.

:p.:hp9.Q&colon. msqld.exe does not start after a break-down, a message 'server
couldn't start' occurs:ehp9.
:p.A&colon. Wait for a moment (maximum 2 minutes) and try it again. OS/2 has
a timeout on broken TCP/IP connections, when the server goes away.
:note.
This should be fixed with version 1.0.11 and above.

:p.:hp9.Q&colon. Oups, I got warnings (LIB0004) during compilation:ehp9.
:p.A&colon. Ignore that stuff. The OS/2 library tool for static libraries
(lib.exe) displays warnings if a module replacement is specified but the
library is fresh. There should be no warnings at a subsequent compilation. The
warnings do only occur if :hp1.\lib\mSQLbase.lib:ehp1. has been removed.

:p.:hp9.Q&colon. I'm using OS/2 Warp with the IAK and I can't get the server
run:ehp9.
:p.A&colon.Do the following steps to set-up an local host entry&colon.
:lm margin=5.
:ol.
:li.Set the two lines ":hp1.SET USE_HOSTS_FIRST=1:ehp1." and
":hp1.SET HOSTNAME=localhost:ehp1." into your :hp2.CONFIG.SYS:ehp2. file.
:li.Create or edit :hp2.startup.cmd:ehp2. in your root directory of OS/2,
containing the line ":hp1.ifconfig lo 127.0.0.1:ehp1.".
:li.Create or edit :hp2.\tcpip\etc\hosts:ehp2. with the line
":hp1.127.0.0.1    localhost:ehp1." (end the line with a line-feed).
:li.Reboot your computer and check it again.
:eol.
:lm margin=1.

:p.:hp9.Q&colon. My programs compiled with a Watcom C compiler don't work with
the DLL:ehp9.
:p.A&colon.Make sure you have a new DLL library from mSQL for OS/2 1.0.14
patch level B or higher/newer. You can't use the old ones since they used an
other way of parameter processing (IBM C/C++ Set/2 proprietary format).

.*------------------------------------------------------------------------------
.* 'Author's Details'
.*------------------------------------------------------------------------------
:h1 id=author clear.Author's Details
:p.Mini SQL was written by:
:xmp.
  David J. Hughes
  Managing Director
  Hughes Technologies Pty Ltd.
  Australia

  E-mail: bambi@Hughes.edu.au
          http&colon.//Hughes.com.au/
  Fax:    +61 7 3302 2199
:exmp.
:p.Mini SQL has been ported to OS/2 by:
:xmp.
  Dirk Ohme
  Programmer at transtec AG
  T&ue.bingen, Germany

  E-mail:  Dirk.Ohme@transtec.de
  Fidonet: 2&colon.246/2001.9@fidonet
:exmp.

.*------------------------------------------------------------------------------
.* 'Archive Location'
.*------------------------------------------------------------------------------
:h1 id=archive clear.Archive Location
:p.The primary source of information relating to Mini SQL is Hughes
Technologies Web Site. It contains all current information and pointers to the
software distribution, mailing list archives, and other important information.
The Hughes Technologies Web Site is located at&colon.
:xmp.
  http&colon.//Hughes.com.au/
:exmp.
:p.The latest version of the OS/2 port can be found at &colon.
:xmp.
  Host:   www.fh-albsig.de (141.87.110.2)
  URL:    http&colon.//www.fh-albsig.de/~ohme
  Files:  FILES/msql*.lsm (description)
          FILES/msql*.zip (Zip 2.0.1 archive, Source &amp. Binaries)
  Note:   OS/2 port
:exmp.

.*------------------------------------------------------------------------------
.* 'Mailing List'
.*------------------------------------------------------------------------------
:h1 id=mails clear.Mailing List
:p.A mailing list is operated to provide a place for common users of mSQL to
discuss the product. It is currently operated at Bunyip Information Systems in
Canada (a long-time user of Mini SQL) and we thank them for their help and
support. To subscribe to the mailing list, send an e-mail message containing
the word ":hp9.subscribe:ehp9." to :hp9.msql-list-request@Bunyip.com:ehp9..
:p.Once you are subscribed  you can send a message to the entire list by
addressing it to :hp9.msql-list@Bunyip.com:ehp9.. Please note that there are
usually between 600 and 1000 mSQL users subscribed to the mailing list at the
time of writing so it is an excellent forum for asking general mSQL user
questions.
:p.If you have special questions, suggestions, etc. for the OS/2 port, please
send your mail directly to :hp2.Dirk.Ohme@transtec.de:ehp2. - Thank you!

.*------------------------------------------------------------------------------
.* end of document
.*------------------------------------------------------------------------------
:euserdoc.
.*==============================================================================
