/*
** RESULTS.C - This is the module containing the code for ODBC for
** returning results and information about results.
**
** (c) 1996 by Dirk Ohme - all rights reserved
*/

#include "cli.h"

/*---------------------------------------------------------------------------*/
/*      This returns the number of columns associated with the database      */
/*      attached to "lpstmt".                                                */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLNumResultCols(
        LPSTMT  lpstmt,
        SDWORD FAR *pccol)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Return information about the database column the user wants          */
/*      information about.                                                   */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLDescribeCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        UCHAR FAR *szColName,
        SWORD   cbColNameMax,
        SWORD FAR *pcbColName,
        SWORD FAR *pfSqlType,
        UDWORD FAR *pcbColDef,
        SWORD FAR *pibScale,
        SWORD FAR *pfNullable)
{
    return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Returns result column descriptor information for a result set.       */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLColAttributes(
        LPSTMT  lpstmt,
        UWORD   icol,
        UWORD   fDescType,
        UCHAR FAR *rgbDesc,
        SWORD   cbDescMax,
        SWORD FAR *pcbDesc,
        SDWORD FAR *pfDesc)
{
    return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Associate a user-supplied buffer with a database column.             */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLBindCol(
        LPSTMT  lpstmt,
        UWORD   icol,
        SWORD   fCType,
        PTR     rgbValue,
        SDWORD  cbValueMax,
        SDWORD FAR *pcbValue)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Returns data for bound columns in the current row                    */
/*      ("lpstmt->iCursor"), advances the cursor.                            */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLFetch(
        LPSTMT  lpstmt)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Returns result data for a single column in the current row.          */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLGetData(
        LPSTMT  lpstmt,
        UWORD   icol,
        SWORD   fCType,
        PTR     rgbValue,
        SDWORD  cbValueMax,
        SDWORD FAR *pcbValue)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      This determines whether there are more results sets available for    */
/*      the "lpstmt".                                                        */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLMoreResults(
        LPSTMT  lpstmt)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      This returns the number of rows associated with the database         */
/*      attached to "lpstmt".                                                */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLRowCount(
        LPSTMT  lpstmt,
        SDWORD FAR *pcrow)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      This positions the cursor within a block of data.                    */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLSetPos(
        LPSTMT  lpstmt,
        UWORD   irow,
        BOOL    fRefresh,
        BOOL    fLock)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      This fetchs a block of data (rowset).                                */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLExtendedFetch(
        LPSTMT  lpstmt,
        UWORD   fFetchType,
        SDWORD  irow,
        UDWORD FAR *pcrow,
        UWORD FAR *rgfRowStatus)
{
        return SQL_SUCCESS;
}


/*---------------------------------------------------------------------------*/
/*      Returns the next SQL error information.                              */
/*---------------------------------------------------------------------------*/
RETCODE SQL_API SQLError(
        LPENV   lpenv,
        LPDBC   lpdbc,
        LPSTMT  lpstmt,
        UCHAR FAR *szSqlState,
        SDWORD FAR *pfNativeError,
        UCHAR FAR *szErrorMsg,
        SWORD   cbErrorMsgMax,
        SWORD FAR *pcbErrorMsg)
{                                                /*--------------------------*/
        char    *pszState       = NULL;          /* pointer to status code   */
        char    *pszErrMsg      = NULL;          /* pointer to error message */
        char    *pszMsqlMsg     = NULL;          /* pointer to mSQL message  */
                                                 /*--------------------------*/
        /*
        ** check parameter
        */
        LogEntry( LOG_STATUS, "[SQLError] lpenv         = $%08lX", lpenv  );
        LogEntry( LOG_STATUS, "           lpdbc         = $%08lX", lpdbc  );
        LogEntry( LOG_STATUS, "           lpstmt        = $%08lX", lpstmt );
        LogEntry( LOG_STATUS, "           szSqlState    = $%08lX", szSqlState );
        LogEntry( LOG_STATUS, "           pfNativeError = $%08lX",
                  pfNativeError
                );
        LogEntry( LOG_STATUS, "           szErrorMsg    = $%08lX", szErrorMsg );
        LogEntry( LOG_STATUS, "           cbErrorMsgMax =  %d", cbErrorMsgMax );
        LogEntry( LOG_STATUS, "           pcbErrorMsg   = $%08lX", pcbErrorMsg);

        pszState        =
        pszErrMsg       = NULL;

        /*---| environment |---*/
        if( NULL != lpenv )
        {
                pszState          = &lpenv->szSqlState[0];
                pszErrMsg         =  lpenv->pszSqlMsg;
                lpenv->pszSqlMsg  = NULL;
                pszMsqlMsg        = NULL;
        }

        /*---| database context |---*/
        if( NULL != lpdbc )
        {
                pszState          = &lpdbc->szSqlState[0];
                pszErrMsg         =  lpdbc->pszSqlMsg;
                lpdbc->pszSqlMsg  = NULL;
                pszMsqlMsg        = &lpdbc->szMsqlErrorMsg[0];
        }

        /*---| statement |---*/
        if( NULL != lpstmt )
        {
                pszState          = &lpstmt->szSqlState[0];
                pszErrMsg         =  lpstmt->pszSqlMsg;
                lpstmt->pszSqlMsg = NULL;
                pszMsqlMsg        =  lpstmt->szMsqlErrorMsg;
        }

        /*---| check pointers |---*/
        if( NULL == pszState )
        {
                LogEntry( LOG_ERROR, "[SQLError] no valid handle(s)" );
                LogEntry( LOG_RETURNCODE, "[SQLError] SQL_INVALID_HANDLE" );
                return SQL_INVALID_HANDLE;
        }

        /*
        ** check status
        */
        if( NULL == pszErrMsg )
        {
                /*---| reset mSQL message buffer |---*/
                if( NULL != pszMsqlMsg )
                {
                        *pszMsqlMsg = '\0';
                }

                /*---| reset status code |---*/
                strcpy( pszState, "00000" );

                /*---| return status code |---*/
                if( NULL != szSqlState )
                {
                        strcpy( szSqlState, pszState );
                }

                /*---| return internal code |---*/
                if( NULL != pfNativeError )
                {
                        *pfNativeError = 0;
                }

                /*---| return message |---*/
                if( NULL != szErrorMsg && 0 < cbErrorMsgMax )
                {
                        *szErrorMsg = '\0';
                        if( NULL != pcbErrorMsg )
                        {
                                *pcbErrorMsg = 0;
                        }
                }

                /*---| return data |---*/
                LogEntry( LOG_RETURNCODE, "[SQLError] SQL_NO_DATA_FOUND" );
                return SQL_NO_DATA_FOUND;
        }

        /*
        ** return data on errors
        */
        /*---| return status code |---*/
        if( NULL != szSqlState )
        {
                strcpy( szSqlState, pszState );
        }

        /*---| return internal code |---*/
        if( NULL != pfNativeError )
        {
                *pfNativeError = 0;
        }

        /*---| return message |---*/
        if( NULL != szErrorMsg && 0 < cbErrorMsgMax )
        {                                        /*--------------------------*/
                register int    ci;              /* counter variable         */
                                                 /*--------------------------*/
                /*---| initialize buffer |---*/
                ci  = 0;
                strncpy( szErrorMsg, "[mSQL]", cbErrorMsgMax );
                ci += 6;

                /*---| add message |---*/
                if( cbErrorMsgMax > ci )
                {
                        strncat( szErrorMsg, pszErrMsg, cbErrorMsgMax - ci );
                        ci += strlen( pszErrMsg );
                }

                /*---| additional info |---*/
                if( NULL          !=  pszMsqlMsg &&
                    '\0'          != *pszMsqlMsg &&
                    cbErrorMsgMax  >  (ci + 4 + strlen(pszMsqlMsg))
                  )
                {
                        sprintf( &szErrorMsg[ci], " (%s)", pszMsqlMsg );
                        ci  = strlen( szErrorMsg );
                }

                /*---| set string length |---*/
                if( NULL != pcbErrorMsg )
                {
                        *pcbErrorMsg = ci;
                }

        } /* if */

        /*---| reset mSQL message buffer |---*/
        if( NULL != pszMsqlMsg )
        {
                *pszMsqlMsg = '\0';
        }

        /*---| return data |---*/
        LogEntry( LOG_RETURNCODE, "[SQLError] SQL_SUCCESS" );
        return SQL_SUCCESS;
}

/*===| end of file |=========================================================*/
