/*
** PREPARE.C - This is the ODBC sample driver code for
** preparing SQL Commands and other functions prior to execution.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/

//	-	-	-	-	-	-	-	-	-
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "gorta.h"

#include <msql.h>

//	-	-	-	-	-	-	-	-	-

//	Allocate a SQL statement

RETCODE SQL_API SQLAllocStmt(
	HDBC	  hdbc,
	HSTMT FAR *phstmt)
{
	HGLOBAL	hstmt;
	LPSTMT lpstmt;

    hstmt = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (STMT));
	if (!hstmt || (*phstmt = (HSTMT)GlobalLock (hstmt)) == SQL_NULL_HSTMT)
	{
		GlobalFree (hstmt);	//	Free it if lock fails
		return SQL_ERROR;
	}
	lpstmt = *phstmt;
	lpstmt->lpdbc = hdbc;
	lpstmt->lMagic = STATEMENT_MAGIC;
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

RETCODE SQL_API SQLFreeStmt(
	HSTMT	  hstmt,
	UWORD	  fOption)
{
	LPSTMT lpstmt;
	
	lpstmt = hstmt;
	assert(lpstmt->lMagic == STATEMENT_MAGIC);

	switch (fOption)
	{
	case SQL_CLOSE:
		if (lpstmt->pvdMResult) // Free previous result
			msqlFreeResult((m_result *)lpstmt->pvdMResult);
		lpstmt->pvdMResult = NULL;
		break;
	case SQL_UNBIND:
   		lpstmt->iRBindings = 0;
		break;
	case SQL_RESET_PARAMS:
    	lpstmt->iPBindings = 0;
    	lpstmt->iPBCurrent = 0;
		break;
	case SQL_DROP:
		/* TBD - RELEASE ERRORS */
		if (lpstmt->pvdMResult) // Free previous result
			msqlFreeResult((m_result *)lpstmt->pvdMResult);
		if (lpstmt->pcPrepared)
			free(lpstmt->pcPrepared);
   		lpstmt->iPBindings = 0;
   		lpstmt->iPBCurrent = 0;
		lpstmt->lMagic = 0L;
		GlobalUnlock (GlobalPtrHandle(hstmt));
		GlobalFree (GlobalPtrHandle(hstmt));
		break;
	}
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Perform a Prepare on the SQL statement

//	Allocates a buffer an copies the statement to the buffer.

/*
 * Version 2.10.0.5 
 * This function is incorrectly implmented. Binding should
 * take place outside of the statement preparation.
 */
RETCODE SQL_API SQLPrepare(
	HSTMT	  hstmt,
	UCHAR FAR *szSqlStr,
	SDWORD	  cbSqlStr)
{
	LPSTMT lpstmt;
	int iParams;

	lpstmt = hstmt;
	assert(lpstmt->lMagic == STATEMENT_MAGIC);

	/* If a statement has already been allocated */
	if (lpstmt->pcPrepared)
	{
		free(lpstmt->pcPrepared);
		lpstmt->pcPrepared = NULL;
	}
	
	if (cbSqlStr == SQL_NTS)
		lpstmt->pcPrepared = strdup(szSqlStr);
	else
	{
		lpstmt->pcPrepared = malloc((int)cbSqlStr + 1);
		assert(lpstmt->pcPrepared);
		memcpy(lpstmt->pcPrepared, szSqlStr, (int)cbSqlStr);
		lpstmt->pcPrepared[cbSqlStr] = '\0';
	}
	assert(lpstmt->pcPrepared);
	
	/*
	 * Count the number of parameters in the statement
	 */
	iParams = 0;
	{
		char *pMark;
		pMark = strchr(lpstmt->pcPrepared, '?');
		while (pMark)
		{
			iParams++;
			pMark = strchr(pMark + 1, '?');
		}
	}

	lpstmt->iPBindings = iParams;
		
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Bind parameters on a statement handle

//	Set up the parameters matching the place holders in the string.
//	Once there is place holders in the input string, all the
//	place holders must be matched.


/*	Version 2.10.0.5
 * This function is incorrectly implemented. The binding is separate from
 * the prepare and may take place before it.
 */
RETCODE SQL_API SQLBindParameter(
	HSTMT	   hstmt,
	UWORD	   ipar,
	SWORD	   fParamType,
	SWORD	   fCType,
	SWORD	   fSqlType,
	UDWORD	   cbColDef,
	SWORD	   ibScale,
	PTR 	   rgbValue,
	SDWORD	   cbValueMax,
	SDWORD FAR *pcbValue)
{
	LPSTMT lpstmt;
	struct PBindInfo *pPB;
	
	lpstmt = hstmt;
	assert(lpstmt->lMagic == STATEMENT_MAGIC);
	
	assert(ipar >= 1);
	assert(ipar <= MSQL_MAX_BINDINGS);
	/* Parameters being from 1 */
    pPB = &(lpstmt->pPBindings[ipar - 1]);

    /* Simply record the values. These are used later (SQLExecute, SQLExecDirect) */
    pPB->iSqlType = fSqlType;
    pPB->iCType = fCType;
    pPB->pvdBuffer = rgbValue;
    pPB->lMaxLen = cbValueMax;
    pPB->plActualLen = pcbValue;
    pPB->iRTLen = 0;
    pPB->pvdRTBuffer = NULL;

	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Returns the description of a parameter marker.

RETCODE SQL_API SQLDescribeParam(
	HSTMT	   hstmt,
	UWORD	   ipar,
	SWORD  FAR *pfSqlType,
	UDWORD FAR *pcbColDef,
	SWORD  FAR *pibScale,
	SWORD  FAR *pfNullable)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Sets multiple values (arrays) for the set of parameter markers.

RETCODE SQL_API SQLParamOptions(
	HSTMT	   hstmt,
	UDWORD	   crow,
	UDWORD FAR *pirow)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Returns the number of parameter markers.

RETCODE SQL_API SQLNumParams(
	HSTMT	   hstmt,
	SWORD  FAR *pcpar)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Sets options that control the behavior of cursors.

RETCODE SQL_API SQLSetScrollOptions(
	HSTMT	   hstmt,
	UWORD	   fConcurrency,
	SDWORD	crowKeyset,
	UWORD	   crowRowset)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Set the cursor name on a statement handle

RETCODE SQL_API SQLSetCursorName(
	HSTMT	  hstmt,
	UCHAR FAR *szCursor,
	SWORD	  cbCursor)
{
	return SQL_SUCCESS;
}

//	-	-	-	-	-	-	-	-	-

//	Return the cursor name for a statement handle

RETCODE SQL_API SQLGetCursorName(
	HSTMT	  hstmt,
	UCHAR FAR *szCursor,
	SWORD	  cbCursorMax,
	SWORD FAR *pcbCursor)
{
	return SQL_SUCCESS;
}
