/*    _____________________________________________________________________

     Rick Beebe                                           (203) 785-4566
     Data Network Operations
     Biomedical Computing Unit                 beebe@biomed.med.yale.edu
     Yale University School of Medicine             beebe@yalemed.bitnet
     333 Cedar Street, New Haven, CT 06510
     June 1995

      Pass it the string you want to search for and it will "regular
      expressionize" it. Note that in addition to removing case sensitivity, it
      also turns spaces into wildcards. So, a search for "bob smith" will also
      turn up "Bobby Woodsmith". If you don't want that functionality, remove 
      the two lines (one if statement) commented below.

      Note that I allocate a 500 character buffer to hold the string. This 
      works well for the application that I'm using this in. You may want to 
      replace that with an appropriately sized malloc'ed space instead.

      I use it like this. The string to search for, in this example, gets put
      into "str" by whatever method you'd like.
      ...
      sprintf(search, "select * from data where name=%s", regex(str));
      msqlQuery(sock, search);
     _____________________________________________________________________*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

char *regex(char *field)
{
        char buffer[500];
        char *cp;
        char *in, *out;
        
        memset(buffer, '\0', 500);
        strcpy(buffer, "'%");
        
        for (in = field, out=buffer+2;*in && out-buffer < 500;in++, out++)
	  {
                if (*in == '\'' || *in == '\\')
		  {
                        *(out++) = '\\';
                        *out = *in;
		      }
                /* take out the following if you don't want to wildcard */
                /* spaces */
/*ssk
                if (*in == ' ')
                         *out = '%';
*/
                else if (isalpha(*in))
		  {
                        *(out++) = '[';
                        *(out++) = toupper(*in);
                        *(out++) = tolower(*in);
                        *out = ']';
  	          }
                else
                        *out = *in;
                }
        *(out++) = '%';
        *(out++) = '\'';
        *out='\0';
        return (buffer);
}
 
