/*
** sqbupdt.c
**
** Klaus Thiele (kth@oblib.teuto.de) - May '95
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sql.h>
#include <errsql.h>

#ifndef HOST
#define HOST NULL
#endif

typedef struct {
   SQLTCUR c;              /* sql cursor */
   char *text;             /* corresponding statement */
} SqlData;

SqlData sql[2];            /* SQLBASE cursors */

char   nr[5];
char   name[46];
int    age;
double money;
char   flag;


int main( void ) {

SQLTRCD   rcd;
SQLTNSI   nsi;
SQLTNBV   nbv;
SQLTROW   nrr;
SQLTCTY   cty;
char      errmsg[SQLMERR];
char      *cmd[9] = { "?",
                     "SELECT",
                     "INSERT",
                     "CREATE",
                     "UPDATE",
                     "DELETE",
                     "?",
                     "?",
                     "DROP" };

   /*
   ** connect cursors to database
   */
   if( (rcd = sqlcnc(&sql[0].c, "SQLBASE", 0, (SQLTDAP)HOST )) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
         return( 1 );
   }

   if( (rcd = sqlcnc(&sql[1].c, "SQLBASE", 0, (SQLTDAP)HOST )) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
         return( 1 );
   }


      /*
      ** update
      */
      strcpy( nr, "0002" );
      money = 1234.56;
      age = 37;

      sql[1].text = "UPDATE PERSDAT SET MONEY=:1, AGE=:2 "
                        "WHERE NR=:3";

      if((rcd=sqlcom(sql[1].c, sql[1].text, 0))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      if((rcd=sqlbnn(sql[1].c, 1, (SQLTDAP)&money, 0, 0, SQLPDOU)) ||
         (rcd=sqlbnn(sql[1].c, 2, (SQLTDAP)&age, 0, 0, SQLPSIN)) ||
         (rcd=sqlbnn(sql[1].c, 3, nr, 0, 0, SQLPSTR)) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }         

      if(sqlcty(sql[1].c, &cty) == 0)
         printf("Command type: %d (%s)\n", cty, cmd[cty]);

      if((rcd=sqlexe(sql[1].c))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Update Ok.\n");

      /*
      **
      */
      strcpy(name,"%Thiele%");
      sql[0].text = "SELECT NR, NAME, AGE, MONEY, FLAG FROM PERSDAT "
                           "WHERE NAME LIKE :SNAME "
                           "ORDER BY AGE DESC";

      if((rcd=sqlcom(sql[0].c, sql[0].text, 0))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      if((rcd=sqlbnd(sql[0].c, "sname", 5, name, sizeof(name), 0, SQLPSTR))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      if((rcd=sqlssb(sql[0].c, 1, SQLPSTR, nr, sizeof(nr), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[0].c, 2, SQLPSTR, name, sizeof(name), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[0].c, 3, SQLPSIN, (SQLTDAP)&age, sizeof(age), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[0].c, 4, SQLPDOU, (SQLTDAP)&money, sizeof(money), 0, SQLNPTR, SQLNPTR)) ||
         (rcd=sqlssb(sql[0].c, 5, SQLPSCH, &flag, sizeof(flag), 0, SQLNPTR, SQLNPTR))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      if((rcd=sqlexe(sql[0].c))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      }

      /*
      */
      if((rcd=sqlnsi(sql[0].c,&nsi))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of select items: %d\n", nsi);

      if((rcd=sqlnbv(sql[0].c,&nbv))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of bind variables: %d\n", nbv);

      if((rcd=sqlnrr(sql[0].c,&nrr))) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         printf("%d: %s\n", rcd, errmsg);
      } else
         printf("Number of fetched rows: %ld\n", nrr);

      if(sqlcty(sql[0].c, &cty) == 0)
         printf("Command type: %d (%s)\n", cty, cmd[cty]);

      /*
      */

      while( (rcd = sqlfet(sql[0].c)) == 0 ) {
         printf("sqlfet: %s - %s, %d, %f, %c\n", nr, name, age, money, flag);
      }

      sqlerr(rcd, (SQLTDAP)&errmsg);
      printf("%d: %s\n", rcd, errmsg);

   /*
   ** disconnect cursors
   */
   sqldis(sql[0].c);
   sqldis(sql[1].c);

   return(0);
}
