/*
** sqbtest.C
**
** Klaus Thiele (kth@oblib.teuto.de) - May '95
**
*/

#include <fstream.h>
#include <string.h>

extern "C" {
#include <sql.h>
}
#include <errsql.h>

#ifndef HOST
#define HOST NULL
#endif

struct SqlData {
   SQLTCUR c;              // sql cursor
   char *text;             // corresponding statement
};

SqlData sql[2];            // SQLBASE cursors

char   nr[5];
char   name[46];
int    age;
double money;
char   flag;

int main( void ) {

SQLTRCD   rcd;
char      errmsg[SQLMERR];

   //
   // connect cursor[0] to first database
   //
   if( (rcd = sqlcnc(&sql[0].c, "SQLBASE/SYSADM/SYSADM", 0, (SQLTDAP)HOST )) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         cout << rcd << ':' << errmsg << endl;
         return( 1 );
   }

   //
   // connect cursor[1] to second database
   //
   if( (rcd = sqlcnc(&sql[1].c, "SQLBASE", 0, (SQLTDAP)HOST)) ) {
         sqlerr(rcd, (SQLTDAP)&errmsg);
         cout << rcd << ':' << errmsg << endl;
         return( 1 );
   }

      //
      // a simple query (using all field-types)
      //
      strcpy(name,"%Thiele%");
      sql[0].text = "SELECT NR, NAME, AGE, MONEY, FLAG FROM PERSDAT "
                           "WHERE NAME LIKE :SNAME "
                           "ORDER BY AGE DESC";

      if(sqlcom(sql[0].c, sql[0].text, 0))
         cout << "COMPILE error" << endl;

      if(sqlbnd(sql[0].c, "sname", 0, name, sizeof(name), 0, SQLPSTR))
         cout << "BIND error" << endl;

      if(sqlssb(sql[0].c, 1, SQLPSTR, nr, sizeof(nr), 0, SQLNPTR, SQLNPTR) ||
         sqlssb(sql[0].c, 2, SQLPSTR, name, sizeof(name), 0, SQLNPTR, SQLNPTR) ||
         sqlssb(sql[0].c, 3, SQLPSIN, (SQLTDAP)&age, sizeof(age), 0, SQLNPTR, SQLNPTR) ||
         sqlssb(sql[0].c, 4, SQLPDOU, (SQLTDAP)&money, sizeof(money), 0, SQLNPTR, SQLNPTR) ||
         sqlssb(sql[0].c, 5, SQLPSCH, &flag, sizeof(flag), 0, SQLNPTR, SQLNPTR))
         cout << "SET BUFFER errro" << endl;

      if(sqlexe(sql[0].c))
         cout << "EXECUTE error" << endl;

      memset(nr,'\0',sizeof(nr));
      memset(name,'\0',sizeof(name));
      age = 0;

      while( sqlfet(sql[0].c) == 0 ) {
         cout << "sqlfet: " << nr << " - "
                            << name << ", "
                            << age << ", "
                            << money << ", "
                            << flag
                            << endl;
      }

      //
      // an insert with the same cursor
      //
      strcpy(nr,"9000");
      strcpy(name,"Mickey Mouse");
      age = 65;
      money = 5678.0;
      flag = 'X';

      sql[0].text = "INSERT INTO PERSDAT (NR,NAME,AGE,MONEY,FLAG) "
                           "VALUES (:NR,:NAME,:AGE,:MONEY,:FLAG)";

      if(sqlcom(sql[0].c, sql[0].text, 0))
         cout << "COMPILE error" << endl;

      if(sqlbnd(sql[0].c, "nr", 0, nr, sizeof(nr), 0, SQLPSTR) ||
         sqlbnd(sql[0].c, "name", 0, name, sizeof(name), 0, SQLPSTR) ||
         sqlbnd(sql[0].c, "age", 0, (SQLTDAP)&age, sizeof(age), 0, SQLPSIN) ||
         sqlbnd(sql[0].c, "money", 0, (SQLTDAP)&money, sizeof(money), 0, SQLPDOU) ||
         sqlbnd(sql[0].c, "flag", 0, &flag, sizeof(flag), 0, SQLPSCH) )
         cout << "BIND error" << endl;

      if(sqlexe(sql[0].c))
         cout << "EXECUTE error" << endl;
      else
         cout << "Insert Ok." << endl;

      //
      // delete
      //
      strcpy(nr,"9000");

      sql[0].text = "DELETE FROM PERSDAT WHERE NR=:NR";

      if(sqlcom(sql[0].c, (SQLTDAP)sql[0].text, 0))
         cout << "COMPILE error" << endl;

      if(sqlbnd(sql[0].c, (SQLTDAP)"nr", 0, (SQLTDAP)nr, sizeof(nr), 0, SQLPSTR))
         cout << "BIND error" << endl;

      if (sqlexe(sql[0].c))
         cout << "EXECUTE error" << endl;
      else
         cout << "Delete Ok." << endl;


      //
      // Test
      //
      sqlcmt(sql[0].c);
      sqlrbk(sql[0].c);

      sql[1].text = "KJKLSZH";

      if(sqlexe(sql[1].c)) {
         sqlrcd(sql[1].c,&rcd);
         sqlerr(rcd,(SQLTDAP)&errmsg);
         cout << rcd << ':' << errmsg << endl;
      }

      if(sqlcom(sql[1].c, sql[1].text, 0)) {
         sqlrcd(sql[1].c, &rcd);
         sqlerr(rcd, (SQLTDAP)&errmsg);
         cout << rcd << ':' << errmsg << endl;
      }


      sql[1].text = "CREATE TABLE TESTIT ("
                      "NR INTEGER NOT NULL PRIMARY KEY, "
                      "NAME CHAR(128), "
                      "TEL CHAR(32) )";

      if(sqlcom(sql[1].c, (SQLTDAP)sql[1].text, 0))
         cout << "COMPILE error" << endl;

      if (sqlexe(sql[1].c))
         cout << "EXECUTE error" << endl;
      else
         cout << "Table created." << endl;


      sql[1].text = "DROP TABLE TESTIT";

      if(sqlcom(sql[1].c, (SQLTDAP)sql[1].text, 0))
         cout << "COMPILE error" << endl;

      if(sqlexe(sql[1].c))
         cout << "EXECUTE error" << endl;
      else
         cout << "Table droped." << endl;


   sql[1].text = "SELECT NR, NAME FROM PERSDAT "
                        "WHERE NR='9001'";

   if(sqlcom(sql[1].c, (SQLTDAP)sql[1].text, 0))
      cout << "COMPILE error" << endl;

   if(sqlssb(sql[1].c, 1, SQLPSTR, nr, sizeof(nr), 0, SQLNPTR, SQLNPTR) ||
      sqlssb(sql[1].c, 2, SQLPSTR, name, sizeof(name), 0, SQLNPTR, SQLNPTR))
      cout << "SET BUFFER error" << endl;

   if( sqlfet(sql[1].c) != 0 ) {
      sqlrcd(sql[1].c, &rcd);
      sqlerr(rcd, (SQLTDAP)&errmsg);
      cout << rcd << ':' << errmsg << endl;
   } 

   if( sqlexe(sql[1].c) )
      cout << "EXECUTE error" << endl;

   if( (rcd = sqlfet(sql[1].c)) == 0 ) {
      cout << "sqlfet: " << nr << " - "
                         << name << endl;
   } else
      cout << "Not found." << endl;


   sql[0].text = "UPDATE PERSDAT SET AGE=4,MONEY=100.0 "
                        "WHERE NR='1001'";

   if(sqlcom(sql[0].c, sql[0].text, 0))
      cout << "COMPILE error" << endl;

   if((rcd=sqlexe(sql[0].c)) == 0)
      cout << "Row(s) updated." << endl;
   else
      cout << "EXECUTE error" << endl;


   //
   // disconnect cursors
   //
   sqldis(sql[0].c);
   sqldis(sql[1].c);

   return(0);
}
