#define STRICT
#include "\code\classes\zedit.h"
#include <string.h>
#include <stdio.h>


ZEdit::ZEdit(HWND hParent,UINT id,UINT len)
{
Size=len;
if(Size>=MAX_EDIT_SIZE)
	Size=MAX_EDIT_SIZE;
hBuf=GlobalAlloc(GPTR,Size);
Buf=(LPSTR)GlobalLock(hBuf);
Buf[0]=0;

SetParent(hParent);
SetID(id);
}

ZEdit::~ZEdit()
{
if(hBuf)	{
	GlobalUnlock(hBuf);
	GlobalFree(hBuf);
	}
}

#pragma argsused
UINT  ZEdit::Write(char* x)
{
if(strlen((const char*)x)>=MAX_EDIT_SIZE)
	return -1;
strcpy((char*)Buf,(const char*)x);
Update();
return strlen((char*)x);
}

UINT ZEdit::Write(int x,char how)
{
char temp[100];
if(how=='D'||how=='d')
	sprintf(temp,"%d",x);
else if(how=='h'||how=='H')
	sprintf(temp,"%X",x);
else
	return 0;
return Write(temp);
}

UINT ZEdit::Write(float x)
{
char temp[100];
sprintf(temp,"%f",x);
return Write(temp);
}


int ZEdit::Read(char* x,UINT len)
{
return SendDlgItemMessage(hParent,(int)Id,WM_GETTEXT,(WPARAM)len,(LPARAM)(LPCSTR)x);
}

int ZEdit::Update()
{
return SendDlgItemMessage(hParent,(int)Id,WM_SETTEXT,(WPARAM)0,(LPARAM)(LPCSTR)Buf);
}

