untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcTs9eaF/phcGn9j4jaM3o65s3NmdcbiXCMMXBti9ptq14Sl4kzPIeSMqnOuBgLErIYdcLVepAfVG4QXF1msLyQU=

OpenBSD 6.4 errata 002, November 2, 2018

The syspatch utility incorrectly handles symbolic links.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 002_syspatch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then install the syspatch utility
    cd /usr/src/usr.sbin/syspatch
    make install

Index: usr.sbin/syspatch/syspatch.sh
===================================================================
RCS file: /cvs/src/usr.sbin/syspatch/syspatch.sh,v
retrieving revision 1.137
diff -u -p -r1.137 syspatch.sh
--- usr.sbin/syspatch/syspatch.sh	9 May 2018 10:22:06 -0000	1.137
+++ usr.sbin/syspatch/syspatch.sh	29 Oct 2018 19:25:25 -0000
@@ -141,6 +141,9 @@ install_file()
 	local _dst=$2 _fgrp _fmode _fown _src=$1
 	[[ -f ${_src} && -f ${_dst} ]]
 
+	# ignore symlinks
+	[[ ! -h ${_src} ]] || return 0
+
 	eval $(stat -f "_fmode=%OMp%OLp _fown=%Su _fgrp=%Sg" ${_src})
 
 	install -DFSp -m ${_fmode} -o ${_fown} -g ${_fgrp} ${_src} ${_dst}
@@ -197,6 +200,11 @@ rollback_patch()
 
 	for _file in ${_files}; do
 		((_ret == 0)) || break
+		# prevent reverting to a bogus syspatch
+		if [[ ${_file} == usr/sbin/syspatch &&
+			${_patch} == 64-002_syspatch ]]; then
+			break
+		fi
 		install_file ${_edir}/${_file} /${_file} || _ret=$?
 	done
 
@@ -305,4 +313,8 @@ if ((OPTIND == 1)); then
 	for _PATCH in ${_PATCHES}; do
 		apply_patch ${_OSrev}-${_PATCH}
 	done
+	# repair X -> Xorg
+	if [[ ! -h /usr/X11R6/bin/X ]]; then
+		ln -sf Xorg /usr/X11R6/bin/X
+	fi
 fi
