/*----------------------------------------------------------------------

            T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade and Mike Seibel
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   Administration Building, AG-44
   Seattle, Washington, 98195, USA
   Internet: lgl@CAC.Washington.EDU
             mikes@CAC.Washington.EDU

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989, 1990, 1991, 1992  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  $Revision: 2.13 $   $State: Exp $          *
    *                                                                     *
    * 			Copyright (c) 1986, 1987 Dave Taylor              *
    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************
 
  ----------------------------------------------------------------------*/


/*======================================================================
     help.c
     Functions to support the pine help screens
 ====*/


#include "headers.h"


/*----------------------------------------------------------------------
     Make a copy of the help text for display, doing various substutions

  Args: a -- input string
        b -- outputstring

 Result: string copied into buffer, and any expressions of the form
 {xxx:yyy} are replaced by either xxx or yyy depending on the whether
 we are using function keys or not.
  ----*/

static void 
copy_fix_keys(a, b)
  register char *a, *b;
{
    while(*b) {
	while(*b && *b != '{')
          if(*b == '^' && *(b+1) == '_') {
              *a++ = *b++;
              *a++ = *b++;
	  } else if(*b != '_') {
              *a++ = *b++;
	  } else {
              b++;
          }
	     
	if(*b == '\0') {
	    break;
	}

	if(ps_global->use_fkeys) {
	    if(*b)
	      b++;
	    while(*b && *b != ':')
	      *a++ = *b++;
	    while(*b && *b != '}')
	      b++;
	    if(*b)
	      b++;
	} else {
	    while(*b && *b != ':')
	      b++;
	    if(*b)
	      b++;
	    while(*b && *b != '}')
	      *a++ = *b++;
	    if(*b)
	      b++;
	}
    }
    *a = '\0';
}



/*----------------------------------------------------------------------
     Get the help text in the proper format and call scroller

    Args: text   -- The help text to display (from pine.help --> helptext.c)
          title  -- The title of the help text 
  
  Result: format text and call scroller

  The pages array contains the line number of the start of the pages in
the text. Page 1 is in the 0th element of the array.
The list is ended with a page line number of -1. Line number 0 is also
the first line in the text.
  -----*/
void
helper(text, title, from_composer)
     char  *text[], *title;
     int    from_composer;
{
    register char **t, **t2, **new_text;
    int             pages[100], current_page, in_include;
    char          **new_text_nr; /* non-register version of new_text */
    char            *line, line_buf[256];
    FILE           *file;


    dprint(1, (debugfile, "\n\n    ---- HELPER ----\n"));
    /*----------------------------------------------------------------------
            First copy the help text and do substitutions
      ----------------------------------------------------------------------*/

    for(t = text ; *t != NULL; t++);
    new_text = (char **)fs_get((t - text + 1) * sizeof(char *));

    current_page = 0;
    in_include   = 0;
    file         = NULL;
    for(t = text, t2 = new_text; *t != NULL;) {
        if(in_include) {
            /*--- Inside and ___include ... ___end_include section ---*/
            if(file != NULL) {
                /*--- Read next line out of include file ---*/
                line = fgets(line_buf, sizeof(line_buf), file);
                if(line == NULL) {
                    fclose(file);
                    while(*t && struncmp(*t, "___end_include", 14) != 0)
                      t++;
                    t++;
                    in_include = 0;
                    continue;
                }
            } else {
                /*--- File wasn't there, copy the default text ---*/
                if(struncmp(*t, "___end_include", 14) == 0){
                    in_include = 0;
                    t++;
                    continue;
                } else {
                    line = *t;
                }
            }
        } else {
            if(struncmp(*t, "___include", 10) == 0) {
                /*-- Found start of an ___include ... ___end_include block --*/
                char *p, *q;
                in_include = 1;
                for(p = (*t)+10; *p && isspace(*p); p++);
                strcpy(line_buf, p);
                for(q = line_buf; *q && !isspace(*q); q++);
                *q = '\0';
                dprint(9, (debugfile, "About to open \"%s\"\n", line_buf));
                file = fopen(line_buf, "r");
                if(file == NULL) 
                  dprint(1, (debugfile, "Helptext Failed open \"%s\": \"%s\"\n",
                             line_buf, error_description(errno)));
                t++;
                continue;
            }  else {
                /*-- The normal case, just another line of help text ---*/
                line = *t;
            }
        }

        /*-- line now contains the text to use, where ever it came from --*/
        dprint(9, (debugfile, "line-->%s<-\n", line));
	if(srchstr(line, "___Page") != NULL) {
	    pages[current_page++] = t2 - new_text;
	}
	*t2 = (char *)fs_get(strlen(line) + 1);
        copy_fix_keys(*t2, line);
        t2++;
        t++;
    }
    *t2 = *t;
    pages[current_page] = -1;

    dprint(7, (debugfile, "helper PAGE COUNT %d\n", current_page));
    { int i;
        for(i = 0 ; pages[i] != -1; i++) 
         dprint(7, (debugfile, "helper PAGE %d line %d [%s]\n",i+1, pages[i],
                    new_text[pages[i]]));
    }

		    
    /* This is mostly hear to get the curses variables for line and column
        in sync with where the cursor is on the screen. This gets warped
	when the composer is called because it does it's own stuff */
    ClearScreen();
    scrolltool(new_text, NULL, NULL, NULL, NULL,  title, pages,
               from_composer ? ComposerHelpText : HelpText);

    for(t2 = new_text; *t2 != NULL; t2++)
      fs_give((void **)t2);

    new_text_nr = new_text;
    fs_give((void **)&new_text_nr);
}


void
print_all_help()
{
    char ***t, **l, buf[500];
    int     line_count;

    if(open_printer("all 50 pages of help text ") == 0) {
        for(t = h_texts; *t != NULL; t++) {
            line_count = 0;
            for(l = *t; *l != NULL; l++) {
                copy_fix_keys(buf, *l);
                print_text(buf);
                print_char('\n');
                line_count++;
            }
            if(line_count > 10)
              print_char(ctrl('L'));
            else
              print_text("\n\n");
        }
        close_printer();
    }
}
          
    
	    
    




