/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	cmddlg.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_cmd_dialog_box class header
 *
 *	RCSid = "$Id: cmddlg.H,v 4.7.1.1 1993/06/01 22:53:13 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef	OI_cmddlg_H
#define	OI_cmddlg_H

#ifndef	OI_seldlg_H
#include <OI/seldlg.H>
#endif /* OI_seldlg_H */

	// class forward reference declarations
	class OI_mdl_command_dialog_box;

#define	OI_command_db_def_ef_max_width	256
#define	OI_COMMAND_DB_DEF_EF_MAX_WIDTH	OI_command_db_def_ef_max_width

class OI_command_dialog_box : public OI_select_dialog_box {
			OI_mdl_command_dialog_box	*mdl_dep;		/* pointer to model dependent cmd dlg box. */
			OI_bool			ef_resize;
	public:
		static	OI_class		*clsp ;				/* ptr to class record */
		static	XrmQuark		q_cbCmdEntryChk ;		/* quark for entry field check callback */
	private:
			void			construct() ;
	protected:
						OI_command_dialog_box(OI_class *clsp, const char *usr_namp,
							OI_number dspln=OI_prompt_db_def_ef_width, const char *lblp="Command Line",
							const char *defstr=NULL, OI_number mxln=OI_command_db_def_ef_max_width,
							OI_number smn=-1, OI_menu_cell **smcpp=NULL, const char *smttl=NULL, OI_number n=-1,
							OI_menu_cell **cpp=NULL) ;
						OI_command_dialog_box(OI_class *clsp, const char *usr_namp,
							OI_number dspln=OI_prompt_db_def_ef_width, const char *lblp="Command Line",
							const char *defstr=NULL, OI_number mxln=OI_command_db_def_ef_max_width,
							OI_number smn=-1, OI_cell_spec *smcpp=NULL, const char *smttl=NULL, OI_number n=-1,
							OI_cell_spec *cpp=NULL) ;
			OI_ef_entry_chk_status	add_history(OI_entry_field *op, void *ap) ;
		virtual	void			new_model(OI_model_type) ;
	public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_command_dialog_box(const char*, OI_number=OI_prompt_db_def_ef_width, const char* ="Command Line",
							const char* =NULL, OI_number =OI_command_db_def_ef_max_width, OI_number =-1,
							OI_cell_spec* =NULL, const char* =NULL, OI_number =-1, OI_cell_spec* =NULL);
						OI_command_dialog_box(const char*, OI_number=OI_prompt_db_def_ef_width, const char* ="Command Line",
							const char* =NULL, OI_number =OI_command_db_def_ef_max_width, OI_number =-1,
							OI_menu_cell** =NULL, const char* =NULL, OI_number =-1, OI_menu_cell** =NULL);
						~OI_command_dialog_box() ;
		static	OI_bool			init(OI_connection*) ;
		static	OI_command_dialog_box	*make_minimal(char*,OI_minimal_type) ;
		virtual	void			mnu_select(OI_menu *, OI_menu_cell *cp, void *ap, OI_number n) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_bool			ef_dsp_resize()				{return(ef_resize);}
			void			set_ef_dsp_resize(OI_bool val)		{ef_resize = val;}
		virtual	void			set_entry_chk(OI_ef_entry_chk_fnp fp, void *argp=NULL) ;
		virtual	void			set_entry_chk(OI_callback *objp, OI_ef_entry_chk_memfnp mfp, void *argp=NULL) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
};

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
OI_command_dialog_box *oi_command_dialog_box(const char*, OI_number=OI_prompt_db_def_ef_width, char* ="Command Line", char* =NULL,
			OI_number =OI_command_db_def_ef_max_width, OI_number =-1, OI_menu_cell** =NULL, char * =NULL, OI_number =-1,
			OI_menu_cell** =NULL);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
OI_command_dialog_box *oi_create_command_dialog_box(const char*, OI_number=OI_prompt_db_def_ef_width, const char* ="Command Line", const char* =NULL,
			OI_number=OI_command_db_def_ef_max_width, OI_number=-1, OI_cell_spec* =NULL, const char* =NULL, OI_number=-1,
			OI_cell_spec* =NULL);
OI_command_dialog_box *oi_create_command_dialog_box(const char*, OI_number, const char*, const char*,
			OI_number, OI_number, OI_menu_cell**, const char * =NULL, OI_number =-1, OI_menu_cell** =NULL);

#endif /* OI_cmddlg_H */
