/*
 ****************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1988, ParcPlace Systems, Inc.  USA
 *	All rights reserved.
 *
 ****************************************************************************
 *
 *	File:
 *		btnmnu.H
 *
 *	Description:
 *		OI_button_menu generic class header
 *		
 *	RCSid = "$Id: btnmnu.H,v 4.2.1.1 1993/06/01 22:53:02 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_btnmnu_H
#define OI_btnmnu_H

#ifndef OI_trnmnu_H
#include <OI/trnmnu.H>
#endif /* OI_trnmnu_H */

	// forward reference declaration
	class OI_mdl_button_menu;

	class OI_button_menu : public OI_trans_menu {
			OI_mdl_button_menu	*mdl_dep ;
	 public:
		static	OI_class		*clsp ;				/* ptr to class record */
	 private:
			void			construct(OI_number, OI_menu_cell**) ;
	 protected:
						OI_button_menu(OI_class *, const char *, OI_number, OI_menu_cell **, OI_orient =OI_VERTICAL,
							const char * =NULL);
						OI_button_menu(OI_class *, const char *, OI_number, OI_cell_spec *, OI_orient =OI_VERTICAL,
							const char * =NULL);
		virtual	void			new_model(OI_model_type) ;
         public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_button_menu(const char *, OI_number, OI_menu_cell **, OI_orient =OI_VERTICAL,
							const char * =NULL) ;
						OI_button_menu(const char *, OI_number, OI_cell_spec *, OI_orient =OI_VERTICAL,
							const char * =NULL) ;
						~OI_button_menu() ;
		virtual	void			allow_main_menu();
		virtual	PIXEL			cell_bkg_paint_pixel(OI_menu_cell *);
		virtual	OI_number		cell_default_extra() ;					/* extra space for default cell */
		virtual	PIXEL			cell_fg_paint_pixel(OI_menu_cell *);
		virtual	PIXEL			cell_fg_reverse_paint_pixel(OI_menu_cell *);
		virtual	void			cell_new_bvl_width(OI_menu_cell *cp);
		virtual	void			cell_set_xtra(OI_menu_cell *cp);
		virtual	void			cell_paint(OI_menu_cell *cp) ;
		virtual	void			disallow_main_menu();
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_write_resq(XrmQuark);
		static	OI_button_menu		*make_minimal(const char*,OI_minimal_type) ;
		virtual	void			new_children(const char *);		/* callback for children resource */
			void			res_main_menu( void * ) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
	} ;
//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_button_menu	*oi_button_menu(const char *, OI_number , OI_menu_cell **, OI_orient =OI_VERTICAL, const char * =NULL) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_button_menu	*oi_create_button_menu(const char*, OI_number,OI_cell_spec*,OI_orient=OI_VERTICAL,const char* =NULL) ;
		OI_button_menu	*oi_create_button_menu(const char*, OI_number,OI_menu_cell**,OI_orient=OI_VERTICAL,const char* =NULL) ;

#endif /* OI_btnmnu_H */
