/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.util.ArrayList;
import java.util.HashMap;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQMergeNode;
import unity.query.LQTree;

public class SubQuery {
    private LQTree logicalQueryTree;
    private ArrayList localQueries;
    private HashMap tableReferences = new HashMap();
    private HashMap databaseReferences = new HashMap();
    private HashMap fieldReferences = new HashMap();

    public void addTableRef(String key, GQTableRef ref) {
        this.tableReferences.put(key, ref);
    }

    public void addDatabaseRef(String key, GQDatabaseRef ref) {
        this.databaseReferences.put(key, ref);
    }

    public void addFieldRef(String key, GQFieldRef ref) {
        this.fieldReferences.put(key, ref);
    }

    public GQDatabaseRef getDBRef(String key) {
        return (GQDatabaseRef)this.databaseReferences.get(key);
    }

    public GQTableRef getTableRef(String key) {
        return (GQTableRef)this.tableReferences.get(key);
    }

    public GQFieldRef getFieldRef(String key) {
        return (GQFieldRef)this.fieldReferences.get(key);
    }

    public void setLogicalQueryTree(LQTree lqt) {
        this.logicalQueryTree = lqt;
    }

    public int numDatabases() {
        return this.databaseReferences.size();
    }

    public HashMap getTableRefs() {
        return this.tableReferences;
    }

    public LQTree getLogicalQueryTree() {
        return this.logicalQueryTree;
    }

    public HashMap getFieldRefs() {
        return this.fieldReferences;
    }

    public void setLocalQueries(ArrayList qrys) {
        this.localQueries = qrys;
    }

    public ArrayList getLocalQueries() {
        return this.localQueries;
    }

    public static SubQuery mergeSubqueries(SubQuery lastSq, SubQuery sq, LQMergeNode mergeNode) {
        SubQuery newSQ = new SubQuery();
        newSQ.logicalQueryTree = new LQTree(mergeNode);
        newSQ.databaseReferences.putAll(lastSq.databaseReferences);
        newSQ.databaseReferences.putAll(sq.databaseReferences);
        newSQ.tableReferences.putAll(lastSq.tableReferences);
        newSQ.tableReferences.putAll(sq.tableReferences);
        newSQ.fieldReferences.putAll(lastSq.fieldReferences);
        newSQ.fieldReferences.putAll(sq.fieldReferences);
        return newSQ;
    }
}

