 REM Renumber.bas v7.4a r1.0 - Symbolic Instruction Code; renumber module.
 REM The public domain DOS programming interpreter utility.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' program code
 REDIM Program(1 TO Max.Lines) AS STRING

 ' initialize variables
 White.Space = CHR$(32) + CHR$(9)

 ' run program from command line
 Filename = COMMAND$
 IF LEN(Filename) = False THEN
    GOTO Boot.Usage
 END IF
 IF DIR$(Filename) = Nul THEN
    GOTO Boot.Usage
 END IF
 COLOR White, Black
 PRINT "Renumber v" + Version + " r" + Release + ":"
 CALL New.Program
 CALL Read.Program
 Prepare.Filename = Filename
 CALL Renumber.Program(0, 0)
Error.Resume:
 COLOR Plain, Black
 WHILE INKEY$ <> Nul
 WEND
 PRINT "Exiting to system.."
 END

Boot.Usage:
 COLOR White, Black
 PRINT "Renumber v" + Version + " r" + Release + "; Usage:"
 COLOR Yellow, Black
 PRINT "Renumber <program name>"
 PRINT "   Renumbers program specified on command line."
 COLOR Plain, Black
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 COLOR White, Black
 PRINT "Renumber utility error";Err
 RESUME Error.Resume

' renumbers current .sic program
SUB Renumber.Program(X, Y)
 COLOR Yellow, Black
 PRINT "Starting line number";
 INPUT Start.Line
 PRINT "Increment value";
 INPUT Increment
 Start.Line = INT(Start.Line)
 IF Start.Line <= False THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 IF Start.Line > Max.Lines THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 Increment = INT(Increment)
 IF Increment <= False THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 IF Increment > INT(Max.Lines / 2) THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 CALL Count.Lines(Last.Line)
 REDIM Renumber.List(1 TO Max.Lines) AS INTEGER
 New.Line.Number = Start.Line
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF New.Line.Number > Max.Lines THEN
	  COLOR White, Black
	  PRINT "Renumber list exceeds"; STR$(Max.Lines); " lines."
	  ERASE Renumber.List
	  EXIT SUB
       END IF
       Renumber.List(New.Line.Number) = Line.Number
       New.Line.Number = New.Line.Number + Increment
    END IF
 NEXT
 PRINT "Renumbering program.."
 FOR Line.Number = 1 TO Last.Line
    New.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = STRIM$(Old.Program.Line$)
    Old.Program.Line$ = TTRIM$(Old.Program.Line$, True)
    IF Old.Program.Line$ <> Nul THEN
       Line.Renumbered = True
       IF UCASE$(LEFT$(Old.Program.Line$, 7)) = "RESTORE" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "RESTORE") + 7
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 8)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 4)) = "GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 5)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 13)) = "ON ERROR GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 14)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 6)) = "RESUME" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" THEN
	     IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME SAME" THEN
		IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME NEXT" THEN
		   Line.Renumbered = False
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "RESUME") + 6
                   GOSUB Next.Space
		   Number$ = MID$(Old.Program.Line$, 7)
		   Number$ = STRIM$(Number$)
		   Old.Line.Number = INT(VAL(Number$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 5)) = "GOSUB" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 6)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 2)) = "ON" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 8)) <> "ON ERROR" THEN
	     Line.Renumbered = False
             IF INSTR(UCASE$(Old.Program.Line$), "GOTO") THEN
                Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
                Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                GOSUB Next.Space
                New.Program.Line1$ = Next.Program.Line$
                Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOTO")
                Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 4)
		DO
                   Imbedded1 = INSTR(Old.Number1$, ",")
                   IF Imbedded1 THEN
                      New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                      Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
		   ELSE
                      New.Number1$ = Old.Number1$
                      Old.Number1$ = Nul
		   END IF
                   IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                      Imbedded = 1
                      New.Program.Line$ = New.Number1$
                      GOSUB Next.Space
                      New.Number1$ = Next.Program.Line$
                   ELSE
                      New.Number1$ = Nul
                   END IF
                   Imbedded2 = INSTR(Old.Number2$, ",")
                   IF Imbedded2 THEN
                      New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                      Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
		   ELSE
                      New.Number2$ = Old.Number2$
                      Old.Number2$ = Nul
		   END IF
		   Line.Renumbered = False
                   Old.Line.Number = INT(VAL(New.Number2$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
                   IF Old.Number2$ = Nul THEN
		      EXIT DO
		   END IF
		   IF Line.Renumbered = False THEN
		      EXIT DO
		   END IF
		LOOP
                IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                   New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                END IF
                Program(Line.Number) = New.Program.Line1$
	     ELSE
                IF INSTR(UCASE$(Old.Program.Line$), "GOSUB") THEN
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
                   Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                   GOSUB Next.Space
                   New.Program.Line1$ = Next.Program.Line$
                   Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOSUB")
                   Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 5)
                   DO
                      Imbedded1 = INSTR(Old.Number1$, ",")
                      IF Imbedded1 THEN
                         New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                         Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
                      ELSE
                         New.Number1$ = Old.Number1$
                         Old.Number1$ = Nul
                      END IF
                      IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                         Imbedded = 1
                         New.Program.Line$ = New.Number1$
                         GOSUB Next.Space
                         New.Number1$ = Next.Program.Line$
                      ELSE
                         New.Number1$ = Nul
                      END IF
                      Imbedded2 = INSTR(Old.Number2$, ",")
                      IF Imbedded2 THEN
                         New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                         Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
                      ELSE
                         New.Number2$ = Old.Number2$
                         Old.Number2$ = Nul
                      END IF
                      Line.Renumbered = False
                      Old.Line.Number = INT(VAL(New.Number2$))
                      IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                         FOR New.Line.Number = 1 TO Max.Lines
                            IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                               New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                               Line.Renumbered = True
                               EXIT FOR
                            END IF
                         NEXT
                      END IF
                      IF Old.Number2$ = Nul THEN
                         EXIT DO
                      END IF
                      IF Line.Renumbered = False THEN
                         EXIT DO
                      END IF
                   LOOP
                   IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                      New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                   END IF
                   Program(Line.Number) = New.Program.Line1$
                END IF
	     END IF
	  END IF
       END IF
       IF Line.Renumbered = False THEN
	  COLOR White, Black
          PRINT "Error renumbering program: line";Line.Number
	  EXIT SUB
       END IF
    END IF
 NEXT
 PRINT "Resequencing line numbers.."
 DO
    Temp.Filename$ = TempName$
    Filename = Temp.Filename$ + ".sc1"
    IF DIR$(Filename) = Nul THEN
       EXIT DO
    END IF
 LOOP
 CALL Store.Program
 CALL New.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 WHILE NOT EOF(1)
    LINE INPUT #1, New.Program.Line$
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(New.Program.Line$, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          EXIT FOR
       END IF
    NEXT
    Old.Line.Number = INT(VAL(LEFT$(New.Program.Line$, Imbedded - 1)))
    FOR New.Program.Line = 1 TO Max.Lines
       IF Renumber.List(New.Program.Line) = Old.Line.Number THEN
          Program(New.Program.Line) = MID$(New.Program.Line$, Imbedded)
	  EXIT FOR
       END IF
    NEXT
 WEND
 CLOSE
 KILL Filename
 Filename = Prepare.Filename
 CALL Store.Program
 COLOR Yellow, Black
 PRINT "Program renumbered."
 EXIT SUB
' locates string with following white spaces
Next.Space:
 Next.Program.Line$ = New.Program.Line$
 DO
    IF Imbedded >= LEN(Next.Program.Line$) THEN
       EXIT DO
    END IF
    IF INSTR(White.Space, MID$(Next.Program.Line$, Imbedded + 1, 1)) THEN
       Imbedded = Imbedded + 1
    ELSE
       EXIT DO
    END IF
 LOOP
 Next.Program.Line$ = LEFT$(Next.Program.Line$, Imbedded)
 RETURN
END SUB

' gets last line in program
SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

' end of program routine
SUB End.Program
END SUB

' loads a program from disk
SUB Read.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 DO WHILE NOT EOF(1)
    LINE INPUT #1, Out2
    Out2 = STRIM$(Out2)
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
          IF Line.Number > False AND Line.Number <= Max.Lines THEN
             Program(Line.Number) = MID$(Out2, Imbedded)
             EXIT FOR
          END IF
       END IF
    NEXT
 LOOP
 CLOSE
END SUB

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
FUNCTION TTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
END FUNCTION

' strips leading/trailing white spaces from string
FUNCTION STRIM$(Var$)
 XVar$ = Var$
 DO
    Blanks = 0
    FOR Count = 1 TO LEN(White.Space)
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
          XVar$ = MID$(XVar$, 2)
          Blanks = -1
       END IF
    NEXT
    IF Blanks = 0 THEN
       EXIT DO
    END IF
 LOOP
 DO
    Blanks = 0
    FOR Count = 1 TO LEN(White.Space)
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
          Blanks = -1
       END IF
    NEXT
    IF Blanks = 0 THEN
       EXIT DO
    END IF
 LOOP
 STRIM$ = XVar$
END FUNCTION

' returns a randomized temporary filename.
' could be constructed from Date/Time.
FUNCTION TempName$
 Var$ = Nul
 FOR Temp = 1 TO 8
    Var$ = Var$ + LTRIM$(STR$(INT(RND*9+1)))
 NEXT
 TempName$ = Var$
END FUNCTION

' remove current .sic program from memory
SUB New.Program
 ' erase/redimension program code array
 ERASE Program
 REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' writes out the current .sic program to file
SUB Store.Program
 CLOSE
 OPEN Filename FOR OUTPUT AS #1
 CALL Count.Lines(Last.Line)
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF INSTR(White.Space, LEFT$(ProgramLine$, 1)) THEN
          PRINT #1, MID$(STR$(Line.Number), 2) + ProgramLine$
       ELSE
          PRINT #1, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
       END IF
    END IF
 NEXT
 CLOSE
END SUB
