/***********************************************************************\
 *                                PC2.c                                *
 *              Copyright (C) by Stangl Roman, 1993, 1994              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * Dialog.c     Dialog window procedures.                              *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Dialog.c Version 1.70 06,1994 $ (LBL)";

#define         _FILE_  "PC/2 - Dialog.c V1.70"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

PFNWP           PI_ClassDialogProcedure;

                                        /* Program Installation dialog notebook pages */
NBPAGE          nbPINotebookPage[]=
{
    {PI_NotebookProcedure,  0,  0,  "Application Settings", "~Application", PIID_PAGE1, PIEF_PROGRAMTITLE},
    {PI_NotebookProcedure,  0,  0,  "Session Settings",     "~Session",     PIID_PAGE2, PIRB_SHELL},
    {PI_NotebookProcedure,  0,  0,  "Style Settings",       "S~tyle",       PIID_PAGE3, PIRB_DEFAULTSTYLE},
    {PI_NotebookProcedure,  0,  0,  "Hotkey Settings",      "~Hotkey",      PIID_PAGE4, PIRB_WSMAXIMIZED},
    {PI_NotebookProcedure,  0,  0,  "Priority Settings",    "~Priority",    PIID_PAGE5, PIRB_NOCHANGE},
    {NULL,                  0,  0,  "",                     "",             0,          0}
};

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - About dialog.                               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(ID_ABOUTDIALOG),    /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Desktop configuration dialog.               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY DD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
                                        /* Child windows that change with the
                                           DDCD_SLIDINGFOCUS checkbox */
static USHORT   usChild2SlidingFocusCB[]={DDCB_PRESERVEZORDER};
                                        /* Child windows that change with the
                                           DDCB_VIRTUALDESKTOP checkbox */
static USHORT   usChild2VirtualDesktopCB[]={DDCB_MOVEDESKTOP, DDCB_CLICK2MOVE,
                                            DDCB_OVERVIEW, DDCB_KEEPONTOP, DDEF_SCROLLPERCENTAGE};
UCHAR       ucBuffer[4];

switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Check the checkboxes that should be set according to the bitmap currently used in    *
 * PC2.INI. If the virtual Desktop is disabled, then its child checkboxes can't be set, *
 * because unchecking the virtual Desktop automatically unchecks its child checkboxes.  *
\*                                                                                      */
                                        /* Check ckeckbox if sliding focus flag is set */
    if(HookParameters.ulStatusFlag & SLIDINGFOCUS)
        WinSendDlgItemMsg(hwndDlg, DDCB_SLIDINGFOCUS, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check ckeckbox if preserve z-order flag is set */
    if(HookParameters.ulStatusFlag & PRESERVEZORDER)
        WinSendDlgItemMsg(hwndDlg, DDCB_PRESERVEZORDER, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check ckeckbox if button 2 z-order flag is set */
    if(HookParameters.ulStatusFlag & BUTTON2ZORDER)
        WinSendDlgItemMsg(hwndDlg, DDCB_BUTTON2ZORDER, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if virtual Desktop flag is set */
    if(HookParameters.ulStatusFlag & VIRTUALDESKTOP)
        WinSendDlgItemMsg(hwndDlg, DDCB_VIRTUALDESKTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if keep on top flag is set */
    if(HookParameters.ulStatusFlag & KEEPONTOP)
        WinSendDlgItemMsg(hwndDlg, DDCB_KEEPONTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if move Desktop flag is set */
    if(HookParameters.ulStatusFlag & MOVEDESKTOP)
        WinSendDlgItemMsg(hwndDlg, DDCB_MOVEDESKTOP, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if click to move flag is set */
    if(HookParameters.ulStatusFlag & CLICK2MOVE)
        WinSendDlgItemMsg(hwndDlg, DDCB_CLICK2MOVE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check checkbox if overview window flag is set */
    if(HookParameters.ulStatusFlag & OVERVIEW)
        WinSendDlgItemMsg(hwndDlg, DDCB_OVERVIEW, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
/*                                                                                      *\
 * Write the Desktop and Window List currently available or the default ones from       *
 * PC2.INI into the entryfields. The maximum length of both we assume MAXNAMEL.         *
\*                                                                                      */
                                        /* First set the limits to MAXNAMEL */
    WinSendDlgItemMsg(hwndDlg, DDEF_DESKTOPNAME, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    WinSendDlgItemMsg(hwndDlg, DDEF_WINDOWLISTNAME, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
                                        /* Insert the strings */
    WinSetDlgItemText(hwndDlg, DDEF_DESKTOPNAME, HookParameters.ucDesktopName);
    WinSetDlgItemText(hwndDlg, DDEF_WINDOWLISTNAME, HookParameters.ucWindowListName);
/*                                                                                      *\
 * Set scrolling percentage entryfield and horizontal scrollbar in 5 % increments.      *
\*                                                                                      */
    WinSendDlgItemMsg(hwndDlg, DDHSB_SCROLLPERCENTAGE,
        SBM_SETTHUMBSIZE, MPFROM2SHORT(1, 20), (MPARAM)NULL);
    WinSendDlgItemMsg(hwndDlg, DDHSB_SCROLLPERCENTAGE,
        SBM_SETSCROLLBAR, MPFROMSHORT(HookParameters.ulScrollPercentage/5),
        MPFROM2SHORT(0, 20));
                                        /* Insert the string */
    WinSetDlgItemText(hwndDlg, DDEF_SCROLLPERCENTAGE,
        (CHAR *)_itoa(HookParameters.ulScrollPercentage, ucBuffer, 10));
/*                                                                                      *\
 * Disable the child windows of the sliding Focus, if this checkbox isn't checked.      *
\*                                                                                      */
    if(!(HookParameters.ulStatusFlag & SLIDINGFOCUS))
        DisableDialogItem(hwndDlg, usChild2SlidingFocusCB,
            sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
/*                                                                                      *\
 * Disable the child windows of the virtual Desktop, if this checkbox isn't checked.    *
\*                                                                                      */
    if(!(HookParameters.ulStatusFlag & VIRTUALDESKTOP))
        DisableDialogItem(hwndDlg, usChild2VirtualDesktopCB,
            sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
/*                                                                                      *\
 * Set click flag.                                                                      *
\*                                                                                      */
    if(HookParameters.ulClickFlag==WM_BUTTON1CLICK)
        WinSendDlgItemMsg(hwndDlg, DDRB_BUTTON1CLICK, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else
        WinSendDlgItemMsg(hwndDlg, DDRB_BUTTON1DBLCLK, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(ID_DESKTOPDIALOG), HM_RESOURCEID);
    break;

case WM_HSCROLL:                        /* Messages generated by horizontal scrollbars */
/*                                                                                      *\
 * This message is generated when a horizontal scrollbar is manipulated. See if it is   *
 * our scrollbar DDHSB_SCROLLPERCENTAGE and process.                                    *
\*                                                                                      */
    if(SHORT1FROMMP(mp1)==DDHSB_SCROLLPERCENTAGE)
        {
        SHORT       sSliderPosition=SHORT1FROMMP(mp2);;

        switch(SHORT2FROMMP(mp2))
        {                               /* All messages contain the new slider position,
                                           so just use this value to change the priority
                                           delta entryfield value */
        case SB_LINELEFT:
            HookParameters.ulScrollPercentage-=5;
            break;

        case SB_PAGELEFT:
            HookParameters.ulScrollPercentage-=25;
            break;

        case SB_LINERIGHT:
            HookParameters.ulScrollPercentage+=5;
            break;

        case SB_PAGERIGHT:
            HookParameters.ulScrollPercentage+=25;
            break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
            HookParameters.ulScrollPercentage=sSliderPosition*5;
            break;
        }
        if(((LONG)HookParameters.ulScrollPercentage)<0) HookParameters.ulScrollPercentage=0;
        if(HookParameters.ulScrollPercentage>100) HookParameters.ulScrollPercentage=100;
        WinSetDlgItemText(hwndDlg, DDEF_SCROLLPERCENTAGE,
            (CHAR *)_itoa(HookParameters.ulScrollPercentage, ucBuffer, 10));
        WinSendDlgItemMsg(hwndDlg, DDHSB_SCROLLPERCENTAGE,
            SBM_SETPOS, MPFROMSHORT(HookParameters.ulScrollPercentage/5), (MPARAM)NULL);
        }
    break;

case WM_CONTROL:                        /* Test for checkbuttons buttons pressed */
/*                                                                                      *\
 * Only if the DDCB_VIRTUALDESKTOP checkbox is pressed, its child windows are to be     *
 * enabled. Otherwise the are disabled, but allways visible.                            *
\*                                                                                      */
    {
    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked ? */
        switch(SHORT1FROMMP(mp1))
        {
        case DDCB_SLIDINGFOCUS:         /* Sliding Focus enable/disable checkbox */
            if((BOOL)WinSendDlgItemMsg(hwndDlg, DDCB_SLIDINGFOCUS, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                                        /* Enable and show SlidingFocusCB child windows */
                DisableDialogItem(hwndDlg, usChild2SlidingFocusCB,
                    sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE);
            else
                {                       /* If preserve Z-order is checked, uncheck it */
                if(WinQueryButtonCheckstate(hwndDlg, DDCB_PRESERVEZORDER))
                    WinSendDlgItemMsg(hwndDlg, DDCB_PRESERVEZORDER, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* Disable and show SlidingFocusCB child windows */
                DisableDialogItem(hwndDlg, usChild2SlidingFocusCB,
                    sizeof(usChild2SlidingFocusCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case DDCB_VIRTUALDESKTOP:       /* Virtal Desktop enable/disable checkbox */
            if((BOOL)WinSendDlgItemMsg(hwndDlg, DDCB_VIRTUALDESKTOP, BM_QUERYCHECK,
                (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                                        /* Enable and show VirtualDesktopCB child windows */
                DisableDialogItem(hwndDlg, usChild2VirtualDesktopCB,
                    sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE);
            else
                {
                                        /* If move Desktop checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(hwndDlg, DDCB_MOVEDESKTOP))
                    WinSendDlgItemMsg(hwndDlg, DDCB_MOVEDESKTOP, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* If click to move checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(hwndDlg, DDCB_CLICK2MOVE))
                    WinSendDlgItemMsg(hwndDlg, DDCB_CLICK2MOVE, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* If overview checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(hwndDlg, DDCB_OVERVIEW))
                    WinSendDlgItemMsg(hwndDlg, DDCB_OVERVIEW, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* If keep on top checkbox is checked, uncheck it */
                if(WinQueryButtonCheckstate(hwndDlg, DDCB_KEEPONTOP))
                    WinSendDlgItemMsg(hwndDlg, DDCB_KEEPONTOP, BM_SETCHECK,
                    MPFROMSHORT(FALSE), (MPARAM)NULL);
                DisableDialogItem(hwndDlg, usChild2VirtualDesktopCB,
                    sizeof(usChild2VirtualDesktopCB)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;
        }
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
                                        /* Query checkboxes' state and set according flag */
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_SLIDINGFOCUS))
            HookParameters.ulStatusFlag|=SLIDINGFOCUS;
        else HookParameters.ulStatusFlag&=~SLIDINGFOCUS;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_PRESERVEZORDER))
            HookParameters.ulStatusFlag|=PRESERVEZORDER;
        else HookParameters.ulStatusFlag&=~PRESERVEZORDER;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_BUTTON2ZORDER))
            HookParameters.ulStatusFlag|=BUTTON2ZORDER;
        else HookParameters.ulStatusFlag&=~BUTTON2ZORDER;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_VIRTUALDESKTOP))
            HookParameters.ulStatusFlag|=VIRTUALDESKTOP;
        else HookParameters.ulStatusFlag&=~VIRTUALDESKTOP;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_KEEPONTOP))
            HookParameters.ulStatusFlag|=KEEPONTOP;
        else HookParameters.ulStatusFlag&=~KEEPONTOP;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_MOVEDESKTOP))
            HookParameters.ulStatusFlag|=MOVEDESKTOP;
        else HookParameters.ulStatusFlag&=~MOVEDESKTOP;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_CLICK2MOVE))
            HookParameters.ulStatusFlag|=CLICK2MOVE;
        else HookParameters.ulStatusFlag&=~CLICK2MOVE;
        if(WinQueryButtonCheckstate(hwndDlg, DDCB_OVERVIEW))
            HookParameters.ulStatusFlag|=OVERVIEW;
        else HookParameters.ulStatusFlag&=~OVERVIEW;
                                        /* Query Desktop and Window List name */
        WinQueryWindowText(WinWindowFromID(hwndDlg, DDEF_DESKTOPNAME),
            sizeof(HookParameters.ucDesktopName), HookParameters.ucDesktopName);
        WinQueryWindowText(WinWindowFromID(hwndDlg, DDEF_WINDOWLISTNAME),
            sizeof(HookParameters.ucWindowListName), HookParameters.ucWindowListName);
                                        /* Query scroll percentage listbox (0-based !!!) */
        WinQueryWindowText(WinWindowFromID(hwndDlg, DDEF_SCROLLPERCENTAGE),
            sizeof(ucBuffer), ucBuffer);
        HookParameters.ulScrollPercentage=(ULONG)atol(ucBuffer);;
                                        /* Reinitialize scroll percentage */
        HookParameters.SlidingXFactor=(HookParameters.ulScrollPercentage*
            HookParameters.DesktopSize.x)/100;
        HookParameters.SlidingYFactor=(HookParameters.ulScrollPercentage*
            HookParameters.DesktopSize.y)/100;
                                        /* Query click flag */
        if(WinQueryButtonCheckstate(hwndDlg, DDRB_BUTTON1CLICK))
            HookParameters.ulClickFlag=WM_BUTTON1CLICK;
        else HookParameters.ulClickFlag=WM_BUTTON1DBLCLK;
                                        /* Show or hide overview window according to
                                           the user selected flag */
        if(HookParameters.ulStatusFlag & OVERVIEW)
            WinSetWindowPos(hwndFrame, HWND_BOTTOM, 0, 0, 0, 0, SWP_SHOW | SWP_DEACTIVATE);
        else
            WinSetWindowPos(hwndFrame, HWND_BOTTOM, 0, 0, 0, 0, SWP_HIDE | SWP_DEACTIVATE);
                                        /* Write changes to PC2.INI */
        INIAccess(pucFilenameINI, FALSE);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog notebook pages. *
 * Req:                                                                                 *
 *      nbPINotebookPage[] ...  Structure of the Program Installtion notebook pages     *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_NotebookProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static SHORT    sPriorityDelta=PRTYC_NOCHANGE;

switch(msg)
{
/*                                                                                      *\
 * Syntax: WM_SETUPNOTEBOOKPAGES, NULL, NULL                                            *                                           *
\*                                                                                      */
case WM_SETUPNOTEBOOKPAGES:
    {
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63 and load the data from the SESSIONDATA structure SessionData    *
 * into the entryfields.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
                                        /* Handle of page 1 */
        nbPINotebookPage[PAGE_1].hwndPINBPage,
        PIEF_PROGRAMTITLE,              /* Program title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(MAXNAMEL),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Load the default text of the entryfield */
        nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PROGRAMTITLE, SessionData.PgmTitle);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndPINBPage,
        PIEF_PATHFILENAME,              /* Path and Filename title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PATHFILENAME, SessionData.PgmName);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndPINBPage,
        PIEF_DIRECTORY,                 /* Working directory entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_DIRECTORY, SessionData.PgmDirectory);
    WinSendDlgItemMsg(
        nbPINotebookPage[PAGE_1].hwndPINBPage,
        PIEF_PARAMETERS,                /* Program Parameters entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PARAMETERS, SessionData.PgmInputs);
                                        /* Insert DOS Settings. If none exist add the
                                           IDLE_* default settings */
    if(strlen(SessionData.PgmDosSettings)!=0)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_1].hwndPINBPage,
            PIMLE_DOSSETTINGS,          /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP(SessionData.PgmDosSettings),
            (MPARAM)NULL);
    else
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_1].hwndPINBPage,
            PIMLE_DOSSETTINGS,          /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP("IDLE_SECONDS=5\nIDLE_SENSITIVITY=100\n"),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program type group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    WinSendMsg(hwndDlg, WM_SETUPPROGRAMTYPE,
        MPFROMSHORT(SessionData.SessionType), (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program style group to the state indicated   *
 * by the SessionData structure.                                                        *
\*                                                                                      */
    if(!(SessionData.PgmControl & (SSF_CONTROL_MAXIMIZE | SSF_CONTROL_MINIMIZE)))
        WinSendDlgItemMsg(              /* Send message to Default radiobutton */
                                        /* Handle of dialog window */
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_DEFAULTSTYLE,          /* Program style: Default radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MAXIMIZE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_MAXIMIZED,             /* Program style: Maximized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MINIMIZE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_MINIMIZED,             /* Program style: Minimized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_INVISIBLE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_INVISIBLE,             /* Program style: Invisible checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_NOAUTOCLOSE)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_NOAUTOCLOSE,           /* Program style: NoAutoClose checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.FgBg & SSF_FGBG_BACK)
        WinSendDlgItemMsg(
            nbPINotebookPage[PAGE_3].hwndPINBPage,
            PIRB_BACKGROUND,            /* Program style: Background checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program Size & Position group to the state   *
 * indicated by the SessionData structure.                                              *
\*                                                                                      */
    if(SessionData.PgmControl & SSF_CONTROL_SETPOS)
        {                               /* If requested select it for the first time */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_SIZEPOSITION, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(TRUE), MPFROMSHORT(TRUE));
        }
    else
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(FALSE), MPFROMSHORT(TRUE));
    }
                                        /* Simulate the click to update the dialog's child windows */
    WinSendMsg(nbPINotebookPage[PAGE_3].hwndPINBPage, WM_CONTROL,
        MPFROM2SHORT(PIRB_SIZEPOSITION, BN_CLICKED), (MPARAM)NULL);
/*                                                                                      *\
 * Now we initialize the priority settings notebook page.                               *
\*                                                                                      */
     WinSendMsg(hwndDlg, WM_SETUPPROGRAMPRIORITY,
        MPFROMSHORT(SessionData.PriorityClass), MPFROMSHORT(SessionData.PriorityDelta));
/*                                                                                      *\
 * Now we initialize the hotkey settings notebook page.                                 *
\*                                                                                      */
     WinSendMsg(hwndDlg, WM_SETUPHOTKEY, (MPARAM)NULL, (MPARAM)NULL);
/*                                                                                      *\
 * Subclass dialog window procedure to catch drag & drop messages of the dialog window, *
 * which doesn't contain any child windows of it (entryfields, buttons, text fields).   *
\*                                                                                      */
                                        /* Subclass window procedure for drag & drop support
                                           save the old procedure, because the subclassing procedure
                                           must call the subclassed dialog procedure for all
                                           messages it doesn't handle itself, i.e. all but drag & drop */
    PI_ClassDialogProcedure=WinSubclassWindow(hwndDlg, PI_SubclassedDialogProcedure);
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPPROGRAMTYPE, USHORT SessionType, NULL                                *
\*                                                                                      */
case WM_SETUPPROGRAMTYPE:
/*                                                                                      *\
 * Adjust the Program Type radiobuttons by selecting only the button corresponding to   *
 * the SessionType.                                                                     *
\*                                                                                      */
    {                                   /* Radiobutton IDs sorted */
    USHORT      usSessionTypeRBs[]={PIRB_SHELL, PIRB_OS2FULLSCREEN, PIRB_OS2WINDOW,
                                    PIRB_PM, PIRB_DOSFULLSCREEN, PIRB_DOSWINDOW,
                                    PIRB_WPSOBJECT};
                                        /* Corresponding session type IDs sorted */
    USHORT      usSessionTypeIDs[]={SSF_TYPE_DEFAULT, SSF_TYPE_FULLSCREEN, SSF_TYPE_WINDOWABLEVIO,
                                    SSF_TYPE_PM, SSF_TYPE_VDM, SSF_TYPE_WINDOWEDVDM,
                                    SSF_TYPE_WPSOBJECT};
                                        /* Radiobutton IDs sorted */
    USHORT      usWINOS2TypeRBs[]={PIRB_WINREAL, PIRB_WINSTANDARD, PIRB_WIN386ENHANCED};
                                        /* Corresponding session type IDs sorted */
    USHORT      usWINOS2TypeIDs[]={PROG_WINDOW_REAL, PROG_WINDOW_PROT, PROG_31_ENH};
    USHORT      usSessionType=SHORT1FROMMP(mp1);
    USHORT      usTemp;
                                        /* Loop for all buttons and deselect all but the
                                           one specified in usSessionType */
    for(usTemp=0; usTemp<=(sizeof(usSessionTypeRBs)/sizeof(USHORT)); usTemp++)
        if(usSessionTypeIDs[usTemp]==usSessionType)
            {
            WinSendDlgItemMsg(          /* Send message to one Program Type radiobutton,
                                           this only updates the radiobutton but doesn't
                                           create a WM_CONTROL message */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_2].hwndPINBPage,
                                        /* Program type radiobutton */
                usSessionTypeRBs[usTemp],
                BM_SETCHECK,            /* Set it to pressed */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
                                        /* Simulate the click to update the dialog's child windows */
            WinSendMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, WM_CONTROL,
                MPFROM2SHORT(usSessionTypeRBs[usTemp], BN_CLICKED), (MPARAM)NULL);
            }
    switch(usSessionType)
    {                                   /* WIN-OS2 sessions must be treated similar */
    case PROG_WINDOW_REAL:
    case PROG_WINDOW_PROT:
    case PROG_31_ENH:
                                        /* Loop for all WIN-OS2 buttons and deselect all but the
                                           one specified in usSessionType */
        for(usTemp=0; usTemp<=(sizeof(usWINOS2TypeRBs)/sizeof(USHORT)); usTemp++)
            if(usWINOS2TypeIDs[usTemp]==usSessionType)
                WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, usWINOS2TypeRBs[usTemp],
                    BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Check WIN-OS2 session type radiobutton */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WINOS2, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, WM_CONTROL,
            MPFROM2SHORT(PIRB_WINOS2, BN_CLICKED), (MPARAM)NULL);
        break;

    default:
                                        /* Check WIN standard session radiobutton, because at
                                           least one should be checked, if no WIN-OS2 session
                                           type is selected */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WINSTANDARD, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        break;
    }
                                        /* Hide DOS Settings window until the application
                                           type is DOS Window or DOS Fullscreen */
    if(usSessionType==SSF_TYPE_WPSOBJECT)
                                        /* Only default Style is allowed */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_DEFAULTSTYLE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPSIZEPOSITION, (BOOL bWriteable), (BOOL bInsert)                      *
\*                                                                                      */
case WM_SETUPSIZEPOSITION:
/*                                                                                      *\
 * The 4 entryfields for the Size&Position are a bit more complicated to handle.        *
 * First we set the entryfields to a size of 4 and the default values are read from the *
 * SessionData structure. Only if Size&Position is selected, this 4 entryfields are not *
 * readonly. Flag bWriteable is true if Size&Position is selected, Flag bInsert is true *
 * if we write the values the first time.                                               *
\*                                                                                      */
    {
    USHORT      usSizePositionEFs[]={PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
    BOOL        bWriteable=SHORT1FROMMP(mp1);
    BOOL        bInsert=SHORT1FROMMP(mp2);
    USHORT      usTemp;
    SHORT       *psSizePosition;
    UCHAR       ucBuffer[6];            /* Prefix, 4 numbers, \0 */

                                        /* Get first Size & Position value */
    psSizePosition=&SessionData.InitXPos;
                                        /* Loop for all entryfields and enable and insert
                                           values into them */
    for(usTemp=0; usTemp<=(sizeof(usSizePositionEFs)/sizeof(USHORT));
        usTemp++, psSizePosition++)
        {
        if(bWriteable==TRUE)            /* If writeable, enable them */
            WinSendDlgItemMsg(          /* Send message to entryfield */
                nbPINotebookPage[PAGE_3].hwndPINBPage,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable read/write */
                MPFROMSHORT(FALSE),
                (MPARAM)NULL);
        else
            WinSendDlgItemMsg(          /* Send message to entryfield */
                nbPINotebookPage[PAGE_3].hwndPINBPage,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable readonly */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
        if(bInsert==TRUE)               /* If initializing, insert them */
            {
            WinSendDlgItemMsg(          /* Send message to dialog window */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_3].hwndPINBPage,
                                        /* Program size: X entryfield */
                usSizePositionEFs[usTemp],
                EM_SETTEXTLIMIT,        /* Set text limit to 5 */
                MPFROMSHORT(5),
                (MPARAM)NULL);
            WinSetDlgItemText(          /* Set a text string in a dialog item */
                nbPINotebookPage[PAGE_3].hwndPINBPage,
                usSizePositionEFs[usTemp],
                (CHAR *)_itoa(*psSizePosition, ucBuffer, 10));
            }
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPHOTKEY, NULL, NULL                                                   *
\*                                                                                      */
case WM_SETUPHOTKEY:
/*                                                                                      *\
 * Load Program Title into entryfield, fill the combobox and fill the MLE containing    *
 * the current window list.                                                             *
\*                                                                                      */
    {
    ULONG       ulTemp1, ulTemp2;
    PSWBLOCK    pSwBlock;               /* Pointer to window list */
                                        /* Used to add \n to switchlist entries */
    UCHAR       ucSwName[MAXNAMEL+1];

                                        /* Set Window Title entryfield */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PIEF_SESSIONTITLE,
        EM_SETTEXTLIMIT, MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndPINBPage, PIEF_SESSIONTITLE, SessionData.WindowTitle);
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY,
        EM_SETTEXTLIMIT, MPFROMSHORT(sizeof(" ")), (MPARAM)NULL);
                                        /* Set SWP control radiobuttons */
    if(SessionData.SwpFlag & SWP_MAXIMIZE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_WSMAXIMIZED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else if(SessionData.SwpFlag & SWP_RESTORE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_WSRESTORE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    else
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_NONE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(SessionData.SwpFlag & SWP_NOMOVE)
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PICB_DONTMOVE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
    if(SessionData.KeyData.usCh!=0)     /* Check if a hotkey is defined */
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PICB_HOTKEYENABLED, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Simulate the click to update the dialog's child windows */
    WinSendMsg(nbPINotebookPage[PAGE_2].hwndPINBPage, WM_CONTROL,
        MPFROM2SHORT(PICB_HOTKEYENABLED, BN_CLICKED), (MPARAM)NULL);
                                        /* Simulate the click to update the PIRB_CTRL or
                                           PIRB_ALT radiobutton */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, (SessionData.KeyData.usFlags==KC_CTRL) ? PIRB_CTRL : PIRB_ALT,
        BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* This message invalidates SessionData.KeyData !!! */
    WinSendMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, WM_CONTROL,
        MPFROM2SHORT((SessionData.KeyData.usFlags==KC_CTRL) ? PIRB_CTRL : PIRB_ALT, BN_CLICKED), (MPARAM)NULL);
                                        /* Query the number of entries in window list */
    ulTemp1=WinQuerySwitchList(hab, NULL, 0);
                                        /* Allocate space for window list */
    pSwBlock=(PSWBLOCK)malloc(ulTemp1=(ulTemp1*sizeof(SWENTRY)+sizeof(HSWITCH)));
                                        /* Load window list into LB */
    ulTemp1=WinQuerySwitchList(hab, pSwBlock, ulTemp1);
    for(ulTemp2=0; ulTemp2<=ulTemp1; ulTemp2++)
        {
        if(pSwBlock->aswentry[ulTemp2].swctl.fbJump==SWL_JUMPABLE)
            {
            strcpy(ucSwName, pSwBlock->aswentry[ulTemp2].swctl.szSwtitle);
            WinSendDlgItemMsg(
                nbPINotebookPage[PAGE_4].hwndPINBPage, PILB_WINDOWLIST,
                LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucSwName));
            }
        }
    free(pSwBlock);                     /* Free allocated space for window list */
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPPROGRAMPRIORITY, (USHORT PriorityClass), (SHORT PriorityDelta)       *                                           *
\*                                                                                      */
case WM_SETUPPROGRAMPRIORITY:
/*                                                                                      *\
 * To enable all Priorities to be selected, the checkbox PICB_CHILDPROCESS must be      *
 * checked and is either checked by the user or by the Priority not equal to the        *
 * default selection of PRTYC_NOCHANGE and 0.                                           *
\*                                                                                      */
    {
    USHORT      usPriorityClassRBs[]={PIRB_NOCHANGE, PIRB_IDLETIME, PIRB_REGULAR,
                                      PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER};
    USHORT      usPriorityClass=SHORT1FROMMP(mp1);
    UCHAR       ucBuffer[4];

    sPriorityDelta=SHORT1FROMMP(mp2);
                                        /* Check priority class radiobutton by simulation a 
                                           radiobutton click */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, usPriorityClassRBs[usPriorityClass],
        BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
    WinSendMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, WM_CONTROL,
        MPFROM2SHORT(usPriorityClass, BN_CLICKED), (MPARAM)NULL);
                                        /* Set priority delta entryfield and scrollbar */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA,
        EM_SETTEXTLIMIT, MPFROMSHORT(3), (MPARAM)NULL);
    WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA,
        (CHAR *)_itoa(sPriorityDelta, ucBuffer, 10));
                                        /* Set scollbar size and position. Caution
                                           a scrollbar is 0 based */
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIHSB_PRIORITYDELTA,
        SBM_SETTHUMBSIZE, MPFROM2SHORT(1, PRTYD_MAXIMUM), (MPARAM)NULL);
    WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIHSB_PRIORITYDELTA,
        SBM_SETSCROLLBAR, MPFROMSHORT(sPriorityDelta),
        MPFROM2SHORT(0, PRTYD_MAXIMUM));
    }
    break;

case WM_HSCROLL:                        /* Messages generated by horizontal scrollbars */
/*                                                                                      *\
 * This message is generated when a horizontal scrollbar is manipulated. See if it is   *
 * our scrollbar PIHSB_PRIORITYDELTA and process.                                       *
\*                                                                                      */
    if(SHORT1FROMMP(mp1)==PIHSB_PRIORITYDELTA)
        {
        UCHAR       ucBuffer[4];
        SHORT       sSliderPosition=SHORT1FROMMP(mp2);;

        switch(SHORT2FROMMP(mp2))
        {                               /* All messages contain the new slider position,
                                           so just use this value to change the priority
                                           delta entryfield value */
        case SB_LINELEFT:
            sPriorityDelta--;
            break;

        case SB_PAGELEFT:
            sPriorityDelta-=10;
            break;

        case SB_LINERIGHT:
            sPriorityDelta++;
            break;

        case SB_PAGERIGHT:
            sPriorityDelta+=10;
            break;

        case SB_SLIDERTRACK:
        case SB_SLIDERPOSITION:
            sPriorityDelta=sSliderPosition;
            break;
        }
        if(sPriorityDelta<PRTYC_NOCHANGE) sPriorityDelta=PRTYC_NOCHANGE;
        if(sPriorityDelta>PRTYD_MAXIMUM) sPriorityDelta=PRTYD_MAXIMUM;
        WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA,
            (CHAR *)_itoa(sPriorityDelta, ucBuffer, 10));
        WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIHSB_PRIORITYDELTA,
            SBM_SETPOS, MPFROMSHORT(sPriorityDelta), (MPARAM)NULL);
        }
    break;

case WM_CONTROL:                        /* Test for autoradio buttons pressed */
/*                                                                                      *\
 * The Size & Position radiobutton must be checked every time it is selected, because   *
 * only if it is selected, the user may have write access to X, Y, Size X and Size Y    *
 * entryfields, otherwise they are read only. The DOS Setting MLE is only visible if a  *
 * DOS window or fullscreen application type is selected.                               *
\*                                                                                      */
    {                                   /* Child windows that change with the
                                           PIRB_WPSOBJECT radiobutton */
    USHORT      usChild2WPSObject[]={PIRB_MAXIMIZED, PIRB_MINIMIZED, PIRB_SIZEPOSITION,
                                     PIRB_INVISIBLE, PIRB_NOAUTOCLOSE, PIRB_BACKGROUND,
                                     PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
                                        /* Disable the following if Size & Position is disabled */
    USHORT      usChild2SizeEnable[]={PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
                                        /* Hide the following for WPS Objects */
    USHORT      usChild2WPSObjectHide[]={PIEF_DIRECTORY, PIEF_PARAMETERS};
                                        /* Child window that changes with a DOS radiobutton */
    USHORT      usChild2DOS[]={PIMLE_DOSSETTINGS};
    USHORT      usChild2DOSP5[]={PIRB_IDLETIME, PIRB_REGULAR, PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER,
                                 PIEF_PRIORITYDELTA, PIHSB_PRIORITYDELTA};
                                        /* Child windows that change with a WIN-OS2 radiobutton */
    USHORT      usChild2WINOS2[]={PIRB_WINREAL, PIRB_WINSTANDARD, PIRB_WIN386ENHANCED/*,
                                  PICB_WINCOMMON*/};
                                        /* Child windows that change witch Hotkey enable checkbox */
    USHORT      usChild2HotKey[]={PIRB_NONE, PIRB_WSMAXIMIZED, PIRB_WSRESTORE, PIRB_CTRL,
                                  PIRB_ALT, PICBX_HOTKEY};

    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked ? */
        switch(SHORT1FROMMP(mp1))
        {
        case PIRB_SIZEPOSITION:         /* Program type: User defined size & position */
            if((BOOL)WinSendDlgItemMsg( /* Send message to Size & Position radiobutton */
                                        /* Handle of dialog window */
                nbPINotebookPage[PAGE_3].hwndPINBPage,
                PIRB_SIZEPOSITION,      /* Program size: Size & Position radiobutton */
                BM_QUERYCHECK,          /* Query the state */
                (MPARAM)NULL,
                (MPARAM)NULL)==TRUE)
                {
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(TRUE), MPFROMSHORT(FALSE));
                DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2SizeEnable,
                    sizeof(usChild2SizeEnable)/sizeof(USHORT), WS_VISIBLE);
                }
            else
                {
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(FALSE), MPFROMSHORT(FALSE));
                                        /* Enable and show Size & Position child windows */
                                        /* Disable and show Size & Position child windows */
                DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2SizeEnable,
                    sizeof(usChild2SizeEnable)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case PICB_HOTKEYENABLED:        /* Enable or disable and show Hotkey controls depending
                                           on Hotkey Enable checkbox */
            if((BOOL)WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage,
                PICB_HOTKEYENABLED, BM_QUERYCHECK, (MPARAM)NULL, (MPARAM)NULL)==TRUE)
                {
                DisableDialogItem(nbPINotebookPage[PAGE_4].hwndPINBPage, usChild2HotKey,
                    sizeof(usChild2HotKey)/sizeof(USHORT), WS_VISIBLE);
                }
            else
                {
                DisableDialogItem(nbPINotebookPage[PAGE_4].hwndPINBPage, usChild2HotKey,
                    sizeof(usChild2HotKey)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                }
            break;

        case PIRB_CTRL:
        case PIRB_ALT:                  /* Set hotkey MLE corresponding to radiobuttons */
            {
            KEYDATA     *pKeyData;
            UCHAR       ucBuffer[]="0"; /* String to be inserted into combobox */
            ULONG       ulTemp1;
            BOOL        bFirst=TRUE;    /* False if first key was inserted */
 
            pKeyData=KeyData;           /* Point to Hotkey control structure */
                                        /* If a key is defined set it into entryfield of
                                           combobox. Clear it afterwards that user selections
                                           to the PIRB_CTRL or PIRB_ALT insert the first free
                                           available key */
            if(SessionData.KeyData.usCh!=0)
                {
                ucBuffer[0]=(UCHAR)SessionData.KeyData.usCh;
                WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY, ucBuffer);
                bFirst=FALSE;
                }
            else bFirst=TRUE;
                                        /* Delete current entries in hotkey combobox */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY,
                LM_DELETEALL, (MPARAM)NULL, (MPARAM)NULL);
                                        /* Loop for all keys and set unused into combobox */
            for(ulTemp1=0; ulTemp1<(sizeof(KeyData)/sizeof(KEYDATA)); pKeyData++, ulTemp1++)
                {
                ucBuffer[0]=(UCHAR)pKeyData->usCh;
                                        /* Clear current key because it may not selected again */
                if((pKeyData->usCh==SessionData.KeyData.usCh) &&
                    ((SHORT1FROMMP(mp1)==PIRB_CTRL ? KC_CTRL : KC_ALT)==pKeyData->usFlags))
                    {
                    SessionData.KeyData.usCh=0;
                    pKeyData->bUsed=FALSE;
                    pKeyData->pMenuData=NULL;
                    }
                                        /* Load unused key of current type into combobox */
                if((pKeyData->bUsed==FALSE) &&
                    ((SHORT1FROMMP(mp1)==PIRB_CTRL ? KC_CTRL : KC_ALT)==pKeyData->usFlags))
                    {
                    if(bFirst==TRUE)
                        {               /* The first valid hotkey is loaded into entryfield part
                                           of combobox */
                        WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY, ucBuffer);
                        bFirst=FALSE;
                        }
                    WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY,
                        LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
                    }
                }
            }
            break;

        case PIRB_DOSFULLSCREEN:
        case PIRB_DOSWINDOW:
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), WS_VISIBLE);
                                        /* Set default priority class radiobutton by simulation a
                                           radiobutton click */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_NOCHANGE,
                BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
            WinSendMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, WM_CONTROL,
                MPFROM2SHORT(PIRB_NOCHANGE, BN_CLICKED), (MPARAM)NULL);
                                        /* Set default priority delta entryfield and scrollbar */
            WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA, "0");
                                        /* Set default scollbar position */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIHSB_PRIORITYDELTA,
                SBM_SETPOS, MPFROMSHORT(0), (MPARAM)NULL);
                                        /* Now disable non-default priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndPINBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndPINBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;

        case PIRB_SHELL:
        case PIRB_OS2FULLSCREEN:
        case PIRB_OS2WINDOW:
        case PIRB_PM:
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Now enable priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndPINBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndPINBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            break;
        
        case PIRB_WPSOBJECT:
                                        /* Disable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Now enable priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndPINBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE);
                                        /* Hide but enable WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), 0);
                                        /* Disable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndPINBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Only default Style is allowed */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_DEFAULTSTYLE, BM_SETCHECK,
                MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Size and Position is not allowed */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_SIZEPOSITION, BM_SETCHECK,
                MPFROMSHORT(FALSE), (MPARAM)NULL);
                                        /* Load empty text in not required fields */
            WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_DIRECTORY, "");
            WinSetDlgItemText(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PARAMETERS, "");
            break;

        case PIRB_WINOS2:
                                        /* Enable and show WPSObject child windows, because
                                           a WIN-OS2 session is a specail DOS session */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show DOS child windows, hide priority */
            DisableDialogItem(nbPINotebookPage[PAGE_1].hwndPINBPage, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), WS_VISIBLE);
                                        /* Set default priority class radiobutton by simulation a
                                           radiobutton click */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_NOCHANGE,
                BM_SETCHECK, MPFROMSHORT(TRUE), (MPARAM)NULL);
            WinSendMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, WM_CONTROL,
                MPFROM2SHORT(PIRB_NOCHANGE, BN_CLICKED), (MPARAM)NULL);
                                        /* Set default priority delta entryfield and scrollbar */
            WinSetDlgItemText(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA, "0");
                                        /* Set default scollbar position */
            WinSendDlgItemMsg(nbPINotebookPage[PAGE_5].hwndPINBPage, PIHSB_PRIORITYDELTA,
                SBM_SETPOS, MPFROMSHORT(0), (MPARAM)NULL);
                                        /* Now disable non-default priority settings */
            DisableDialogItem(nbPINotebookPage[PAGE_5].hwndPINBPage, usChild2DOSP5,
                sizeof(usChild2DOSP5)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_3].hwndPINBPage, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WIN-OS2 child windows */
            DisableDialogItem(nbPINotebookPage[PAGE_2].hwndPINBPage, usChild2WINOS2,
                sizeof(usChild2WINOS2)/sizeof(USHORT), WS_VISIBLE);
            break;
        }
    if(SHORT1FROMMP(mp1)==PILB_WINDOWLIST)
        switch(SHORT2FROMMP(mp1))       /* Events of Window List listbox */
        {
        case LN_ENTER:                  /* When selected, copy selected item into session title entryfield */
            {
            UCHAR   ucTemp[MAXNAMEL];
            USHORT  usSelection;

            usSelection=(USHORT)WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PILB_WINDOWLIST,
                LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), (MPARAM)NULL);
                                        /* Copy selected item */
            if(usSelection!=(USHORT)LIT_NONE)
                {
                WinSendDlgItemMsg(nbPINotebookPage[PAGE_4].hwndPINBPage, PILB_WINDOWLIST,
                    LM_QUERYITEMTEXT, MPFROM2SHORT(usSelection, MAXNAMEL), MPFROMP(ucTemp));
                WinSetDlgItemText(nbPINotebookPage[PAGE_4].hwndPINBPage, PIEF_SESSIONTITLE, ucTemp);
                }
            break;
            }
        }
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case PIPB_WINFILEDLG:               /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the File Find pushbutton to get the standard file dialog to find   *
 * the program he wants to install.                                                     *
\*                                                                                      */
        {
        FILEDLG fdFileDlg;              /* Standard file dialog control */
        HWND    hwndFileDlg;            /* Handle of standard file dialog */

                                        /* Clear out structure */
        memset(&fdFileDlg, 0, sizeof(FILEDLG));
                                        /* Structure size */
        fdFileDlg.cbSize=sizeof(FILEDLG);
                                        /* FDS_* flags */
        fdFileDlg.fl=FDS_CENTER | FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO;
                                        /* Dialog title string */
        fdFileDlg.pszTitle="PC/2 File Search";
                                        /* Initial path, filename or file filter */
        strcpy(fdFileDlg.szFullFile, "C:\\*");
                                        /* Open the standard file dialog ...*/
        hwndFileDlg=WinFileDlg(HWND_DESKTOP, hwndDlg, &fdFileDlg);
        if(hwndFileDlg && (fdFileDlg.lReturn==DID_OK))
                                        /* Load the values of the standard file dialog to
                                           the corresponding entryfield in the Program
                                           installation dialog. It is a file not an object. */
            InstallFilename2Dialog(hwndDlg, fdFileDlg.szFullFile, FALSE);
        }
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog.                *
 * Req:                                                                                 *
 *      StartSession .. a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static HWND          hwndNB;            /* Program Installation dialog notebook window handle */

switch(msg)
{
case WM_INITDLG:
    {
    HPS         hps;                    /* Used to query font metrics for tab size */
    FONTMETRICS fmFontMetrics;
    POINTL      aptlTabText[TXTBOX_COUNT];
    USHORT      usTabTextLength=50;
    SWP         swp;
    ULONG       ulPage, ulPageID;
 

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
                                        /* Get window handle of notebook */
    hwndNB=WinWindowFromID(hwndDlg, PINB_NOTEBOOK);
    hps=WinGetPS(hwndNB);               /* Get presentation space to query fontmetrics */
    memset(&fmFontMetrics, 0, sizeof(FONTMETRICS));
    if(GpiQueryFontMetrics(hps, sizeof(FONTMETRICS), &fmFontMetrics))
        fmFontMetrics.lMaxBaselineExt<<=1;
    else
        fmFontMetrics.lMaxBaselineExt=30;
                                        /* Load and associate all dialogs of the Program
                                           Installation dialog to notebook pages */
    for(ulPage=0; nbPINotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        {
                                        /* Load a dialog into a page */
        if(!(nbPINotebookPage[ulPage].hwndPINBPage=WinLoadDlg(
            hwndDlg,                    /* Parent window */
            hwndDlg,                    /* Owner window */
                                        /* Window procedure */
            nbPINotebookPage[ulPage].pDialogWndProc,
            NULLHANDLE,                 /* Resource idendity */
                                        /* Dialog idendity */
            nbPINotebookPage[ulPage].ulIDDialogPage,
            NULL)))                     /* Application defined data area */
                                        /* On error suggest exiting */
        USR_ERR("Can't load dialog resources - suggest exiting...", hwndFrame, hwndClient);
                                        /* Query length of largest tab text */
        if(GpiQueryTextBox(hps, strlen(nbPINotebookPage[ulPage].pszTab),
            nbPINotebookPage[ulPage].pszTab, TXTBOX_COUNT, aptlTabText))
            if(usTabTextLength<aptlTabText[TXTBOX_CONCAT].x)
                usTabTextLength=aptlTabText[TXTBOX_CONCAT].x;
        ulPageID=(ULONG)WinSendMsg(     /* Insert a page into the notebook */
            hwndNB,
            BKM_INSERTPAGE,
            (MPARAM)NULL,               /* Page ID, ignored if BKA_FIRST or BKA_LAST
                                           specified */
                                        /* Style and order attribute */
            MPFROM2SHORT(BKA_MAJOR | BKA_STATUSTEXTON | BKA_AUTOPAGESIZE, BKA_LAST));
        nbPINotebookPage[ulPage].ulIDPage=ulPageID;
                                        /* Set text into the status line */
        WinSendMsg(hwndNB,
            BKM_SETSTATUSLINETEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbPINotebookPage[ulPage].pszStatusLine));
                                        /* Set text into tab */
        WinSendMsg(hwndNB,
            BKM_SETTABTEXT,
            MPFROMP(ulPageID),
            MPFROMP(nbPINotebookPage[ulPage].pszTab));
                                        /* Associate page with dialog */
        WinSendMsg(hwndNB,
            BKM_SETPAGEWINDOWHWND,
            MPFROMP(ulPageID),
            MPFROMLONG(nbPINotebookPage[ulPage].hwndPINBPage));
        }
    WinReleasePS(hps);
    WinSendMsg(hwndNB,                  /* Set background to dialog box background */
        BKM_SETNOTEBOOKCOLORS,
        MPFROMLONG(SYSCLR_FIELDBACKGROUND),
        MPFROMSHORT(BKA_BACKGROUNDPAGECOLORINDEX));
    WinSendMsg(hwndNB,                  /* Set tab dimension */
        BKM_SETDIMENSIONS,
        MPFROM2SHORT(usTabTextLength+5, (SHORT)((float)fmFontMetrics.lMaxBaselineExt*0.8)),
        MPFROMSHORT(BKA_MAJORTAB));
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
                                        /* Now initialize all notebook page dialogs
                                           by posting to 1st page */
    WinPostMsg(nbPINotebookPage[PAGE_1].hwndPINBPage, WM_SETUPNOTEBOOKPAGES, (MPARAM)NULL, (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    {
    ULONG   ulPageId, ulPage;
    ULONG   ulHelp[]={PIID_PAGE1, PIID_PAGE2, PIID_PAGE3, PIID_PAGE4, PIID_PAGE5};

    ulPageId=(ULONG)WinSendMsg(hwndNB,  /* Query the currently active page */
        BKM_QUERYPAGEID,
        MPFROMLONG(0),                  /* Location page ID, ignored if */
                                        /* Page ID is BKA_TOP */
        MPFROM2SHORT(BKA_TOP, BKA_MAJOR));
    for(ulPage=0; nbPINotebookPage[ulPage].pDialogWndProc!=NULL; ulPage++)
        if(nbPINotebookPage[ulPage].ulIDPage==ulPageId)
            if(hwndHelp!=NULLHANDLE) WinSendMsg(
                hwndHelp,               /* Help window */
                HM_DISPLAY_HELP,        /* Display a help panel */
                                        /* Panel ID in ressource file */
                MPFROMSHORT(ulHelp[ulPage]),
                HM_RESOURCEID);         /* MP1 points to the help window identity */
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Program Title, Filename, Parameters and DOS Settings and copy them to the  *
 * corresponding entries in the StartSession structure.                                 *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Program title entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PROGRAMTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        WinQueryWindowText(             /* Query data entered in Path and Filename entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PATHFILENAME),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmName),
            SessionData.PgmName);
        WinQueryWindowText(             /* Query data entered in working Directory entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_DIRECTORY),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDirectory),
            SessionData.PgmDirectory);
        WinQueryWindowText(         /* Query data entered in Parameters entry */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndPINBPage, PIEF_PARAMETERS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmInputs),
            SessionData.PgmInputs);
        WinQueryWindowText(             /* Query data entered in DOS Settings MLE */
            WinWindowFromID(nbPINotebookPage[PAGE_1].hwndPINBPage, PIMLE_DOSSETTINGS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDosSettings),
            SessionData.PgmDosSettings);
/*                                                                                      *\
 * Query the Program Type radiobuttons and set the corresponding bit into the           *
 * StartSession structure. No change or the default selection are preselected during    *
 * WM_INITDLG. It must be one of them set, so we don't need else parts for if-else.     *
\*                                                                                      */
                                        /* Program type: WPS default */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_SHELL))
            SessionData.SessionType=SSF_TYPE_DEFAULT;
                                        /* Program type: OS/2 Fullscreen */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_OS2FULLSCREEN))
            SessionData.SessionType=SSF_TYPE_FULLSCREEN;
                                        /* Program type: OS/2 Window */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_OS2WINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWABLEVIO;
                                        /* Program type: PM */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_PM))
            SessionData.SessionType=SSF_TYPE_PM;
                                        /* Program type: DOS Fullscreen */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_DOSFULLSCREEN))
            SessionData.SessionType=SSF_TYPE_VDM;
                                        /* Program type: DOS Window */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_DOSWINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWEDVDM;
                                        /* Program type: WPS Object */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WPSOBJECT))
            SessionData.SessionType=SSF_TYPE_WPSOBJECT;
                                        /* Program type: WIN-OS2 session. Type can then be
                                           queried from WIN-OS2 session radiobuttons */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WINOS2))
            {
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WINREAL))
                SessionData.SessionType=PROG_WINDOW_REAL;
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WINSTANDARD))
                SessionData.SessionType=PROG_WINDOW_PROT;
            if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_2].hwndPINBPage, PIRB_WIN386ENHANCED))
                SessionData.SessionType=PROG_31_ENH;
            }
/*                                                                                      *\
 * Query Program Style radiobuttons and set the corresponding bits in the StartSession  *
 * structure. No change or the default selection are preselected during WM_INITDLG.     *
\*                                                                                      */
                                        /* Program style: Maximized */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_MAXIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MAXIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MAXIMIZE);
                                        /* Program style: Minimized */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_MINIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MINIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MINIMIZE);
                                        /* Program style: Invisible */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_INVISIBLE))
            SessionData.PgmControl|=SSF_CONTROL_INVISIBLE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_INVISIBLE);
                                        /* Program style: No autoclose */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_NOAUTOCLOSE))
            SessionData.PgmControl|=SSF_CONTROL_NOAUTOCLOSE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_NOAUTOCLOSE);
                                        /* Program style: Background */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_BACKGROUND))
            SessionData.FgBg|=SSF_FGBG_BACK;
        else
            SessionData.FgBg&=(~SSF_FGBG_BACK);
/*                                                                                      *\
 * Query Size & Position radiobutton, set the corresponding bit, and load the values    *
 * from the corresponding entryfields for the StartSession structure.                   *
\*                                                                                      */
        {
        UCHAR   Buffer[6];              /* Prefix, 4 numbers, \0 */

        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_3].hwndPINBPage, PIRB_SIZEPOSITION))
            SessionData.PgmControl|=SSF_CONTROL_SETPOS;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_SETPOS);
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndPINBPage, PIEF_X), sizeof(Buffer), Buffer);
        SessionData.InitXPos=(SHORT)atol(Buffer);
        if(SessionData.InitXPos<HookParameters.VirtualDesktopMin.x)
            SessionData.InitXPos=HookParameters.VirtualDesktopMin.x;
        if(SessionData.InitXPos>2*HookParameters.VirtualDesktopMax.x)
            SessionData.InitXPos=HookParameters.VirtualDesktopMax.x;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndPINBPage, PIEF_Y), sizeof(Buffer), Buffer);
        SessionData.InitYPos=(SHORT)atol(Buffer);
        if(SessionData.InitYPos<HookParameters.VirtualDesktopMin.y)
            SessionData.InitYPos=HookParameters.VirtualDesktopMin.y;
        if(SessionData.InitYPos>2*HookParameters.VirtualDesktopMax.y)
            SessionData.InitYPos=HookParameters.VirtualDesktopMax.y;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndPINBPage, PIEF_XSIZE), sizeof(Buffer), Buffer);
        SessionData.InitXSize=(USHORT)atol(Buffer);
        if(SessionData.InitXSize<0) SessionData.InitXSize*=-1;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_3].hwndPINBPage, PIEF_YSIZE), sizeof(Buffer), Buffer);
        SessionData.InitYSize=(USHORT)atol(Buffer);
        if(SessionData.InitYSize<0) SessionData.InitYSize*=-1;
/*                                                                                      *\
 * Query Hotkey settings notebook page                                                  *
\*                                                                                      */
        {
        UCHAR   ucBuffer[]=" ";

        SessionData.SwpFlag=0;          /* Assume no flags, which will now be corrected */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_WSMAXIMIZED))
            SessionData.SwpFlag=SWP_MAXIMIZE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_WSRESTORE))
            SessionData.SwpFlag=SWP_RESTORE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PICB_DONTMOVE))
            SessionData.SwpFlag|=SWP_NOMOVE;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_CTRL))
            SessionData.KeyData.usFlags=KC_CTRL;
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PIRB_ALT))
            SessionData.KeyData.usFlags=KC_ALT;
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_4].hwndPINBPage, PICBX_HOTKEY),
            sizeof(ucBuffer), ucBuffer);
                                        /* If no hotkey is contained in the hotkey combobox
                                           none is available or it is disabled ignore hotkey feature */
        if(!strcmp(ucBuffer, "") ||
            !WinQueryButtonCheckstate(nbPINotebookPage[PAGE_4].hwndPINBPage, PICB_HOTKEYENABLED))
            {
            SessionData.KeyData.usFlags=0;
            SessionData.KeyData.usCh=0;
            }
        else                            /* Mark the selected key as used */
            {
            KEYDATA     *pKeyData;
            ULONG       ulTemp1;
 
            SessionData.KeyData.usCh=(USHORT)ucBuffer[0];
            pKeyData=KeyData;           /* Point to Hotkey control structure */
                                        /* Loop for all keys and set used one */
            for(ulTemp1=0; ulTemp1<(sizeof(KeyData)/sizeof(KEYDATA)); pKeyData++, ulTemp1++)
                {
                                        /* Set current key to used */
                if((pKeyData->usCh==SessionData.KeyData.usCh)  &&
                    (pKeyData->usFlags==SessionData.KeyData.usFlags))
                    {
                    pKeyData->bUsed=TRUE;
                    pKeyData->pMenuData=SessionData.KeyData.pMenuData;
                    }
                }
            }
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_4].hwndPINBPage, PIEF_SESSIONTITLE),
            sizeof(SessionData.WindowTitle), SessionData.WindowTitle);
        if(!strcmp(SessionData.WindowTitle, ""))
            strcpy(SessionData.WindowTitle, SessionData.PgmTitle);
        }
/*                                                                                      *\
 * Query Program Priority radiobuttons and set the corresponding bits in the            *
 * StartSession structure. The default priority is No-Change. The listbox is also       *
 * queried and the Delta Priority is also set in the StartSession structure. It must be *
 * one of the radiobuttons, so else part of if-else is not required.                    *
\*                                                                                      */
                                        /* Program Priority: No-Change */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_NOCHANGE))
            SessionData.PriorityClass=PRTYC_NOCHANGE;
                                        /* Program Priority: Idle-time */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_IDLETIME))
            SessionData.PriorityClass=PRTYC_IDLETIME;
                                        /* Program Priority: Regular */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_REGULAR))
            SessionData.PriorityClass=PRTYC_REGULAR;
                                        /* Program Priority: Time-critical */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_TIMECRITICAL))
            SessionData.PriorityClass=PRTYC_TIMECRITICAL;
                                        /* Program Priority: Server */
        if(WinQueryButtonCheckstate(nbPINotebookPage[PAGE_5].hwndPINBPage, PIRB_FOREGROUNDSERVER))
            SessionData.PriorityClass=PRTYC_FOREGROUNDSERVER;
                                        /* Query index of selected item on correct it */
        WinQueryWindowText(WinWindowFromID(nbPINotebookPage[PAGE_5].hwndPINBPage, PIEF_PRIORITYDELTA),
            sizeof(Buffer), Buffer);
        SessionData.PriorityDelta=(SHORT)atol(Buffer);
        }
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the subclassed PC/2 - Program Installation dialog.     *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PDRAGINFO       pDragInfo;              /* Pointer to DRAGINFO structure */
PDRAGITEM       pDragItem;              /* Pointer to DRAGITEM structure */

switch(msg)
{
/*                                                                                      *\
 * Allow objects to be dropped on dialog box to add first dragitem as an application.   *
\*                                                                                      */
case DM_DRAGOVER:
    pDragInfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDragInfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);
    if(pDragInfo->cditem!=1)
                                        /* Don't allow dropping of more than one item */
        return(MPFROM2SHORT(DOR_NODROP, DO_UNKNOWN));
    else
                                        /* Allow drop of undefined operation onto dialog window */
        return(MPFROM2SHORT(DOR_DROP, DO_UNKNOWN));

case DM_DROP:
    {
    UCHAR       ucBuffer[256];
    UCHAR       ucObjectType[256];
    UCHAR       *pucBuffer;

    pDragInfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDragInfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);
                                        /* Query the rendering format */
    DrgQueryStrName(pDragItem->hstrRMF, sizeof(ucObjectType), ucObjectType);
                                        /* Scan for an WPS object */
    if(strstr(ucObjectType, "<DRM_OBJECT, DRF_OBJECT>")==NULL)
        {                               /* It is an application to get path and filename */
                                        /* Query path (container) */
        DrgQueryStrName(pDragItem->hstrContainerName, sizeof(ucBuffer), ucBuffer);
                                        /* Position to \0 of path */
        pucBuffer=ucBuffer+strlen(ucBuffer);
                                        /* Query filename and append it to path */
        DrgQueryStrName(pDragItem->hstrSourceName, sizeof(ucBuffer)-strlen(pucBuffer), pucBuffer);
                                        /* Now change the entryfields to the dropped object
                                           which is not a WPS object */
        InstallFilename2Dialog(hwnd, ucBuffer, FALSE);
        }
    else
        {                               /* It is an WPS Object so only get object name */
                                        /* Query filename but don't append it to path */
        DrgQueryStrName(pDragItem->hstrSourceName, sizeof(ucBuffer), ucBuffer);
                                        /* Now change the entryfields to the dropped object
                                           which is a WPS object */
        InstallFilename2Dialog(hwnd, ucBuffer, TRUE);
        }
    }
    break;

default:                                /* Pass all other messages to default window procedure */
    return((MRESULT)PI_ClassDialogProcedure(hwnd, msg, mp1, mp2));
}
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Menu Installation dialog.                   *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session.                                   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        MIEF_MENUTITLE,                 /* Program submenu title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(MAXNAMEL),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set text of title entryfield */
        hwndDlg, MIEF_MENUTITLE, SessionData.PgmTitle);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(MIID_MENUDIALOG),   /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Submenu Title and copy it to the corresponding entry in the StartSession   *
 * structure.                                                                           *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Submenu title entry */
            WinWindowFromID(hwndDlg, MIEF_MENUTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Control Addition dialog.                    *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the control style         *
 *                      selected in the dialog is entered. If DID_OK is pressed this    *
 *                      structure is used to add the control entries to the Popup-menu. *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    ULONG       ulid;
    ULONG       ulidCopy;
                                        /* Sort radiobuttons as the Menuentry IDs are
                                           sorted */
    USHORT      usChild2Control[]={MDRB_CTRL_CONFIGMENU, MDRB_CTRL_ABOUT, MDRB_CTRL_EXIT,
                                   MDRB_CTRL_SHUTDOWN, MDRB_CTRL_CONFIGDESKTOP,
                                   MDRB_CTRL_HELP};

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
    for(ulid=ID_CONFIGDIALOG; ulid<=ID_HELP; ulid++)
        {
        ulidCopy=ulid;                  /* Copy because SearchItem() changes passed ID */
                                        /* Search in the linked list for entry ulid */
        if((SearchItem(pPopupMenu, &ulidCopy))!=NULL)
                                        /* Disable and show 1 Control child windows
                                           according to its id if id was found */
            DisableDialogItem(hwndDlg, &usChild2Control[ulid-ID_CONFIGDIALOG],
                1, WS_VISIBLE | WS_DISABLED);
        }
                                        /* Select Separator RB because this is the only
                                           one selectable all times */
    WinSendDlgItemMsg(hwndDlg, MDRB_CTRL_SEPARATOR, BM_SETCHECK,
        MPFROMSHORT(TRUE), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
                                        /* Panel ID in ressource file */
        MPFROMSHORT(MDID_CONTROLDIALOG),
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query through all radiabuttons for the control style the user has selected. Write    *
 * the corresponding string name into the  SessionData.PgmTitle field.                  *
\*                                                                                      */
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_CONFIGMENU))
            strcpy(SessionData.PgmTitle, CTRL_CONFIGMENU);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_CONFIGDESKTOP))
            strcpy(SessionData.PgmTitle, CTRL_CONFIGDESKTOP);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_ABOUT))
            strcpy(SessionData.PgmTitle, CTRL_ABOUT);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_SHUTDOWN))
            strcpy(SessionData.PgmTitle, CTRL_SHUTDOWN);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_HELP))
            strcpy(SessionData.PgmTitle, CTRL_HELP);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_EXIT))
            strcpy(SessionData.PgmTitle, CTRL_EXIT);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_SEPARATOR))
            strcpy(SessionData.PgmTitle, CTRL_SEPARATOR);
        if(WinQueryButtonCheckstate(hwndDlg, MDRB_CTRL_BRKSEPARATOR))
            strcpy(SessionData.PgmTitle, CTRL_BREAKSEPARATOR);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - ShutDown OS/2 dialog.                       *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
                                        /* Load before ShutDown info */
    WinSetDlgItemText(hwndDlg, SDID_SHUTDOWNMESSAGE, 
        "All disk activity will be suspended. After all disk activity has been stopped, "\
        "it is safe to power off or reset your system.");
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
    WinPostMsg(hwndDlg, WM_SHUTDOWN, NULL, NULL);
    break;
    }

/*                                                                                      *\
 * Syntax: WM_SHUTDOWN, NULL, NULL                                                      *
\*                                                                                      */
case WM_SHUTDOWN:
/*                                                                                      *\
 * Wait for 1 seconds and then shut down OS/2.                                          *
\*                                                                                      */
    DosSleep(01000);
    DosShutdown(0);
                                        /* Load after ShutDown info */
    WinSetDlgItemText(hwndDlg, SDID_SHUTDOWNMESSAGE,
        "All disk activity has been stopped. It is now safe to power off or reset "\
        "your system. ");
    break;

case WM_COMMAND:                        /* Eat up keys to avoid dismission of dialog with
                                           ESC key */
    return((MRESULT)TRUE);

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Startup Parameters dialog.                  *
 * Req: *PgmInputs .....A pointer to a string of commandline params of an application   *
 *                      via mp2                                                         *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static COMMANDLINEPARAMS        *pCLPParams;

switch(msg)
{
case WM_INITDLG:
    {
    UCHAR       ucBuffer[EF_SIZE255+1];

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    pCLPParams=PVOIDFROMMP(mp2);
/*                                                                                      *\
 * Load text from CLPParams into the dialog box text fields, and set the text limit of  *
 * the entryfield to 127.                                                               *
\*                                                                                      */
                                        /* Program to be started information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPROGRAM, pCLPParams->ucPgmTitle);
    sprintf(ucBuffer, "%s[...] %s", pCLPParams->ucPBefore, pCLPParams->ucPAfter);
                                        /* User information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPINFO, pCLPParams->ucPUser);
                                        /* Current parameters text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPARAMETERS, ucBuffer);
    WinSendDlgItemMsg(hwndDlg, SUEF_STARTUPPARAMETERS, EM_SETTEXTLIMIT,
        MPFROMSHORT(MAXNAMEL), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(SUID_STARTUPDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        WinQueryWindowText(WinWindowFromID(hwndDlg, SUEF_STARTUPPARAMETERS),
            sizeof(pCLPParams->ucPUser), pCLPParams->ucPUser);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Resort dialog.                              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static MENUDATA *pSortedMenuData;       /* Pointer to the first element of the resorted
                                           linked list */
static MENUDATA *pParentMenuData;       /* Menuitem, which current level is a child of */
static USHORT   usChild2InitPBs[]={DID_OK};
static USHORT   usChild2MovePBs[]={DID_CANCEL};
static USHORT   usChild2OKPBs[]={RDPB_MOVE};
static BOOL     bFirstMove;
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    MENUDATA    *pMDSource;             /* Pointer withing the current linked list */

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Disable OK pushbutton, until all items have been moved. Get the first element of the *
 * current level of the linked list which will be resorted. Add all Menuitems of the    *
 * current level of the linked list to the source listbox. Save the parent Menuitem,    *
 * from where the current level is a child of.                                          *
\*                                                                                      */
    bFirstMove=FALSE;                   /* We didn't make any sort before */
    pSortedMenuData=NULL;               /* Pointer of resorted linked list points to a non
                                           available Menuitem */
                                        /* Disable and show OK pushbutton */
    DisableDialogItem(hwndDlg, usChild2InitPBs,
        sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
    if(pMenuData==pPopupMenu)           /* Is current level is the root of all levels ? */
        pParentMenuData=NULL;           /* Yes, then parent Menuitem is NULL */
    else                                /* No, then get parent Menuitem */
        pParentMenuData=pMenuData->Back;
    pMDSource=pMenuData;                /* Get first element of linked list */
    do                                  /* Add current level of Menuitems to the source listbox */
    {
        if(pMDSource->Item==ENTRYSUBMENU) /* It is a Submenu */
            {
            UCHAR       ucBuffer[MAXNAMEL+4];
                                        /* Add >> for a Submenu */
            sprintf(ucBuffer, "%s >>", pMDSource->PgmTitle);
                                        /* Insert Menuitem at the end of the listbox */
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
            }
                                        /* It's a Menuitem or Control */
        if((pMDSource->Item==ENTRYMENUITEM) || (pMDSource->Item==ENTRYCONTROL))
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(pMDSource->PgmTitle));
                                        /* It may also be an empty entry, but then we
                                           ignore it, because it must be filled with
                                           Menuitem or Submenu data first */
        if(pMDSource->Next!=NULL)       /* Get through linked list without diving into
                                           Submenus */
                pMDSource=pMDSource->Next;
        else break;                     /* We're at the end of the linked list */
    }while(TRUE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(RDID_RESORTDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case RDPB_MOVE:                     /* Move pushbutton */
        {
        MENUDATA        *pMDSource;     /* Walk through current linked list */
                                        /* Walk through destination linked list */
        MENUDATA        *pMDDestination;
        SHORT           sCount;
 
/*                                                                                      *\
 * For the first resort operation, disable the Cancel pushbutton.                       *
\*                                                                                      */
        if(bFirstMove==FALSE)           /* After the first move operation, disable the
                                           Cancel pushbutton */
            {
            bFirstMove=TRUE;            /* We make now the first move */
            DisableDialogItem(hwndDlg, usChild2MovePBs,
                sizeof(usChild2MovePBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
/*                                                                                      *\
 * Now get the selected Menuitem of the source listbox, delete it from the listbox. If  *
 * the source listbox is now empty, reenable the OK pushbutton again.                   *
\*                                                                                      */
                                        /* Query the selected Menuitem from the source listbox */
        sCount=(SHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYSELECTION,
            MPFROMSHORT(LIT_FIRST), (MPARAM)NULL);
        if(sCount==LIT_NONE)            /* If no item selected ignore this button */
            return((MRESULT)FALSE);
        {
        UCHAR   ucBuffer[MAXNAMEL+4];
        SHORT   usItems;
                                        /* Query the text of the selected Menuitem from the
                                           source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMTEXT,
            MPFROM2SHORT(sCount, sizeof(ucBuffer)), MPFROMP(ucBuffer));
                                        /* Delete the selected Menuitem from the source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_DELETEITEM,
            MPFROMSHORT(sCount), (MPARAM)NULL);
                                        /* Insert the text of the selected Menuitem into the
                                           destination listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_DESTINATIONMENU, LM_INSERTITEM,
            MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
                                        /* Query the number of Menuitems from the source
                                           listbox */
        usItems=(USHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMCOUNT,
            (MPARAM)NULL, (MPARAM)NULL);
        if(usItems==0)                  /* If now more items left, reenable OK pushbutton
                                           and disable Resort pushbutton */
            {
            DisableDialogItem(hwndDlg, usChild2InitPBs,
                sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE);
            DisableDialogItem(hwndDlg, usChild2OKPBs,
                sizeof(usChild2OKPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
        }
/*                                                                                      *\
 * Now remove the selected Menuitem from the current linked list, by updating the       *
 * pointers according to previous or following Menuitems.                               *
\*                                                                                      */
        pMDSource=pMenuData;            /* Point to the first element of the linked list */
        for( ; sCount>0; sCount--)      /* Walk through the linked list to the selected
                                           item */
            pMDSource=pMDSource->Next;
        pMDDestination=pSortedMenuData; /* Point to the first element of the resorted linked list */
        if(pMDDestination!=NULL)        /* Walk through the resorted linked list to the
                                           last Menuitem, if there's at least one element */
            for( ; pMDDestination->Next!=NULL; pMDDestination=pMDDestination->Next);
/*                                                                                      *\
 * Now update the Popup-Menu, by moving the selected Menuitem.                          *
\*                                                                                      */
        if((pMDDestination==NULL) && (pParentMenuData==NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pPopupMenu));
        if((pMDDestination==NULL) && (pParentMenuData!=NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pParentMenuData));
        if(pMDDestination!=NULL)
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pMDDestination));

        if((pMDSource->Back!=NULL) && (pMDSource->Next!=NULL))
            {                           /* Current element follows another and is followed
                                           by another element, so simple remove it by
                                           updating the pointers. Be carefull if the
                                           parent element is a Submenu where the current
                                           level is a leaf of. */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSource->Next;
                pMenuData=pMDSource->Next;
                }
            else
                (pMDSource->Back)->Next=pMDSource->Next;
            (pMDSource->Next)->Back=pMDSource->Back;
            }
        if((pMDSource->Back!=NULL) && (pMDSource->Next==NULL))
            {                           /* Current element follows another but is the last
                                           one of the current linked list.  Be carefull if
                                           the parent element is a Submenu where the current
                                           level is a leaf of. */
                                        /* Next element of course is NULL */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSource->Next;
                pMenuData=pMDSource->Next;
                }
            else
                (pMDSource->Back)->Next=pMDSource->Next;
            }
        if((pMDSource->Back==NULL) && (pMDSource->Next!=NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, but is followed by another */
            (pMDSource->Next)->Back=NULL;
            pMenuData=pMDSource->Next;
            pPopupMenu=pMDSource->Next;
            }
        if((pMDSource->Back==NULL) && (pMDSource->Next==NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, and isn't followed by another */
            pMenuData=NULL;
            pPopupMenu=NULL;
            }
/*                                                                                      *\
 * Now add the deleted Menuitem at the end of the resorted linked list, by updating the *
 * pointer of the last element to point to the deleted one.                             *
\*                                                                                      */
        if(pMDDestination==NULL)
            {                           /* If the resorted linked list is empty, add
                                           deleted element and update pointers */
            pSortedMenuData=pMDSource;
            pMDDestination=pMDSource;
            pMDDestination->Next=NULL;
            pMDDestination->Back=NULL;
            }
        else
            {                           /* If the resorted linked list isn't empty, add
                                           deleted element at the end and update pointers */
            pMDDestination->Next=pMDSource;
            pMDSource->Back=pMDDestination;
            pMDSource->Next=NULL;
            }
        }
        return((MRESULT)FALSE);         /* We don't want to close the dialog by breaking
                                           out of the switch statement */

    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Now replace the current linked list, which is empty as all Menuitems have been re-   *
 * moved, with the resorted linked list.                                                *
\*                                                                                      */
        if(pParentMenuData==NULL)
            {                           /* If the root of the complete linked list has been
                                           resorted, update the root pointers */
            pPopupMenu=pSortedMenuData;
            pMenuData=pPopupMenu;
            }
        else
            {                           /* If the current level has a parent Menuitem, a
                                           Submenu of course, update the current level pointers */
            pMenuData=pSortedMenuData;
            pSortedMenuData->Back=pParentMenuData;
            pParentMenuData->Submenu=pMenuData;
            }
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


