/*------------------------------------------------------------------
 * test_c.cmd :
 *------------------------------------------------------------------
 * 08-05-92 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

parse arg server .

if RxFuncQuery("RoxLoadFuncs") then
   do
   rc = RxFuncAdd("RoxLoadFuncs","Rox","RoxLoadFuncs")
   rc = RoxLoadFuncs()
   end

rc = RoxLoad("socket.rox")

/*------------------------------------------------------------------
 * choose port number
 *------------------------------------------------------------------*/
port = 1923

/*------------------------------------------------------------------
 * get server
 *------------------------------------------------------------------*/
if (server = "") then
   do
   say "Server not specified."
   exit
   end

/*---------------------------------------------------------------
 * open socket
 *---------------------------------------------------------------*/
sock = RoxCreate("socket")
if (sock = -1) then
   do
   say "Error on SockSocket:" .errno(sock)
   exit
   end

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*---------------------------------------------------------------
 * connect socket
 *---------------------------------------------------------------*/
rc = .connectServer(sock,server,port)
if (rc = -1) then
   do
   say "Error connecting to" server ":" .errno(sock)
   exit
   end

/*------------------------------------------------------------------
 * get some data to send over
 *------------------------------------------------------------------*/
data = random(10000,99999)

say "Sending  '"data"' to  " server

/*------------------------------------------------------------------
 * send the data over
 *------------------------------------------------------------------*/
rc = time("r")
rc = .sendLine(sock,data)
elapsed = time("e")

if (rc = -1) then
   do
   say "Error on SockSend:" .errno(sock)
   exit
   end

/*------------------------------------------------------------------
 * receive the result from the server
 *------------------------------------------------------------------*/
rc = time("r")
line = .recvLine(sock)
elapsed = elapsed + time("e")

/*------------------------------------------------------------------
 * print results
 *------------------------------------------------------------------*/
if (reverse(line) <> data) then
   say "Unexpected results from the server: '"line"'"

else
   do
   say "Received '"line"' from" server "(successful!!)"
   say "Elapsed network transit time:" elapsed "seconds"
   end

/*------------------------------------------------------------------
 * close socket (and catch signals)
 *------------------------------------------------------------------*/
halt:

rc = RoxDestroy(sock)

exit

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source . . me .

   say "usage:"
   say "   " me "<server>"
   say "is used to run the rxSock tester"
   say
   say "where:"
   say "   <server> - tcp/ip host name running test_s (default = current host)"

   exit
