/* vgetctyp.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

void v_getctype (int *start, int *end)
{
  static VIOCURSORINFO cinfo;

#if defined (IF_OS2)
  IF_OS2
    {
      VioGetCurType (&cinfo, 0);
      *start = cinfo.yStart -1;
      *end = cinfo.cEnd -1;
    }
#endif
#if defined (IF_DOS)
  IF_DOS
    {
      union REGS r;

      r.h.ah = 0x03;
      r.h.bh = 0x00;
      _int86 (0x10, &r, &r);
      *start = r.h.ch & 0x1f;
      *end = r.h.cl & 0x1f;
    }
#endif
}
