
/*---------------------------------------------------------------------*/
/*  imsl.c                                                             */
/*  file origin:                                                       */
/*    imsl user's manual, imsl math/library, version 1.1, jan, 1989    */
/*    page 647 - 648                                                   */
/*---------------------------------------------------------------------*/


#include <math.h>
#include <stdlib.h>
#include "lsode.h"


void fcn(int[], double, double[], double[]);

int main()
{
      double atole[1+1], rtol[1+1], *rwork,t,tout,*y;
      int i,iopt,istate,itask,itol,*iwork,liw,lrw,mf,neq[1+1];

      neq[1] = 3;
      y = dvector(neq[1]);
      y[1] = 0.0e0;
      y[2] = 1.0e0;
      y[3] = 1.0e0;

      t = 0.0e0;
      tout = 0.0e0;

      itol = 1;
      rtol[1] = 1.e-04;
      atole[1] = 1.e-06;

      itask = 1;
      istate = 1;
      iopt = 1;
      lrw = 68;
      liw = 23;
      rwork = dvector(lrw);
      iwork = ivector(liw);

      mf = 10;

/*  integration step - call lsode. ----------------------------------- */

        for(i=0; i<=10; i++) {
             lsode(fcn,neq,y,&t,tout,itol,rtol,atole,itask,&istate,
                         iopt,rwork,lrw,iwork,liw,NULL,mf,stdout);
             if (istate < 0) {
                   printf("\n error halt:  istate = %3d",istate);
                   break;
             }
             printf("\n%15.5f  %15.5f  %15.5f  %15.5f",t,y[1],y[2],y[3]);
             tout += 1.0e0;
      }

      printf("\n\n  number of steps = %d",iwork[11]);
      printf("\n  number of fcn evaluations = %d",iwork[12]);

      free(iwork);
      free(rwork);
      free(y);
      return 0;
}



void  fcn(int neq[], double t, double y[], double yprime[])
{
     yprime[1] = y[2]*y[3];
     yprime[2] = -y[1]*y[3];
     yprime[3] = -0.51e0*y[1]*y[2];
     return;
}

