/* IRC 2 startup file. Assumes Rexx is installed.
   Copyright 1994 V. Phaniraj -- phaniraj@badlands.nodak.edu

   This is the startup file for Irc2.exe for OS/2. It requires IBM TCP/IP 
   and OS/2 Version 2.0 and above. Various options can be setup using
   ircsetup.cmd ; some can be set by editing this file. The values in this
   file are over-ridden by command line parameters, if specified.

   C:\> IRC Nickname Server Your_name

   All parameters are optional but if omitted must be specified as 
   a dot (.). The Def_* Values above will be taken for missing or 
   specified by a dot (.) parameters. By example, if I want to
   enter irc under nickname "Try", I would type:

   C:\> IRC Try

   If I want the Default nickname but want to connect to an other server 
   I would type:

   C:\> IRC . another.server.edu

   If I want every default but my IRCNAME set to "I am God" I would type:

   C:\> IRC . . I am God  
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs

/* Change values below to suit your taste  ; others are set using 
   ircsetup.cmd  */

Def_Colour = '07,0F,70,74,7C,47,07'   

/*
This will do white text on blue background

Def_Colour = '1F,0F,70,74,7C,47,1E'

*/

/* 
 IRCNICK   is the nickname of the user that will be used in irc
 IRCSERVER is the startup server used for irc. Find the one closest
           to you. Some examples are irc.colorado.edu, csz.bu.edu,
           irc.uiuc.edu and alfred.u.washington.edu. You can put a
           port number and passwd (if needed) on the end of the server
           by using colons as follows:
           server:port:passwd:nick
 IRCNAME   is the irc name of the user that will be shown in irc
           This information will be displayed after the username.
 USER      is the userid of the user that will be shown in irc.
 HOME      specifies the directory where the ircrc file (initialization script)
           is located.
 IRCCOLOUR this specfiies the colours used, as documented in irc2.doc
           For example changingd Def_Colour to '1F,0F,70,74,7C,47,07,07'
           would have white text on a blue background. 
 IRCLIB    this sets the location of the help, script, translation and
           ircserv.txt files.  It's calculated from the run directory of
           IRC/2 if not set.
*/


/* now the code to use a irc.ini file */
  irc_inifile=SysSearchPath('PATH','irc2.ini')   
  if irc_inifile = '' then irc_inifile=SysSearchPath('DPATH','irc2.ini')   
  
 if irc_inifile <> '' then do 
   rc = SysFileSearch('DEVICE',irc_inifile,'file')
   if rc = 3 then call ircsetup
 end
 else call ircsetup

  irc_inifile=SysSearchPath('PATH','irc2.ini')   
  if irc_inifile = '' then irc_inifile=SysSearchPath('DPATH','irc2.ini')   

  rc=SysIni(irc_inifile,'irc/2','ALL:','names')
   do i = 1 to names.0
    val=SysIni(irc_inifile,'irc/2',names.i)
    interpret names.i '= val' 
   end

/* pick up values from the environment if they exist */

if Value('IRCNICK',,'OS2ENVIRONMENT') <> '' Then,
   Def_Nick = Value('IRCNICK',,'OS2ENVIRONMENT')

if Value('IRCSERVER',,'OS2ENVIRONMENT') <> '' Then,
   Def_Server = Value('IRCSERVER',,'OS2ENVIRONMENT')

if Value('IRCNAME',,'OS2ENVIRONMENT') <> '' Then,
   Def_Name = Value('IRCNAME',,'OS2ENVIRONMENT')

if Value('IRCLIB',,'OS2ENVIRONMENT') <> '' Then,
   Def_Lib = Value('IRCLIB',,'OS2ENVIRONMENT')

if Value('IRCPATH',,'OS2ENVIRONMENT') <> '' Then,
   Def_Path = Value('IRCPATH',,'OS2ENVIRONMENT')

if Value('IRCCOLOUR',,'OS2ENVIRONMENT') <> '' Then,
   Def_Colour = Value('IRCCOLOUR',,'OS2ENVIRONMENT')

Parse Arg Nick Server Name

if Nick   = '.' | Nick   = ' '  Then nick   = Def_Nick
if Server = '.' | Server = ' '  Then Server = Def_Server
if Name   = '.' | Name   = ' '  Then Name   = Def_Name

/*  Load Values into the environment */

call value 'IRCNICK',Nick,'OS2ENVIRONMENT'
call value 'IRCSERVER',Server,'OS2ENVIRONMENT'
call value 'IRCNAME',Name,'OS2ENVIRONMENT'
call value 'USER',Def_User,'OS2ENVIRONMENT'
call value 'HOME',Def_Home,'OS2ENVIRONMENT'
call value 'IRCLIB',Def_Lib,'OS2ENVIRONMENT'
call value 'IRCPATH',Def_Path,'OS2ENVIRONMENT'
call value 'IRCCOLOUR',Def_Colour,'OS2ENVIRONMENT'


/*
'@mode co80,43'
add the line above if you want irc to start in 43 lines mode.
*/

irc_exe_file=SysSearchPath('PATH','irc2.exe')
'@'irc_exe_file Def_Parms

