#include "point.h"
#include "sortcltn.h"
#include "set.h"

main()
{
    cout << "\nTest class SortedCltn\n";
    Point A(1,1);               // create Point, A
    Point B(1,2);
    Point C(1,3);
    Point D(1,3);
    Point E(1,4);

    SortedCltn s(8);            // create SortedCltn, s
    SortedCltn t(8);
                                
    s.add(A);                   // add Points to s 
    s.add(B);                   // points are sorted
    s.add(C);                   // as they are added
    s.add(D);
    s.add(E);
    cout << "s = " << s << "\n"; // print s contents

    t.add(E);                   // add Points to t
    t.add(D);                   // in different order
    t.add(C);
    t.add(B);
    t.add(A);
    cout << "s==t: " << (s==t) << "\n"; // equality test
                                // collections compare equal 
                                // despite order in which                                
                                // elements were added

    Set st = s.asSet();         // Sets eliminate duplicates
    cout << "s.asSet(): " << st << "\n";
    cout << "st.asSortedCltn(): " << st.asSortedCltn() << "\n";
    return 0;
}
