#include "dict.h"
#include "arrayob.h"
#include "assoc.h"
#include "assocint.h"
#include "strclass.h"

extern const Class class_Address;
////////////////////////////////////////////////////////////
// class Address (declaration)
////////////////////////////////////////////////////////////
class Address : public Object
{
    String &_first, &_last, &_phone;
public:
    Address(char* first, char* last, char* phone)  
      : _first(*new String(first)),         // constructor 
        _last (*new String(last)),          // initializer
        _phone(*new String(phone)) {}       // list

    String&         first() { return _first; }
    String&         last()  { return _last; }
    String&         phone() { return _phone; }
    virtual 
    void            printOn(ostream& strm) const;
    virtual const 
    Class*          isA()                  const;
};

////////////////////////////////////////////////////////////
// class Address (definition)
////////////////////////////////////////////////////////////
DEFINE_CLASS(Address, Object); 

void Address::printOn(ostream& strm) const
{ 
    strm << _first << " " << _last << " " << _phone; 
}


////////////////////////////////////////////////////////////
// main program
////////////////////////////////////////////////////////////
main()
{
    cout << "\nA Dictionary of Addresses\n";
    Dictionary aDictionary;

    aDictionary.addAssoc((*new String("Armstrong")), 
                          *new Address("Louis", "Armstrong", "725-1674"));
    aDictionary.addAssoc((*new String("Hank")),
                          *new Address("Hank", "Armstrong", "763-1234"));
    aDictionary.addAssoc((*new String("Joan")),
                          *new Address("Joan", "Didion", "848-2882"));
    aDictionary.addAssoc((*new String("Neil")),
                          *new Address("Neil", "Armstrong", "848-2882"));
    aDictionary.addAssoc((*new String("Annie")),
                          *new Address("Annie", "Oakley", "848-2882"));
    cout << aDictionary << "\n\n";
                 

    cout << "Print the Armstrongs\n";
    
    //////////////////////////////////////////////
    // The following DO ... DONE construct is
    // called an iterator and is implemented 
    // as a macro.  Iterators are used to
    // perform a given polymorphic operation
    // on each element of a collection.
    // This iterator finds address associations
    // in the dictionary which have the last
    // name "Armstrong".  The first name and
    // the phone number for each "Armstrong"
    // is printed on a separate line
    //////////////////////////////////////////////

    DO(aDictionary, Assoc*, p)
        Address& anAddress = *(Address*)(p->value());
        if (String("Armstrong") == anAddress.last())
            cout << anAddress.first() << " " 
                 << anAddress.phone() << "\n";
    DONE
    return 0;
}


