#include "point.h"
#include "sortcltn.h"
#include "set.h"

#define TestDate
#ifdef TestDate
#include "date.h" //-gmv
#endif

main()
{
    cout << "\nTest class SortedCltn\n";
    Point A(1,1);
    Point B(1,2);
    Point C(1,3);
    Point D(1,3);
    Point E(1,4);
    SortedCltn s(8);
    SortedCltn t(8);
    s.add(A);
    s.add(B);
    s.add(C);
    s.add(D);
    s.add(E);
    cout << "s = " << s << "\n";
    t.add(E);
    t.add(D);
    t.add(C);
    t.add(B);
    t.add(A);
    cout << "s==t: " << (s==t) << "\n";
    Set st = s.asSet();
    cout << "s.asSet(): " << st << "\n";
    cout << "st.asSortedCltn(): " << st.asSortedCltn() << "\n";
#ifdef TestDate
    //-gmv
    cout << "dates\n";
    Date d1(1,"Jan",85);
    Date d2(1,"Jan",86);
    Date d3(1,"Jan",87);

    Date d4(2,"Jan",87);
    Date d5(2,"Jan",86);
    Date d6(2,"Jan",85);

    Date d7(31,"Dec",87);
    Date d8(31,"Dec",86);
    Date d9(31,"Dec",85);

    Date d10(1,"Jan",93);
    Date d11(1,"Jan",94);
    Date d12(1,"Jan",95);

    SortedCltn u(8);
    u.add(d1);
    u.add(d2);
    u.add(d3);

    u.add(d4);
    u.add(d5);
    u.add(d6);

    u.add(d7);
    u.add(d8);
    u.add(d9);

    u.add(d10);
    u.add(d11);
    u.add(d12);

    u.add(*new Date(31,"Dec",93));
    u.add(*new Date( 1,"Apr",93));
    u.add(*new Date( 1,"May",93));
    u.add(*new Date( 27,"Apr",93));
    

    cout << "u = " << u << "\n";
    Date aDate(27, "Apr", 93);
    cout << aDate
         << " Day of Week is "
         << aDate.weekDay()
         << " ("
         << nameOfDay(aDate.weekDay())
         << ")"
         << "\n";
#endif
    return 0;
}
