#include "iterator.h"
#include "collect.h"
#include <stdlib.h>    // for exit

#define THIS    Iterator
#define BASE    Object
DEFINE_CLASS(Iterator,Object);

Iterator::Iterator(const Collection& c)
{
    cltn = (Collection*)&c;
    cltn->doReset(*this);
}

void Iterator::reset()
{
    cltn->doReset(*this);
}

Object* Iterator::operator++()
{
    return ptr = cltn->doNext(*this);
}

bool Iterator::operator==(const Iterator& a) const
{
    return cltn->isSame(*a.cltn) && index == a.index && num == a.num;
}

const Class* Iterator::species() const
{
    return &class_Iterator;
}

bool Iterator::isEqual(const Object& p) const
{
    return p.isSpecies(class_Iterator) && *this==*(Iterator*)&p;
}

unsigned Iterator::hash() const
{
    return (unsigned)cltn ^ index ^ num;
}

Object* Iterator::copy() const        { return shallowCopy(); }

void Iterator::deepenShallowCopy()
{
#if 1
    cout << "error (gmv): Iterator::deepenShallowCopy() not implemented\n";
    exit(1);
//-gmv removed because of reference to class_SeqCltn:
//Error iterator.cpp 85: Undefined symbol 'class_SeqCltn' in function Iterator::deepenShallowCopy
#else
// put back
// Can only deepCopy() Iterators over SeqCltns
// -- not Sets, Bags, Dictionaries, etc.
    assertClass(*cltn,class_SeqCltn);
    cltn = (Collection*)cltn->deepCopy();
    if (index != 0) ptr = cltn->at(index-1);
#endif
}

Object* Iterator::shallowCopy() const
{
#if 1
    cout << "error (gmv): Iterator::shallowCopy() not implemented\n";
    exit(1);
    return (Object*)0;
//-gmv removed because of reference to class_SeqCltn:
//Error iterator.cpp 94: Undefined symbol 'class_SeqCltn' in function Iterator::shallowCopy
#else
// Can only shallowCopy() Iterators over SeqCltns
// -- not Sets, Bags, Dictionaries, etc.
    assertClass(*cltn,class_SeqCltn);
    Iterator* temp = (Iterator*)Object::shallowCopy();
    temp->cltn = (Collection*)temp->cltn->copy();
    if (index != 0) temp->ptr = temp->cltn->at(index-1);
    return temp;
#endif
}

void Iterator::printOn(ostream& strm) const
{
    strm << className() << "(" << cltn->className()
        << "[" << index << "]#" << num << ")";
}
