//----------------------------------------------------------------------
// File: CGWINDOW.CPP
//----------------------------------------------------------------------
#pragma hdrstop
#include <owl.h>
#include <button.h>
#include <checkbox.h>
#include <groupbox.h>
#include <radiobut.h>
#include <static.h>
#include <combobox.h>
#include <edit.h>
#include <scrollba.h>
#include <btree.h>
#include <stdtempl.h>
#include "cgwindow.h"

//----------------------------------------------------------------------
// GLOBAL VARIABLES
//----------------------------------------------------------------------
Btree registerWindowTypes;
PTGroupBox activeGroup;

static char    xxButton  = BUTTONCLASS,
          xxEdit    = EDITCLASS,
          xxStatic  = STATICCLASS,
          xxListBox = LISTBOXCLASS,
          xxScrollBar    = SCROLLBARCLASS,
          xxComboBox     = COMBOBOXCLASS;

//----------------------------------------------------------------------
// Registration of predefined controls
//----------------------------------------------------------------------
CGWindowRegister regButton(&xxButton, BuildButton);
CGWindowRegister regEdit(&xxEdit, BuildEdit);
CGWindowRegister regStatic(&xxStatic, BuildStatic);
CGWindowRegister regListBox(&xxListBox, BuildListBox);
CGWindowRegister regScrollBar(&xxScrollBar, BuildScrollBar);
CGWindowRegister regComboBox(&xxComboBox, BuildComboBox);

//----------------------------------------------------------------------
// Class: CGWindow
//----------------------------------------------------------------------
CGWindow::CGWindow(PTWindowsObject AParent, LPSTR ATitle)
     : TWindow(AParent, ATitle) {

     // Allow keyboard controls
     EnableKBHandler();

     // Initialize scrolling
     Attr.Style |= WS_HSCROLL | WS_VSCROLL;
     Scroller = new TScroller(this, 1, 1, 0, 0);
     Scroller->XLine = Scroller->YLine = 20;

     // Store resource name
     if(ATitle)
          AResourceName = strdup(ATitle);

     hFont = 0;

} // F: CGWindow::CGWindow

//----------------------------------------------------------------------
// F: CGWindow::~CGWindow
//----------------------------------------------------------------------
CGWindow::~CGWindow() {

     // Delete Font
     if (hFont)
          DeleteObject(hFont);

     // Delete resource name
     if (AResourceName)
          delete AResourceName;

} // F: CGWindow::~CGWindow

//----------------------------------------------------------------------
// F: CGWindow::CreateFont
//----------------------------------------------------------------------
HFONT CGWindow::CreateFont(LPSTR lpszFaceName, int
nPointSize) {

     LOGFONT   lf;
     HDC       hDC;

     memset(&lf, 0, sizeof(LOGFONT));
     hDC = GetDC(NULL);
     lf.lfHeight = -MulDiv(nPointSize, GetDeviceCaps(hDC,
LOGPIXELSY),        72);
     ReleaseDC(NULL, hDC);
     lf.lfWeight = FW_BOLD;
     lf.lfQuality = PROOF_QUALITY;
     lf.lfPitchAndFamily = FF_DONTCARE;
     strcpy(lf.lfFaceName, lpszFaceName);
     return CreateFontIndirect(&lf);

} // F: CGWindow::CreateFont

//----------------------------------------------------------------------
// F: CGWindow::PreProcessControl
//----------------------------------------------------------------------
void CGWindow::PreProcessControl(DLGITEM & ADlgItem) {

     // Scale Coordinates
     ADlgItem.X  = MulDiv(ADlgItem.X,  nScaleX, 4);
     ADlgItem.Y  = MulDiv(ADlgItem.Y,  nScaleY, 8);
     ADlgItem.CX = MulDiv(ADlgItem.CX, nScaleX, 4);
     ADlgItem.CY = MulDiv(ADlgItem.CY, nScaleY, 8);
     if((ADlgItem.Style & WS_GROUP) == WS_GROUP)
          activeGroup = NULL;
} // F: CGWindow::PreProcessControl

//----------------------------------------------------------------------
// F: CGWindow::ProcessControl
//----------------------------------------------------------------------
PTWindowsObject CGWindow::ProcessControl(DLGITEM & DlgItem)
{

     PTWindowsObject pAControl = NULL;

     // Construct Child Window
     PCGWindowRegister reg =
PCGWindowRegister(&registerWindowTypes.
          findMember(CGWindowRegister(DlgItem.Class,
NULL)));
     if(reg != ZERO)
          pAControl = reg->Build(this, DlgItem);

     return pAControl;

} // F: CGWIndow::ProcessControl


//----------------------------------------------------------------------
// F: CGWindow::PostProcessControl
//----------------------------------------------------------------------
void CGWindow::PostProcessControl(PTWindowsObject AControl,
DLGITEM &      ADlgItem) {

     // Assign resource's style bits
     PTWindow(AControl)->Attr.Style = ADlgItem.Style;

} // F: CGWIndow::PostProcessControl

//----------------------------------------------------------------------
// F: CGWindow::SetupWindow
//----------------------------------------------------------------------
void CGWindow::SetupWindow() {
     RECT      rect;
     POINT          pt;
     HANDLE    hMem;
     LPSTR          lpDlg;
     PDLGFONTHDR    pFontHdr = new DLGFONTHDR;
     PDLGITEM  pDlgItem = new DLGITEM;
     PDLGHDR   pDlgHdr = new DLGHDR;

     // Load & Lock Dialog Resource
     hMem = LoadResource(GetModule()->hInstance,
     FindResource(GetModule()->hInstance, AResourceName,
RT_DIALOG));
          lpDlg = LockResource(hMem);

     // Retrieve Dialog Header
     lpDlg = GetDlgInfo((LPDLGTEMPLATE) lpDlg, pDlgHdr);

     // Retrieve Dialog Font Information
     if (pDlgHdr->Style & DS_SETFONT) {
          lpDlg = GetFontInfo(lpDlg, pFontHdr);
          hFont = CreateFont(pFontHdr->szTypeFace,
               pFontHdr->PointSize);
     }

     // Scale Coordinates
     TEXTMETRIC tm;
     HDC hDC = GetDC(NULL);
     HFONT hSaveFont = SelectObject(hDC, hFont);
     GetTextMetrics(hDC, &tm);
     SelectObject(hDC, hSaveFont);
     ReleaseDC(NULL, hDC);

     nScaleX = tm.tmAveCharWidth + tm.tmOverhang;
     nScaleY = tm.tmHeight;

     Place.left     = MulDiv(pDlgHdr->X,  nScaleX, 4);
     Place.top = MulDiv(pDlgHdr->Y,  nScaleY, 8);
     Place.right    = Attr.W = pDlgHdr->CX = MulDiv(pDlgHdr-
>CX, nScaleX,       4);
     Place.bottom = Attr.H = pDlgHdr->CY = MulDiv(pDlgHdr-
>CY, nScaleY,       8);

     // Retrieve Dialog Items & Construct Child Windows
     for (int i = 0; i < pDlgHdr->ItemCount; i++) {

          // Retrieve Dialog Item
          lpDlg = GetDlgItem((LPDLGITEMTEMPLATE)lpDlg,
pDlgItem);

          PreProcessControl(*pDlgItem);
          PTWindowsObject pAControl =
ProcessControl(*pDlgItem);
          if(pAControl)
               PostProcessControl(pAControl, *pDlgItem);

     } // for

     // Unlock & Free Resource
     UnlockResource(hMem);
     FreeResource(hMem);

     SetCaption(pDlgHdr->CaptionText);
     TWindow::SetupWindow();
     ForEach(SetControlFont, &hFont);

     GetWindowRect(HWindow, &rect);
     pt.x = rect.left;
     pt.y = rect.top;
     ScreenToClient(Parent->GetClient() ?
          Parent->GetClient()->HWindow :
          Parent->HWindow, &pt);
     MoveWindow(HWindow, pt.x, pt.y,
          Place.right  + (GetSystemMetrics(SM_CXFRAME) * 2),
          Place.bottom + (GetSystemMetrics(SM_CYFRAME) * 2)
+
               GetSystemMetrics(SM_CYCAPTION), FALSE);

     delete pFontHdr;
     delete pDlgItem;
     delete pDlgHdr;

} // F: CGWindow::SetupWindow

//----------------------------------------------------------------------
// F: CGWindow::WMSize
//----------------------------------------------------------------------
void CGWindow::WMSize(RTMessage Msg) {

     TWindow::WMSize(Msg);
     int nX = max(int(Scroller->YRange ?
          Place.right - Msg.LP.Lo -
GetSystemMetrics(SM_CXVSCROLL) :
          Place.right - Msg.LP.Lo), 0);
     int nY = max(int(Scroller->XRange ?
          Place.bottom - Msg.LP.Hi -
GetSystemMetrics(SM_CYHSCROLL) :
          Place.bottom - Msg.LP.Hi), 0);
     Scroller->SetRange(nX, nY);

} // F: CGWindow::WMSize

//----------------------------------------------------------------------
// Class: CGWindowRegister
//----------------------------------------------------------------------
CGWindowRegister::CGWindowRegister(char *type,
PROCESSCONTROL process) {

     if(*type & 0x80) {
          szClass = new char[2];
          szClass[0] = *type;
          szClass[1] = 0;
     }
     else
          szClass = strdup(type);

     #pragma warn -pia
     if(BuildIt = process)
     #pragma warn .pia
          registerWindowTypes.add(*this);

} // F: CGWindowRegister::CGWindowRegister

//----------------------------------------------------------------------
// F: CGWindowRegister::~CGWindowRegister
//----------------------------------------------------------------------
CGWindowRegister::~CGWindowRegister() {

     if(BuildIt)
          registerWindowTypes.detach(*this);
     delete szClass;

} // F: CGWindowRegister::~CGWindowRegister

//----------------------------------------------------------------------
// Functions
//----------------------------------------------------------------------
LPSTR GetDlgInfo(LPDLGTEMPLATE DlgTemp, PDLGHDR pDlgHdr) {

     LPSTR lpScan;

     pDlgHdr->Style = DlgTemp->Style;
     pDlgHdr->ItemCount = DlgTemp->ItemCount;
     pDlgHdr->X = DlgTemp->X;
     pDlgHdr->Y = DlgTemp->Y;
     pDlgHdr->CX = DlgTemp->CX;
     pDlgHdr->CY = DlgTemp->CY;
     lpScan = LPSTR(&DlgTemp->CY + 1);
     lpScan = MoveString(pDlgHdr->MenuName, lpScan,
          sizeof(pDlgHdr->MenuName));
     lpScan = MoveString(pDlgHdr->ClassName, lpScan,
          sizeof(pDlgHdr->ClassName));
     lpScan = MoveString(pDlgHdr->CaptionText, lpScan,
          sizeof(pDlgHdr->CaptionText));
     return lpScan;

} // F: GetDlgInfo

LPSTR GetFontInfo(LPSTR DlgTemp, PDLGFONTHDR pFontHdr) {

     LPSTR lpScan;
     pFontHdr->PointSize = short(*DlgTemp);
     lpScan = LPSTR(DlgTemp + sizeof(short));
     lpScan = MoveString(pFontHdr->szTypeFace, lpScan,
          sizeof(pFontHdr->szTypeFace));
     return lpScan;

} // F: GetFontInfo

LPSTR GetDlgItem(LPDLGITEMTEMPLATE lpItem, PDLGITEM
pDlgItem) {

     LPSTR lpScan;

     pDlgItem->X = lpItem->X;
     pDlgItem->Y = lpItem->Y;
     pDlgItem->CX = lpItem->CX;
     pDlgItem->CY = lpItem->CY;
     pDlgItem->ID = lpItem->ID;
     pDlgItem->Style = lpItem->Style;
     lpScan = LPSTR(&lpItem->Class);

     if(unsigned(*lpScan) & 0x80) {
          memset(pDlgItem->Class, 0, sizeof(pDlgItem-
>Class));
          pDlgItem->Class[0] = *lpScan;
          lpScan++;
     }
     else
          lpScan = MoveString(pDlgItem->Class, lpScan,
               sizeof(pDlgItem->Class));

     lpScan = MoveString(pDlgItem->Text, lpScan,
          sizeof(pDlgItem->Text));
     pDlgItem->Info = BYTE(*lpScan);
     lpScan += sizeof(pDlgItem->Info);
     if(pDlgItem->Info) {
          pDlgItem->Data = DWORD(lpScan);
          lpScan += pDlgItem->Info;
     }
     return lpScan;

} // F: GetDlgItem

LPSTR MoveString(LPSTR pto, LPSTR lpfrom, int imax) {

     #pragma warn -pia
     for(memset(pto, 0, imax);
          imax > 1 && *lpfrom && (*pto++ = *lpfrom++);
          imax--);
     #pragma warn .pia

     while(*lpfrom++);
          return (lpfrom);

} // F: MoveString

void SetControlFont(Pvoid pControl, Pvoid pControlFont) {

     SendMessage(PTControl(pControl)->HWindow,
          WM_SETFONT, *LPWORD(pControlFont), 1L);

} // F: SetControlFont

PTWindowsObject BuildButton(PTWindowsObject that, DLGITEM&
DlgItem) {

     if(((DlgItem.Style & BS_RADIOBUTTON) == BS_RADIOBUTTON)
||
          ((DlgItem.Style &
BS_AUTORADIOBUTTON)==BS_AUTORADIOBUTTON))
               return new TRadioButton(that, DlgItem.ID,
               DlgItem.Text,
               DlgItem.X, DlgItem.Y, DlgItem.CX, DlgItem.CY,
               activeGroup);
     else if (((DlgItem.Style & BS_CHECKBOX) == BS_CHECKBOX)
||
          ((DlgItem.Style & BS_AUTOCHECKBOX) ==
BS_AUTOCHECKBOX))
               return new TCheckBox(that, DlgItem.ID,
DlgItem.Text,
               DlgItem.X, DlgItem.Y, DlgItem.CX, DlgItem.CY,
               activeGroup);
     else if ((DlgItem.Style & BS_GROUPBOX) == BS_GROUPBOX)
{
          activeGroup = new TGroupBox(that, DlgItem.ID,
DlgItem.Text,
          DlgItem.X, DlgItem.Y, DlgItem.CX, DlgItem.CY);
          return activeGroup;
     }
     else
          return new TButton(that, DlgItem.ID, DlgItem.Text,
               DlgItem.X, DlgItem.Y, DlgItem.CX, DlgItem.CY,
               (DlgItem.Style &
BS_DEFPUSHBUTTON)==BS_DEFPUSHBUTTON);

} // F: BuildButton

PTWindowsObject BuildEdit(PTWindowsObject that, DLGITEM&
DlgItem) {

     return new TEdit(that, DlgItem.ID, DlgItem.Text,
          DlgItem.X, DlgItem.Y, DlgItem.CX, DlgItem.CY,
MAXEDIT,
               (DlgItem.Style &
ES_MULTILINE)==ES_MULTILINE);

} // F: BuildEdit

PTWindowsObject BuildStatic(PTWindowsObject that, DLGITEM&
DlgItem) {

     return new TStatic(that, DlgItem.ID, DlgItem.Text,
DlgItem.X,
          DlgItem.Y, DlgItem.CX, DlgItem.CY, MAXEDIT);

} // F: BuildStatic

PTWindowsObject BuildListBox(PTWindowsObject that, DLGITEM&
DlgItem) {

     return new TListBox(that, DlgItem.ID, DlgItem.X,
DlgItem.Y,
          DlgItem.CX, DlgItem.CY);

} // F: BuildListBox

PTWindowsObject BuildScrollBar(PTWindowsObject that,
DLGITEM& DlgItem) {

     return new TScrollBar(that, DlgItem.ID, DlgItem.X,
DlgItem.Y,
          DlgItem.CX, DlgItem.CY, DlgItem.CX > DlgItem.CY);

} // F: BuildScrollBar

PTWindowsObject BuildComboBox(PTWindowsObject that, DLGITEM&
DlgItem) {

     return new TComboBox(that, DlgItem.ID, DlgItem.X,
DlgItem.Y,
          DlgItem.CX, DlgItem.CY, DlgItem.Style, MAXEDIT);

} // F: BuildComboBox
