Program Illustrating_The_PullDown_Menu_Kit;

Uses Crt, FastTTT, DOS, WinTTT, KeyTTT, PullTTT;

{ Notes:   1) The MenuDesc Type is an array of strings holding the
              description of the menu titles.
           2) The main headings of each pull down option must start
              with a '\'.
           3) The last choice in the array must be followed by a
              string '\\'.
  Thats all there is to it.}

var
TheMenu : MenuDesc;   {Array holding the menu definitions}

Procedure Define_Demo_Menu;
begin
  Fillchar(Themenu,sizeof(Themenu),#0);
  TheMenu[1] := '\File';      {menu definition for pull down menu}
  TheMenu[2] := 'Load        ';
  TheMenu[3] := 'New         ';
  TheMenu[4] := 'Save        ';
  TheMenu[5] := 'Write to    ';
  TheMenu[6] := 'Directory   ';
  TheMenu[7] := 'Change dir  ';
  TheMenu[8] := 'OS shell    ';
  TheMenu[9] := 'Quit        ';

  TheMenu[10] :=  '\Edit ';

  TheMenu[11] :=  '\Run ';

  TheMenu[12] := '\Compile     ';
  TheMenu[13] := 'Make         ';
  TheMenu[14] := 'Build        ';
  TheMenu[15] := 'Destination  ';
  TheMenu[16] := 'Find Error   ';
  TheMenu[17] := 'Primary file ';
  TheMenu[18] := 'Find         ';
  TheMenu[19] := 'find/Replace ';
  TheMenu[20] := 'find Next    ';
  TheMenu[21] := 'Get Info     ';

  TheMenu[22] := '\Options';
  TheMenu[23] := 'Compiler    ';
  TheMenu[24] := 'Environment ';
  TheMenu[25] := 'Directories ';
  TheMenu[26] := 'Parameters  ';
  TheMenu[27] := 'Load Options';
  TheMenu[28] := 'Save Options';
  TheMenu[29] := '\\';

end; {Proc Define demo menu}

Procedure Fill_Screen_With_Junk;
var I,J : integer;
begin
    ClrScr;
    Fillscreen(1,1,80,23,15,0,chr(001));
    WriteCenter(24,15,0,'ESC to exit Menu or F1 for Help');
end;

{$F+}
Procedure Menu_Help(Var ChM:Char;PickM,PickS : byte);
{an example of how to hook other procedures into the menu system}
var Ch : char;
begin
    If ChM = #187 then
    begin
        MkWin(20,7,60,15,white,red,1);
        WriteAT(22,9,white,red,'This could be context sensitive');
        WriteAT(22,10,white,red,'about the highlighted pick:');
        GotoXY(25,12);Write('Main Pick ',PickM);
        GotoXY(25,13);Write('Sub  Pick ',PickS);
        Ch := GetKey;
        RmWin;
    end;
end;
{$F-}


var
 Major,Minor : byte;
 Ch : char;

begin   {main demo program}
    Define_Demo_Menu;
    Fill_Screen_With_Junk;
    Major := 1;
    Minor := 4;
    PM_UserHook := @Menu_Help;
    With PM do
    begin
        Style := 0;  {0 no border, 1 single border, 2 double border}
        TopX :=  1;
        TopY := 2;
        ScreenNo := 3;
        Gap :=  5;
    end; {With}
    Pull_Menu(TheMenu,Major,Minor);
    GotoXY(1,20);
    If Major = 0 then
       write('You escaped')
    else
       write('You selected main menu ',Major,' and sub-topic ',Minor);
    WriteAT(1,22,white,black,'Run DemoTTT.exe for the main demo program');
    WriteAT(1,23,white,black,'Technojocks Turbo Toolkit v4.0');
    Ch := Readkey;
end.
