{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Turbo Pascal V4.0 DEARC unSqueezing routines.

* ASSOCIATED FILES
DEARC.PAS
DEARCABT.PAS
DEARCGLB.PAS
DEARCIO.PAS
DEARCLZW.PAS
DEARCUNP.PAS
DEARCUSQ.PAS
DEARC.TXT

* CHECKED BY
DRM 08/08/88

* KEYWORDS
TURBO PASCAL V4.0

==========================================================================
}
(**
 *
 *  Module:       dearcusq.pas
 *  Description:  DEARC unSqueezing routines (huffman encoding)
 *
 *  Revision History:
 *    7-26-88: unitized for Turbo v4.0
 *
**)


unit dearcusq;

interface

uses
  dearcglb,
  dearcabt,
  dearcio,
  dearcunp;

procedure init_usq;
function getc_usq : integer;


(*
 *  definitions for unsqueeze
 *)
Const
  ERROR   = -1;
  SPEOF   = 256;
  NUMVALS = 256;               { 1 less than the number of values }

Type
  nd = record
          child : array [0..1] of integer
        end;

Var
  node     : array [0..NUMVALS] of nd;
  bpos     : integer;
  curin    : integer;
  numnodes : integer;

implementation


(**
 *
 *  Name:         procedure init_usq
 *  Description:  initialize for unsqueeze
 *  Parameters:   none
 *
**)
procedure init_usq;
var
  i : integer;
begin
  bpos := 99;

  fread(numnodes, sizeof(numnodes));

  if (numnodes < 0) or (numnodes > NUMVALS) then
    abort('File has an invalid decode tree');

  node[0].child[0] := -(SPEOF + 1);
  node[0].child[1] := -(SPEOF + 1);

  for i := 0 to numnodes-1 do
    begin
      fread(node[i].child[0], sizeof(integer));
      fread(node[i].child[1], sizeof(integer))
    end
end; (* proc init_usq; *)


(**
 *
 *  Name:         function getc_usq : integer
 *  Description:  unsqueeze
 *  Parameters:   none
 *  Returns:      unsqueezed char
 *
**)
function getc_usq : integer;
label
  exit;
var
  i : integer;
begin
  i := 0;

  while i >= 0 do
    begin
      bpos := bpos + 1;

      if bpos > 7 then
        begin
          curin := getc_unp;

          if curin = ERROR then
            begin
              getc_usq := ERROR;
              goto exit                   (******** was "exit" ************)
            end;

          bpos := 0;

          i := node[i].child[1 and curin]
        end
      else
        begin
          curin := curin shr 1;
          i := node[i].child[1 and curin]
        end
    end; (* while *)

  i := - (i + 1);

  if i = SPEOF then
    getc_usq := -1
  else
    getc_usq := i;

  exit:
end; (* func getc_usq *)


end.

