{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Turbo Pascal V4.0 DEARC unPacking routines.

* ASSOCIATED FILES
DEARC.PAS
DEARCABT.PAS
DEARCGLB.PAS
DEARCIO.PAS
DEARCLZW.PAS
DEARCUNP.PAS
DEARCUSQ.PAS
DEARC.TXT

* CHECKED BY
DRM 08/08/88

* KEYWORDS
TURBO PASCAL V4.0

==========================================================================
}
(**
 *
 *  Module:       dearcunp.pas
 *  Description:  unPacking routines (run-length encoding)
 *
 *  Revision History:
 *    7-26-88: unitized for Turbo v4.0
 *
**)


unit dearcunp;

interface

uses
  dearcglb,
  dearcabt,
  dearcio;

  procedure putc_unp(c : integer);
  procedure putc_ncr(c : integer);
  function getc_unp : integer;


implementation

(*
 *  definitions for unpack
 *)
Const
  DLE = $90;

Var
  lastc  : integer;

(**
 *
 *  Name:         procedure putc_unp
 *  Description:  put one character to extracted file,  update CRC
 *  Parameters:   value -
 *                  c : integer - value to write
 *
**)
procedure putc_unp(c : integer);
begin
  crcval := ((crcval shr 8) and $00FF) xor crctab[(crcval xor c) and $00FF];
  put_ext(c)
end; (* proc putc_unp *)


(**
 *
 *  Name:         procedure putc_ncr
 *  Description:  put one char,  checking for run-length compression
 *  Parameters:   value -
 *                  c : integer - value to write
 *
**)
procedure putc_ncr(c : integer);
begin
  case state of
    NOHIST :
      if c = DLE then
        state := INREP
      else
        begin
          lastc := c;
          putc_unp(c)
        end;

    INREP  :
      begin
        if c = 0 then
          putc_unp(DLE)
        else
          begin
            c := c - 1;
            while (c <> 0) do
              begin
                putc_unp(lastc);
                c := c - 1
              end
            end;

        state := NOHIST
      end
  end  (* case *)
end; (* proc putc_ncr *)


(**
 *
 *  Name:         function getc_unp : integer
 *  Description:  get one character from archive
 *  Parameters:   none
 *  Returns:      character read
 *
**)
function getc_unp : integer;
begin
  if size = 0.0 then
    getc_unp := -1
  else
    begin
      size := size - 1;
      getc_unp := get_arc
    end;
end; (* func getc_unp *)

end.

